/*
 * DESQview/X Socket Library. Copyright (c) 1991 Quarterdeck Office Systems.
 */

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

/*      @(#)errno.h    */


#ifndef __SYS_ERRNO_H__
#define __SYS_ERRNO_H__

#include <errno.h>

/* Errno Values */
#ifdef ESRCH
#undef ESRCH
#endif
#define ESRCH		3

#ifdef EBADF /* Zortech defines this in <errno.h> */
#undef EBADF
#endif
#define EBADF           9       /* Bad file number              */

#ifdef EFAULT /* Zortech defines this in <errno.h> */
#undef EFAULT
#endif
#define EFAULT          14      /* Bad address                  */

#ifdef EINVAL
#undef EINVAL
#endif
#define EINVAL          22

#ifdef EMFILE /* Zortech defines this in <errno.h> */
#undef EMFILE
#endif
#define EMFILE          24

#ifdef EPIPE /* Zortech defines this in <errno.h> */
#undef EPIPE
#endif
#define EPIPE           32

#ifdef ENOBUFS
#undef ENOBUFS
#endif
#define ENOBUFS		55

#define EWOULDBLOCK     35
#define EINPROGRESS     36
#define ENOTSOCK        38      /* Socket operation on non-socket */
#define EMSGSIZE        40      /* Message too long             */
#define EPROTOTYPE      41      /* Protocol wrong type for socket */
#define ENOPROTOOPT     42      /* Bad protocol option          */
#define EPROTONOSUPPORT 43      /* Protocol not supported       */
#define ESOCKTNOSUPPORT 44      /* Socket type not supported    */
#define EAFNOSUPPORT    47      /* Addr family not supported by prot family */
#define EADDRINUSE      48
#define EADDRNOTAVAIL   49
#define ECONNRESET	54
#define EISCONN         56      /* Socket already connected */
#define ENOTCONN        57
#define ESHUTDOWN       58
#define ETIMEDOUT       60
#define ECONNREFUSED    61

#endif /*  __SYS_ERRNO_H__ */
