/*
 * $XConsortium: Xlibos.h,v 1.23 89/12/18 13:44:00 rws Exp $
 *
 * Xlib networking include files for UNIX Systems.
 */

#ifdef att
/*
 * UNIX System V Release 3.2
 */
#include <sys/stropts.h>
#define BytesReadable(fd,ptr) (_XBytesReadable ((fd), (ptr)))
#define MALLOC_0_RETURNS_NULL
#include <sys/param.h>
#define MAXSOCKS (NOFILES_MAX)
#define MSKCNT ((MAXSOCKS + 31) / 32)

#else
#ifdef MSDOS
/* Special case for MSDOS/PCDOS. 90/06/18 POHC */
/*#include <sys/ioctl.h>
#include <netdb.h> POHC 91/01/28 */
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/param.h> /* needed for XConnDis.c */
#ifdef __BCC__ /* JDC 92/08/11 */
#define BytesReadable(fd, ptr) so_ioctl ((fd), FIONREAD, (long *)(ptr))
#else
#define BytesReadable(fd, ptr) ioctl ((fd), FIONREAD, (long *)(ptr))
#endif
#ifndef NOFILE /* POHC 91/01/09 */
#ifdef FOPEN_MAX /* POHC */
#define NOFILE FOPEN_MAX
#else /* FOPEN_MAX */
#define NOFILE 20
#endif /* FOPEN_MAX */
#endif /* NOFILE */
#define MSKCNT ((NOFILE + 31) / 32)	/* size of bit array */
#if defined(__WATCOMC__) || defined(__NDPC__)
#define MALLOC_0_RETURNS_NULL
#endif
#else /* !MSDOS */
/*
 * 4.2BSD-based systems
 */
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <netdb.h>
#include <sys/uio.h>	/* needed for XlibInt.c */
#include <sys/param.h> /* needed for XConnDis.c */

#define BytesReadable(fd, ptr) ioctl ((fd), FIONREAD, (ptr))
#define MSKCNT ((NOFILE + 31) / 32)	/* size of bit array */
#endif /* MSDOS */
#endif /* att else bsdish */


/* Utek leaves kernel macros around in include files (bleah) */
#ifdef dirty
#undef dirty
#endif

#ifdef CRAY
#define WORD64
#define MALLOC_0_RETURNS_NULL
#endif

#if (MSKCNT==1)
#define BITMASK(i) (1 << (i))
#define MASKIDX(i) 0
#endif
#if (MSKCNT>1)
#define BITMASK(i) (1 << ((i) & 31))
#define MASKIDX(i) ((i) >> 5)
#endif

#define MASKWORD(buf, i) buf[MASKIDX(i)]
#define BITSET(buf, i) MASKWORD(buf, i) |= BITMASK(i)
#define BITCLEAR(buf, i) MASKWORD(buf, i) &= ~BITMASK(i)
#define GETBIT(buf, i) (MASKWORD(buf, i) & BITMASK(i))

#if (MSKCNT==1)
#define COPYBITS(src, dst) dst[0] = src[0]
#define CLEARBITS(buf) buf[0] = 0
#define MASKANDSETBITS(dst, b1, b2) dst[0] = (b1[0] & b2[0])
#define ORBITS(dst, b1, b2) dst[0] = (b1[0] | b2[0])
#define UNSETBITS(dst, b1) (dst[0] &= ~b1[0])
#define ANYSET(src) (src[0])
#endif
#if (MSKCNT==2)
#define COPYBITS(src, dst) { dst[0] = src[0]; dst[1] = src[1]; }
#define CLEARBITS(buf) { buf[0] = 0; buf[1] = 0; }
#define MASKANDSETBITS(dst, b1, b2)  {\
		      dst[0] = (b1[0] & b2[0]);\
		      dst[1] = (b1[1] & b2[1]); }
#define ORBITS(dst, b1, b2)  {\
		      dst[0] = (b1[0] | b2[0]);\
		      dst[1] = (b1[1] | b2[1]); }
#define UNSETBITS(dst, b1) {\
                      dst[0] &= ~b1[0]; \
                      dst[1] &= ~b1[1]; }
#define ANYSET(src) (src[0] || src[1])
#endif
#if (MSKCNT==3)
#define COPYBITS(src, dst) { dst[0] = src[0]; dst[1] = src[1]; \
			     dst[2] = src[2]; }
#define CLEARBITS(buf) { buf[0] = 0; buf[1] = 0; buf[2] = 0; }
#define MASKANDSETBITS(dst, b1, b2)  {\
		      dst[0] = (b1[0] & b2[0]);\
		      dst[1] = (b1[1] & b2[1]);\
		      dst[2] = (b1[2] & b2[2]); }
#define ORBITS(dst, b1, b2)  {\
		      dst[0] = (b1[0] | b2[0]);\
		      dst[1] = (b1[1] | b2[1]);\
		      dst[2] = (b1[2] | b2[2]); }
#define UNSETBITS(dst, b1) {\
                      dst[0] &= ~b1[0]; \
                      dst[1] &= ~b1[1]; \
                      dst[2] &= ~b1[2]; }
#define ANYSET(src) (src[0] || src[1] || src[2])
#endif
#if (MSKCNT==4)
#define COPYBITS(src, dst) dst[0] = src[0]; dst[1] = src[1]; \
			   dst[2] = src[2]; dst[3] = src[3]
#define CLEARBITS(buf) buf[0] = 0; buf[1] = 0; buf[2] = 0; buf[3] = 0
#define MASKANDSETBITS(dst, b1, b2)  \
                      dst[0] = (b1[0] & b2[0]);\
                      dst[1] = (b1[1] & b2[1]);\
                      dst[2] = (b1[2] & b2[2]);\
                      dst[3] = (b1[3] & b2[3])
#define ORBITS(dst, b1, b2)  \
                      dst[0] = (b1[0] | b2[0]);\
                      dst[1] = (b1[1] | b2[1]);\
                      dst[2] = (b1[2] | b2[2]);\
                      dst[3] = (b1[3] | b2[3])
#define UNSETBITS(dst, b1) \
                      dst[0] &= ~b1[0]; \
                      dst[1] &= ~b1[1]; \
                      dst[2] &= ~b1[2]; \
                      dst[3] &= ~b1[3]
#define ANYSET(src) (src[0] || src[1] || src[2] || src[3])
#endif

#if (MSKCNT>4)
#define COPYBITS(src, dst) bcopy((caddr_t) src, (caddr_t) dst,\
				 MSKCNT*sizeof(long))
#define CLEARBITS(buf) bzero((caddr_t) buf, MSKCNT*sizeof(long))
#define MASKANDSETBITS(dst, b1, b2)  \
		      { int cri;			\
			for (cri=0; cri<MSKCNT; cri++)	\
		          dst[cri] = (b1[cri] & b2[cri]) }
#define ORBITS(dst, b1, b2)  \
		      { int cri;			\
		      for (cri=0; cri<MSKCNT; cri++)	\
		          dst[cri] = (b1[cri] | b2[cri]) }
#define UNSETBITS(dst, b1) \
		      { int cri;			\
		      for (cri=0; cri<MSKCNT; cri++)	\
		          dst[cri] &= ~b1[cri];  }
/*
 * If MSKCNT>4, then ANYSET is a routine defined in XlibInt.c.
 *
 * #define ANYSET(src) (src[0] || src[1] || src[2] || src[3] || src[4] ...)
 */
#endif

#ifdef sgi
#include <malloc.h>
#include <string.h>
#else
#ifdef MSDOS /* POHC */
#include <stdlib.h>
#else
char *malloc(), *realloc(), *calloc();
void free();
char *strncpy(), *strncat();
void perror();
void exit();
#endif
#endif

#ifndef MSDOS /* 90/06/22 POHC */
void bcopy();
#endif

/*
 * The following definitions can be used for locking requests in multi-threaded
 * address spaces.
 */
#define LockDisplay(dis)
#define LockMutex(mutex)
#define UnlockMutex(mutex)
#define UnlockDisplay(dis)
#define Xfree(ptr) free((ptr))


/*
 * Note that some machines do not return a valid pointer for malloc(0), in
 * which case we provide an alternate under the control of the
 * define MALLOC_0_RETURNS_NULL.  This is necessary because some
 * Xlib code expects malloc(0) to return a valid pointer to storage.
 */
#ifdef MALLOC_0_RETURNS_NULL

# define Xmalloc(size) malloc(((size) > 0 ? (size) : 1))
# define Xrealloc(ptr, size) realloc((ptr), ((size) > 0 ? (size) : 1))
# define Xcalloc(nelem, elsize) calloc(((nelem) > 0 ? (nelem) : 1), (elsize))

#else

# define Xmalloc(size) malloc((size))
# define Xrealloc(ptr, size) realloc((ptr), (size))
# define Xcalloc(nelem, elsize) calloc((nelem), (elsize))

#endif


/*
 *	ReadvFromServer and WritevToSever use struct iovec, normally found
 *	in Berkeley systems in <sys/uio.h>.  See the readv(2) and writev(2)
 *	manual pages for details.
 *
 *	struct iovec {
 *		caddr_t iov_base;
 *		int iov_len;
 *	};
 */
#ifndef _CADDR_T_DEF_
#ifndef __NDPC__
typedef char *      caddr_t;
#endif
#define _CADDR_T_DEF_ /* MJCR/POHC 91/04/24 */
#endif

#if defined(USG)
#if !defined(CRAY) && !defined(umips)
struct iovec {
    caddr_t iov_base;
    int iov_len;
};
#ifndef __TIMEVAL__
#define __TIMEVAL__
struct timeval {			/* BSD has in <sys/time.h> */
    long tv_sec;
    long tv_usec;
};
#endif /* __TIMEVAL__ */
#endif /* not CRAY or umips */
#endif /* USG */

 
#ifdef STREAMSCONN
#include "Xstreams.h"

#if (!defined(EWOULDBLOCK)) && defined(EAGAIN)
#define EWOULDBLOCK EAGAIN
#endif

extern char _XsTypeOfStream[];
extern Xstream _XsStream[];

#define ReadFromServer(dpy, data, size) \
	(*_XsStream[_XsTypeOfStream[dpy]].ReadFromStream)((dpy), (data), (size), \
						     BUFFERING)
#define WriteToServer(dpy, bufind, size) \
	(*_XsStream[_XsTypeOfStream[dpy]].WriteToStream)((dpy), (bufind), (size))

#else /* else not STREAMSCONN */

/*
 * bsd can read from sockets directly
 */
#define ReadFromServer(dpy, data, size) recv((dpy), (data), (size), 0) /* was read 90/07/05 POHC */
#define WriteToServer(dpy, bufind, size) send((dpy), (bufind), (size), 0) /* was write 90/07/05 POHC */

#endif /* STREAMSCONN */


#ifndef USG
#ifndef MSDOS /* POHC */
#define _XReadV readv
#define _XWriteV writev
#else /* MSDOS */
#define _XReadV recvv
#define _XWriteV sendv
#endif /* MSDOS */
#endif

#define ReadvFromServer(dpy, iov, iovcnt) _XReadV((dpy), (iov), (iovcnt))
#define WritevToServer(dpy, iov, iovcnt) _XWriteV((dpy), (iov), (iovcnt))

#if !defined(sgi) && !defined(MSDOS) /* 90/06/25 POHC */
extern char *index();
#endif
#define SearchString(string, char) index((string), (char))
