/* Project SWORD
   V2.0

   SubSystem  : Little usefull graphical objects
   CommandNos : 3100..3199
   File       : Include/Gadgets/Button.H
   Authors    : Olivier PAYEN, Eric NICOLAS
   Overview   : Objects TButton and TStdButton
   UpDate     : Nov 12, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GADGETS_BUTTON_H_
#define _GADGETS_BUTTON_H_

// ----- Object TButton

#define boDisabled        0x0001
#define boImmediate       0x0002
#define boRepetition      0x0004
#define boNoCase          0x0008
#define boShiftedScanCode 0x0010

// Global commands

#define cmButtonReAction 3100
#define cmOK             3101
#define cmCancel         3102
#define cmCommandEnable  3103
#define cmCommandDisable 3104

// ----- TButton

extern short RegTButton;
extern char *IdentTButton;

struct TButton : TZone
{ long    Command;
  int     ScanCode;
  int     ButtonOptions;
  // Constructors
          TButton();
          TButton(int X ,int Y, int L, int H, long _Command, int _ScanCode, int _Options);
          TButton(TRect& R, long _Command, int _ScanCode, int _Options);
          void     Init(long _Command=0, int _ScanCode=0, int _Options=0);
  virtual ~TButton(void);
  // Events
  virtual boolean  MouseLDown(TPoint& Where, int Buttons);
  virtual boolean  MouseLUp(TPoint& Where, int Buttons);
  virtual boolean  KeyDown(int ScanCode);
  virtual boolean  HandleCommand(long Command, char Info08b=0, short Info16b=0, long Info32b=0, void *InfoPtr=NULL);
  // Graphics
  virtual int      DrawFrame();
  virtual void     DrawInside(int Depl);
  virtual void     Draw(TRect& Clip);
          void     DrawSelect(int Depl);
  // Action
  virtual void     Action();
          void     KeyboardAction();
  // Objects streams
  virtual TAtom*   Duplicate(void);
  virtual void     Read(TDisk* file);
  virtual void     Write(TDisk* file);
};

// ----- TStdButton

extern short RegTStdButton;
extern char *IdentTStdButton;

struct TStdButton : TButton
{ char     *Text,*ParamText;
  TMapping *Mapp;
  int       dXT, dYT;
  int       dXM, dYM;
  // Constructors / Destructors
          TStdButton();
          TStdButton(int X, int Y, int L, int H, long _Command, int _ScanCode, int _Options, char* _Text, TMapping *_Mapp=NULL);
          TStdButton(TRect& R, long _Command, int _ScanCode, int _Options, char* _Text, TMapping* _Mapp);
          void     Init(char* eText=NULL, TMapping *_Mapp=NULL);
          void     Init2(void);
  virtual ~TStdButton(void);
          void     Done(void);
  // Graphics
  virtual void     DrawInside(int Depl);
  virtual void     SetColorGroup(char ColorGroup);
  // Objects streams
  virtual TAtom*   Duplicate(void);
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// ----- Standard Buttons

struct TOKButton : TStdButton
{ TOKButton(int X, int Y);
};

struct TCancelButton : TStdButton
{ TCancelButton(int X, int Y);
};

// Inline functions

inline TAtom* TButton::Duplicate(void)
{ return new TButton();
}

inline TAtom* TStdButton::Duplicate(void)
{ return new TStdButton();
}

#endif // _GADGETS_BUTTON_H_
