/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Include/Gadgets/WFrame.H
   Author    : Eric NICOLAS
   Overview  : TWindowFrame object = Visible frame of a window
   UpDate    : May 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GADGETS_WFRAME_H_
#define _GADGETS_WFRAME_H_

extern short RegTWindowFrameCorner;
extern char *IdentTWindowFrameCorner;
extern short RegTWindowFrame;
extern char *IdentTWindowFrame;
extern short RegTWindowBack;
extern char *IdentTWindowBack;

struct TWindowFrame;

struct TWindowFrameCorner : TZone
{ // Datas
  TSysIcone *Drawing;
  int        Number;
  // Constructors / Destructors
          TWindowFrameCorner();
          TWindowFrameCorner(int X, int Y, char *Descr, int eNCurs,
                             int eNumber, int eOptions);
          void Init(char *Descr=NULL, int NCurs=0, int eNumber=0, int eOptions=0);
  virtual ~TWindowFrameCorner(void);
  // Graphics
  virtual void Draw(TRect& Clip);
  virtual void SetColorGroup(char ColorGroup);
  // Mouse interaction
  virtual boolean       MouseLDown(TPoint& Where, int Buttons);
  // Linked list
          TWindowFrame *Father(void);
};

struct TWindowFrame : TZone
{ // Datas
  TSysIcone *Frames[4];
  // Constructors
           TWindowFrame();
           TWindowFrame(int X, int Y, int L, int H, boolean Sizeable);
           TWindowFrame(TRect& R, boolean Sizeable);
           void     Init(boolean Sizeable=FALSE);
  virtual ~TWindowFrame();
  // Graphics
  virtual void     Draw(TRect& Clip);
  virtual void     ShrinkInside(TRect& InsideFather);
  // Events
  virtual boolean  HandleCommand(long Command, char , short , long , void *);
  // Changing Window Size
          void     ChangeSize(int CornerNo, TPoint mWhere);
  // Objects streams
  virtual TAtom*   Duplicate(void);
  // Linked list
          TWindow *Father(void);
};

struct TWindowBack : TZone
{ // Constructors
           TWindowBack();
           TWindowBack(int X, int Y, int L, int H);
           TWindowBack(TRect& R);
           void     Init(void);
  // Graphics
  virtual void     Draw(TRect& Clip);
  // Objects streams
  virtual TAtom*   Duplicate(void);
};

// Inline functions

inline TAtom* TWindowFrame::Duplicate(void)
{ return new TWindowFrame();
}

inline TAtom* TWindowBack::Duplicate(void)
{ return new TWindowBack();
}

inline TWindowFrame *TWindowFrameCorner::Father(void)
{ return (TWindowFrame*)(TZone::Father());
}

inline TWindow *TWindowFrame::Father(void)
{ return (TWindow*)(TZone::Father());
}

#endif // _GADGETS_WFRAME_H_
