/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Include/Graphics/Colors.H
   Author    : Eric NICOLAS
   Overview  : Managing of colors, dithering
   UpDate    : Oct 02, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GRAPHICS_COLORS_H_
#define _GRAPHICS_COLORS_H_

// ----- Defines

#define colMODE_16        0
#define colMODE_256       1
#define colMODE_TrueColor 2

#define ColorBW           0
#define ColorBlue         1
#define ColorGreen        2
#define ColorRed          3
#define ColorYellow       4

#define Black             0
#define DarkGray          1
#define LightGray         2
#define White             3

// ----- Object for dithering

struct TDither
{ // Constructor / Destructor
          TDither();
  virtual ~TDither();
  // Usefull method
  virtual int      GetRGBColor(int X, int Y, int R, int G, int B);
};

// ----- Variables

extern int      ColorMode;
extern int      NoSysColor[16];
extern int      SysColorGroup[5][4];
extern TDither *Dither;

// ----- Functions

void InitColors(void);
void DoneColors(void);

#endif // _GRAPHICS_COLORS_H_
