/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Include/Graphics/Desktop.H
   Author    : Eric NICOLAS
   Overview  : TDesktop object
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GRAPHICS_DESKTOP_H_
#define _GRAPHICS_DESKTOP_H_

extern short RegTDesktop;
extern char *IdentTDesktop;

struct TDesktop : TZone
{ // Vars
  TScreenZone *ToDrawZones;
  // Constructors
          TDesktop();
	      void     Init(void);
  virtual ~TDesktop(void);
  // Events
  virtual boolean  AutoEvt(void);
  virtual boolean  HandleCommand(long Command, char Info08b=0, short Info16b=0, long Info32b=0, void *InfoPtr=NULL);
  // Graphics
  virtual void     ShowDrawingNow(void);
  virtual void     Insert(TAtom *A);
  virtual void     UpdateClipZone(void);
  virtual void     Invalidate(TRect& What);
  virtual void     Invalidate(void);
  // Linked lists
          TZone*   GetActiveZone(void);
  // Objects streams
  virtual TAtom*   Duplicate(void);
};

extern TDesktop *Desktop;

// Inline functions

inline TAtom* TDesktop::Duplicate(void)
{ return new TDesktop();
}

#endif // _GRAPHICS_DESKTOP_H_
