/* Project SWORD
   V2.0

   SubSystem : Basic objects, General use mecanisms
   File      : Include/Mecanism/Collec.H
   Author    : Eric NICOLAS
   Overview  : Objects TCollection, TSortedCollection : Abstract objects
               for arrays and sorted arrays of variable size
   UpDate    : Mar 18, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _MECANISM_COLLEC_H_
#define _MECANISM_COLLEC_H_

typedef void *Pvoid;

struct TCollection
{ protected:
    Pvoid  *Array;         // Array dynamically allocated in memory
    long    CurrentSize;   // Current size of the array
    long    CurrentItems;  // Current nb of items in the array
    long    IncrSize;      // Increment of the size when too short
  public:
    // Constructor / Destructor
    TCollection(long BeginSize, long SizeIncr);
    virtual ~TCollection();
            void DeleteItems();
    // Acces to datas
    virtual long  Put(Pvoid *Item);
            void *Get(long Position);
            long  NbElements();
  protected:
    // Memory Management
            void ReSize(long NewSize);
};

struct TSortedCollection : public TCollection
{ protected:
    boolean Doublons;        // =TRUE if we accept two same items
  public:
    // Constructor
    TSortedCollection(long BeginSize, long SizeIncr);
    // Acces to datas
    virtual long Put(Pvoid *Item);
            long GetPosition(Pvoid &Item);
    // Sorting methods
            void Sort(void);
  protected:
    virtual int  Comparison(Pvoid Item1, Pvoid Item2) =0;
            void DoSort(long a, long b);
};

#endif // _MECANISM_H_
