/* Project SWORD
   V2.0

   SubSystem : ToolBox for 3D graphics
   File      : Include/ToolBox/Graph3D/Point3D.H
   Author    : Eric NICOLAS
   Overview  : Object TPoint3D : A point (X,Y,Z)
               Object TPoint3DCollection : A sorted collection of points
   UpDate    : Apr  3, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_GRAPH3D_POINT3D_H_
#define _TOOLBOX_GRAPH3D_POINT3D_H_

// ----- Objet TPoint3D

struct TPoint3D
{ protected:
    float _X,_Y,_Z;
  public:
    // Constructors
    TPoint3D();
    TPoint3D(float X, float Y, float Z);
    TPoint3D(TPoint3D& P);
    // Acces to datas
            float &X();
            float &Y();
            float &Z();
            float  Theta();
            float  Phi();
    // operators between TPoint3Ds
            TPoint3D operator+(TPoint3D& P);     // + bewteen each components
            TPoint3D operator+=(TPoint3D& P);
            TPoint3D operator-(TPoint3D& P);     // - bewteen each components
            TPoint3D operator-=(TPoint3D& P);
            TPoint3D operator^(TPoint3D& P);     // vectorial product
            float    operator*(TPoint3D& P);     // scalar product
    // order relation on 3D space
    // :: The order taken is a lexicographic order on X,Y,Z components.
    // :: A comparison is made first on X. If both Xs are equals, a
    // :: comparison is made on Y. If both Ys are equals, a comparison is
    // :: made on Z. If both Z are equals, both points are equals.
    friend  int      comparison(TPoint3D& P1, TPoint3D& P2);
            boolean  operator<(TPoint3D& P);
            boolean  operator>(TPoint3D& P);
            boolean  operator<=(TPoint3D& P);
            boolean  operator>=(TPoint3D& P);
            boolean  operator==(TPoint3D& P);
            boolean  operator!=(TPoint3D& P);
    // operators between TPoint3D and float
    friend  TPoint3D operator*(TPoint3D& P, float F);
    friend  TPoint3D operator/(TPoint3D& P, float F);
    friend  TPoint3D operator*(float F, TPoint3D& P);
            TPoint3D operator*=(float F);
            TPoint3D operator/=(float F);
    // :: +,- unaires
            TPoint3D operator+();
            TPoint3D operator-();
    // functions on TPoint3Ds
    friend  float norm(TPoint3D& P);      // sqrt(P*P)
};

// ----- Object TPoint3DCollection

struct TPoint3DCollection : public TSortedCollection
{ public:
    // Constructor
    TPoint3DCollection(long BeginSize, long SizeIncr);
    // Acces to datas
    long      PutPoint(TPoint3D **P);
    TPoint3D *GetPoint(long Position);
    long      GetPointPosition(TPoint3D *P);
  protected:
    // Order relation
    virtual int  Comparison(Pvoid Item1, Pvoid Item2);
};

// ----- Inline functions

inline float &TPoint3D::X()
{ return _X;
}

inline float &TPoint3D::Y()
{ return _Y;
}

inline float &TPoint3D::Z()
{ return _Z;
}

inline TPoint3D TPoint3D::operator+=(TPoint3D& P)
{ _X+=P._X;
  _Y+=P._Y;
  _Z+=P._Z;
  return *this;
}

inline TPoint3D TPoint3D::operator-=(TPoint3D& P)
{ _X-=P._X;
  _Y-=P._Y;
  _Z-=P._Z;
  return *this;
}

inline float TPoint3D::operator*(TPoint3D& P)
{ return _X*P._X+_Y*P._Y+_Z*P._Z;
}

inline TPoint3D TPoint3D::operator*=(float F)
{ _X*=F;
  _Y*=F;
  _Z*=F;
  return *this;
}

inline TPoint3D TPoint3D::operator/=(float F)
{ _X/=F;
  _Y/=F;
  _Z/=F;
  return *this;
}

inline boolean TPoint3D::operator<(TPoint3D& P)
{ return (boolean)(comparison(*this,P)<0);
}

inline boolean TPoint3D::operator>(TPoint3D& P)
{ return (boolean)(comparison(*this,P)>0);
}

inline boolean TPoint3D::operator<=(TPoint3D& P)
{ return (boolean)(comparison(*this,P)<=0);
}

inline boolean TPoint3D::operator>=(TPoint3D& P)
{ return (boolean)(comparison(*this,P)>=0);
}

inline boolean TPoint3D::operator==(TPoint3D& P)
{ return (boolean)(comparison(*this,P)==0);
}

inline boolean TPoint3D::operator!=(TPoint3D& P)
{ return (boolean)(comparison(*this,P)!=0);
}

inline TPoint3D TPoint3D::operator+()
{ return (*this);
}

inline float TPoint3D::Theta()
{ return atan2(_Y,_X);
}

inline float TPoint3D::Phi()
{ return atan2(_Z,sqrt(_X*_X+_Y*_Y));
}
#endif // _TOOLBOX_GRAPH3D_POINT3D_H_
