/* Project SWORD
   V2.0

   SubSystem : ToolBox for 3D graphics
   File      : Include/ToolBox/Graph3D/Scene.CC
   Author    : Eric NICOLAS
   Overview  : Description of a scene for Radiosity computing
   UpDate    : Apr  3, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_GRAPH3D_SCENE_H_
#define _TOOLBOX_GRAPH3D_SCENE_H_

// Collections of points and facets

struct TPointsCollec : TSortedCollection
{          TPointsCollec();
  virtual  int  Comparison(Pvoid Item1, Pvoid Item2);
};

struct TFacetsCollec : TSortedCollection
{          TFacetsCollec();
  virtual  int  Comparison(Pvoid Item1, Pvoid Item2);
};

// Globals variables

extern TPointsCollec *Points;
extern TFacetsCollec *Facets;
extern TCamera        Camera;
extern TScreen        Screen;

// Functions for Scene manipulation

void InitScene(void);
void DoneScene(void);
void InsertCarre(TPoint3D *P1, TPoint3D *P2, TPoint3D *P3, TPoint3D *P4);
void Show(void);
void Show_Hide(void);

#endif // _TOOLBOX_GRAPH3D_SCENE_H_
