/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Src/Gadgets/Gauge.CC
   Author    : Eric NICOLAS
   Overview  : TGauge object
   UpDate    : Oct 16, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

short RegTGauge;
char *IdentTGauge = "TGauge";

TGauge::TGauge() : TZone()
{ Init();
}

TGauge::TGauge(int X, int Y, int L, int H) : TZone(X,Y,L,H)
{ Init();
}

TGauge::TGauge(TRect& R) : TZone(R)
{ Init();
}

void TGauge::Init(void)
{ Register=RegTGauge;
  Ident=IdentTGauge;
  CurrentValue=0;
}

TGauge::~TGauge(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TGauge::SetValue(int V)
{ if ((V<0) || (V>100)) return;
  if (V!=CurrentValue)
  { CurrentValue=V;
	 Invalidate(2,2,Where.L()-3,Where.H()-3);
  }
}

void TGauge::Draw(TRect& )
{ // Fond
  int LProgress=(Where.L()-4)*CurrentValue/100;
  // :: Part 1 : Progress status : Done
  if (LProgress>0)
  { SetSysColor(GetColor(1));
    Bar(2,2,2+LProgress-1,Where.H()-3);
  }
  // :: Part 2 : Progress status : To do
  if (LProgress<Where.L()-4)
  { SetSysColor(GetColor(2));
    Bar(2+LProgress,2,Where.L()-3,Where.H()-3);
  }
  // Frame
  Frame3D(1);
  // Texte
  SetSysColor(GetColor(3));
  char Buffer[10];
  sprintf(Buffer,"%d %%",CurrentValue);
  FontSystem->XAlignCenter();
  FontSystem->YAlignCenter();
  FontSystem->ChooseFace(FFace_BOLD);
  PutStr(Where.L()/2, Where.H()/2, Buffer, FontSystem);
  FontSystem->ChooseFace(FFace_NORMAL);
  FontSystem->AlignDefault();
}
