/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Src/Gadgets/Menus.CC
   Author    : Eric NICOLAS
   Overview  : TMenu, TMenuChoice objects : Menu Bar
   UpDate    : Nov 20, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

// ===== Globals ============================================================

TMenu *MainMenu;

// ===== Routine utilitaire =================================================

char *QWERTYstr1 = "QWERTZUIOP";
char *QWERTYstr2 = "ASDFGHJKL";
char *QWERTYstr3 = "YXCVBNM";

char *MakeHotText(int SC)
{ char Temp[20];
  *Temp=0;
  // Ctrl+A..Z
  if ((SC>=0x0001)&&(SC<=0x001A)) sprintf(Temp,"Ctrl+%c",(char)(SC-0x0001)+'A');
  // Alt+QWER...
  if ((SC>=0x1000)&&(SC<=0x1900)) sprintf(Temp,"Alt+%c",QWERTYstr1[(SC-0x1000)>>8]);
  // Alt+ASDF...
  if ((SC>=0x1E00)&&(SC<=0x2600)) sprintf(Temp,"Alt+%c",QWERTYstr2[(SC-0x1E00)>>8]);
  // Alt+YXCV...
  if ((SC>=0x2C00)&&(SC<=0x3200)) sprintf(Temp,"Alt+%c",QWERTYstr3[(SC-0x2C00)>>8]);
  // F1...10
  if ((SC>=0x3B00)&&(SC<=0x4400)) sprintf(Temp,"F%d",((SC-0x3B00) >> 8)+1);
  // Shift+F1...10
  if ((SC>=0x5400)&&(SC<=0x5D00)) sprintf(Temp,"Shift+F%d",((SC-0x5400) >> 8)+1);
  // Ctrl+F1...10
  if ((SC>=0x5E00)&&(SC<=0x6700)) sprintf(Temp,"Ctrl+F%d",((SC-0x5E00) >> 8)+1);
  // Alt+F1...10
  if ((SC>=0x6800)&&(SC<=0x7100)) sprintf(Temp,"Alt+F%d",((SC-0x6800) >> 8)+1);
  if (*Temp) return strdup(Temp);
  return NULL;
}

// ===== TMenuChoice Object =================================================

short RegTMenuChoice;
char *IdentTMenuChoice = "TMenuChoice";

TMenuChoice::TMenuChoice() : TZone()
{ Init(NULL,0,0,NULL,0,opSeparator);
}

TMenuChoice::TMenuChoice(char *_Text, int _GlobalScanCode, int _Command,
                         int _Status, int _Options) : TZone()
{ Init(_Text, _GlobalScanCode, _Command, NULL, _Status, _Options);
}

TMenuChoice::TMenuChoice(char *_Text, TMenu *_SubMenu, int _Status) : TZone()
{ Init(_Text, 0, 0, _SubMenu, _Status, 0);
}

void TMenuChoice::Init(char *_Text, int _GlobalScanCode, int _Command,
                       TMenu *_SubMenu, int _Status, int _Options)
{ char *P;
  //
  Register=RegTMenuChoice;
  Ident=IdentTMenuChoice;
  // Parameters
  if (_Text!=NULL) Text=strdup(_Text); else Text=NULL;
  GlobalScanCode=_GlobalScanCode;
  Command=_Command;
  SubMenu=_SubMenu;
  SetOptions(_Options);
  SetStatus(_Status);
  // Variables calculees
  // :: HotText
  if (GlobalScanCode) HotText=MakeHotText(GlobalScanCode);
                 else HotText=NULL;
  // :: LocalScanCode
  LocalScanCode=0;
  if (Text!=NULL)
  { P=strchr(Text,'&');
    if (P!=NULL) LocalScanCode=(short)(*(P+1));
  }
}

TMenuChoice::~TMenuChoice(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TMenuChoice::Done(void)
{ if (SubMenu!=NULL) delete SubMenu;
  if (Text!=NULL) free(Text);
  if (HotText!=NULL) free(HotText);
  TZone::Done();
}

void TMenuChoice::Draw(TRect& )
{ if (GetOptions(opSeparator))
  { // -- Trac d'un sparateur
    SetSysColor(GetColor(DarkGray));
    LineX(0,2,Where.L()-1);
    SetSysColor(GetColor(White));
    LineX(0,3,Where.L()-1);
    SetSysColor(GetColor(LightGray));
    Bar(0,0,Where.L()-1,1);
    Bar(0,4,Where.L()-1,5);
  }
  else
  { // -- Trac d'un choix
    // Fond
    if (GetStatus(sfMenuChoiceDown)) SetSysColor(GetColor(DarkGray));
                                else SetSysColor(GetColor(LightGray));
    Bar(0,0,Where.L()-1,Where.H()-2);
    // Sparation
    SetSysColor(GetColor(LightGray));
    LineX(0,Where.H()-1,Where.L()-1);
    // Texte
    if (GetStatus(sfDisabled)) SetSysColor(GetColor(DarkGray));
                          else SetSysColor(GetColor(Black));
    PutSysStr(2,1,Text,FontSystem);
    // Raccourcis ou '>>'
    FontSystem->XAlignRight();
    if (SubMenu!=NULL) PutStr(Where.L()-3,1,">>",FontSystem);
                  else PutStr(Where.L()-3,1,HotText,FontSystem);
    FontSystem->XAlignDefault();
  }
}

void TMenuChoice::BecomeActiveZone(void)
{ TZone::BecomeActiveZone();
  Down();
}

void TMenuChoice::LeaveActiveZone(void)
{ TZone::LeaveActiveZone();
  Up();
}

void TMenuChoice::Down(void)
{ if (!GetStatus(sfDisabled))
    if (!GetStatus(sfMenuChoiceDown))
    { // Lve tous les autres choix
      TZone *Z=First();
      while(Z!=NULL)
      { if (Z->Register==RegTMenuChoice) ((TMenuChoice*)Z)->Up();
        Z=Z->Next();
      }
      // Descends ce choix
      SetStatus(sfMenuChoiceDown);
      Invalidate();
    }
}

void TMenuChoice::Up(void)
{ if (!GetStatus(sfDisabled))
    if (GetStatus(sfMenuChoiceDown))
    { ClearStatus(sfMenuChoiceDown);
      Invalidate();
    }
}

void TMenuChoice::Activate()
{ if (Command!=0)
  { // Le bouton declenche une commande
    SetCommand(Command);
    Father()->CloseMenu();
  }
  else
    if (SubMenu!=NULL)
    { // Le bouton declenche un sous-menu
      // :: Positionne le sous-menu
      int L=SubMenu->Where.L();
      int H=SubMenu->Where.H();
      SubMenu->Where.X1()=Corner.X()+Where.L();
      SubMenu->Where.Y1()=Corner.Y()+Where.H()-46;
      SubMenu->Where.X2()=SubMenu->Where.X1()+L-1;
      SubMenu->Where.Y2()=SubMenu->Where.Y1()+H-1;
      // :: Affiche le sous-menu
      Desktop->Insert(SubMenu);
    }
}

boolean TMenuChoice::MouseLDown(TPoint& , int )
{ if (GetStatus(sfMouseIn)&&(!GetStatus(sfDisabled)))
  { Activate();
    return TRUE;
  }
  return FALSE;
}

TMenuChoice* TMenuChoice::NextChoice()
{ TZone* Z=Next();
  while(Z!=NULL)
  { if (Z->Register==RegTMenuChoice)
      if (!Z->GetStatus(sfDisabled)) return (TMenuChoice*)Z;
    Z=Z->Next();
  }
  return NULL;
}

TMenuChoice* TMenuChoice::PrevChoice()
{ TZone* Z=Previous();
  while(Z!=NULL)
  { if (Z->Register==RegTMenuChoice)
      if (!Z->GetStatus(sfDisabled)) return (TMenuChoice*)Z;
    Z=Z->Previous();
  }
  return NULL;
}

// ===== TMenu Object =======================================================

short RegTMenu;
char *IdentTMenu = "TMenu";

TMenu::TMenu() : TStdWindow()
{ Init();
}

TMenu::TMenu(char *Text, int _Options) : TStdWindow(10,10,100,50,Text,FALSE)
{ Init(_Options);
}

void TMenu::Init(int _Options)
{ Register=RegTMenu;
  Ident=IdentTMenu;
  SetOptions(_Options);
  if (GetOptions(opMainMenu)) MainMenu=this;
}

void TMenu::InitAfterInsert(void)
{ SetColorGroup(ColorGreen);
}

TMenu::~TMenu(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TMenu::InitChoices(void)
{ int          dL, dH;
  int          y, h;
  TMenuChoice *MC;
  // Calcul des tailles
  dL=CompWidth()-Where.L();
  dH=CompHeight()-Where.H();
  DoChangeSize(dL,dH);
  // Positionnement et taille des diff. choix
  MC=(TMenuChoice*)Son();
  y=26;
  while(MC!=NULL)
  { if (MC->Register==RegTMenuChoice)
    { if (MC->SubMenu!=NULL)
      { MC->SubMenu->FatherMenu=this;
        MC->SubMenu->InitChoices();
      }
      if (MC->GetOptions(opSeparator)) h=6;
                                  else h=20;
      MC->Where.X1()=7;
      MC->Where.Y1()=y;
      MC->Where.X2()=Where.L()-8;
      MC->Where.Y2()=y+h-1;
      MC->wText=wText;
      MC->wHotText=wHotText;
      y+=h;
    }
    MC=(TMenuChoice*)MC->Next();
  }
}

int TMenu::CompWidth()
{ int          i;
  TMenuChoice *MC;
  //
  MC=(TMenuChoice*)Son();
  wText=0;
  wHotText=FontSystem->WidthStr(">>");
  while(MC!=NULL)
  { if (MC->Register==RegTMenuChoice)
    { i=FontSystem->WidthSysStr(MC->Text);
      if (i>wText) wText=i;
      i=FontSystem->WidthStr(MC->HotText);
      if (i>wHotText) wHotText=i;
    }
    MC=(TMenuChoice*)MC->Next();
  }
  return wText+wHotText+25;
}

int TMenu::CompHeight()
{ int          h;
  TMenuChoice *MC;
  //
  MC=(TMenuChoice*)Son();
  h=32;
  while(MC!=NULL)
  { if (MC->Register==RegTMenuChoice)
    { if (MC->GetOptions(opSeparator)) h+=6;
                                  else h+=20;
    }
    MC=(TMenuChoice*)MC->Next();
  }
  return h;
}

void TMenu::Draw(TRect& )
{ SetSysColor(GetColor(LightGray));
  Bar(5,26,6,Where.H()-6);
  Bar(Where.L()-7,26,Where.L()-6,Where.H()-6);
  LineX(7,Where.H()-6,Where.L()-8);
}

boolean TMenu::MouseLDown(TPoint& Where, int Buttons)
{ if (!GetStatus(sfMouseIn))
    if (!GetOptions(opMainMenu))
    { // C'est pas le menu principal et on clique a l'exterieur
      // -> Il faut l'enlever du bureau
      CloseMenu();
      return TRUE;
    }
  return TStdWindow::MouseLDown(Where,Buttons);
}

boolean TMenu::KeyDown(int ScanCode)
{ TMenuChoice *MC,*nMC;
  switch(ScanCode)
  { case ScanEscape :
      CloseMenu();
      return TRUE;
    case ScanUpArrow :
      MC=ActiveChoice();
      if (MC==NULL) nMC=LastChoice();
               else { nMC=MC->PrevChoice();
                      if (nMC==NULL) nMC=LastChoice();
                    }
      nMC->Down();
      return TRUE;
    case ScanDownArrow :
      MC=ActiveChoice();
      if (MC==NULL) nMC=FirstChoice();
               else { nMC=MC->NextChoice();
                      if (nMC==NULL) nMC=FirstChoice();
                    }
      nMC->Down();
      return TRUE;
    case ScanReturn :
      MC=ActiveChoice();
      if (MC==NULL) CloseMenu();
               else MC->Activate();
      return TRUE;
  }
  // Test tous les raccourcis locaux
  MC=FirstChoice();
  while(MC!=NULL)
  { if (ScanCode==MC->LocalScanCode)
    { MC->Down();
      MC->Activate();
      return TRUE;
    }
    MC=MC->NextChoice();
  }
  return FALSE;//TStdWindow::KeyDown(ScanCode);
}

void TMenu::CloseMenu(void)
{ if (!GetOptions(opMainMenu))
  { // Enlve le menu du bureau
    UnLink();
    // Dsactive tous les choix
    TZone *Z=Son();
    while(Z!=NULL)
    { if (Z->Register==RegTMenuChoice)
        ((TMenuChoice*)Z)->Up();
      Z=Z->Next();
    }
    // Ferme aussi le pre si c'est un sous-...-sous-Menu
    FatherMenu->CloseMenu();
  }
}

TMenuChoice *TMenu::ActiveChoice()
{ TZone *Z=Son();
  while(Z!=NULL)
  { if (Z->Register==RegTMenuChoice)
      if (!Z->GetStatus(sfDisabled)) return (TMenuChoice*)Z;
    Z=Z->Next();
  }
  return NULL;
}

TMenuChoice *TMenu::FirstChoice()
{ TZone *Z=Son();
  while(Z!=NULL)
  { if (Z->Register==RegTMenuChoice)
      if (!Z->GetStatus(sfDisabled)) return (TMenuChoice*)Z;
    Z=Z->Next();
  }
  return NULL;
}

TMenuChoice *TMenu::LastChoice()
{ TZone *Z=Son()->Last();
  while(Z!=NULL)
  { if (Z->Register==RegTMenuChoice)
      if (!Z->GetStatus(sfDisabled)) return (TMenuChoice*)Z;
    Z=Z->Previous();
  }
  return NULL;
}
