/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Src/Graphics/ScrZone.CC
   Author    : Eric NICOLAS
   Overview  : TScreenZone object
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"

// ----- TScreenZone

TScreenZone::TScreenZone(int X1, int Y1, int X2, int Y2) : TAtom()
{ Where=TRect(X1,Y1,X2,Y2);
}

TScreenZone::TScreenZone(TRect& W) : TAtom()
{ Where=W;
}

TScreenZone::TScreenZone() : TAtom()
{ Where=TRect();
}

TScreenZone::~TScreenZone(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

int TScreenZone::Clip(TScreenZone *SZ, TRect& RZ)
{ TRect R, RC;
  int   V;
  R=SZ->Where-RZ;
  RC=SZ->Where;
  if (!R.Empty())
  { // Tests gnraux
    V=0;
    if (RC.X1()==R.X1()) V|=1;
    if (RC.X2()==R.X2()) V|=2;
    if (RC.Y1()==R.Y1()) V|=4;
    if (RC.Y2()==R.Y2()) V|=8;
    // On calcule les rectangles qui composent RC moins R
    switch(V)
    { case 0:
      case 1:
      case 2:
        if (V!=1) InsertBefore(new TScreenZone(RC.X1(),R.Y1(),R.X1()-1,R.Y2()));
        if (V!=2) InsertBefore(new TScreenZone(R.X2()+1,R.Y1(),RC.X2(),R.Y2()));
      case 3:
        InsertBefore(new TScreenZone(RC.X1(),R.Y2()+1,RC.X2(),RC.Y2()));
        SZ->Where.Y2()=R.Y1()-1;
        break;
      case 4:
      case 5:
      case 6:
        if (V!=5) InsertBefore(new TScreenZone(RC.X1(),RC.Y1(),R.X1()-1,R.Y2()));
        if (V!=6) InsertBefore(new TScreenZone(R.X2()+1,RC.Y1(),RC.X2(),R.Y2()));
      case 7:
        SZ->Where.Y1()=R.Y2()+1;
        break;
      case 8:
      case 9:
      case 10:
        if (V!=9)  InsertBefore(new TScreenZone(RC.X1(),R.Y1(),R.X1()-1,R.Y2()));
        if (V!=10) InsertBefore(new TScreenZone(R.X2()+1,R.Y1(),RC.X2(),RC.Y2()));
      case 11:
        SZ->Where.Y2()=R.Y1()-1;
        break;
      case 12:
        InsertBefore(new TScreenZone(R.X2()+1,RC.Y1(),RC.X2(),R.Y2()));
      case 14:
        SZ->Where.X2()=R.X1()-1;
        break;
      case 13:
        SZ->Where.X1()=R.X2()+1;
        break;
      case 15:
        delete SZ;
        break;
    }
    return 1;
  }
  return 0;
}

void TScreenZone::RegroupZones()
{ TScreenZone *SZ, *SZ2, *SZn;
  int          V;
  // Tentatives de fusions de zones contigues
ReStart:
  SZ=Son();
  while(SZ!=NULL)
  { SZ2=SZn=SZ->Next();
    while(SZ2!=NULL)
    { V=0;
      if ((SZ->Where.X1()==SZ2->Where.X1())&&
          (SZ->Where.X2()==SZ2->Where.X2()))
      { if (SZ->Where.Y2()+1==SZ2->Where.Y1())
        { SZ2->Where.Y1()=SZ->Where.Y1();
          V=1;
        }
        else
        if (SZ2->Where.Y2()+1==SZ->Where.Y1())
        { SZ2->Where.Y2()=SZ->Where.Y2();
          V=1;
        }
      }
      if ((SZ->Where.Y1()==SZ2->Where.Y1())&&
          (SZ->Where.Y2()==SZ2->Where.Y2()))
     { if (SZ->Where.X2()+1==SZ2->Where.X1())
       { SZ2->Where.X1()=SZ->Where.X1();
         V=1;
       }
       else
        if (SZ2->Where.X2()+1==SZ->Where.X1())
        { SZ2->Where.X2()=SZ->Where.X2();
          V=1;
        }
      }
      if (V)
      { delete SZ;
        goto ReStart;
      }
      SZ2=SZ2->Next();
    }
    SZ=SZn;
  }
  // Suppression des zones de recouvrement entre plusieurs Screen Zone
  SZ=Son();
  while(SZ!=NULL)
  { SZ2=SZ->Next();
    while(SZ2!=NULL)
    { // Supprime ventuellement les recouvrements entre SZ et SZ2
      if (Clip(SZ,SZ2->Where)) goto ReStart;
      //
      SZ2=SZ2->Next();
    }
    SZ=SZ->Next();
  }
}
