/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Src/Graphics/Shell.CC
   Author    : Eric NICOLAS
   Overview  : Basic object : creation of events, mouse management
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"

#include <time.h>

// Variables globales

short         RegTShell;
char         *IdentTShell = "TShell";
long          ScreenSaverDelay;
TScreenSaver *ScreenSaver;

// Variables locales

long  AlarmTime;
long  AlarmComm;
long  AlarmDelay;
void *AlarmPtr;
long  ScreenSaverTime;

// Constructeur, Destructeur

TShell::TShell(void) : TObject()
{ Register=RegTShell;
  Ident=IdentTShell;
  NbEventStock=0;
/*Time.Second=70;
  Time.Minute=70;
  Time.Hour=25;*/
  AlarmComm=0;
  MouseActiveZone=NULL;
  // Build the default Screen Saver
  ScreenSaver=new TScreenSaver(this);
  ScreenSaverTime=GetTime()/100;
  ScreenSaverDelay=10;
}

TShell::~TShell(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

// Mouse events

void TShell::GetKeyMouseEvent(TEvent *Event)
{ // Capte tous les vnements
  MouseEvent evt;
  MouseGetEvent(M_EVENT | M_POLL,&evt);
  if (evt.flags & M_KEYPRESS)   { Event->What=evKeyDown;    goto fin; }
  if (evt.flags & M_LEFT_DOWN)  { Event->What=evMouseLDown; goto fin; }
  if (evt.flags & M_RIGHT_DOWN) { Event->What=evMouseRDown; goto fin; }
  if (evt.flags & M_LEFT_UP)    { Event->What=evMouseLUp;   goto fin; }
  if (evt.flags & M_RIGHT_UP)   { Event->What=evMouseRUp;   goto fin; }
  if (evt.flags & M_MOTION)     { Event->What=evMouseMove;  goto fin; }
  return;
fin:
  Event->Where.X()=evt.x;
  Event->Where.Y()=evt.y;
  Event->Buttons=evt.buttons;
  if (evt.key & 0xFF00) Event->ScanCode=(evt.key & 0xFF) << 8;
                   else Event->ScanCode=(evt.key & 0xFF);
  Event->KbStat=evt.kbstat;
}

// Time event and Alarms

void SetAlarm(long Comm, long Delay, void *Ptr)
{ AlarmTime=GetTime();
  AlarmComm=Comm;
  AlarmDelay=Delay;
  AlarmPtr=Ptr;
}

void TShell::GetTimeEvent(TEvent* Event)
{ long Time=GetTime();
  // Vrifie l'ventuelle alarme
  if (AlarmComm)
    if (Time-AlarmTime>AlarmDelay)
    { Event->What=evCommand;
      Event->Command=AlarmComm;
      Event->InfoPtr=AlarmPtr;
      AlarmComm=0;
      return;
    }
/*
  // Met  jour les compteurs et envoie les Events
  if ((btime.ti_sec!=Time.Second) ||
      (btime.ti_min!=Time.Minute) ||
      (btime.ti_hour!=Time.Hour))
  { Time.Second=btime.ti_sec;
    Time.Hour=btime.ti_hour;
    Time.Minute=btime.ti_min;
    Event->What=evTime;
    return;
  }
  if ((bdate.da_year!=Time.Year) ||
      (bdate.da_mon!=Time.Month) ||
      (bdate.da_day!=Time.Day))
  { Time.Year=bdate.da_year;
    Time.Month=bdate.da_mon;
    Time.Day=bdate.da_day;
    Event->What=evDate;
    return;
  }*/
}

//

void TShell::GetEvent(TEvent* Event)
{ // Par dfaut, aucun vnement
  Event->What=evNothing;
  // Regarde d'abord le stock
  if (NbEventStock)
  { NbEventStock--;
    *Event=EventStock[NbEventStock];
  }
  else
  { // Puis les divers priphriques d'entre
    GetKeyMouseEvent(Event);
    if (Event->What!=evNothing)
    { // Un vnement utilisateur a eu lieu -> Il faut remettre  zro
      // Le dlai d'conomiseur d'cran
      ScreenSaverTime=GetTime()/100;
    }
    else
      if (GetTime()/100-ScreenSaverTime>ScreenSaverDelay)
      { // Le dlai d'inactivit est dpass -> Dclencher le ScreenSaver
        // 1. Excute l'conomiseur jusqu' une action utilisateur
        ScreenSaver->Execute();
        // 2. Demande la Restauration de l'cran
        Event->What=evCommand;
        Event->Command=cmReDrawScreen;
        // 3. Reset du timing
        ScreenSaverTime=GetTime()/100;
        return;
      }
    if (Event->What==evNothing) GetTimeEvent(Event);
    // Si aucun, envoie l'vnement automatique
    if (Event->What==evNothing) Event->What=evAuto;
  }
}

void TShell::SetEvent(TEvent *Event)
{ if (NbEventStock==MaxEventStock)
  { /*ErrorMsg("Erreur programmeur",
             "Trop d'vnements stocks par SetEvent");*/
  }
  else
  { EventStock[NbEventStock]=*Event;
    NbEventStock++;
  }
}

boolean TShell::ToggleKey()
{/* TEvent Event;
  TObject::ToggleKey();
  Event.What=evCommand;
  Event.Command=cmDrawCursor;
  HandleEvent(&Event);
  CursorIns=(Toggle & tgIns);
  Event.What=evCommand;
  Event.Command=cmDrawCursor;
  HandleEvent(&Event);*/
  return TRUE;
}

boolean TShell::Focus(void)
{ return TRUE;
}

long TShell::EventsLoop(TObject *O)
{ TEvent Event;
  O->ExitCode=0L;
  do
  { GetEvent(&Event);
//    if (Event.What & evNotModal)
      HandleEvent(&Event);
//    else
//      O->HandleEvent(&Event);
  } while(!(O->ExitCode));
  return(O->ExitCode);
}

void TShell::HandleEvent(TEvent *Event)
{ // Handling of Mouse Cursor Aspect when the mouse fly over screen objects
  if (Event->What==evMouseMove)
  { TZone *OldMouseActive = MouseActiveZone;
    MouseActiveZone=NULL;
    TObject::HandleEvent(Event);
    if (OldMouseActive!=MouseActiveZone)
    { if (OldMouseActive!=NULL) OldMouseActive->LeaveActiveZone();
      OldMouseActive=MouseActiveZone;
      if (MouseActiveZone!=NULL) MouseActiveZone->BecomeActiveZone();
    }
  }
  // Normal events handling
  else TObject::HandleEvent(Event);
}

boolean TShell::HandleCommand(long Command, char Info08b, short Info16b, long Info32b, void *InfoPtr)
{ TEvent     Event;
  GrCursor *Cursor;
  if (TObject::HandleCommand(Command,Info08b,Info16b,Info32b,InfoPtr)) return TRUE;
  switch(Command)
  { case cmUpdateMouse :
     Cursor=MouseGetCursor();
     Event.What=evMouseMove;
     Event.Where.X()=Cursor->cr_xcord;
     Event.Where.Y()=Cursor->cr_ycord;
     SetEvent(&Event);
     return TRUE;
  }
  return FALSE;
}

// ----- Screen Saver

TScreenSaver::TScreenSaver(TShell *Shell)
{ TheShell=Shell;
}

boolean TScreenSaver::NoUserAction(void)
{ TEvent Event;
  Event.What=evNothing;
  TheShell->GetKeyMouseEvent(&Event);
  return (boolean)(Event.What==evNothing);
}

void TScreenSaver::Execute(void)
{ NoStep=0;
  Init();
  do
  { Step();
    NoStep++;
  } while(NoUserAction());
  Done();
}

void TScreenSaver::Init(void)
{ // Blank Screen
  GrSetClipBox(0,0,GrMaxX(),GrMaxY());
  GrFilledBox(0,0,GrMaxX(),GrMaxY(),NoSysColor[0]);
  // Change le curseur souris
  ChangeMouseAspect(MouseCursorInactivity);
  MouseChangeTime=GetTime()/100;
}

void TScreenSaver::Step(void)
{ // Change in a random way the mouse cursor position, every seconds
  if (GetTime()/100-MouseChangeTime>=1)
  { MouseWarp(20+Random(GrMaxX()-40),20+Random(GrMaxY()-40));
    MouseChangeTime=GetTime()/100;
  }
}

void TScreenSaver::Done(void)
{ // Restaure le curseur souris
  RestoreMouseAspect();
}
