/* Project SWORD
   V2.0

   SubSystem : ToolBox for 3D graphics
   File      : LibSrc/ToolBox/Graph3D/Scene.CC
   Author    : Eric NICOLAS
   Overview  : Description of a scene for Radiosity computing
   UpDate    : Apr  3, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <math.h>
#include <graphics.h>

#include "Common/Common.H"
#include "Mecanism/Collec.H"
#include "ToolBox/Graph3D/Point3D.H"
#include "ToolBox/Graph3D/Facet.H"
#include "ToolBox/Graph3D/Transf.H"
#include "ToolBox/Graph3D/Camera.H"
#include "ToolBox/Graph3D/Screen.H"
#include "ToolBox/Graph3D/Scene.H"

// Globals variables

TPointsCollec *Points;
TFacetsCollec *Facets;
TCamera        Camera;
TScreen        Screen;

// Collections of points and facets

TPointsCollec::TPointsCollec() : TSortedCollection(10,10)
{ Doublons=FALSE;
}

int TPointsCollec::Comparison(Pvoid Item1, Pvoid Item2)
{ TPoint3D *P1=(TPoint3D*)Item1;
  TPoint3D *P2=(TPoint3D*)Item2;
  return comparison(*P1,*P2);
}


TFacetsCollec::TFacetsCollec() : TSortedCollection(5,5)
{ Doublons=TRUE;
}

int TFacetsCollec::Comparison(Pvoid Item1, Pvoid Item2)
{ TFacet   *F1=(TFacet*)Item1;
  TFacet   *F2=(TFacet*)Item2;
  TPoint3D  V1=F1->Barycenter()-Camera.Position;
  TPoint3D  V2=F2->Barycenter()-Camera.Position;
  float     N1=norm(V1), N2=norm(V2);
  if (N1<N2) return -1;
  if (N1>N2) return 1;
  return 0;
}

// Functions for Scene manipulation

void InitScene(void)
{ Points=new TPointsCollec();
  Facets=new TFacetsCollec();
}

void DoneScene(void)
{ delete Points;
  delete Facets;
}

void InsertCarre(TPoint3D *P1, TPoint3D *P2, TPoint3D *P3, TPoint3D *P4)
{ Points->Put(&((Pvoid)P1));
  Points->Put(&((Pvoid)P2));
  Points->Put(&((Pvoid)P3));
  Points->Put(&((Pvoid)P4));
  TFacet *F1=new TFacet(P1,P2,P4);
  TFacet *F2=new TFacet(P2,P3,P4);
  Facets->Put(&((Pvoid)F1));
  Facets->Put(&((Pvoid)F2));
}

void Show(void)
{ int     i;
  TFacet *F;
  float   X1,X2,X3;
  float   Y1,Y2,Y3;
  float   S1,S2,S3;
  int     E1,E2,E3;
  int     SC[6];
  Camera.SetUp();
  Screen.SetUp();
  setcolor(7);
  for(i=0;i<Facets->NbElements();i++)
  { F=(TFacet*)(Facets->Get(i));
    E1=Camera.Projection(F->P1(),X1,Y1,S1);
    E2=Camera.Projection(F->P2(),X2,Y2,S2);
    E3=Camera.Projection(F->P3(),X3,Y3,S3);
    if (E1 && E2 && E3)
    { Screen.RealToScreen(X1,Y1,SC[0],SC[1]);
      Screen.RealToScreen(X2,Y2,SC[2],SC[3]);
      Screen.RealToScreen(X3,Y3,SC[4],SC[5]);
      line(SC[0],SC[1],SC[2],SC[3]);
      line(SC[2],SC[3],SC[4],SC[5]);
      line(SC[4],SC[5],SC[0],SC[1]);
    }
  }
}

void Show_Hide(void)
{ int     i;
  TFacet *F;
  float   X1,X2,X3;
  float   Y1,Y2,Y3;
  float   S1,S2,S3;
  int     E1,E2,E3;
  int     SC[8];
  Camera.SetUp();
  Screen.SetUp();
  setfillstyle(SOLID_FILL,0);
  setcolor(7);
  for(i=0;i<Facets->NbElements();i++)
  { F=(TFacet*)(Facets->Get(i));
    E1=Camera.Projection(F->P1(),X1,Y1,S1);
    E2=Camera.Projection(F->P2(),X2,Y2,S2);
    E3=Camera.Projection(F->P3(),X3,Y3,S3);
    if (E1 && E2 && E3)
    { Screen.RealToScreen(X1,Y1,SC[0],SC[1]);
      Screen.RealToScreen(X2,Y2,SC[2],SC[3]);
      Screen.RealToScreen(X3,Y3,SC[4],SC[5]);
      SC[6]=SC[0];
      SC[7]=SC[1];
      fillpoly(4,SC);
    }
  }
}
