/* Project SWORD
   V2.0

   SubSystem : Image manipulation tools
   File      : Src/ToolBox/Image/ImgFile.CC
   Author    : Cedric JOULAIN, Eric NICOLAS
   Overview  : TImageFile Object
   UpDate    : Nov 11, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "../Src/ToolBox/Image/JPEG/ImgJPEG.H"
#include "ToolBox/Image/ImgFile.H"

TImageFile::TImageFile(int W, int H)
{ Height = H;
  Width = W;
  if (W*H)
  { // Because jpeg library is in C we use malloc and free
    R = (byte *) malloc(W*H);
    G = (byte *) malloc(W*H);
    B = (byte *) malloc(W*H);
    GC = GrCreateContext(W,H,NULL,NULL);
  }
  else
  { R = NULL;
    G = NULL;
    B = NULL;
    GC = NULL;
  }
}

TImageFile::~TImageFile(void)
{ // Because jpeg library is in C we use malloc and free
  if (R)	 free(R);
  if (G)	 free(G);
  if (B)	 free(B);
  if (GC) GrDestroyContext(GC);
}

void TImageFile::Load(char *Name)
{ // Charge l'image
  int I;
  char c='\0';
  for(I=0; Name[I]; I++)
    if(Name[I]=='.') c = Name[I+1];
  /* if extension != .J** not a JPEG file */
  if((c != 'J')&&(c != 'j')) Load_C (Name, &Width, &Height, &R, &G, &B);
                        else read_JPEG_file (Name, &Width, &Height, &R, &G, &B);
  // Place l'image dans le buffer au format de l'cran
  RawToScreen();
}

void TImageFile::Save(char */*Name*/)
{
}

void TImageFile::RawToScreen(void)
{ int   i,j;
  byte *Rp=R;
  byte *Gp=G;
  byte *Bp=B;

  // Fill the device context with our image
  BeginDraw();
  for(j=0;j<Height;j++)
	 for(i=0;i<Width;i++)
	 { GrPlot(i,j,Dither->GetRGBColor(i,j,*Rp,*Gp,*Bp));
		Rp++;
		Gp++;
		Bp++;
	 }
  EndDraw();
}

void TImageFile::Draw(int Xs, int Ys, int Xd, int Yd, int W, int H)
{ GrBitBlt(NULL,Xd,Yd,GC,Xs,Ys,Xs+W-1,Ys+H-1,GrWRITE);
}

void TImageFile::BeginDraw(void)
{ GrSetContext(GC);
}

void TImageFile::EndDraw(void)
{ GrSetContext(NULL);
}
