// lbinstdj.h - defines main application class lbinstdj_app.
//    Copyright (C) 2000 Laurynas Biveinis <lauras@softhome.net>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#ifndef LBINSTDJ_H_
#define LBINSTDJ_H

#include "global.h"
#include "pathdlg.h"

#ifdef HAVE_TV_H
#   define Uses_TApplication
#   define Uses_TDeskTop
#   define Uses_TEvent 
#   define Uses_TRect
#   define Uses_TStatusLine
#   define Uses_TValidator
#   include <tv.h>
#endif

class lbinstdj_app : public TApplication
{
    public:
        lbinstdj_app(void); 

        virtual void         handleEvent(TEvent& event);
        static  TDeskTop    *initDeskTop(TRect r);
        static  TMenuBar    *initMenuBar(TRect r);
        static  TStatusLine *initStatusLine(TRect r);
        
    private:
        bool check_for_reg_key(const char * key, const char * value);
        void do_installation(void);
        void errno_box(const char * message);
        int  exec_command(const char * command, const char * message);
        void exit_request(const int message);
        void get_dir(path_dialog * dialog, char * dir);
        void greetings(void);
        void init_zippo(const char * dir);
        void merge_registry_file(const char * file);
        bool num_tails_enabled(void);
        void old_installation(const char * djdir, const char * zipdir);
        void restore_num_tails(void);
        void update_autoexec_bat(const char * dir);
        void update_registry(void);
};

#endif // #ifndef LBINSTDJ_H_