// path.cc - implements path input class - path_dialog.
//    Copyright (C) 2000 Laurynas Biveinis <lauras@softhome.net>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

#include "global.h"

#include "choosedr.h"
#include "pathdlg.h"

#define Uses_MsgBox
#define Uses_TButton
#define Uses_TChDirDialog
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TProgram
#define Uses_TRect
#define Uses_TWindowInit
#include <rhtvision/tv.h>

#include <stdio.h>
#include <string.h>

path_dialog::path_dialog(const char * title, const char * prompt,
                         const char * def_dir, int is_new_button) :
   TDialog(TRect(0, 0, 55, 8), title),
   TWindowInit(&TDialog::initFrame),
   new_button(is_new_button)
{
   options |= ofCentered;
   TInputLine * input_path = new TInputLine(TRect(2, 3, 38, 4), FILENAME_MAX);
   input_path->setData(const_cast<char *>(def_dir));
   TValidator * validator = set_validator();
   if (validator)
      input_path->SetValidator(validator);
   insert(input_path);
   insert(new TLabel(TRect(2, 2, 38, 3), prompt, input_path));
   insert(new TButton(TRect(38, 3, 53, 5), "~B~rowse...", cmBrowse, bfNormal));
   insert(new TButton(TRect(10, 5, 20, 7), "~N~ext", cmOK, bfDefault));
   insert(new TButton(TRect(25, 5, 35, 7), "~E~xit", cmCancel, bfNormal));
   selectNext(False);
}
//----------------------------------------------------------------------------
void path_dialog::handleEvent(TEvent & event)
{
   if ((event.what == evCommand) && (event.message.command == cmBrowse))
   {
      char new_dir[FILENAME_MAX + 1];
      getData(new_dir);
      choose_dir * ch_dir = new choose_dir(new_dir, new_button);
      if (ch_dir->get_dir(new_dir))
         setData(new_dir);
      destroy(ch_dir);
   }
   TDialog::handleEvent(event);
}
//----------------------------------------------------------------------------
bool path_dialog::get_path(char * path)
{
    int dlg_exit = TProgram::deskTop->execView(this);
    if (dlg_exit == cmCancel)
       return false;
    getData(path);
    return true;
}
//----------------------------------------------------------------------------
TValidator * path_dialog::set_validator(void)
{
   return NULL;
}
//============================================================================
djgpp_dir_dialog::djgpp_dir_dialog(void) :
   path_dialog("DJGPP directory", "~E~nter the DJGPP installation path:",
               "C:/DJGPP", choose_dir::with_new_button),
   TWindowInit(&TDialog::initFrame)
{
}
//----------------------------------------------------------------------------
TValidator * djgpp_dir_dialog::set_validator(void)
{
   return new dj_path_validator;
}
//----------------------------------------------------------------------------
void djgpp_dir_dialog::dj_path_validator::Error(void)
{
    messageBox("You cannot install DJGPP in /dev directory "
               "on any drive because it has special meaning "
               "for DJGPP. See the DJGPP FAQ 22.21 for details.",
               mfError | mfOKButton);
}
//-----------------------------------------------------------------------------
Boolean djgpp_dir_dialog::dj_path_validator::IsValid(const char * path)
{
   if (path[1] == ':')
      return strnicmp(path + 3, "dev", sizeof("dev") - 1);
   if (is_path_separator(path[0]))
      return strnicmp(path + 1, "dev", sizeof("dev") - 1);
   return True;
}
//============================================================================
zip_path_dialog::zip_path_dialog(void) :
   path_dialog("Packages directory", "~E~nter DJGPP packages directory:",
               "", choose_dir::no_new_button),
   TWindowInit(&TDialog::initFrame)
{
}

