/* $Id: major.c,v 1.2 2003/03/02 18:43:56 richdawe Exp $ */

/*
 * major.c - Test program for dependencies of the form n.*, when
 * a package is present with only n, the major version number.
 * Copyright (C) 2003 by Richard Dawe
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <libpakke/package.h>
#include <libpakke/packlist.h>
#include <libpakke/packdep.h>

/* Sanity checks */
#if PACKAGE_VERSION_N_HAS != 14
#error "Need to update test to cope with PACKAGE_VERSION's has_*"
#endif

#if PACKAGE_VERSION_N_DATA != 21
#error "Need to update test to cope with PACKAGE_VERSION's data fields"
#endif

#define MAJOR_VERSION 1

PACKAGE_VERSION major_version = {
  1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, /* has_* */
  MAJOR_VERSION, 0, 0, /* major */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* int version components */
  NULL, NULL, NULL, NULL, /* platform components */
  TYPE_BINARIES
};

PACKAGE_VERSION dep_version = {
  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, /* has_* */
  MAJOR_VERSION, PACKAGE_VERSION_WILDCARD, 0, /* major, minor */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* int version components */
  NULL, NULL, NULL, NULL, /* platform components */
  TYPE_BINARIES
};

/* --------
 * - main -
 * -------- */

int
main (int argc, char *argv[])
{
  /* Fake package list */
  PACKAGE_INFO packages[2];

  /* Dependencies for dependent package */
  PACKAGE_DEP dep, dep2;

  /* For failures */
  PACKAGE_DEP *failed_dep[4] = { NULL, NULL, NULL, NULL };
  const int failed_dep_max   = 3;

  const char MAJOR_PACKAGE_NAME[] = "major";
  const char DEPENDENT_PACKAGE_NAME[] = "dependent";

  int verbose = 0;
  int i;

  /* Verbose operation, for manual testing. */
  if (   (getenv("VERBOSE") != NULL)
      && (strcmp(getenv("VERBOSE"), "n") != 0))
    verbose = 1;

  /* Parse arguments. */
  for (i = 1; i < argc; i++) {
    /* Verbose operation, for manual testing. */
    if (   (strcmp(argv[i], "--verbose") == 0)
	|| (strcmp(argv[i], "-v") == 0))
      verbose = 1;
  }

  /* Set up package list */
  memset(packages, 0, sizeof(packages));
  memset(&dep, 0, sizeof(dep));

  packages[0].q_forw = &packages[1];
  packages[1].q_back = &packages[0];

  /* Set up major package */
  strcpy(packages[0].name, MAJOR_PACKAGE_NAME);
  memcpy(&packages[0].version, &major_version, sizeof(major_version));

  /* Set up dependent package */
  /* We check that 4.? doesn't match 4. We check that 4 matches 4. */
  strcpy(packages[1].name, DEPENDENT_PACKAGE_NAME);
  packages[1].deps[0] = &dep;
  packages[1].deps[1] = &dep2;
  packages[1].deps[2] = NULL;

  dep.dep_type = PACKAGE_DEP_REQUIRES;
  dep.op       = DEP_OP_EQUAL;
  strcpy(dep.name, MAJOR_PACKAGE_NAME);
  memcpy(&dep.version, &dep_version, sizeof(dep_version));

  dep2.dep_type = PACKAGE_DEP_REQUIRES;
  dep2.op       = DEP_OP_EQUAL;
  strcpy(dep2.name, MAJOR_PACKAGE_NAME);
  memcpy(&dep2.version, &major_version, sizeof(major_version));

  /* Generate cross-links */
  packlist_xref(&packages[0]);

  /* Check that the dependency has been made */
  if ((dep.dep != NULL) && (dep2.dep != &packages[0])) {
    if (verbose)
      puts("Dependency matching failed!");
    return(EXIT_FAILURE);
  }

  return(EXIT_SUCCESS);
}
