dnl GNU Autoconf macro AC_LIB_TVISION
dnl Checks for Turbo Vision library. If it is available - adds it
dnl to LIBS variable and defines HAVE_TVISION.

dnl Call as
dnl AC_LIB_TVISION([ACTION_IF_FOUND, [ACTION_IF_NOT_FOUND]])

AC_DEFUN([AC_LIB_TVISION], 
[
   AC_REQUIRE([AC_PROG_CXX])dnl
   AC_REQUIRE([AC_LANG_CPLUSPLUS])dnl
   AC_MSG_CHECKING([for Turbo Vision library])
   lb_save_LIBS="$LIBS"
   LIBS="-lrhtv $LIBS"
   AC_TRY_LINK([void win_ver(void);], [win_ver();], lb_tvlib=RHTV)
   if test -z $lb_tvlib; then
      LIBS=$lb_save_LIBS
      LIBS="-ltv $LIBS"
      AC_TRY_LINK([void win_ver(void);], [win_ver();], lb_tvlib=TV)
      if test -z $lb_tvlib; then
         LIBS=$lb_save_LIBS
         AC_MSG_RESULT(not found)
         ifelse([$2], , , [$2])
      else
         ifelse([$1], , [AC_DEFINE(HAVE_TVISION, 1, [Turbo Vision library])], [$1])
         AC_MSG_RESULT([old version 1.0.3- found])
      fi
   else
      ifelse([$1], , [AC_DEFINE(HAVE_TVISION, 1, [Turbo Vision library])], [$1])
      AC_MSG_RESULT(v1.0.4+ found)
   fi
   if test -n $lb_tvlib; then
      dnl Add TV header path to preprocessor search list
      dnl FIXME: this is not gonna work if cross compiling
      CPPFLAGS="$CPPFLAGS -isystem /dev/env/DJDIR/include/rhtvision"
   fi
])
