// kite.h - defines main application class kite_app.
//    Copyright (C) 2000, 2001 Laurynas Biveinis <lauras@softhome.net>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#ifndef KITE_H_
#define KITE_H

#include "global.h"
#include "log.h"
#include "pathdlg.h"

#include <stdio.h>

#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TEvent 
#define Uses_TRect
#define Uses_TStatusLine
#define Uses_TValidator
#include <rhtvision/tv.h>

class kite_app : public TApplication
{
    public:
        kite_app(int ac, char *av[]);
        virtual ~kite_app(void);

        virtual void         handleEvent(TEvent& event);
        static  TDeskTop    *initDeskTop(TRect r);
        static  TMenuBar    *initMenuBar(TRect r);
        static  TStatusLine *initStatusLine(TRect r);
        
    private:
        bool check_for_reg_key(const char * key, const char * value);
        void do_installation(void);
        void errno_box(const char * message);
        int  exec_command(const char * command, const char * message);
        void exit_request(const int message);
        void get_dir(path_dialog * dialog, char * dir);
        void greetings(void);
        void init_zippo(const char * dir);
        void install_packages(const char * dj_dir, const char * zip_dir);
        void merge_registry_file(const char * file);
        bool num_tails_enabled(void);
        void process_options(char * log_file, char * pkg_dir,
                             char * djgpp_dir, int * tails, int * post_tails);
        void restore_num_tails(void);
        void update_autoexec_bat(const char * dir);
        void update_registry(void);

        log_file  * log;
        int         argc;
        char     ** argv;
        char log_fn[FILENAME_MAX + 1];
        char pkg_dir[FILENAME_MAX + 1];
        char djgpp_dir[FILENAME_MAX + 1];

        enum { tails_off = -1, ask_user = 0, tails_on = 1};
            // This variable controls if numeric tails in registry should be
            // disabled or left intact.
        int  disable_tails;
            // This variable controls if numeric tails should be restored
            // after installation
        int  restore_tails;
};

class wait_box
{
   public:
      wait_box(const char * message);
      ~wait_box(void);
   private:
      TDialog * dialog;
};

#endif // #ifndef KITE_H_
