/* $Id: zippo.h,v 1.7 2001/08/05 14:29:26 richdawe Exp $ */

/*
 *  zippo.h - Defines for zippo's main program
 *  Copyright (C) 1999-2001 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __zippo_h__
#define __zippo_h__

/* --- Defines --- */

/* Defaults */
#define DEFAULT_DJGPP_PATH "c:/djgpp/"

/* Prefixes */
#define ZIPPO_SHARE_PREFIX    "share/zippo/"
#define ZIPPO_DB_PREFIX       ZIPPO_SHARE_PREFIX "db/"
#define ZIPPO_DB_AVAIL_PREFIX ZIPPO_SHARE_PREFIX "db-avail/"

/* Operations */
enum {
  OP_NONE = 0,

  /* Informational */
  OP_STATUS, OP_VERSION, OP_HELP, OP_LICENSE,

  /* Database-related */
  OP_INITDB, OP_SYNCDB,

  /* Queries */
  OP_QUERY, OP_QUERY_ALL, OP_QUERY_FILE, OP_QUERY_AVAILABLE,

  /* Install/uninstall/upgrade */
  OP_INSTALL, OP_INSTALL_AVAILABLE, OP_UNINSTALL, OP_UPGRADE,

  /* Miscellaneous */
  OP_CHECK_INTEGRITY
};

/* Verbosity */
enum {
  V_UNDEFINED   = 0x00,
  V_QUIET       = 0x01,
  V_NORMAL      = 0x02,
  V_VERBOSE     = 0x03
};

#endif	/* #define __zippo_h__ */
