// IDEOptionsDialog.cpp : implementation file
//

#include "stdafx.h"
#include "DFE32.h"
#include "IDEOptionsDialog.h"
#include "extern.h"
#include "childfrm.h"
#include "dfe32doc.h"
#include "dfe32view.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIDEOptionsDialog dialog


CIDEOptionsDialog::CIDEOptionsDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CIDEOptionsDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIDEOptionsDialog)
	m_DebugDefault = FALSE;
	m_GccPath = _T("");
	m_Indent = FALSE;
	m_GdbPath = _T("");
	m_MakePath = _T("");
	m_Clear = FALSE;
	//}}AFX_DATA_INIT
	m_Font = new CFont;
}


void CIDEOptionsDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIDEOptionsDialog)
	DDX_Check(pDX, IDC_DEBUGDEFAULT_CHECK, m_DebugDefault);
	DDX_Text(pDX, IDC_GCCPATH_EDIT, m_GccPath);
	DDX_Check(pDX, IDC_INDENT_CHECK, m_Indent);
	DDX_Text(pDX, IDC_GDB_EDIT, m_GdbPath);
	DDX_Text(pDX, IDC_MAKE_EDIT, m_MakePath);
	DDX_Check(pDX, IDC_CLEAR_CHECK, m_Clear);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CIDEOptionsDialog, CDialog)
	//{{AFX_MSG_MAP(CIDEOptionsDialog)
	ON_BN_CLICKED(IDC_OPTIONSBROWSE_BUTTON, OnOptionsbrowseButton)
	ON_BN_CLICKED(IDC_GDBBROWSE_BUTTON, OnGdbbrowseButton)
	ON_BN_CLICKED(IDC_MAKEBROWSE_BUTTON, OnMakebrowseButton)
	ON_BN_CLICKED(IDC_FONT_BUTTON, OnFontButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIDEOptionsDialog message handlers

void CIDEOptionsDialog::OnOK() 
{
	// TODO: Add extra validation here
	char buffer[500];
	buffer[499] = '\0';
	UpdateData(TRUE);
	debugdefault = m_DebugDefault;
	indent = m_Indent;
	gccpath = m_GccPath;
	gdbpath = m_GdbPath;
	makepath = m_MakePath;
	currfont = m_Font;
	clear = m_Clear;
	LOGFONT lf;
	currfont->GetLogFont(&lf);
	WritePrivateProfileString("Options","GCC Path",gccpath.GetBuffer(500),
		"Dfe32.ini");
	WritePrivateProfileString("Options","GDB Path",gdbpath.GetBuffer(500),
		"Dfe32.ini");
	WritePrivateProfileString("Options","Make Path",makepath.GetBuffer(500),
		"Dfe32.ini");
	WritePrivateProfileString("Options","Auto Indent",itoa(indent, buffer, 10),
		"Dfe32.ini");
	WritePrivateProfileString("Options", "Debug Default", 
		itoa(debugdefault,buffer,10), "Dfe32.ini");
	WritePrivateProfileStruct("Options","Font",&lf,sizeof(LOGFONT),
		"Dfe32.ini");
	WritePrivateProfileString("Options","Clear",itoa(clear, buffer, 10),
		"Dfe32.ini");
	CDialog::OnOK();
}

BOOL CIDEOptionsDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_DebugDefault = debugdefault;
	m_Indent = indent;
	m_GccPath = gccpath;
	m_GdbPath = gdbpath;
	m_MakePath = makepath;
	m_Font = currfont;
	m_Clear = clear;
	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CIDEOptionsDialog::OnOptionsbrowseButton() 
{
	// TODO: Add your control notification handler code here
	CFileDialog filedialog(TRUE, NULL, NULL, OFN_HIDEREADONLY | 
		OFN_OVERWRITEPROMPT, 
		"Gcc Executable (gcc.exe)|gcc.exe||");
	if (filedialog.DoModal() == IDOK)
	{
		m_GccPath = filedialog.GetPathName();
		UpdateData(FALSE);
	}
}

void CIDEOptionsDialog::OnGdbbrowseButton() 
{
	// TODO: Add your control notification handler code here
	CFileDialog filedialog(TRUE, NULL, NULL, OFN_HIDEREADONLY | 
		OFN_OVERWRITEPROMPT, 
		"Gdb Executable (gdb.exe)|gdb.exe||");
	if (filedialog.DoModal() == IDOK)
	{
		m_GdbPath = filedialog.GetPathName();
		UpdateData(FALSE);
	}
}

void CIDEOptionsDialog::OnMakebrowseButton() 
{
	// TODO: Add your control notification handler code here
	CFileDialog filedialog(TRUE, NULL, NULL, OFN_HIDEREADONLY | 
		OFN_OVERWRITEPROMPT, 
		"Make Executable (make.exe)|make.exe||");
	if (filedialog.DoModal() == IDOK)
	{
		m_MakePath = filedialog.GetPathName();
		UpdateData(FALSE);
	}
}

void CIDEOptionsDialog::OnFontButton() 
{
	// TODO: Add your control notification handler code here
	CFontDialog dlg;
	LOGFONT lf;
	if (m_Font->GetSafeHandle() != NULL)
	{
		m_Font->GetLogFont(&lf);
		dlg.m_cf.Flags |= CF_INITTOLOGFONTSTRUCT;
		dlg.m_cf.lpLogFont = &lf;
	}
	if (dlg.DoModal() == IDOK)
	{
		m_Font = new CFont;
		dlg.GetCurrentFont(&lf);
		m_Font->CreateFontIndirect(&lf);
	}
}

CIDEOptionsDialog::~CIDEOptionsDialog()
{
}