/* bump.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "specific.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define DELAY_MIN 0
#define DELAY_MAX 3000
#define DELAY_STEP 100

#define SORT_MIN 1
#define SORT_MAX 21
#define SORT_STEP 1

#define XSTEP_MIN 0
#define XSTEP_MAX scr_w
#define XSTEP_STEP 1

#define YSTEP_MIN 0
#define YSTEP_MAX scr_h
#define YSTEP_STEP 1
/*---------------------------------------------------------------------------*/
/* variables */
uchr *bmp_buf, *scr_buf, table[256 * 256];
int dx, dy, x, y;
BITMAP *scr_pbmp;

int delayy, xstep, ystep;

static tkeyparse
  see_f1_0 = {K_0, keysee_f1_0}, /* bump.c specific */
  see_f1_1 = {K_1, keysee_f1_1},
  see_f1_2 = {K_2, keysee_f1_2},
  see_f1_3 = {K_3, keysee_f1_3},
  see_f1_4 = {K_4, keysee_f1_4},
  see_f1_5 = {K_5, keysee_f1_5},
  see_f1_6 = {K_6, keysee_f1_6},
  see_f1_7 = {K_7, keysee_f1_7},
  see_f1_8 = {K_8, keysee_f1_8},
  see_f1_9 = {K_9, keysee_f1_9},
  see_f1_A = {K_A, keysee_f1_A},
  see_f1_D = {K_D, keysee_f1_D},
  see_f1_P = {K_P, keysee_f1_P},
  see_f1_Q = {K_Q, keysee_f1_Q},
  see_f1_a = {K_a, keysee_f1_a},
  see_f1_d = {K_d, keysee_f1_d},
  see_f1_p = {K_p, keysee_f1_p},
  see_f1_q = {K_q, keysee_f1_q}
;

tkeyparse* tkeyparsetbl_bump[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f1_0, /* bump.c specific */
  &see_f1_1,
  &see_f1_2,
  &see_f1_3,
  &see_f1_4,
  &see_f1_5,
  &see_f1_6,
  &see_f1_7,
  &see_f1_8,
  &see_f1_9,
  &see_f1_A,
  &see_f1_D,
  &see_f1_P,
  &see_f1_Q,
  &see_f1_a,
  &see_f1_d,
  &see_f1_p,
  &see_f1_q,
  NULL
};

teffect eff_bump =
{
  bump_init,
  bump_effect,
  bump_loop_end,
  bump_done,
  tkeyparsetbl_bump,
  1
};
/*---------------------------------------------------------------------------*/
int bump_loop_end()
{
  switch (lastkey)
    {
    COMMON_LOOP_END
    case K_A:
    case K_D:
    case K_P:
    case K_Q:
    case K_a:
    case K_d:
    case K_p:
    case K_q:
      return 0;
      break;
    default:
      return 1;
      break;
    }
}
/*---------------------------------------------------------------------------*/
void bump_done()
{
  free(bmp_buf);
  destroy_bitmapm(scr_pbmp);
}
/*---------------------------------------------------------------------------*/
void bump_effect(int asort)
{
  switch (asort)
    {
    case 1:
      bump_effect0(x, y, 1); /* circle */
      break;
    case 2:
      bump_effect0(x, y, 2); /* cross */
      break;
    case 3:
      bump_effect0(x, y, 3); /* cross : darker */
      break;
    case 4:
      bump_effect0(x, y, 4); /* cross : darker > */
      break;
    case 5:
      bump_effect0(x, y, 5); /* cross : darker >> */
      break;
    case 6:
      bump_effect0(x, y, 6); /* cross : darker >>> */
      break;
    case 7:
      bump_effect1(x, y, 255, 255, 0); /* square */
      break;
    case 8:
      bump_effect1(x, y, 128, 65, 0); /* square : darker */
      break;
    case 9:
      bump_effect1(x, y, 64, 17, 0); /* square : darker > */
      break;
    case 10:
      bump_effect1(x, y, 32, 5, 0); /* square : darker >> */
      break;
    case 11:
      bump_effect1(x, y, 16, 2, 0); /* square : darker >>> */
      break;
    case 12:
      bump_effect1(x, y, 255, 255, 1); /* horizontal line */
      break;
    case 13:
      bump_effect1(x, y, 128, 65, 1); /* horizontal line : darker */
      break;
    case 14:
      bump_effect1(x, y,  64, 17, 1); /* horizontal line : darker > */
      break;
    case 15:
      bump_effect1(x, y,  32, 5, 1); /* horizontal line : darker >> */
      break;
    case 16:
      bump_effect1(x, y, 16, 2, 1); /* horizontal line : darker >>> */
      break;
    case 17:
      bump_effect1(x, y, 255, 255, 2); /* vertical line */
      break;
    case 18:
      bump_effect1(x, y, 128, 65, 2); /* vertical line : darker */
      break;
    case 19:
      bump_effect1(x, y,  64, 17, 2); /* vertical line : darker > */
      break;
    case 20:
      bump_effect1(x, y,  32, 5, 2); /* vertical line : darker >> */
      break;
    case 21:
      bump_effect1(x, y, 16, 2, 2); /* vertical line : darker >>> */
      break;
    }
  rest(delayy);
}
/*---------------------------------------------------------------------------*/
void bump_effect0(int cx, int cy, int par1)
{
  int h, lx, ly, nx, ny, pos, w;

  pos = scr_w;
  for (h = 0; h < scr_h; h++)
    {
      ly = h - cy;
      for (w = 0; w < scr_w; w++)
	{
	  nx = bmp_buf[pos + 1] - bmp_buf[pos - 1];
	  ny = bmp_buf[pos + scr_w] - bmp_buf[pos - scr_w];
	  lx = w - cx;
	  nx -= lx;
	  ny -= ly;
	  nx += 128 / par1;
	  ny += 128 / par1;
	  if (nx > 255 / par1 || nx < 0)
	    {
	      nx = 255 / par1;
	    }
	  if (ny > 255 / par1 || ny < 0)
	    {
	      ny = 255 / par1;
	    }
	  scr_buf[pos] = table[nx + ny * 256];
	  pos++;
	}
    }
  blit(scr_pbmp, screen, 0, 0, 0, 0, scr_w, scr_h);
  bump_move();
}
/*---------------------------------------------------------------------------*/
void bump_effect1(int cx, int cy, int par1, int par2, int par3)
{
  int color, color1, color2, lx, ly, nx, ny, pos, w, h;

  pos = scr_w;
  for (h = 0; h < scr_h; h++)
    {
      ly = h - cy;
      for (w = 0; w < scr_w; w++)
        {
	  nx = bmp_buf[pos + 1] - bmp_buf[pos - 1];
	  ny = bmp_buf[pos + scr_w] - bmp_buf[pos - scr_w];
	  lx = w - cx;
	  color1 = par1 - abs(nx - lx);
	  if (color1 < 0)
	    {
	      color1 = 0;
	    }
	  color2 = par1 - abs(ny - ly);
	  if (color2 < 0)
	    {
	      color2 = 0;
	    }
	  if (par3 == 1)
	    {
	      color = (int)(par1 * color2 / par2);
	    }
	  else if (par3 == 2)
	    {
	      color = (int)(color1 * par1 / par2);
	    }
	  else
	    {
	      color = (int)(color1 * color2 / par2);
	    }
	  scr_buf[pos] = (uchr) color;
	  pos++;
        }
    }
  blit(scr_pbmp, screen, 0, 0, 0, 0, scr_w, scr_h);
  bump_move();
}
/*---------------------------------------------------------------------------*/
void bump_init()
{
  scr_pbmp = create_bitmap(scr_w, scr_h);
  blit(pbmp, scr_pbmp, 0, 0, 0, 0, scr_w, scr_h);

  bmp_buf = mallocm(npixels * sizeof(uchr));
  scr_buf = scr_pbmp->line[0]; /* (uchr*) scr_pbmp->dat */
  memcpy(bmp_buf, scr_buf, npixels); /* bmp_buf remains unchanged */

  bump_init_table();
  dx = xstep;
  dy = ystep;
  x = scr_w / 2;
  y = scr_h / 2;

  lastkey = K_d;
}
/*---------------------------------------------------------------------------*/
void bump_init_table()
{
  int i, j;
  float nx, ny, nz;

  for (j = 0; j < 256; j++)
    {
      ny = (j - 128) / 128.0;
      for (i = 0; i < 256; i++)
	{
	  nx = (i - 128) / 128.0;
	  nz = 1 - sqrt(nx * nx + ny * ny);
	  if (nz < 0)
	    {
	      nz = 0;
	    }
	  table[i + j * 256] = nz * 256;
	}
    }
}
/*---------------------------------------------------------------------------*/
void bump_move()
{
  int off = 10;

  x += dx;
  y += dy;
  if (x < off)
    {
      dx = +xstep;
    }
  if (x > (scr_w - off))
    {
      dx = -xstep;
    }
  if (y < off)
    {
      dy = +ystep;
    }
  if (y > (scr_h - off))
    {
      dy = -ystep;
    }
}
/*---------------------------------------------------------------------------*/
void bump_restore()
{
  keysee_insert();
}
/*---------------------------------------------------------------------------*/
void keysee_f1_0()
{
  keysee_f1_gen("f1_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_1()
{
  keysee_f1_gen("f1_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_2()
{
  keysee_f1_gen("f1_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_3()
{
  keysee_f1_gen("f1_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_4()
{
  keysee_f1_gen("f1_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_5()
{
  keysee_f1_gen("f1_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_6()
{
  keysee_f1_gen("f1_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_7()
{
  keysee_f1_gen("f1_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_8()
{
  keysee_f1_gen("f1_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_9()
{
  keysee_f1_gen("f1_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f1_A()
{
  paraint(&eff_bump.asort, SORT_MIN, SORT_MAX, SORT_STEP, 1, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_D()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_P()
{
  paraint(&xstep, XSTEP_MIN, XSTEP_MAX, XSTEP_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_Q()
{
  paraint(&ystep, YSTEP_MIN, YSTEP_MAX, YSTEP_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_a()
{
  paraint(&eff_bump.asort, SORT_MIN, SORT_MAX, SORT_STEP, 0, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_d()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_gen(uchr s[256])
{
  int pi;
  char **tps;

  bump_restore();
  tps = get_config_argv("[See]", s, &pi);
  eff_bump.asort = atoi(tps[1]);
  delayy = atoi(tps[2]);
  xstep = atoi(tps[3]);
  ystep = atoi(tps[4]);
  do_effect(&eff_bump);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_p()
{
  paraint(&xstep, XSTEP_MIN, XSTEP_MAX, XSTEP_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f1_q()
{
  paraint(&ystep, YSTEP_MIN, YSTEP_MAX, YSTEP_STEP, 0, 0);
}
