/* distort.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "specific.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define COUNT_MIN 0
#define COUNT_MAX 100
#define COUNT_STEP 1

#define DELAY_MIN 0
#define DELAY_MAX 3000
#define DELAY_STEP 100

#define EFF_MIN (ftofix(0.00))
#define EFF_MAX (ftofix(1.00))
#define EFF_STEP (ftofix(0.01))

#define SIZE_MIN (itofix(0))
#define SIZE_MAX (itofix(100))
#define SIZE_STEP (itofix(1))

#define WALL_MIN 0
#define WALL_MAX 1
#define WALL_STEP 1

#define X_MIN 0
#define X_MAX scr_w
#define X_STEP xstep

#define XSTEP_MIN 0
#define XSTEP_MAX scr_w
#define XSTEP_STEP 1

#define Y_MIN 0
#define Y_MAX scr_h
#define Y_STEP ystep

#define YSTEP_MIN 0
#define YSTEP_MAX scr_h
#define YSTEP_STEP 1
/*---------------------------------------------------------------------------*/
/* variables */
int h2, i;
BITMAP *pbmpwarp, *pbmpoldscr;

int count, delayy, wall, x, xstep, y, ystep;
fixed eff, size;

static tkeyparse
  see_f3_0 = {K_0, keysee_f3_0}, /* distort.c specific */
  see_f3_1 = {K_1, keysee_f3_1},
  see_f3_2 = {K_2, keysee_f3_2},
  see_f3_3 = {K_3, keysee_f3_3},
  see_f3_4 = {K_4, keysee_f3_4},
  see_f3_5 = {K_5, keysee_f3_5},
  see_f3_6 = {K_6, keysee_f3_6},
  see_f3_7 = {K_7, keysee_f3_7},
  see_f3_8 = {K_8, keysee_f3_8},
  see_f3_9 = {K_9, keysee_f3_9},
  see_f3_C = {K_C, keysee_f3_C},
  see_f3_D = {K_D, keysee_f3_D},
  see_f3_E = {K_E, keysee_f3_E},
  see_f3_P = {K_P, keysee_f3_P},
  see_f3_Q = {K_Q, keysee_f3_Q},
  see_f3_S = {K_S, keysee_f3_S},
  see_f3_W = {K_W, keysee_f3_W},
  see_f3_X = {K_X, keysee_f3_X},
  see_f3_Y = {K_Y, keysee_f3_Y},
  see_f3_c = {K_c, keysee_f3_c},
  see_f3_d = {K_d, keysee_f3_d},
  see_f3_e = {K_e, keysee_f3_e},
  see_f3_p = {K_p, keysee_f3_p},
  see_f3_q = {K_q, keysee_f3_q},
  see_f3_s = {K_s, keysee_f3_s},
  see_f3_w = {K_w, keysee_f3_w},
  see_f3_x = {K_x, keysee_f3_x},
  see_f3_y = {K_y, keysee_f3_y}
;

tkeyparse* tkeyparsetbl_distort[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f3_0, /* distort.c specific */
  &see_f3_1,
  &see_f3_2,
  &see_f3_3,
  &see_f3_4,
  &see_f3_5,
  &see_f3_6,
  &see_f3_7,
  &see_f3_8,
  &see_f3_9,
  &see_f3_C,
  &see_f3_D,
  &see_f3_E,
  &see_f3_P,
  &see_f3_Q,
  &see_f3_S,
  &see_f3_W,
  &see_f3_X,
  &see_f3_Y,
  &see_f3_c,
  &see_f3_d,
  &see_f3_e,
  &see_f3_p,
  &see_f3_q,
  &see_f3_s,
  &see_f3_w,
  &see_f3_x,
  &see_f3_y,
  NULL
};

teffect eff_distort =
{
  distort_init,
  distort_effect,
  distort_loop_end,
  distort_done,
  tkeyparsetbl_distort,
  1
};
/*---------------------------------------------------------------------------*/
int distort_loop_end()
{
  switch (lastkey)
    {
    COMMON_LOOP_END
    case K_C:
    case K_D:
    case K_E:
    case K_P:
    case K_Q:
    case K_S:
    case K_W:
    case K_X:
    case K_Y:
    case K_c:
    case K_d:
    case K_e:
    case K_p:
    case K_q:
    case K_s:
    case K_w:
    case K_x:
    case K_y:
      return 0;
      break;
    default:
      return 1;
      break;
    }
}
/*---------------------------------------------------------------------------*/
void applysine(BITMAP *outbitmap, fixed ashift)
{
  uchr apoint, *liney;
  int desty, newy, outy, xpos, ypos;
  fixed angle;
  const fixed anglefact = 2670177L; /* = 256 / (PI * 2) */

  desty = pbmp->h - fixtoi(size); /* 190 */
  outy = fixtoi(size) * 2; /* 20 */
  for (ypos = fixtoi(size); ypos < desty; ypos++) /* 10, 190 */
    {
      liney = pbmp->line[ypos];
      outy++; /* 21 */
      for (xpos = pbmp->w; xpos--;) /* 320 */
	{
	  apoint = liney[xpos];
	  if ((apoint) || (!wall))
	    {
	      /* 320 * 0.05 + 25, 256/(2*PI) = 41, 40.74367 */
	      angle = fmul(xpos * eff + ashift, anglefact); /* 1670.49028 */
	      /* 10, -0.77152 = -7.71567 */
	      newy = fixtoi(fmul(size, fsin(angle))) + outy;
	      outbitmap->line[newy][xpos] = apoint;
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
void distort_done()
{
  destroy_bitmapm(pbmpwarp);
  destroy_bitmapm(pbmpoldscr);
}
/*---------------------------------------------------------------------------*/
void distort_effect()
{
  if (wall)
    {
      blit(pbmpoldscr, pbmpwarp, 0, 0, 0, 0, scr_w, h2);
    }
  else
    {
      clear(pbmpwarp);
    }
  applysine(pbmpwarp, itofix(i));
  blit(pbmpwarp, screen, 0, 0, x, y, scr_w, h2);
  i--;
  if (i <= 0)
    {
      i = count;
    }
  rest(delayy);
}
/*---------------------------------------------------------------------------*/
void distort_init()
{
  h2 = scr_h + 2 * fixtoi(size);
  pbmpwarp = create_bitmapm(scr_w, h2);
  pbmpoldscr = create_bitmapm(scr_w, h2);
  blit(screen, pbmpoldscr, x, y, 0, 0, scr_w, h2);
  i = count;

  lastkey = K_d;
}
/*---------------------------------------------------------------------------*/
void keysee_f3_0()
{
  keysee_f3_gen("f3_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_1()
{
  keysee_f3_gen("f3_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_2()
{
  keysee_f3_gen("f3_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_3()
{
  keysee_f3_gen("f3_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_4()
{
  keysee_f3_gen("f3_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_5()
{
  keysee_f3_gen("f3_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_6()
{
  keysee_f3_gen("f3_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_7()
{
  keysee_f3_gen("f3_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_8()
{
  keysee_f3_gen("f3_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_9()
{
  keysee_f3_gen("f3_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f3_C()
{
  paraint(&count, COUNT_MIN, COUNT_MAX, COUNT_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_D()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_E()
{
  parafixed(&eff, EFF_MIN, EFF_MAX, EFF_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_P()
{
  paraint(&xstep, XSTEP_MIN, XSTEP_MAX, XSTEP_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_Q()
{
  paraint(&ystep, YSTEP_MIN, YSTEP_MAX, YSTEP_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_S()
{
  parafixed(&size, SIZE_MIN, SIZE_MAX, SIZE_STEP, 1, 0);
  distort_done();
  distort_init();
}
/*---------------------------------------------------------------------------*/
void keysee_f3_W()
{
  paraint(&wall, WALL_MIN, WALL_MAX, WALL_STEP, 1, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_X()
{
  paraint(&x, X_MIN, X_MAX, X_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_Y()
{
  paraint(&y, Y_MIN, Y_MAX, Y_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_c()
{
  paraint(&count, COUNT_MIN, COUNT_MAX, COUNT_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_d()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_e()
{
  parafixed(&eff, EFF_MIN, EFF_MAX, EFF_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_gen(uchr s[256])
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", s, &pi);
  count = atoi(tps[1]);
  delayy = atoi(tps[2]);
  eff = ftofix(atof(tps[3]));
  xstep = atoi(tps[4]);
  ystep = atoi(tps[5]);
  size = itofix(atoi(tps[6]));
  wall = atoi(tps[7]);
  x = atoi(tps[8]);
  y = atoi(tps[9]);
  do_effect(&eff_distort);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_p()
{
  paraint(&xstep, XSTEP_MIN, XSTEP_MAX, XSTEP_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_q()
{
  paraint(&ystep, YSTEP_MIN, YSTEP_MAX, YSTEP_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_s()
{
  parafixed(&size, SIZE_MIN, SIZE_MAX, SIZE_STEP, 0, 0);
  distort_done();
  distort_init();
}
/*---------------------------------------------------------------------------*/
void keysee_f3_w()
{
  paraint(&wall, WALL_MIN, WALL_MAX, WALL_STEP, 0, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_x()
{
  paraint(&x, X_MIN, X_MAX, X_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f3_y()
{
  paraint(&y, Y_MIN, Y_MAX, Y_STEP, 0, 0);
}
