/* mi.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
extern int lastkey;
extern struct tkeyparse **ptkeyparsetbl;
/*---------------------------------------------------------------------------*/
/* variables */
uchr bdir_changed, bview_changed, curc, curl;
uchr extg[5];
uchr confname[256], intrname[256], retval[256];
uchr scr[4000];
uint count; /* total number of files in filenames */
uint disp0;
FILE *fpg;
tfilename filenames[MAXFILES - 1];

static tkeyparse
  mi_altd = {K_ALTD, keymi_altd},
  mi_altm = {K_ALTM, keymi_altm},
  mi_c = {K_c, keymi_c},
  mi_cr = {K_CR, keymi_cr},
  mi_ctrld = {K_CTRLD, keymi_ctrld},
  mi_ctrlk = {K_CTRLK, keymi_ctrlk},
  mi_ctrlo = {K_CTRLO, keymi_ctrlo},
  mi_d = {K_d, keymi_d},
  mi_down = {K_DOWN, keymi_down},
  mi_e = {K_e, keymi_e},
  mi_end = {K_END, keymi_end},
  mi_f1 = {K_F1, keymi_f1},
  mi_f2 = {K_F2, keymi_f2},
  mi_f3 = {K_F3, keymi_f3},
  mi_f4 = {K_F4, keymi_f4},
  mi_f5 = {K_F5, keymi_f5},
  mi_f6 = {K_F6, keymi_f6},
  mi_f7 = {K_F7, keymi_f7},
  mi_h = {K_h, keymi_h},
  mi_home = {K_HOME, keymi_home},
  mi_i = {K_i, keymi_i},
  mi_left = {K_LEFT, keymi_left},
  mi_m = {K_m, keymi_m},
  mi_p = {K_p, keymi_p},
  mi_pagedown = {K_PAGEDOWN, keymi_pagedown},
  mi_pageup = {K_PAGEUP, keymi_pageup},
  mi_r = {K_r, keymi_r},
  mi_right = {K_RIGHT, keymi_right},
  mi_s = {K_s, keymi_s},
  mi_space = {K_SPACE, keymi_space},
  mi_up = {K_UP, keymi_up},
  mi_v = {K_v, keymi_v},
  mi_w = {K_w, keymi_w}
;

tkeyparse* tkeyparsetbl_mi[] =
{
  &mi_altd,
  &mi_altm,
  &mi_c,
  &mi_cr,
  &mi_ctrld,
  &mi_ctrlk,
  &mi_ctrlo,
  &mi_d,
  &mi_down,
  &mi_e,
  &mi_end,
  &mi_f1,
  &mi_f2,
  &mi_f3,
  &mi_f4,
  &mi_f5,
  &mi_f6,
  &mi_f7,
  &mi_h,
  &mi_home,
  &mi_i,
  &mi_left,
  &mi_m,
  &mi_p,
  &mi_pagedown,
  &mi_pageup,
  &mi_r,
  &mi_right,
  &mi_s,
  &mi_space,
  &mi_up,
  &mi_v,
  &mi_w,
  NULL
};
/*---------------------------------------------------------------------------*/
int main()
{
  login();

  main_loop();

  initscr();
  puttext(1, 1, 80, 25, scr);
  _setcursortype(_NORMALCURSOR);
  return 0;
}
/*---------------------------------------------------------------------------*/
int getall(const char *path, const struct ffblk *ff)
{
  uchr d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT];
  uchr cmdline[256];

  if (!strcmp(ff->ff_name, "XXXXX"))
    {
      return 42;
    }
  fnsplit(path, d, p, f, e);
  strlwr(e);
  if (!strcmp(".avi", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".bmp", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".fli", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".gif", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".iff", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".it", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".jpg", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".lbm", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".mid", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".mod", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".mov", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".mpg", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".mtm", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".pcd", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".pcx", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".png", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".s3m", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".tga", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".tif", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".voc", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".wav", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  if (!strcmp(".xm", e))
    {
      sprintf(cmdline, "copy %s %s", path, DATAPATHS);
      execit(cmdline, 0);
    }
  return 0;
}
/*---------------------------------------------------------------------------*/
int getit(const char *path, const struct ffblk *ff)
{
  uchr d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT];

  if (!strcmp(ff->ff_name, "XXXXX"))
    {
      return 42;
    }
  if (!strcmp(extg, ".*"))
    {
      fprintf(fpg, "%s\n", path);
    }
  else
    {
      fnsplit(path, d, p, f, e);
      strlwr(e);
      if (!strcmp(extg, e))
	{
	  fprintf(fpg, "%s\n", path);
	}
    }
  return 0;
}
/*---------------------------------------------------------------------------*/
int modit(const char *path, const struct ffblk *ff)
{
  uchr apath[256], d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], cmdline[256];

  if (strcmp(ff->ff_name, "XXXXX") == 0)
    {
      return 42;
    }
  strcpy(apath, path);
  fnsplit(path, d, p, f, e);
  strlwr(e);
  if (!strcmp(".mod", e))
    {
      sprintf(cmdline, "c:\\djgpp\\contrib\\mich\\util\\hear %s -extract", path);
      execit(cmdline, 1);
    }
  if (!strcmp(".s3m", e))
    {
      sprintf(cmdline, "c:\\djgpp\\contrib\\mich\\util\\hear %s -extract", path);
      execit(cmdline, 1);
    }
  if (!strcmp(".xm", e))
    {
      sprintf(cmdline, "c:\\djgpp\\contrib\\mich\\util\\hear %s -extract", path);
      execit(cmdline, 1);
    }
  return 0;
}
/*---------------------------------------------------------------------------*/
ulng pos2i()
{
  return (disp0 + curc * NLINS + curl);
}
/*---------------------------------------------------------------------------*/
uchr nav_bcol()
{
  uchr b;

  if (curl == 1)
    {
      b = 1;
    }
  else
    {
      b = 0;
    }
  return b;
}
/*---------------------------------------------------------------------------*/
uchr nav_bscr()
{
  uchr b;

  if (curc == 0 && curl == 1)
    {
      b = 1;
    }
  else
    {
      b = 0;
    }
  return b;
}
/*---------------------------------------------------------------------------*/
uchr nav_btab()
{
  uchr b;

  if (disp0 == 0 && curc == 0 && curl == 1)
    {
      b = 1;
    }
  else
    {
      b = 0;
    }
  return b;
}
/*---------------------------------------------------------------------------*/
uchr nav_ecol()
{
  uchr b;

  if (curl == NLINS)
    {
      b = 1;
    }
  else
    {
      b = 0;
    }
  return b;
}
/*---------------------------------------------------------------------------*/
uchr nav_escr()
{
  uchr b;

  if (curc == NCOLS - 1 && curl == NLINS)
    {
      b = 1;
    }
  else
    {
      b = 0;
    }
  return b;
}
/*---------------------------------------------------------------------------*/
uchr nav_etab()
{
  uchr b;

  if (pos2i() == count)
    {
      b = 1;
    }
  else
    {
      b = 0;
    }
  return b;
}
/*---------------------------------------------------------------------------*/
/* 1, 1, 80, 23, 1, "M I C H E L L E" */
void awindow(uchr x, uchr y, uchr dx, uchr dy, uchr type, uchr *s)
{
  uchr l, x0;

  frame(x, y, dx, dy, type);

  l = strlen(s);
  x0 = x + ((dx - l) >> 1);
  writescr(x0, y, SC_NOR, s);
}
/*---------------------------------------------------------------------------*/
void dir_changed()
{
  DIR *pdir = opendir(".");
  struct dirent *pdirent;
  uchr s[256];
  int i;

  bdir_changed = 0;
  count = 1;
  for (i = 1; i <= MAXFILES; i++)
    {
      strcpy(filenames[i - 1].fn, "\0");
      filenames[i - 1].sel = 0;
      filenames[i - 1].col = SC_NOR;
    }

  pdirent = readdir(pdir);
  while (pdirent)
    {
      strcpy(filenames[count - 1].fn, pdirent->d_name);
      /* it's a directory, put it between [] */
      if (!access(filenames[count - 1].fn, D_OK) ||
	  !strcmp(filenames[count - 1].fn, "..") ||
	  !strcmp(filenames[count - 1].fn, "."))
	{
	  sprintf(s, "[%s]", filenames[count - 1].fn);
	  strcpy(filenames[count - 1].fn, s);
	}
      count++;
      pdirent = readdir(pdir);
    }
  count--;
  closedir(pdir);
  sort_filenames(1, count);
}
/*---------------------------------------------------------------------------*/
/* executes commandline */
/* flag = 0 : execute without testing if file really exists (e.g. for shell commands) */
/* flqg = 1 : execute if test successfull */
void execit(uchr *commandline, uchr flag)
{
  char *ps, s[256], s1[256], s2[256], t[256];
  uchr d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT];

  if (flag == 0)
    {
      _setcursortype(_NORMALCURSOR);
      system(commandline);
      _setcursortype(_NOCURSOR);
    }
  else
    {
      ps = NULL;
      strcpy(t, commandline);
      strcpy(s1, strtok(t, " "));

      fnsplit(s1, d, p, f, e); /* test if extension allready in commandline */
      strcpy(s, f); /* name + extension */
      strcat(s, e);
      ps = searchpath(s);
      if (ps != NULL)
	{
	  _setcursortype(_NORMALCURSOR);
	  system(commandline);
	  _setcursortype(_NOCURSOR);
	}
      else
	{
	  strcpy(s2, ".exe"); /* test if .EXE */
	  strcpy(s, s1); /* first string of commandline */
	  strcat(s, s2); /* add .EXE */
	  fnsplit(s, d, p, f, e); /* split */
	  strcpy(s, f); /* name + extension */
	  strcat(s, e);
	  ps = searchpath(s);
	  if (ps != NULL)
	    {
	      _setcursortype(_NORMALCURSOR);
	      system(commandline);
	      _setcursortype(_NOCURSOR);
	    }
	  else
	    {
	      strcpy(s2, ".bat"); /* test if .BAT */
	      strcpy(s, s1); /* first string of commandline */
	      strcat(s, s2); /* add .BAT */
	      fnsplit(s, d, p, f, e); /* split */
	      strcpy(s, f); /* name + extension */
	      strcat(s, e);
	      ps = searchpath(s);
	      if (ps != NULL)
		{
		  _setcursortype(_NORMALCURSOR);
		  system(commandline);
		  _setcursortype(_NOCURSOR);
		}
	      else
		{
		  strcpy(s2, ".com"); /* test if .COM */
		  strcpy(s, s1); /* first string of commandline */
		  strcat(s, s2); /* add .COM */
		  fnsplit(s, d, p, f, e); /* split */
		  strcpy(s, f); /* name + extension */
		  strcat(s, e);
		  ps = searchpath(s);
		  if (ps != NULL)
		    {
		      _setcursortype(_NORMALCURSOR);
		      system(commandline);
		      _setcursortype(_NOCURSOR);
		    }
		  else
		    {
		      clrscr();
		      printf("Could not execute :\n");
		      printf("%s\n", commandline);
		      printf("Install the application at the appropriate place\n");
		      printf("or edit %s\n", confname);
		      printf("Press any key to continue ...\n");
		      printf("s : %s\n", s);
		      printf("ps : %s\n", ps);
		      printf("d : %s\n", d);
		      printf("p : %s\n", p);
		      printf("f : %s\n", f);
		      printf("e : %s\n", e);
		      getch();
		    }
		}
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
/* 1, 1, 80, 23, 1 */
void frame(uchr x, uchr y, uchr dx, uchr dy, uchr type)
{
  uchr cx, cy, s[256];
  uchr frames[2][6] =
  {
    { 218, 191, 217, 192, 196, 179 },
    { 201, 187, 188, 200, 205, 186 }
  };

  sprintf(s, "%c", frames[type][0]); /* upper left corner */
  for (cx = 1; cx <= dx - 2; cx++) /* upper row */
    {
      sprintf(s + strlen(s), "%c", frames[type][4]);
    }
  sprintf(s + strlen(s), "%c", frames[type][1]); /* upper right corner */
  writescr(x, y, SC_NOR, s);

  for (cy = 0; cy <= dy - 3; cy++)
    {
      sprintf(s, "%c", frames[type][5]);
      for (cx = 1; cx <= dx - 2; cx++)
	{
	  strcat(s, " ");
	}
      sprintf(s + strlen(s), "%c", frames[type][5]);
      writescr(x, y + cy + 1, SC_NOR, s);
    }
  sprintf(s, "%c", frames[type][3]);
  for (cx = 1; cx <= dx - 2; cx++)
    {
      sprintf(s + strlen(s), "%c", frames[type][4]);
    }
  sprintf(s + strlen(s), "%c", frames[type][2]);
  writescr(x, y + dy - 1, SC_NOR, s);
}
/*---------------------------------------------------------------------------*/
void i2pos(long i)
{
  disp0 = i / (NTOTAL + 1) * NTOTAL;
  curc = (i - disp0) / NLINS;
  if (i % NLINS == 0)
    {
      curc--;
    }
  curl = i - disp0 - curc * NLINS;
}
/*---------------------------------------------------------------------------*/
void initscr()
{
  ushr w = 0;

  while ((w + 1) < 4000)
    {
      scr[w] = 219; /* filled rectangle uchracter */
      scr[w + 1] = BLUE;
      w += 2;
    }
}
/*---------------------------------------------------------------------------*/
void keymi_altd()
{
  uchr c, s[256];

  bdir_changed = 1;
  bview_changed = 1;
  disp0 = 0;
  curc = 0;
  curl = 1;

  do
    {
      prompt("Enter drive letter : ");
      scanf("%c", &c);
      sprintf(s, "%c:\\", c);
    }
  while (!isalpha(c) || (chdir(s) == -1));

  promptclr();
}
/*---------------------------------------------------------------------------*/
void keymi_altm()
{
  uchr cmdline[256], d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], s[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;

  fnsplit(retval, d, p, f, e);
  strupr(e); /* extensions in config-file are in upper-case */

  mi_search(e, INI_M, INI_DEFAULT_M, s);
  sprintf(cmdline, " %s %s", s, retval);
  if (*cmdline != '\0')
    {
      prompt("Enter target : ");
      gets(s);
      sprintf(cmdline + strlen(cmdline), " %s", s);
      execit(cmdline, 1);
      promptclr();
    }
}
/*---------------------------------------------------------------------------*/
void keymi_c()
{
  uchr cmdline[256], s[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;

  prompt("Copy to : ");
  gets(s);
  sprintf(cmdline, "copy %s %s", retval, s);
  execit(cmdline, 0);

  promptclr();
}
/*---------------------------------------------------------------------------*/
void keymi_cr()
{
  uchr cmdline[256], d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], s[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;

  /* it's a directory */
  if (retval[0] == '[')
    {
      disp0 = 0;
      curc = 0;
      curl = 1;

      strip(retval);
      chdir(retval);
    }
  /* it's a file */
  else
    {
      fnsplit(retval, d, p, f, e);
      strupr(e); /* extensions in config-file are in upper-case */

      /* if it's not a .BAT, .COM or .EXE */
      if (strcmp(e, ".BAT") && strcmp(e, ".COM") && strcmp(e, ".EXE"))
	{
	  mi_search(e, INI_CR, INI_DEFAULT_CR, s);
	  sprintf(cmdline, " %s %s", s, retval);
  	}
      /* it's a .BAT, .COM or .EXE */
      else
	{
	  sprintf(cmdline, " %s", retval);
	}

      if (*cmdline != '\0')
	{
	  execit(cmdline, 1);
	}
    }
}
/*---------------------------------------------------------------------------*/
void keymi_ctrld()
{
  uchr c, cmdline[256];
  uint w;

  bdir_changed = 1;
  bview_changed = 1;
  disp0 = 0;
  curc = 0;
  curl = 1;

  do
    {
      prompt("Delete (y/n) : ");
      scanf("%c", &c);
    }
  while (c != 'n' && c != 'y');

  if (c == 'y')
    {
      for (w = 0; w < count; w++)
	{
	  if (filenames[w].sel == 1)
	    {
	      /* you can't delete these */
	      if ((!strcmp(filenames[w].fn, "[..]")) ||
		  (!strcmp(filenames[w].fn, "[.]")))
		{
		}
	      else
		{
		  /* it's a directory */
		  if (filenames[w].fn[0] == '[')
		    {
		      strip(filenames[w].fn);
		      sprintf(cmdline, " deltree %s", filenames[w].fn);
		      execit(cmdline, 1);
		    }
		  /* it's a file */
		  else
		    {
		      chmod(filenames[w].fn, S_IWUSR);
		      unlink(filenames[w].fn);
		    }
		}
	    }
	}
    }

  promptclr();
}
/*---------------------------------------------------------------------------*/
void keymi_ctrlk()
{
  uchr cmdline[256], s[256];
  uint w;

  bdir_changed = 0;
  bview_changed = 1;

  prompt("Copy to : ");
  gets(s);

  for (w = 0; w < count; w++)
    {
      if (filenames[w].sel == 1)
	{
	  filenames[w].sel = 0;
	  filenames[w].col = SC_NOR;

	  /* you can't copy these */
	  if ((!strcmp(filenames[w].fn, "[..]")) ||
	      (!strcmp(filenames[w].fn, "[.]")))
	    {
	    }
	  else
	    {
	      /* it's a directory */
	      if (filenames[w].fn[0] == '[')
		{
		  strip(filenames[w].fn);
		  sprintf(cmdline, "copy %s %s", filenames[w].fn, s);
		  execit(cmdline, 0);
		}
	      /* it's a file */
	      else
		{
		  sprintf(cmdline, "copy %s %s", filenames[w].fn, s);
		  execit(cmdline, 0);
		}
	    }
	}
    }

  promptclr();
}
/*---------------------------------------------------------------------------*/
void keymi_ctrlo()
{
  uchr s[256], s1[256];
  uint w;

  bdir_changed = 1;
  bview_changed = 1;
  disp0 = 0;
  curc = 0;
  curl = 1;

  prompt("Move to : ");
  gets(s);
  for (w = 0; w < count; w++)
    {
      if (filenames[w].sel == 1)
	{
	  /* you can't move these */
	  if ((!strcmp(filenames[w].fn, "[..]")) ||
	      (!strcmp(filenames[w].fn, "[.]")))
	    {
	    }
	  else
	    {
	      /* it's a directory */
	      if (filenames[w].fn[0] == '[')
		{
		  /* can't move directories */
		}
	      /* it's a file */
	      else
		{
		  sprintf(s1, "%s\\%s", s, filenames[w].fn);
		  rename(filenames[w].fn, s1);
		}
	    }
  	}
    }
  promptclr();
}
/*---------------------------------------------------------------------------*/
void keymi_d()
{
  uchr c, cmdline[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;
  disp0 = 0;
  curc = 0;
  curl = 1;

  /* you can't delete these */
  if ((!strcmp(retval, "[..]")) || (!strcmp(retval, "[.]")))
    {
    }
  else
    {
      do
	{
	  prompt("Delete (y/n) : ");
	  scanf("%c", &c);
	}
      while (c != 'n' && c != 'y');

      if (c == 'y')
	{
	  /* it's a directory */
	  if (retval[0] == '[')
	    {
	      strip(retval);
	      sprintf(cmdline, " deltree %s", retval);
	      execit(cmdline, 1);
	    }
	  /* it's a file */
	  else
	    {
	      chmod(retval, S_IWUSR);
	      unlink(retval);
	    }
	}
      promptclr();
    }
}
/*---------------------------------------------------------------------------*/
void keymi_down()
{
  bdir_changed = 0;
  bview_changed = 1;

  if ((nav_etab() == 0) & (nav_escr() == 0) & (nav_ecol() == 1))
    {
      curl = 1;
      curc++;
      return;
    }
  if (!((nav_etab() == 0) & (nav_escr() == 1)))
    {
      if (nav_etab() == 0)
	{
	  curl++;
	}
      return;
    }
  curl = 1;
  curc = 0;
  disp0 += NTOTAL;
}
/*---------------------------------------------------------------------------*/
void keymi_e()
{
  uchr cmdline[256], d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], s[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;

  fnsplit(retval, d, p, f, e);
  strupr(e); /* extensions in config-file are in upper-case */

  mi_search(e, INI_E, INI_DEFAULT_E, s);
  sprintf(cmdline, " %s %s", s, retval);
  if (*cmdline != '\0')
    {
      execit(cmdline, 1);
    }
}
/*---------------------------------------------------------------------------*/
void keymi_end()
{
  bdir_changed = 0;
  bview_changed = 1;
  i2pos(count);
}
/*---------------------------------------------------------------------------*/
void keymi_f1()
{
  uchr s[256] = "\0", w = 0;
  FILE *fph;

  bdir_changed = 0;
  bview_changed = 1;

  fph = fopenm(HELPNAME, "rt");
  initscr();
  puttext(1, 1, 80, 25, scr);
  _setcursortype(_NORMALCURSOR);
  while (readln(fph, s) != NULL)
    {
      puts(s);
      w++;
      if (w % 24 != 0)
	{
	  continue;
	}
      printf("Press <ENTER> to continue ... ");
      scanf("%*[^\n]");
      getchar();
    }
  if (w % 24 != 0)
    {
      printf("Press <ENTER> to continue ... ");
      scanf("%*[^\n]");
      getchar();
    }
  _setcursortype(_NOCURSOR);
  fclose(fph);
}
/*---------------------------------------------------------------------------*/
void keymi_f2()
{
  uchr afile[256], batchmode, cmdline[256], d[MAXDRIVE], p[MAXDIR], f[MAXFILE];
  uchr e[MAXEXT], fields = 0, s[256];
  FILE *pfc, *pfi;

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;

  _setcursortype(_NORMALCURSOR);

  pfc = fopenm(confname, "rt");
  setfilept(pfc, INI_OTHER, 1);
  fscanf(pfc, "%s", s);
  fscanf(pfc, "%s", s);
  fscanf(pfc, "%s", s);
  strlwr(s);
  if (!strcmp(s, "auto"))
    {
      batchmode = BATCHAUTO;
    }
  else
    {
      batchmode = BATCHMANUAL;
    }
  fclose(pfc);

  fnsplit(retval, d, p, f, e);

  prompt("Process files in (.txt) : ");
  gets(s);
  promptclr();

  pfi = fopenm(s, "rt");
  while (1 == 1)
    {
      fields = fscanf(pfi, "%s", afile);
      if (fields != 1) break;
      sprintf(cmdline, "%s %s", f, afile);
      execit(cmdline, 0);
      if (batchmode == BATCHMANUAL)
	{
	  getch();
	}
    }
  fclose(pfi);

  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_f3()
{
  uint w;
  uchr choice, curdir[256], d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT];
  uchr s[256];

  bdir_changed = 1;
  bview_changed = 1;
  _setcursortype(_NORMALCURSOR);

  getcwd(curdir, 255);
  cs2doss(curdir);

  sprintf(s, "%s", "attrib -r *.*");
  execit(s, 1);

  for (w = 0; w < count; w++)
    {
      fnsplit(filenames[w].fn, d, p, f, e);
      strlwr(e);
      if (!strcmp(e, ".arc")) choice = 1;
      else if (!strcmp(e, ".arj")) choice = 2;
      else if ((e[1] == 'a') && (e[2] == '0')) choice = 2;
      else if (!strcmp(e, ".gz")) choice = 3;
      else if (!strcmp(e, ".lzh")) choice = 4;
      else if (!strcmp(e, ".rar")) choice = 5;
      else if ((e[1] == 'r') && (e[2] == '0')) choice = 5;
      else if (!strcmp(e, ".tar")) choice = 6;
      else if (!strcmp(e, ".tgz")) choice = 7;
      else if (!strcmp(e, ".zip")) choice = 8;
      else choice = 0; /* no compressed file */
      if (choice)
	{
	  sprintf(s, "md %s", f);
	  execit(s, 0);
	  sprintf(s, "move %s %s/%s", filenames[w].fn, curdir, f);
	  cs2doss(s);
	  execit(s, 1);
	  sprintf(s, "%s/%s", curdir, f);
	  cs2doss(s);
	  chdir(s);
	  switch (choice)
	    {
	    case 1:
	      {
		sprintf(s, "arc e %s%s", f, e);
		cs2doss(s);
		execit(s, 1);
		break;
	      }
	    case 2:
	      {
		if (e[2] != '0')
		  {
		    sprintf(s, "arj e %s%s", f, e);
		    cs2doss(s);
		    execit(s, 1);
		  }
		break;
	      }
	    case 3:
	      {
		sprintf(s, "gunzip %s%s", f, e);
		cs2doss(s);
		execit(s, 1);
		break;
	      }
	    case 4:
	      {
		sprintf(s, "lha e %s%s", f, e);
		cs2doss(s);
		execit(s, 1);
		break;
	      }
	    case 5:
	      {
		if (e[2] != '0')
		  {
		    sprintf(s, "rar e %s%s", f, e);
		    cs2doss(s);
		    execit(s, 1);
		    break;
		  }
	      }
	    case 6:
	      {
		sprintf(s, "djtar %s%s", f, e);
		cs2doss(s);
		execit(s, 1);
		break;
	      }
	    case 7:
	      {
		sprintf(s, "djtar -z %s%s", f, e);
		cs2doss(s);
		execit(s, 1);
		break;
	      }
	    case 8:
	      {
		sprintf(s, "pkunzip -d %s%s", f, e);
		cs2doss(s);
		execit(s, 1);
		break;
	      }
	    }
	  sprintf(s, "%s", "attrib -r *.*");
	  execit(s, 1);
	  chdir(curdir);
	}
    }

  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_f4()
{
  uchr c, s[256];

  bdir_changed = 1;
  bview_changed = 1;
  do
    {
      sprintf(s, "Delete %s (y/n) : ", intrname);
      prompt(s);
      scanf("%c", &c);
    }
  while (c != 'n' && c != 'y');
  if (c == 'y')
    {
      unlink(intrname);
    }
  promptclr();
}
/*---------------------------------------------------------------------------*/
void keymi_f5()
{
  char d[256], n[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;

  prompt("scan directory : ");
  gets(d);
  promptclr();
  prompt("for extension : ");
  gets(extg);
  promptclr();
  prompt("put filenames in : ");
  gets(n);
  promptclr();

  fpg = fopenm(n, "wt");
  __file_tree_walk(d, getit);
  fclose(fpg);
}
/*---------------------------------------------------------------------------*/
void keymi_f6()
{
  char d[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;

  prompt("scan directory : ");
  gets(d);
  promptclr();
  __file_tree_walk(d, getall);
}
/*---------------------------------------------------------------------------*/
void keymi_f7()
{
  char d[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;

  prompt("scan directory : ");
  gets(d);
  promptclr();
  __file_tree_walk(d, modit);
}
/*---------------------------------------------------------------------------*/
void keymi_h()
{
  uchr s[256] = "\0";
  uint w = 0;
  FILE *fph;

  bdir_changed = 0;
  bview_changed = 1;

  _setcursortype(_NORMALCURSOR);

  fph = fopenm(HELPNAME, "rt");
  initscr();
  puttext(1, 1, 80, 25, scr);
  while (readln(fph, s) != NULL)
    {
      puts(s);
      w++;
      if (w % 24 != 0)
	{
	  continue;
	}
      printf("Press <ENTER> to continue ... ");
      scanf("%*[^\n]");
      getchar();
    }
  if (w % 24 != 0)
    {
      printf("Press <ENTER> to continue ... ");
      scanf("%*[^\n]");
      getchar();
    }
  fclose(fph);
  _setcursortype(_NOCURSOR);
}
/*---------------------------------------------------------------------------*/
void keymi_home()
{
  bdir_changed = 0;
  bview_changed = 1;
  i2pos(1);
}
/*---------------------------------------------------------------------------*/
void keymi_i()
{
  uchr *p, *s = "", s0[256] = "";
  FILE *fpi;

  strcpy(retval, filenames[pos2i() - 1].fn);
  if (!access(intrname, F_OK))
    {
      bdir_changed = 0;
    }
  else
    {
      bdir_changed = 1;
    }
  bview_changed = 1;
  s = searchpath(retval);
  p = s;
  if (*p == '.')
    {
      p++;
      getcwd(s0, 100);
      strcat(s0, p);
    }
  cs2doss(s0);
  if (!access(intrname, F_OK))
    {
      fpi = fopenm(intrname, "at");
      fprintf(fpi, "%s\n", s0);
    }
  else
    {
      fpi = fopenm(intrname, "wt");
      fprintf(fpi, "%s\n", s0);
    }
  fclose(fpi);
  keymi_down();
}
/*---------------------------------------------------------------------------*/
void keymi_left()
{
  bdir_changed = 0;
  bview_changed = 1;

  if (!((nav_btab() == 0) & (pos2i() > NLINS)))
    {
      return;
    }
  if (curc != 0)
    {
      curc--;
    }
  else
    {
      curc = 4;
      disp0 -= NTOTAL;
    }
}
/*---------------------------------------------------------------------------*/
void keymi_m()
{
  uchr s[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;
  disp0 = 0;
  curc = 0;
  curl = 1;

  /* it's a directory */
  if (retval[0] == '[')
    {
    }
  /* it's a file */
  else
    {
      prompt("Move to : ");
      gets(s);
      sprintf(s, "%s\\%s", s, retval);
      rename(retval, s);
      promptclr();
    }
}
/*---------------------------------------------------------------------------*/
void keymi_p()
{
  uchr cmdline[256], d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], s[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 0;
  bview_changed = 1;

  fnsplit(retval, d, p, f, e);
  strupr(e); /* extensions in config-file are in upper-case */

  mi_search(e, INI_P, INI_DEFAULT_P, s);
  sprintf(cmdline, " %s %s", s, retval);
  if (*cmdline != '\0')
    {
      execit(cmdline, 1);
    }
}
/*---------------------------------------------------------------------------*/
void keymi_pagedown()
{
  bdir_changed = 0;
  bview_changed = 1;

  if ((nav_etab() == 0) &
      (nav_ecol() == 0) &
      ((NLINS - curl) <= (count - pos2i()) ) )
    {
      curl = NLINS;
      return;
    }
  if ((nav_etab() == 0) &
      (nav_ecol() == 0) &
      (NLINS - curl > count - pos2i()))
    {
      curl = count % NLINS;
      return;
    }
  if ((nav_etab() == 0) &
      (nav_ecol() == 1) &
      (NLINS <= count - pos2i()))
    {
      curl = NLINS;
      if (curc != 4)
	{
	  curc++;
	}
      else
	{
	  curc = 0;
	  disp0 += NTOTAL;
	}
    return;
    }
  if (!((nav_etab() == 0) &
	(nav_ecol() == 1) &
	(NLINS > count - pos2i())))
    {
      return;
    }
  curl = count % NLINS;
  if (curc != 4)
    {
      curc++;
    }
  else
    {
      curc = 0;
      disp0 += NTOTAL;
    }
}
/*---------------------------------------------------------------------------*/
void keymi_pageup()
{
  bdir_changed = 0;
  bview_changed = 1;

  if ((nav_btab() == 0) & (nav_bcol() == 0))
    {
      curl = 1;
      return;
    }
  if (!((nav_btab() == 0) & (nav_bcol() == 1)))
    {
      return;
    }
  curl = 1;
  if (curc != 0)
    {
      curc--;
    }
  else
    {
      curc = NCOLS - 1;
      disp0 -= NTOTAL;
    }
}
/*---------------------------------------------------------------------------*/
void keymi_r()
{
  uchr s[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 1;
  bview_changed = 1;

  /* it's a directory */
  if (retval[0] == '[')
    {
    }
  /* it's a file */
  else
    {
      prompt("Rename to : ");
      gets(s);
      rename(retval, s);
      promptclr();
    }
}
/*---------------------------------------------------------------------------*/
void keymi_right()
{
  bdir_changed = 0;
  bview_changed = 1;

  if (!((nav_etab() == 0) & (pos2i() + NLINS <= count)))
    {
      return;
    }
  if (curc != 4)
    {
      curc++;
    }
  else
    {
      curc = 0;
      disp0 += NTOTAL;
    }
}
/*---------------------------------------------------------------------------*/
void keymi_s()
{
  uchr cmdline[256], s[256];

  bdir_changed = 1;
  bview_changed = 1;

  prompt("DOS command : ");
  gets(s);
  sprintf(cmdline, " %s", s);
  execit(cmdline, 0);
  promptclr();
}
/*---------------------------------------------------------------------------*/
void keymi_space()
{
  bdir_changed = 0;
  bview_changed = 1;

  if (filenames[curc * NLINS + curl + disp0 - 1].sel == 1)
    {
      filenames[curc * NLINS + curl + disp0 - 1].sel = 0;
      filenames[curc * NLINS + curl + disp0 - 1].col = SC_NOR;
    }
  else
    {
      filenames[curc * NLINS + curl + disp0 - 1].sel = 1;
      filenames[curc * NLINS + curl + disp0 - 1].col = SC_SEL;
    }
  keymi_down();
}
/*---------------------------------------------------------------------------*/
void keymi_up()
{
  bdir_changed = 0;
  bview_changed = 1;

  if ((nav_btab() == 0) & (nav_bscr() == 0) & (nav_bcol() == 1))
    {
      curl = NLINS;
      curc--;
      return;
    }
  if (!((nav_btab() == 0) & (nav_bscr() == 1)))
    {
      if (nav_btab() == 0)
	{
	  curl--;
	}
      return;
    }
  curl = NLINS;
  curc = NCOLS - 1;
  disp0 -= NTOTAL;
}
/*---------------------------------------------------------------------------*/
void keymi_v()
{
  uchr cmdline[256], d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], s[256];

  strcpy(retval, filenames[pos2i() - 1].fn);
  bdir_changed = 0;
  bview_changed = 1;

  fnsplit(retval, d, p, f, e);
  strupr(e); /* extensions in config-file are in upper-case */

  mi_search(e, INI_V, INI_DEFAULT_V, s);
  sprintf(cmdline, "%s%s", s, retval);
  if (*cmdline != '\0')
    {
      execit(cmdline, 1);
    }
}
/*---------------------------------------------------------------------------*/
void keymi_w()
{
  uchr s[256];

  bdir_changed = 0;
  bview_changed = 1;
  sprintf(s, "%s <CR> ", VERSIONMI);
  prompt(s);
  gets(s);
  promptclr();
}
/*---------------------------------------------------------------------------*/
void login()
{
  uchr loginname[256], *s;
  FILE *fpcdef, *fpcnew;

  fpcdef = fopen(DEFNAME, "rt");
  if (!fpcdef)
    {
      clrscr();
      printf("OOOPS, couldn't find %s\n", DEFNAME);
      printf("This file may not be moved, renamed, or deleted.\n");
      printf("installation: c:\\djgpp\\pkunzip -d ebmchxxxx.zip\n");
      printf("Enjoy :-)\n");
      getch();
      exit(1);
    }

  bdir_changed = 1; /* something changed in current dir */
  bview_changed = 1; /* something changed on the screen */
  curc = 0;
  curl = 1;
  disp0 = 0;

  textbackground(BLUE);
  textcolor(LIGHTGRAY);
  initscr();
  awindow(SC_X, SC_Y, SC_WI, SC_LE, SC_FT, SC_TI);
  puttext(1, 1, 80, 25, scr);

  s = getenv("MI_LOGIN");
  if (!s)
    {
      do
	{
	  prompt("Enter your login name (max. 4 chars) : ");
	  gets(loginname);
	}
      while (strlen(loginname) >= 5);

      setenv("MI_LOGIN", loginname, 1);
    }
  else
    {
      strcpy(loginname, s);
    }

  sprintf(confname, "%smich%s.txt", EXEPATH, loginname);
  fpcnew = fopen(confname, "rt");
  if (!fpcnew)
    {
      fpcnew = fopenm(confname, "wt");
      /* copy default config to new config */
      while (fgets(s, 256, fpcdef) != NULL)
	{
	  fprintf(fpcnew, "%s", s);
	}
    }
  sprintf(intrname, "%sintr%s.txt", UTILPATH, loginname);
  fclose(fpcdef);
  fclose(fpcnew);
  promptclr();
}
/*---------------------------------------------------------------------------*/
void main_loop()
{
  do
    {
      ptkeyparsetbl = tkeyparsetbl_mi;

      if (bdir_changed == 1) /* something changed in current dir */
	{
	  dir_changed();
	}

      if (bview_changed == 1) /* something changed on the screen */
	{
	  view_changed();
	}

      key_scan();
    }
  while (lastkey != K_ESC);
}
/*---------------------------------------------------------------------------*/
void mi_search(uchr ext[256], uchr str1[256], uchr str2[256], uchr r[256])
{
  uchr b = 0, s[256] = "\0";
  FILE *fpc;

  /* search extension in config-file */
  fpc = fopenm(confname, "rt");
  setfilept(fpc, str1, 1);
  while (strcmp(s, TERMIN) && b == 0)
    {
      readln(fpc, s);
      if (strcmp(s, ext))
	{
	  continue;
	}

      readln(fpc, s);
      strcpy(r, s);
      b = 1;
    }
  fclose(fpc);

  /* extension not found in config-file */
  /* open with str2 */
  if (b == 0)
    {
      fpc = fopenm(confname, "rt");
      setfilept(fpc, str2, 1);
      readln(fpc, s);
      strcpy(r, s);
      fclose(fpc);
    }
}
/*---------------------------------------------------------------------------*/
void prompt(uchr s[256])
{
  uchr l;

  writescr(PX, PY, SC_NOR, EMPTYLINE);
  writescr(PX, PY, SC_NOR, s);
  puttext(1, 1, 80, 25, scr);
  l = strlen(s);
  gotoxy(PX + l, PY);
  _setcursortype(_NORMALCURSOR);
}
/*---------------------------------------------------------------------------*/
void promptclr()
{
  _setcursortype(_NOCURSOR);
  writescr(PX, PY, SC_NOR, EMPTYLINE);
  puttext(1, 1, 80, 25, scr);
}
/*---------------------------------------------------------------------------*/
void sort_filenames(uint first, uint last)
{
  uint i1, i2;
  tfilename tf;

  for (i1 = first; i1 < last; i1++)
    {
      for (i2 = first; i2 < last; i2++)
	{
	  if (strcmp(filenames[i2 - 1].fn, filenames[i2].fn) > 0)
	    {
	      tf = filenames[i2 - 1];
	      filenames[i2 - 1] = filenames[i2];
	      filenames[i2] = tf;
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
void strip(uchr *s)
{
  long i, l;
  uchr as[256];

  l = strlen(s);
  *as = '\0';
  for (i = 1; i <= l - 2; i++)
    {
      as[i - 1] = s[i];
    }
  as[l - 2] = '\0';
  strcpy(s, as);
}
/*---------------------------------------------------------------------------*/
void view_changed()
{
  uchr x, y;

  bview_changed = 0;
  awindow(SC_X, SC_Y, SC_WI, SC_LE, SC_FT, SC_TI);
  for (x = 0; x < NCOLS; x++)
    {
      for (y = 1; y <= NLINS; y++)
	{
	  writescr(COL0 + x * FILENL, LIN0 + y, SC_NOR, "               ");
	  writescr(COL0 + x * FILENL, LIN0 + y,
		   filenames[x * NLINS + y + disp0 - 1].col,
		   filenames[x * NLINS + y + disp0 - 1].fn);
	}
    }
  if (filenames[curc * NLINS + curl + disp0 - 1].sel == 1)
    {
      writescr(COL0 + curc * FILENL, LIN0 + curl, SC_CURSEL,
	       filenames[curc * NLINS + curl + disp0 - 1].fn);
    }
  else
    {
      writescr(COL0 + curc * FILENL, LIN0 + curl, SC_CUR,
	       filenames[curc * NLINS + curl + disp0 - 1].fn);
    }
  puttext(1, 1, 80, 25, scr);
}
/*---------------------------------------------------------------------------*/
/* left upper corner of the screen (x, y) == (1, 1) */
/* right lower corner of the screen (x, y) == (80, 25) */
void writescr(uchr x, uchr y, uchr color, uchr *s)
{
  ushr l, ps, pscr;

  if (x > 80)
    {
      printf("error:\n");
      printf("(writescr) x > 80\n");
      getch();
      exit(1);
    }

  if (y > 25)
    {
      printf("error:\n");
      printf("(writescr) y > 25\n");
      exit(1);
    }

  ps = 0; /* string index */
  pscr = (y - 1) * 160 + (x  - 1) * 2; /* scr index */
  l = strlen(s);
  while (ps < l)
    {
      scr[pscr] = s[ps];
      scr[pscr + 1] = color;
      pscr += 2;
      ps++;
    }
}
