/* Copyright (C) 1996,1997,1998,1999 by Salvador E. Tropea (SET),
   see copyrigh file for details */
/**[txh]********************************************************************

  Module: CodePage
  Comments:
  This module is only used under DOS and hence can be called only from DOS
modules.@p
  The module provides the tables to emulate the DOS code pages with other
fonts than the BIOS ones.@p

***************************************************************************/

//#ifdef __DJGPP__
#define Uses_TStringCollection
// For the text constants
#define Uses_TScreen
#define Uses_TRadioButtons
#define Uses_TMenuBox
#define Uses_TFrame
#define Uses_TIndicator
#define Uses_THistory
#define Uses_TColorSelector
#define Uses_TMonoSelector
#define Uses_TColorDialog
#define Uses_TInputLine
#define Uses_TStatusLine
#define Uses_TCheckBoxes
#define Uses_TScrollBar
#define Uses_TButton
#define Uses_TDirListBox
//#define Uses_TFileEditor
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TBackground
#define Uses_TCEditor_Commands
#define Uses_TCEditor_Internal
#define Uses_TCEditor
#define Uses_ProgBar
#define Uses_TNoCaseNoOwnerStringCollection
#include <ceditor.h>

#include <codepage.h>

TNoCaseNoOwnerStringCollection *CodePages=0;
const unsigned maxSymbolDefined=587; // Number of symbols defined (0-460=>461)

typedef struct
{
 char Name[28];
 int id;
 ushort Font[128];
 char *UpLow;
 char *MoreLetters;
 int LowRemapNum;
 ushort *LowRemap;
} CodePage;

// PC437 doesn't need traslation, they are the first 256 chars.
CodePage PC437=
{ "PC 437 ASCII ext.",
  437,
 { 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 },
 "",
 "",0,0
};

CodePage PC737=
{ "PC 737 Greek",
  737,
 { 'A','B',226,560,'E','Z','H',233,'I','K',583,'M','N',561,'O',562,
   'P',228,'T','Y',232,'X',563,234,224,225,546,235,238,547,548,549,
   550,389,551,230,552,553,'o',227,554,229,555,231,556,237,557,558,
   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
   559,565,566,567,579,568,569,570,580,571,572,573,574,575,576,577,
   578,241,342,343,281,450,246,344,248,345,250,346,347,253,254,255 },
 "",
 "",0,0
};

CodePage PC775=
{ "PC 775 DOS Baltic Rim",
  775,
 { 264,129,130,584,132,511,134,256,317,497,516,517,499,273,142,143,
   144,145,146,501,148,510,155,270,260,153,154,318,156,320,334,331,
   585,498,162,316,315,262,435,338,336,335,170,171,172,319,174,175,
   176,177,178,179,180,313,299,314,542,185,186,187,188,522,304,191,
   192,193,194,195,196,197,524,502,200,201,202,203,204,205,206,306,
   311,294,312,543,523,297,525,503,298,217,218,219,220,221,222,223,
   268,225,500,267,285,288,230,258,512,513,544,545,515,496,514, 39,
   341,241,434,343, 20, 21,246,429,248,249,250,346,347,253,254,255
 },
 "팡┙णеѶҷӸԽվ",
 "",0,0
};

CodePage PC850=
{ "PC 850 Latin 1",
  850,
 { 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
   144,145,146,147,148,149,150,151,152,153,154,318,156,320,334,159,
   160,161,162,163,164,165,166,167,168,335,170,171,172,173,174,175,
   176,177,178,179,180,263,289,275,336,185,186,187,188,155,157,191,
   192,193,194,195,196,197,284,287,200,201,202,203,204,205,206,331,
   321,323,290,280,276,337,265,291,281,217,218,219,220,338,277,223,
   268,225,292,278,285,288,230,332,333,271,293,279,261,272,339,340,
   341,241,342,343, 20, 21,246,344,248,345,250,346,347,253,254,255 },
 "҉ӊԋ،׍ޑ┙뛝֢餥",
 "",0,0
};

CodePage PC852=
{ "PC 852 Latin 2",
  852,
 { 128,129,130,131,132,282,256,135,317,137,354,353,140,273,142,264,
   144,266,257,147,148,327,325,270,260,153,154,305,326,319,334,294,
   160,161,162,163,313,311,306,298,314,312,  0,262,299,307,174,175,
   176,177,178,179,180,263,289,301,309,185,186,187,188,316,315,191,
   192,193,194,195,196,197,330,328,200,201,202,203,204,205,206,331,
   321,323,300,280,324,302,265,291,358,217,218,219,220,310,283,223,
   268,225,292,267,258,295,304,297,269,271,259,274,261,272,308,340,
   341,348,349,350,351, 21,246,344,248,345,352,286,303,296,254,255 },
 "ކӋ׫┙֢饤ط",
 "",0,0
};

// PC855 Russian DOS code page
CodePage PC855=
{ "PC 855 Russian 2",
  855,
 { 413,412,415,414,137,280,408,407,115, 83,105,281,139,416,106, 74,
   418,417,420,419,422,421,424,423,426,425,428,427,405,379,401,375,
    97,360,381,361,397,371,384,363,101, 69,396,370,383,362,174,175,
   176,177,178,179,180,120, 88,387,365,185,186,187,188,388,366,191,
   192,193,194,195,196,197,389, 75,200,201,202,203,204,205,206,331,
   390,367,391, 77,392, 72,111, 79,393,217,218,219,220,368,406,223,
   380,112, 80, 99, 67,394, 84,395,369,385,364,382, 66,403,377,411,
   341,402,376,386,409,399,373,404,378,400,374,398,372, 21,254,255 },
 "",
 "",0,0
};

CodePage PC857=
{ "PC 857 Turkish",
  857,
 { 128,129,130,131,132,133,134,135,136,137,138,139,140,337,142,143,
   144,145,146,147,148,149,150,151,487,153,154,318,156,320,309,307,
   160,161,162,163,164,165,504,505,168,335,170,171,172,173,174,175,
   176,177,178,179,180,263,289,275,336,185,186,187,188,155,157,191,
   192,193,194,195,196,197,284,287,200,201,202,203,204,205,206,331,
   167,166,290,280,276,276,265,291,281,217,218,219,220,338,277,223,
   268,225,292,278,285,288,230,230,334,271,293,279,141,152,339,340,
   341,241,241,343, 20, 21,246,344,248,345,250,346,347,253,254,255 },
 "҉ӊԋ،׍┙뛝֣餥Ǣ",
 "",0,0
};

CodePage PC860=
{ "PC 860 Portuguese",
  860,
 { 128,129,130,131,284,133,263,135,136,290,138,265,140,141,287,289,
   144,275,276,147,285,149,271,151,277,288,154,155,156,279,158,268,
   160,161,162,163,164,165,166,167,168,278,170,171,172,173,174,175,
   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 },
 "",
 "",0,0
};

CodePage PC861=
{ "PC 861 Icelandic",
  861,
 { 128,129,130,131,132,133,134,135,136,137,138,323,322,333,142,143,
   144,145,146,147,148,332,150,272,261,153,154,318,156,320,158,159,
   160,161,162,163,263,265,268,271,168,169,170,171,172,173,174,175,
   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 },
 "",
 "",0,0
};

CodePage PC863=
{ "PC 863 French",
  863,
 { 128,129,130,131,289,133, 20,135,136,137,138,139,140,342,275, 21,
   144,276,290,147,280,281,150,151,331,292,154,155,156,279,158,159,
   338,340,162,163,345,344,347,339,291,169,170,171,172,173,174,175,
   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 },
 "",
 "",0,0
};

CodePage PC865=
{ "PC 865 Nordic",
  865,
 { 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
   144,145,146,147,148,149,150,151,152,153,154,318,156,320,158,159,
   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,331,
   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 },
 "",
 "",0,0
};

CodePage PC869=
{ "PC 869 Greek 2",
  869,
 { 0x20,0x20,0x20,0x20,0x20,0x20,572,572,250,170,338, 96, 39,573,341,574,
   575,281,576,576,576,577,450,336,578,253,347,565,156,566,567,568,
   579,581,569,570, 65, 66,226,560, 69, 90, 72,171,233, 73,174,175,
   176,177,178,179,180, 75,583, 77, 78,185,186,187,188,561, 79,191,
   192,193,194,195,196,197,562, 80,200,201,202,203,204,205,206,228,
    84, 89,232, 88,563,234,224,225,546,217,218,219,220,235,238,223,
   547,548,549,550,389,551,230,552,553,111,227,554,229,555,231,340,
   341,241,556,237,557, 21,558,564,248,345,559,580,582,571,254,255 },
 "֤ץئݧި",
 "",0,0
};

CodePage ISO8879_1=
{ "ISO 8859-1 Latin 1",
  88791,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
    32,173,155,156, 36,157,338, 21,345,336,166,174,170,341,335,341,
   248,241,253,347,340,230, 20,249,344,346,167,175,172,171,343,168,
   275,263,289,287,142,143,146,128,276,144,290,280,277,265,291,281,
   323,165,278,268,292,288,153,334,320,279,271,293,154,272,333,225,
   133,160,131,284,132,134,145,135,138,130,136,137,141,161,140,139,
   321,164,149,162,147,285,148,246,318,151,163,150,129,261,332,152 },
 "",
 "",0,0
};

static ushort LowCrazyCharsRemaped[] =
{ 439,247,440,441,  4,442,443,444,445,176,177,178,219,220,223,221,
  222,446,447,242,243,448, 17, 16, 24, 25, 26, 27, 18, 29,447,227,
   32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
   48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
   80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
   96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
  112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,450 };


CodePage ISO8859_1_Lat1=
{ "ISO Latin 1 (Linux)",
  885901,
 { 451,452,453,192,454,179,218,195,455,217,196,193,191,180,194,197,
   456,457,458,200,459,186,201,204,460,188,205,202,187,185,203,206,
    32,173,155,156, 36,157,338, 21,345,336,166,174,170,341,335,341,
   248,241,253,347,340,230, 20,249,344,346,167,175,172,171,343,168,
   275,263,289,287,142,143,146,128,276,144,290,280,277,265,291,281,
   323,165,278,268,292,288,153,334,320,279,271,293,154,272,333,225,
   133,160,131,284,132,134,145,135,138,130,136,137,141,161,140,139,
   321,164,149,162,147,285,148,246,318,151,163,150,129,261,332,152 },
 "",
 "",
 128,LowCrazyCharsRemaped
};

CodePage ISO8859_1u_Lat1=
{ "ISO Latin 1u(Linux)",
  885911,
 { 275,263,289,287,142,143,146,128,276,144,290,280,277,265,291,281,
   323,165,278,268,292,288,153,334,320,279,271,293,154,272,333,225,
    32,173,155,156, 36,157,338, 21,345,336,166,174,170,341,335,341,
   248,241,253,347,340,230, 20,249,344,346,167,175,172,171,343,168,
   451,452,453,192,454,179,218,195,455,217,196,193,191,180,194,197,
   456,457,458,200,459,186,201,204,460,188,205,202,187,185,203,206,
   133,160,131,284,132,134,145,135,138,130,136,137,141,161,140,139,
   321,164,149,162,147,285,148,246,318,151,163,150,129,261,332,152 },
 "",
 "",
 128,LowCrazyCharsRemaped
};

CodePage ISO8879_2=
{ "ISO 8859-2 Latin 2",
  88792,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
    32,313,351,319,331,356,270, 21,345,304,309,305,273,341,306,316,
   167,311,349,317,340,355,260,350,344,297,307,357,262,348,298,315,
   269,263,289,330,142,327,264,128,299,144,314,280,301,265,291,300,
   323,267,302,268,292,354,153,334,303,283,271,274,154,272,310,225,
   259,160,131,328,132,325,256,135,294,130,312,137,358,161,140,359,
   321,258,295,162,147,353,148,246,296,282,163,286,129,261,308,352 },
 "",
 "",0,0
};

CodePage ISO8859_3=
{ "ISO 8859-3 Latin 3",
  88593,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   255,534,351,156,331,0x20,468, 21,345,487,309,504,470,341,0x20,316,
   248,535,253,347,340,230,469,250,344,337,307,505,471,171,0x20,315,
   275,263,289,0x20,142,480,464,128,276,144,290,280,277,265,291,281,
   0x20,165,278,268,292,586,153,334,466,279,271,293,154,508,472,225,
   133,160,131,0x20,132,481,465,135,138,130,136,137,141,161,140,139,
   0x20,164,149,162,147,486,148,246,467,151,163,150,129,509,473,352
 },
 "",
 "ߵ",0,0
};

CodePage ISO8859_4=
{ "ISO 8859-4 Latin 4",
  88594,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   255,313,461,516,331,518,544, 21,345,304,496,510,536,341,306,339,
   248,311,349,517,340,519,545,350,344,297,497,511,537,462,298,463,
   585,263,289,287,142,143,146,522,299,144,314,280,542,265,291,498,
   323,514,500,512,292,288,153,334,320,524,271,293,154,520,502,225,
   584,160,131,284,132,134,145,523,294,130,312,137,543,161,140,499,
   321,515,501,513,147,285,148,246,318,525,163,150,129,521,503,352
 },
 "",
 "ߢ",0,0
};

// PC866 Russian DOS code page
CodePage PC866=
{ "PC 866 Russian",
  866,
 { 360,361, 66,362,363, 69,364, 51,365,366, 75,367, 77, 72, 79,368,
    80, 67, 84,369,370, 88,371,372,373,374,375,376,377,378,379,380,
    97,381,382,383,384,101,385,386,387,388,389,390,391,392,111,393,
   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
   112, 99,394,395,396,120,397,398,399,400,401,402,403,404,405,406,
   280,137,407,408,281,139,409,410,248,249,250,251,411,331,254,255 },
 "",
 "",0,0
};

// ISO 8859-5 Russian ISO layout
CodePage ISO8859_5=
{ "ISO 8859-5 Russian",
  88595,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
    32,280,412,414,407, 83,416,281, 74,417,419,421,423,341,425,427,
   360,361, 66,362,363, 69,364, 51,365,366, 75,367, 77, 72, 79,368,
    80, 67, 84,369,370, 88,371,372,373,374,375,376,377,378,379,380,
    97,381,382,383,384,101,385,386,387,388,389,390,391,392,111,393,
   112, 99,394,395,396,120,397,398,399,400,401,402,403,404,405,406,
   411,137,413,415,408,115,105,139,106,418,420,422,424, 21,426,428 },
 "аѱҲӳԴյֶ׷ظٹںۻܼݽ޾߿",
 "",0,0
};

// KOD OBMENA INFORMATSIEY - 8bit RUSSKIY
//    I think that's close to the original ;-)
CodePage KOI_8r=
{ "KOI-8r (Russian)",
  100000,
 { 196,179,218,191,192,217,195,180,194,193,197,223,220,219,221,222,
   176,177,178,244,254,249,251,247,243,242,255,245,248,253,250,246,
   205,186,213,137,214,201,184,183,187,212,211,200,190,189,188,198,
   199,204,181,280,182,185,209,210,203,207,208,202,216,215,206,336,
   405, 97,381,397,384,101,396,383,120,387,388,107,390,391,392,111,
   393,406,112, 99,394,395,385,382,403,402,386,399,404,400,398,401,
   379,360,361,371,363, 69,370,362, 88,365,366, 75,367, 77, 72, 79,
   368,380, 80, 67, 84,369,364, 98,377,376, 51,373,378,374,372,375 },
 "",
 "",0,0
};

// KOI8 with CRL/NMSU extensions for SerboCroat
CodePage KOI_8crl=
{ "KOI-8 with CRL/NMSU",
  100001,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188, // grf
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254, // grf
   0x20,0x20,0x20,137,413,106,418,420,422,428,0x20,0x20,0x20,0x20,0x20,0x20,
   0x20,0x20,0x20,280,412, 74,417,419,421,427,0x20,0x20,0x20,0x20,0x20,0x20,
   405, 97,381,397,384,101,396,383,120,387,388,389,390,391,392,111,
   393,406,112, 99,394,395,385,382,403,402,386,399,404,400,398,401,
   379,360,361,371,363, 69,370,362, 88,365,366, 75,367, 77,72, 79,
   368,380, 80, 67, 84,369,364, 66,377,376,409,373,378,374,372,375 },
 "",
 "",0,0
};

// ECMA-Cyrillic ISO-IR-111
CodePage ISO_IR_111=
{ "ECMA-Cyr.ISO-IR-111",
  0x0111000E,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   255,413,415,137,408,115,105,139,106,418,420,422,424,341,426,428,
   411,412,414,280,407, 83,281,416, 74,417,419,421,423,331,425,427,
   405, 97,381,397,384,101,396,383,120,387,388,389,390,391,392,111,
   393,406,112, 99,394,395,385,382,403,402,386,399,404,400,398,401,
   379,360,361,371,363, 69,370,362, 88,365,366, 75,367, 77, 72, 79,
   368,380, 80, 67, 84,369,364, 66,377,376,409,373,378,374,372,375 },
 "",
 "",0,0
};

// GOST_19768-74 ST_SEV_358-88 ISO-IR-153 /subset of ISO-8859-5/
CodePage ISO_IR_153=
{ "Cyrillic ISO-IR-153",
  0x0153000E,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   255,280,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,341,0x20,0x20,
   360,361, 66,362,363, 69,364,409,365,366, 75,367, 77, 72, 79,368,
    80, 67, 84,369,370, 88,371,372,373,374,375,376,377,378,379,380,
    97,381,382,383,384,101,385,386,387,388,389,390,391,392,111,393,
   112, 99,394,395,396,120,397,398,399,400,401,402,403,404,405,406,
   0x20,137,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20 },
 "аѱҲӳԴյֶ׷ظٹںۻܼݽ޾߿",
 "",0,0
};


// Mac OS Cyrillic, cp10007
CodePage CP10007=
{ "Mac Cyr. CP 10007",
  10007,
 { 360,361, 66,362,363, 69,364,409,365,366, 75,367, 77, 72, 79,368,
    80, 67, 84,369,370, 88,371,372,373,374,375,376,377,378,379,380,
   431,248,155,156, 21,  7, 20,281,335,336,436,412,413,448,414,415,
   236,241,243,242,105,230,235, 74,407,408,416,139,417,418,419,420,
   106, 83,170,251,159,247,560,174,175,430,255,421,422,423,424,115,
    45,341,434,435, 96, 39,246,429,425,426,427,428,411,280,137,406,
    97,381,382,383,384,101,385,386,387,388,389,390,391,392,111,393,
    112, 99,394,395,396,120,397,398,399,400,401,402,403,404,405,331 },
 "ߟ",
 "",0,0
};

// Mac OS Ukrainian
CodePage CP100072=
{ "Mac OS Ukrainian",
  100072,
 { 360,361, 66,362,363, 69,364,409,365,366, 75,367, 77, 72, 79,368,
    80, 67, 84,369,370, 88,371,372,373,374,375,376,377,378,379,380,
   431,248,437,156, 21,  7, 20,281,335,336,436,412,413,448,414,415,
   236,241,243,242,105,230,438, 74,407,408,416,139,417,418,419,420,
   106, 83,170,251,159,247,560,174,175,430,255,421,422,423,424,115,
    45,341,434,435, 96, 39,246,429,425,426,427,428,411,280,137,406,
    97,381,382,383,384,101,385,386,387,388,389,390,391,392,111,393,
   112, 99,394,395,396,120,397,398,399,400,401,402,403,404,405,331 },
 "ߟ",
 "",0,0
};

// Osnovnoj Variant Russian
CodePage OVR=
{ "Osnovnoj Variant Russian",
  885951,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188, // grf
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254, // grf
   0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
   360,361, 66,362,363, 69,364,409,365,366, 75,367, 77, 72, 79,368,
    80, 67, 84,369,370, 88,371,372,373,374,375,376,377,378,379,380,
    97,381,382,383,384,101,385,386,387,388,389,390,391,392,111,393,
   112, 99,394,395,396,120,397,398,399,400,401,402,403,404,405,406,
   280,137,340, 96,340, 96, 26, 27, 25, 24,246,241,411,331,0x20,0x20 },
 "аѱҲӳԴյֶ׷ظٹںۻܼݽ޾߿",
 "",0,0
};

// Alternativnyj Variant Russian
CodePage AVR=
{ "Alternativnyj Variant RU",
  885952,
 { 360,361, 66,362,363, 69,364,409,365,366, 75,367, 77, 72, 79,368,
    80, 67, 84,369,370, 88,371,372,373,374,375,376,377,378,379,380,
    97,381,382,383,384,101,385,386,387,388,389,390,391,392,111,393,
   218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188, // grfs
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254, // grfs
   0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
   112, 99,394,395,396,120,397,398,399,400,401,402,403,404,405,406,
   280,137,340, 96,340, 96, 26, 27, 25, 24,246,241,411,331,0x20,0x20 },
 "",
 "",0,0
};

// U-code Russian /subset of ISO-8859-5 and GOST_19768-74/
CodePage U_CodeR=
{ "U-code Russian",
  885953,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188, // grf
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254, // grf
   255,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
   360,361, 66,362,363, 69,364,409,365,366, 75,367, 77, 72, 79,368,
    80, 67, 84,369,370, 88,371,372,373,374,375,376,377,378,379,380,
    97,381,382,383,384,101,385,386,387,388,389,390,391,392,111,393,
   112, 99,394,395,396,120,397,398,399,400,401,402,403,404,405,406,
   0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20 },
 "аѱҲӳԴյֶ׷ظٹںۻܼݽ޾߿",
 "",0,0
};

/***** 7 bits! ******/
static ushort KOI7[] =
{ 0,  1,  2,  3,  4,  5,  6,  7,
  8,  9, 10, 11, 12, 13, 14, 15,
 16, 17, 18, 19, 20, 21, 22, 23,
 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35,331, 37, 38, 39,
 40, 41, 42, 43, 44, 45, 46, 47,
 48, 49, 50, 51, 52, 53, 54, 55,
 56, 57, 58, 59, 60, 61, 62, 63,
405, 97,381,397,384,101,396,383,
120,387,388,389,390,391,392,111,
393,406,112, 99,394,395,385,382,
403,402,386,399,404,400,398,401,
379,360,361,371,363, 69,370,362,
 88,365,366, 75,367, 77, 72, 79,
368,380, 80, 67, 84,369,364, 66,
377,376,409,373,378,374,372,127
};

CodePage KOI_7=
{
 "ISO 5427 ISO-IR-37 KOI-7",
 0x0037000E,
 {
   32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
   48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
  218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
  186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
   96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
  112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127
 },
 "@`AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz[{\\|]}^~",
 "_",
 128,KOI7
};

static ushort ISOIR147[] =
{   0,  1,  2,  3,  4,  5,  6,  7,
  8,  9, 10, 11, 12, 13, 14, 15,
 16, 17, 18, 19, 20, 21, 22, 23,
 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35, 36, 37, 38, 39,
 40, 41, 42, 43, 44, 45, 46, 47,
 48, 49, 50, 51, 52, 53, 54, 55,
 56, 57, 58, 59, 60, 61, 62, 63,
364,360,361,371,363, 69,370,362,
 88,365, 74, 75,367, 77, 72, 79,
368,417, 80, 67, 84,369, 66,419,
427, 83,409,373,414,423,372, 95,
385, 97,381,397,384,101,396,383,
120,387,106,389,390,391,392,111,
393,418,112, 99,394,395,382,420,
428,115,386,399,415,424,398,127 };

CodePage ISO_IR_147=
{
 "JUS_I.B1.003-MAC ISO-IR-147",
 0x0147000E,
 {
   32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
   48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
  218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
  186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
   96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
  112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127
 },
 "`@aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ{[|\\}]~^",
 "",
 128,ISOIR147
};

static ushort ISOIR146[] =
{ 0,  1,  2,  3,  4,  5,  6,  7,
  8,  9, 10, 11, 12, 13, 14, 15,
 16, 17, 18, 19, 20, 21, 22, 23,
 24, 25, 26, 27, 28, 29, 30, 31,
 32, 33, 34, 35, 36, 37, 38, 39,
 40, 41, 42, 43, 44, 45, 46, 47,
 48, 49, 50, 51, 52, 53, 54, 55,
 56, 57, 58, 59, 60, 61, 62, 63,
364,360,361,371,363, 69,370,362,
 88,365, 74, 75,367, 77, 72, 79,
368,417, 80, 67, 84,369, 66,419,
427, 83,409,373,412,421,372, 95,
385, 97,381,397,384,101,396,383,
120,387,106,389,390,391,392,111,
393,418,112, 99,394,395,382,420,
428,115,386,399,413,422,398,127 };

CodePage ISO_IR_146=
{
 "JUS_I.B1.003-SERB ISOIR146",
 0x0146000E,
 {
   32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
   48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
  218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
  186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
   96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
  112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127
 },
 "`@aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ{[|\\}]~^",
 "",
 128,ISOIR146
};

static ushort Low32CharsRemaped[] =
{ 197,196,191,192,217,179,195,  7,194,193,218,219,178,177,176,180,
   16, 17, 18,220,222,221,254, 23, 24, 25, 26, 27,223, 29, 30, 31};

// PC1250 Windows latin 2 code page
CodePage PC1250=
{ "CP 1250 Win Latin 2",
  1250,
 { 0x20,0x20, 44,0x20,429,430,431,432,0x20,433,304, 60,270,305,306,273,
   0x20, 96, 39,434,435,  7, 45,341,0x20,436,297, 62,260,326,298,262,
   255,350,351,319,331,313,338, 21,345,336,309,174,170,341,335,316,
   248,241,349,317,340,230, 20,250,344,311,307,175,327,348,325,315,
   269,263,289,330,142,266,264,128,299,144,314,280,301,265,291,300,
   323,267,302,268,292,354,153,334,303,283,271,274,154,272,310,225,
   259,160,131,328,132,257,256,135,294,130,312,137,358,161,140,324,
   321,258,295,162,147,353,148,246,296,282,163,286,129,261,308,352 },
 "",
 "",
 32,Low32CharsRemaped
};

// PC1251 Russian Windows code page
CodePage PC1251=
{ "CP 1251 Win Russian",
  1251,
 { 412,414, 44,415,429,430,431,432,0x20,433,417, 60,419,423,421,427,
   413, 96, 39,434,435,  7, 45,341,0x20,436,418, 62,420,424,422,428,
   255,425,426, 74,331,437,338, 21,280,336,407,174,170,341,335,416,
   248,241,281,105,438,230, 20,250,137,411,408,175,106, 83,115,139,
   360,361, 66,362,363, 69,364,409,365,366, 75,367, 77, 72, 79,368,
    80, 67, 84,369,370, 88,371,372,373,374,375,376,377,378,379,380,
    97,381,382,383,384,101,385,386,387,388,389,390,391,392,111,393,
   112, 99,394,395,396,120,397,398,399,400,401,402,403,404,405,406 },
 "",
 "",
 32,Low32CharsRemaped
};

// PC1252 Windows latin 1 code page
CodePage PC1252=
{ "CP 1252 Win Latin 1",
  1252,
 { 0x20,0x20, 44,159,429,430,431,432, 94,433,304, 60,440,0x20,306,0x20,
   0x20, 96, 39,434,435,  7, 45,341,126,436,297, 62,441,0x20,298,450,
   255,173,155,156,331,157,338, 21,345,336,166,174,170,341,335,339,
   248,241,253,347,340,230, 20,250,344,346,167,175,172,171,343,168,
   275,263,289,287,142,143,146,128,276,144,290,280,277,265,291,281,
   323,165,278,268,292,288,153,334,320,279,271,293,154,272,333,225,
   133,160,131,284,132,134,145,135,138,130,136,137,141,161,140,139,
   322,164,149,162,147,285,148,246,318,151,163,150,129,261,332,152 },
 "",
 "",
 32,Low32CharsRemaped
};

// PC1253 Windows greek code page
CodePage PC1253=
{ "CP 1253 Win Greek",
  1253,
 { 0x20,0x20, 44,159,429,430,431,432,0x20,433,0x20, 60,0x20,0x20,0x20,0x20,
   0x20, 96, 39,434,435,  7, 45,341,0x20,436,0x20, 62,0x20,0x20,0x20,0x20,
   255,564,572,156,331,157,338, 21,345,336,0x20,174,170,341,335,341,
   248,241,253,347,340,230, 20,250,573,574,575,175,576,171,577,578,
   581, 65, 66,226,560, 69, 90, 72,233, 73, 75,583, 77, 78,561, 79,
   562, 80,0x20,228, 84, 89,232, 88,563,234,281,450,565,566,567,568,
   582,224,225,546,235,238,547,548,549,550,389,551,230,552,553,111,
   227,554,555,229,231,556,237,557,558,559,579,580,569,570,571,0x20 },
 "ܢݸ޹ߺ",
 "",
 32,Low32CharsRemaped
};

// PC1254 Windows
CodePage PC1254=
{ "CP 1254 Win Latin?",
  1254,
 { 0x20,0x20, 44,159,429,430,431,432, 94,433,304, 60,440,0x20,0x20,0x20,
   0x20, 96, 39,434,435,  7, 45,341,126,436,297, 62,441,0x20,0x20,450,
   255,173,155,156,331,157,338, 21,345,336,166,174,170,341,335,339,
   248,241,253,347,340,230, 20,250,344,346,167,175,172,171,343,168,
   275,263,289,287,142,143,146,128,276,144,290,280,277,265,291,281,
   504,165,278,268,292,288,153,334,320,279,271,293,154,487,309,225,
   133,160,131,284,132,134,145,135,138,130,136,137,141,161,140,139,
   505,164,149,162,147,285,148,246,318,151,163,150,129,337,307,152 },
 "ޚ",
 "",
 32,Low32CharsRemaped
};

// PC1257 Windows
CodePage PC1257=
{ "CP 1257 Win Latin?",
  1257,
 { 0x20,0x20, 44,0x20,429,430,431,432,0x20,433,0x20, 60,0x20,345,350,344,
   0x20, 96, 39,434,435,  7, 45,341,0x20,436,0x20, 62,0x20,339,349,0x20,
   255,0x20,155,156,331,0x20,338, 21,320,336,516,174,170,341,335,146,
   248,241,253,347,340,230, 20,250,318,346,517,175,172,171,343,145,
   313,522,585,264,142,143,314,496,299,144,273,542,510,512,498,544,
   304,267,514,268,500,288,153,334,524,319,270,502,154,316,306,225,
   311,523,584,256,132,134,312,497,294,130,262,543,511,513,499,545,
   297,258,515,162,501,285,148,246,525,317,260,503,129,315,298,352
 },
 "",
 "",
 32,Low32CharsRemaped
};

CodePage ISO8859_7=
{ "ISO 8859-7 Greek",
  88597,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   255, 96, 39,156, 32, 32,338, 21,345,336, 32,174,170,341, 32,341,
   248,241,253,347,340,564,572,250,573,574,575,175,576,171,577,578,
   581, 65, 66,226,560, 69, 90, 72,233, 73, 75,583, 77, 78,561, 79,
   562, 80, 32,228, 84, 89,232, 88,563,234,281,450,565,566,567,568,
   582,224,225,546,235,238,547,548,549,550,389,551,230,552,553,111,
   227,554,555,229,231,556,237,557,558,559,579,580,569,570,571, 32 },
 "ܶݸ޹ߺ",
 "",0,0
};

// ISO 8859-9 (1989) Pure
CodePage ISO8859_9=
{ "ISO 8859-9",
  88599,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   255,173,155,156,331,157,338, 21,345,336,166,174,170,341,335,339,
   248,241,253,347,340,230, 20,250,344,346,167,175,172,171,343,168,
   275,263,289,287,142,143,146,128,276,144,290,280,277,265,291,281,
   504,165,278,268,292,288,153,334,320,279,271,293,154,487,309,225,
   133,160,131,284,132,134,145,135,138,130,136,137,141,161,140,139,
   505,164,149,162,147,285,148,246,318,151,163,150,129,337,307,152 },
 "",
 "",0,0
};

// ISO/IEC 8859-14:1998
CodePage ISO8859_14=
{ "ISO 8859-14",
  885914,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   255,478,479,156,480,481,482, 21,526,336,530,483,528,341,335,450,
   484,485,586,486,488,489, 20,490,527,491,531,492,529,532,533,493,
   275,263,289,287,142,143,146,128,276,144,290,280,277,265,291,281,
   474,165,278,268,292,288,153,494,320,279,271,293,154,272,476,225,
   133,160,131,284,132,134,145,135,138,130,136,137,141,161,140,139,
   475,164,149,162,147,285,148,495,318,151,163,150,129,261,477,152
 },
 "",
 "",0,0
};

// ISO/IEC 8859-15:1998
CodePage ISO8859_15=
{ "ISO 8859-15 Icelan.",
  885915,
 { 218,196,191,192,217,179,195,180,194,193,197,201,205,187,200,188,
   186,199,182,209,207,219,178,177,176,223,220,222,221,254,254,254,
   255,173,155,156,0x20,157,304, 21,297,336,166,174,170,341,335,339,
   248,241,253,347,306,230, 20,250,298,346,167,175,440,441,450,168,
   275,263,289,287,142,143,146,128,276,144,290,280,277,265,291,281,
   323,165,278,268,292,288,153,334,320,279,271,293,154,272,333,225,
   133,160,131,284,132,134,145,135,138,130,136,137,141,161,140,139,
   322,164,149,162,147,285,148,246,318,151,163,150,129,261,332,152 },
 "",
 "",0,0
};


void DeInitCodePages(void)
{
 destroy(CodePages);
 CodePages=0;
}



void InitCodePages(void)
{
 if (!CodePages)
   {
    CodePages=new TNoCaseNoOwnerStringCollection(7,3);

    #define a(v) CodePages->insert(&v)
    // Latin (22)
    a(PC437);
    a(PC775);
    a(PC850);
    a(PC852);
    a(PC857);
    a(PC860);
    a(PC861);
    a(PC863);
    a(PC865);
    a(ISO8879_1);
    a(ISO8859_1_Lat1);
    a(ISO8859_1u_Lat1);
    a(ISO8879_2);
    a(ISO8859_3);
    a(ISO8859_4);
    a(ISO8859_9);
    a(ISO8859_14);
    a(ISO8859_15);
    a(PC1250);
    a(PC1252);
    a(PC1254);
    a(PC1257);
    // Russian (16)
    a(PC855);
    a(PC866);
    a(ISO8859_5);
    a(KOI_8r);
    a(KOI_8crl);
    a(PC1251);
    a(ISO_IR_111);
    a(ISO_IR_153);
    a(CP10007);
    a(CP100072);
    a(OVR);
    a(AVR);
    a(U_CodeR);
    a(KOI_7);
    a(ISO_IR_147);
    a(ISO_IR_146);
    // Greek (4)
    a(PC737);
    a(PC869);
    a(PC1253);
    a(ISO8859_7);
    #undef a
    atexit(DeInitCodePages);
   }
}

ccIndex CodePageIDToIndex(int id)
{
 InitCodePages();
 ccIndex c=CodePages->getCount();
 ccIndex i;
 for (i=0; i<c; i++)
   {
    CodePage *p=(CodePage *)(CodePages->at(i));
    if (p->id==id)
       return i;
   }
 return 0;
}

int IndexToCodePageID(ccIndex index)
{
 InitCodePages();
 CodePage *p=(CodePage *)(CodePages->at(index));
 return p->id;
}

static unsigned short CPTable[257];

unsigned short *GetCodePage128Translate(int id)
{
 InitCodePages();
 CodePage *p=(CodePage *)(CodePages->at(CodePageIDToIndex(id)));
 memcpy(CPTable+128,p->Font,sizeof(short)*128);
 CPTable[256]=128;
 int i=0;
 if (p->LowRemapNum)
   {
    CPTable[256]=0;
    memcpy(CPTable,p->LowRemap,sizeof(short)*p->LowRemapNum);
    i=p->LowRemapNum;
   }
 for (; i<128; i++)
     CPTable[i]=i;

 return CPTable;
}

TStringCollection *GetCodePagesList(void)
{
 InitCodePages();
 return CodePages;
}

#ifdef __DJGPP__
#include <dpmi.h>

int GetCurrentOSCodePage(void)
{
 __dpmi_regs r;
 // From TVision
 //  get version number, in the form of a normal number
 r.x.ax=0x3000;
 __dpmi_int(0x21,&r);
 unsigned ver=(r.h.ah) | ((r.h.al & 0xff)<<8);
 if (ver<0x30C) // United States code page, for all versions before 3.3
    return 437;
 
 r.x.ax=0x6601;
 __dpmi_int(0x21,&r);
 return r.x.bx;
}

// Ultra DJGPP specific!
extern unsigned char __dj_ctype_toupper[];
extern unsigned char __dj_ctype_tolower[];

static
void CreateDefaultToUpper(void)
{
 int i=0;

 // Why it?
 __dj_ctype_toupper[0]=0;
 // That's only for ASCII and not even PC437!
 for (i=0; i<256; i++)
     if (i>='a' && i<='z')
        __dj_ctype_toupper[i+1]=i-32;
     else
        __dj_ctype_toupper[i+1]=i;
}

static
void CreateDefaultToLower(void)
{
 int i=0;

 __dj_ctype_tolower[0]=0;
 for (i=0; i<256; i++)
     if (i>='A' && i<='Z')
        __dj_ctype_tolower[i+1]=i+32;
     else
        __dj_ctype_tolower[i+1]=i;
}

static
void CreateToUpLowTablesFor(CodePage *p)
{
 // Make the ASCII part
 CreateDefaultToUpper();
 CreateDefaultToLower();
 // Now the code page specific
 uchar *s=(uchar *)p->UpLow;
 for (; *s; s+=2)
    {
     __dj_ctype_tolower[*(s+1)+1]=*s;
     __dj_ctype_toupper[*s+1]=*(s+1);
    }
}

static
void CreateIsWordCharFor(CodePage *p)
{
 int i;
 // Clean the table
 for (i=0; i<256; i++)
     _table_types_editor_[i]&=~ttedIsWordChar;
 // first the ASCII
 for (i=0; i<128; i++)
     if (ucisalnum(i))
        _table_types_editor_[i]|=ttedIsWordChar;
 _table_types_editor_['_']|=ttedIsWordChar;
 // Now, all the upper/lower are letters ;-)
 uchar *s=(uchar *)p->UpLow;
 for (; *s; s++)
     _table_types_editor_[*s]|=ttedIsWordChar;
 // And the rest
 for (s=(uchar *)p->MoreLetters; *s; s++)
     _table_types_editor_[*s]|=ttedIsWordChar;
}
#else
int GetCurrentOSCodePage(void)
{
 return 437;
}

static
void CreateDefaultToUpper(void)
{
}

static
void CreateDefaultToLower(void)
{
}

static
void CreateToUpLowTablesFor(CodePage *)
{
 // Make the ASCII part
 CreateDefaultToUpper();
 CreateDefaultToLower();
}

static
void CreateIsWordCharFor(CodePage *)
{
}
#endif

static uchar Similar[]=
{
 ' ','@','@','*','*','*','*','*','','o','','M','F','d','d','*', 26, 27,'I','', //   0- 19
 'P','S','','','^','V','>','<','','-','','',' ','!','"','#','$','%','&','\'', // 20- 39
 '(',')','*','+',',','-','.','/','0','1','2','3','4','5','6','7','8','9',':',';', //  40- 59
 '<','=','>','?','@','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O', //  60- 79
 'P','Q','R','S','T','U','V','W','X','Y','Z','[','\\',']','^','_','`','a','b','c',//  80- 99
 'd','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w', // 100-119
 'x','y','z','{','|','}','~','^',                                                 // 120-127
 'C','u','e','a','a','a','a','c','e','e','e','i','i','i','A','A','E','a','A','o', // 128-147
 'o','o','u','u','y','O','U','c','L','Y','P','f','a','i','o','u','n','N','a','o', // 148-167
 '?','','','*','*','!','<','>',' ',' ',' ','|','','','','','','','','', // 168-187
 '','','','*','*','','','','-','+','','','','','','','','','','', // 188-207
 '','','','','','','','','','*','*',' ',' ',' ',' ',' ','a','B','G','p', // 208-227
 'S','s','m','t','F','f','O','d','i','o','e','U','=','+','>','<','','','/','~', // 228-247
 'o','.','.','V','n','2','*',' '
};

unsigned char RemapCharCodePage(uchar c, unsigned short *map)
{
 if (c<map[256])
    return c;
 int i;
 ushort v=c;
 for (i=map[256]; i<256; i++)
     if (map[i]==v)
        return i;

 while (v>126 || v<32)
   {
    v=Similar[v];
    if (v>=32 && v<127)
       return v;
    for (i=map[256]; i<256; i++)
        if (map[i]==v)
           return i;
   }
 return v;
}

void RemapStringCodePage(uchar *n, uchar *o, ushort *map)
{
 int i;
 for (i=0; o[i]; i++)
     n[i]=RemapCharCodePage(o[i],map);
}

void RemapNStringCodePage(uchar *n, uchar *o, ushort *map, int len)
{
 for (; len; --len)
     n[len-1]=RemapCharCodePage(o[len-1],map);
}

// From the screen saver
extern char *coFormaScreenSaverStars[];
extern char *cFormaScreenSaverStars[];

void RemapCharactersFor(int id)
{
 InitCodePages();
 ccIndex index=CodePageIDToIndex(id);
 CodePage *p=(CodePage *)(CodePages->at(index));
 CreateToUpLowTablesFor(p);
 CreateIsWordCharFor(p);

 ushort *map=GetCodePage128Translate(id);

 #define C(cla,name) RemapStringCodePage((uchar *)cla##::##name,(uchar *)cla##::o##name,map)
 C(TRadioButtons,button);
 C(TMenuBox,frameChars);
 C(TFrame,frameChars);
 C(TFrame,closeIcon);
 C(TFrame,zoomIcon);
 C(TFrame,unZoomIcon);
 C(TFrame,dragIcon);
 C(THistory,icon);
 C(TMonoSelector,button);
 C(TStatusLine,hintSeparator);
 C(TCheckBoxes,button);
 C(TButton,shadows);
 C(TButton,markers);
 C(TDirListBox,pathDir);
 C(TDirListBox,firstDir);
 C(TDirListBox,middleDir);
 C(TDirListBox,lastDir);
 C(TDirListBox,graphics);
 #undef C

 #define C(cla,name) cla##::##name=RemapCharCodePage(cla##::o##name,map)
 C(TIndicator,dragFrame);
 C(TIndicator,normalFrame);
 C(TColorSelector,icon);
 C(TInputLine,rightArrow);
 C(TInputLine,leftArrow);
 C(TMenuBox,rightArrow);
 C(TRadioButtons,check);
 C(TIndicator,modifiedStar);
 C(TCEditor,TabChar);
 #undef C

 int i;

 for (i=0; i<6; i++)
     specialChars[i]=RemapCharCodePage(o_specialChars[i],map);
 #define C(cla,name,len) RemapNStringCodePage((uchar *)cla##::##name,(uchar *)cla##::o##name,map,len)
 C(TScrollBar,vChars,5);
 C(TScrollBar,hChars,5);
 #undef C

 #define C(num,o,n) for (i=0; i<num; i++) n[i][0]=RemapCharCodePage(o[i][0],map)
 C(4,coFormaScreenSaverStars,cFormaScreenSaverStars);
 #undef C

 TBackground *bkg=TProgram::deskTop->getBackground();
 bkg->changePattern(RemapCharCodePage(TDeskTop::defaultBkgrnd,map));

 TListViewer::columnSeparator=RemapCharCodePage(TListViewer::ocolumnSeparator,map);

 ProgBar_CurrentChar=RemapCharCodePage(ProgBar_DefaultChar,map);

 message(TProgram::deskTop,evBroadcast,cmcUpdateCodePage,map);
}

static ushort Similar2[]=
{
 'c','l','n','r','s','y','z', // 0x100-0x106 small acute
 'A','C','I','L','N','O','R','S','U','Y','Z', // 0x107-0x111 capital acute
 'U', // 0x112 double acute
 'A','E','I','O','U', // 0x113-0x117 capital grave
 'E','I', // 0x118-0x119 capital diaeresis
 'U','u', // 0x11A-0x11B ring above
 'a','o','u','A','O', // 0x11C-0x120 tilde/double acute
 'A','E','I','O','U', // 0x121-0x125 capital circumflex
 'c','n','r','s','z','C','D','E','N','R','S','T','Z', // 0x126-0x132 caron
 's','t','S','T', // 0x133-0x136 cedilla
 'a','e','A','E', // 0x137-0x13A ogonek
 'z','Z', // 0x13B-013C dot above
 'l','o','L','O','d', // 0x13D-0x141 stroke
 0x141, // 0x142 latin small letter eth
 'D', // 0x143 stroke
 'd','l','t','L', // 0x144-0x147 caron
 'a','e','A', // 0x14-0x14A breve
 '$', // 0x14B currency sign (o four feets), I guess that's a good fall back
      // specially thinking all people understand $ as money
 'P','p', // 0x14C-0x14D thorn (Icelandic) sorry I know that's arbitrary and
          // silly. Anyone have a better choice?
 '*', // 14E multiplication sign
 'R', // 14F registered sign (R)
 'c', // 150 copyright sign (c)
 'i', // 151  latin small letter dotless i
 '|', // 152  broken bar (|)
 '_', // 153  macron (_ but high)
 '\'',// 154  acute accent
 '-', // 155  soft hyphen (- long)
 '_', // 156  double low line (_ double)
 '3', // 157  vulgar fraction three quarters
 ',', // 158  cedilla
 '"', // 159  diaeresis (diresis, umlaut)
 '1', // 15a  superscript one
 '3', // 15b  superscript three
 '"', // 15c  double acute accent
 ';', // 15d  ogonek (cedilla inv.)
 '<', // 15e  caron (mandarin chinese third tone)
 '(', // 15f  breve
 '.', // 160  dot above (mandarin chinese light tone)
 'o','O', // 0x161-0x162 double acute
 0x145,0x147,0x146,'e',0x144, // 0x163-0x167 caron, fall back to the other representation
 // 0x168
 'A','B','G','D','Z','I','J','L','P','U','F','C','C','S','S','"','Y','"',
 'E','U','A', // 0x168-0x17C Cyrillic capitals group 1
 'b','v','g','d','z','z','i','j','k','l','m','n','p','t','u','f','c','c',
 's','s','\'','y','\'','e','u','a', // 0x17D-0x196 Cyrillic smalls group 1
 'I','i', // 0x197-0x198 ukrainian ie
 'Z', // 0x199 capital letter ze
 ' ', // 0x19A free slot
 'N', // 0x19B number
 // ISO-5 cyrillics:
 'D', // 19C capital letter dje (Serbocroatian) ()-5
 'd', // 19D small letter dje (Serbocroatian) ()-5
 'G', // 19E capital letter gje ()-5
 'g', // 19F small letter gje ()-5
 'Y', // 1A0 capital letter yi (Ukrainian) ()-5
 'L', // 1A1 capital letter lje ()-5
 'l', // 1A2 small letter lje ()-5
 'N', // 1A3 capital letter nje ()-5
 'n', // 1A4 small letter nje ()-5
 'T', // 1A5 capital letter tshe (Serbocroatian) ()-5
 't', // 1A6 small letter tshe (Serbocroatian) ()-5
 'K', // 1A7 capital letter kje ()-5
 'k', // 1A8 small letter kje ()-5
 'V', // 1A9 capital letter short U (Byelorussian) ()-5
 'v', // 1AA small letter short U (Byelorussian) ()-5
 'D', // 1AB capital letter dzhe ()-5
 'd', // 1AC small letter dzhe ()-5
 // Windows CP 1251 (russian)
 '"', // 1AD double low-9 quotation mark ()-cp1251
 '.', // 1AE horizontal ellipsis         ()-cp1251
 '|', // 1AF dagger                      ()-cp1251
 '|', // 1B0 double dagger               ()-cp1251
 '%', // 1B1 per mille sign              ()-cp1251
 '"', // 1B2 left double quotation mark  ()-cp1251
 '"', // 1B3 right double quotation mark ()-cp1251
 'T', // 1B4 trade mark sign             ()-cp1251
 0x16A, // 1B5 cyrillic capital letter ghe with upturn, default to GHE ()-cp1251
 0x17F, // 1B6 cyrillic small letter ghe with upturn, default to ghe   ()-cp1251
 '?',   // 1B7 That's a ? inside a circle, it means the character is unknown
 'O', // 1B8 latin capital ligature OE
 'o', // 1B9 latin small ligature oe
 // Idiot ISO-1 font found in Linux, only to break standards and annoy people
 't', // 1BA  symbol for horizontal tabulation
 'f', // 1BB  symbol for form feed
 'c', // 1BC  symbol for carriage return
 'l', // 1BD  symbol for line feed
 'n', // 1BE  symbol for newline
 'v', // 1BF  symbol for vertical tabulation
 '#', // 1C0  not equal to
 'v', // 1C1  downwards arrow with corner leftwards
 'Y', // 1C2  latin capital letter y with diaeresis
 ' ', // 1C3  free
 0xB3,// 1C4  box drawings light up ()-1 linux
 0xC4,// 1C5  box drawings light right ()-1 linux
 0xB3,// 1C6  box drawings light down ()-1 linux
 0xC4,// 1C7  box drawings light left ()-1 linux
 ' ', // 1C8  free
 0xBA,// 1C9  box drawings heavy up ()-1 linux
 0xCD,// 1CA  box drawings heavy right ()-1 linux
 0xBA,// 1CB  box drawings heavy down ()-1 linux
 0xCD,// 1CC  box drawings heavy left ()-1 linux
 0x1A8,//1CD  latin small letter kra
 'N','n', // Latin letter eng
 // Circumflex 1D0-1DD
 'C','c','G','g','H','h','J','j','S','s','W','w','Y','y',
 // Dot above 1DE-1EF
 'B','b','C','c','D','d','F','f','g','I','M','m','P','p','S','s','T','t',
 // Macron 1F0-1F7
 'E','e','I','i','O','o','U','u',
 // Breve 1F8-1FD
 'G','g','I','i','U','u',
 // Cedilla 1FE-205
 'G','g','K','k','N','n','R','r',
 // Tilde 206-209
 'I','i','U','u',
 // Ogonek 20A-20F
 'I','i','U','u','W','w',
 'Y',// 210   0x1EF2 LATIN CAPITAL LETTER Y WITH GRAVE
 'y',// 211   0x1EF3 LATIN SMALL LETTER Y WITH GRAVE
 'W',// 212   0x1E82 LATIN CAPITAL LETTER W WITH ACUTE
 'w',// 213   0x1E83 LATIN SMALL LETTER W WITH ACUTE
 'W',// 214   0x1E84 LATIN CAPITAL LETTER W WITH DIAERESIS
 'w',// 215   0x1E85 LATIN SMALL LETTER W WITH DIAERESIS
 'H',// 216   0x0126 LATIN CAPITAL LETTER H WITH STROKE
 'h',// 217   0x0127 LATIN SMALL LETTER H WITH STROKE
 'T',// 218   0x0166 LATIN CAPITAL LETTER T WITH STROKE
 't',// 219   0x0167 LATIN SMALL LETTER T WITH STROKE
 'O',// 21A   0x01A0 LATIN CAPITAL LETTER O WITH HORN
 'o',// 21B   0x01A1 LATIN SMALL LETTER O WITH HORN
 'U',// 21C   0x01AF LATIN CAPITAL LETTER U WITH HORN
 'u',// 21D   0x01B0 LATIN SMALL LETTER U WITH HORN
 'E',// 21E   0x0116 LATIN CAPITAL LETTER E WITH DOT ABOVE
 'e',// 21F   0x0117 LATIN SMALL LETTER E WITH DOT ABOVE
 'L',// 220   0x013B LATIN CAPITAL LETTER L WITH CEDILLA
 'l',// 221   0x013C LATIN SMALL LETTER L WITH CEDILLA
 // Greek smalls 222-22F
 'g','z','h','u','i','l','n','j','r','s','y','x','c','v',
 // Greek capitals 230-233
 'D','J','P','C',
 // Greek accented
 0x159,// 234   0x0385 GREEK DIALYTIKA TONOS => diaeresis
 0xE0, // 235   0x03AC GREEK SMALL LETTER ALPHA WITH TONOS => alpha
 0xEE, // 236   0x03AD GREEK SMALL LETTER EPSILON WITH TONOS => epsilon
 0x224,// 237   0x03AE GREEK SMALL LETTER ETA WITH TONOS => eta
 0x226,// 238   0x03AF GREEK SMALL LETTER IOTA WITH TONOS => iota
 'o',  // 239   0x03CC GREEK SMALL LETTER OMICRON WITH TONOS => omicron
 0x22C,// 23A   0x03CD GREEK SMALL LETTER UPSILON WITH TONOS => upsilon
 0x22F,// 23B   0x03CE GREEK SMALL LETTER OMEGA WITH TONOS => omega
 'A',  // 23C   0x0386 GREEK CAPITAL LETTER ALPHA WITH TONOS
 'E',  // 23D   0x0388 GREEK CAPITAL LETTER EPSILON WITH TONOS
 'H',  // 23E   0x0389 GREEK CAPITAL LETTER ETA WITH TONOS
 'I',  // 23F   0x038A GREEK CAPITAL LETTER IOTA WITH TONOS
 'O',  // 240   0x038C GREEK CAPITAL LETTER OMICRON WITH TONOS
 'Y',  // 241   0x038E GREEK CAPITAL LETTER UPSILON WITH TONOS
 0xEA, // 242   0x038F GREEK CAPITAL LETTER OMEGA WITH TONOS => omega
 0x226,// 243   0x03CA GREEK SMALL LETTER IOTA WITH DIALYTIKA => iota
 0x22C,// 244   0x03CB GREEK SMALL LETTER UPSILON WITH DIALYTIKA => upsilon
 0x238,// 245   0x0390 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS => iota + tonos
 0x23A,// 246   0x03B0 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS => upsilon + tonos
 'L',  // 247   <U039B> GREEK CAPITAL LETTER LAMDA
 'a','A',  // 248/9   <U0101/0> LATIN LETTER A WITH MACRON
 'G', //  24A   <U0120> LATIN CAPITAL LETTER G WITH DOT ABOVE
};

void RemapBufferGeneric(int sourID, int destID, uchar *buffer, unsigned len,
                        ushort ops)
{
 unsigned i;
 InitCodePages(); // Just in case
 // Table to convert a value into an internal code
 ushort *toCode=GetCodePage128Translate(sourID);
 ushort *aux;
 if (ops & rbgDontRemapLow32)
   {
    for (i=0; i<32; i++)
        toCode[i]=i;
   }
 else
   {
    // Avoid conversions that will break the text:
    toCode[0]=0;
    toCode['\n']='\n';
    toCode['\r']='\r';
    toCode['\t']='\t';
   }

 // Table to convert an internal value into a 0-255 value
 uchar *fromCode=new uchar[maxSymbolDefined];
 memset(fromCode,0,maxSymbolDefined*sizeof(uchar));

 ccIndex destInd=CodePageIDToIndex(destID);
 CodePage *destCP=(CodePage *)(CodePages->at(destInd));

 aux=destCP->Font;
 for (i=0; i<128; i++)
     if (aux[i]<maxSymbolDefined) // extra check, just in case I forgot to update the constant
        fromCode[aux[i]]=i+128;

 i=0;
 if (!(ops & rbgDontRemapLow32) && destCP->LowRemapNum)
   {
    unsigned to=destCP->LowRemapNum;
    aux=destCP->LowRemap;
    for (; i<to; i++)
        if (aux[i]<maxSymbolDefined)
           fromCode[aux[i]]=i;
   }
 for (; i<128; i++)
     fromCode[i]=i;
 // Avoid conversions that will break the text:
 fromCode[0]=0;
 fromCode['\n']='\n';
 fromCode['\r']='\r';
 fromCode['\t']='\t';

 // Adjust values found in source but not in dest (look for similars)
 for (i=1; i<256; i++)
    {
     unsigned val=toCode[i];
     if (fromCode[val])
        continue;
     while (!fromCode[val])
       { // Find an equivalent for val
        if (val<256)
           val=Similar[val];
        else
           val=Similar2[val-256];
       }
     fromCode[toCode[i]]=val;
    }

 // Ok, now do it!
 for (i=0; i<len; i++)
     buffer[i]=fromCode[toCode[buffer[i]]];

 delete[] fromCode;
}
//#endif
