// MICRO-X ACCESSOR SYSTEM Ver. 1.5.1
// Program Name: Mcsub1.cpp ... Subaccessor1 Accessor System Program.
// Date Revised: March 11, 2003.
//
// Author       : JOHN F. CLARK JR.
// I can be contacted by mail at......
// Address      : 11-15 Port Richmond Av. Staten Island, NY 10302
//
// *****************************************************
// [ Appendix: Terms Conditions and Aggreements ]
// *****************************************************
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//                       NO WARRANTY
// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
// OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
// PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
// OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
// TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
// PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
// REPAIR OR CORRECTION.
//
// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
// INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
// OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
// TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
// YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
// PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGES.
//                    END OF TERMS AND CONDITIONS
//***************************************************************************
//
// *************************************************************
// ... START of MAIN Program for Mcsub1.cpp Subaccessor1 ...
// *************************************************************
//---------------------------------------------
// [ Mcsub1.cpp's header file include section ]
//---------------------------------------------
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <dpmi.h>
#include <go32.h>
#include <libc.h>
#include <keys.h>
#include <pc.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <time.h>
#include <bios.h>
#include <ezvgadj.h>

// ...Micro-x's Function Definition Section ...
void Err_Handler(int ERR_FLAG);
void Mouse_init(unsigned long int mass1, unsigned long int mass2);
void mouse_on(void);
void mouse_off(void);
int mouse_btn_stas(void);
int mouse_y_stas(void);
int mouse_x_stas(void);
int mouse_btn_rels(void);
void Set_screen(char *ar_ptr[56]);
void Accs_Help(void);
void Up_Arrow(char *ar_ptr[56]);
void Dwn_Arrow(char *ar_ptr[56]);
void Enter_Key(char *ar_ptr[56]);
void Mouse_Ev_Hndle(char *ar_ptr[56]);
void mouse_xy_set(void);
void mouse_xy_get(void);

// .....Global System INIT. Section....
_go32_dpmi_registers r;

// ... Global Variables declaration Section ...
unsigned long int mouse_install = 0;
int mouse_ON_OFF = 0;
int mouse_px_y = 100;
int mouse_px_x = 160;
int cur_ybase = 9;
int cur_xbase = 25;
int itm_sbcrp = 7;
int pat_sbcrp = 35;
int _ON = 1;
int _OFF = 0;
int video_mode = 0;
int LocalScrn_y = 0;
int LocalScrn_x = 0;
int Idel_lop = 1;
int LoadExeReady = 1;
char Itm_8[ ] = "EXIT......(to micro-x subaccessor #2)";
char Itm_9[ ] = "EXIT.......(to micro-x main accessor)";

// ... Start of Micro-x Main Program ...
int main(int argc, char **argv)
{
   int a, y, x, t;
   int ERR_FLAG = 0;
   int mouse_key;
   FILE *fp;
   unsigned long int mass1 = 0x0ffff;
   unsigned long int mass2 = 0x04700;
   int mouse_y = 0;
   int mouse_x = 0;
   int presskey = 0;
   int handle = 0;
   unsigned int result = 0;
   char Itm_1s[] = "#L";
   char Itm_2s[] = "#P";
   char *ar_ptr[56];
   char *buf = (char*) malloc(4800);
   unsigned *scrn_buf = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);
   char c = '';
   char com_line[ ] = "60786MX1";
   char buf1[9];
   extern int _ON;
   extern int _OFF;
   extern int viedo_mode;
   extern int LocalScrn_y;
   extern int LocalScrn_x;

//........
   _fmode = O_BINARY;
   a = 0;
   x = 0;

    if (strlen(argv[1]) > 8)
    {
        ERR_FLAG = 2;
        Err_Handler(ERR_FLAG);
        free(buf);
        free(scrn_buf);
        mouse_off();
        exit(0);
    }

    if (strlen(argv[1]) == NULL)
    {
        ERR_FLAG = 2;
        Err_Handler(ERR_FLAG);
        free(buf);
        free(scrn_buf);
        mouse_off();
        exit(0);
    }

    if ((argc >= 3) || (argc == 0))
    {

        ERR_FLAG = 2;
        Err_Handler(ERR_FLAG);
        free(buf);
        free(scrn_buf);
        mouse_off();
        exit(0);
    }
// .......
    fp = fopen("accs.tmp", "w");
    fprintf(fp, "%s", argv[1]);
    fclose(fp);
    fp = fopen("accs.tmp", "r");
    fscanf(fp, "%s", buf1);
    fclose(fp);
    remove("accs.tmp");
// ........
   if (strcmp(buf1, com_line) != 0)
    {
       ERR_FLAG = 2;
       Err_Handler(ERR_FLAG);
       free(buf);
       free(scrn_buf);
       mouse_off();
       exit(0);
    }
//.........
   t = 0;
   a = 0;
   x = 0;
   while (x != 28)
   {
      *(ar_ptr + t) = strcpy(buf + a, Itm_1s);
      t += 1;
      x += 1;
      a = a + 38;
   }
   t = 28;
   a = 1064;
   x = 28;
   while (x != 56)
   {
      *(ar_ptr + t) = strcpy(buf + a, Itm_2s);
      t += 1;
      x += 1;
      a = a + 128;
   }
// ..........
    if(!_dos_open("ACCSD15.DAT", O_RDONLY, &handle) )
    {
      if(_dos_read(handle, buf, 4800, &result) != 0)
      {
       ERR_FLAG = 2;
       Err_Handler(ERR_FLAG);
       free(buf);
       free(scrn_buf);
       mouse_off();
       _dos_close(handle);
       exit(0);
      }
    }
    _dos_close(handle);
//.........
   t = 0;
   x = 0;
   while (x != 4800)
   {
      if ((*(buf + t) != NULL) && (*(buf + t) != '\0'))
      {
         *(buf + t) += c;
      }
      t += 1;
      x += 1;
   }
// .... Main program INI startup ...
   video_mode = ScreenMode();
   LocalScrn_y = wherey();
   LocalScrn_x = wherex();
   ScreenRetrieve(scrn_buf);
   Mouse_init(mass1, mass2);
   textmode(C80);
   _setcursortype(_NOCURSOR);
   Set_screen(ar_ptr);
   mouse_on();
   mouse_xy_set();
   gppconio_init();

// ... Main program idel loop ...

   while (Idel_lop != _OFF)
   {
         if (kbhit())
         {
           presskey = getkey();
         }
// ........
         if (presskey == K_Up)
         {
            mouse_xy_get();
            mouse_off();
            Up_Arrow(ar_ptr);
            mouse_xy_set();
            mouse_on();
            presskey = 0;
         }
// ........
        if (presskey == K_Down)
        {
            mouse_xy_get();
            mouse_off();
            Dwn_Arrow(ar_ptr);
            mouse_xy_set();
            mouse_on();
            presskey = 0;
        }
// ........
       if (presskey == K_Return)
       {
           Enter_Key(ar_ptr);
           presskey = 0;
       }
// ........
       if (presskey == K_F1)
       {
           Accs_Help();
           presskey = 0;
       }
//........
       mouse_key = mouse_btn_stas();
       if (mouse_key != 0)
       {
           delay(50);
           mouse_key = 0;
           mouse_key = mouse_btn_rels();
           if (mouse_key != 0)
           {
              mouse_key = 0;
              Mouse_Ev_Hndle(ar_ptr);
           }
       }
       Idel_lop = LoadExeReady;
   }
// ........
   mouse_off();
   r.h.ah = 0x00;
   r.h.al = video_mode;
   r.x.ss = r.x.sp = 0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenUpdate(scrn_buf);
   free(buf);
   free(scrn_buf);
   _setcursortype(_NORMALCURSOR);
   if (LocalScrn_y >= 25)
   {
        LocalScrn_y -= 1;
   }
   if (LocalScrn_x >= 80)
   {
        LocalScrn_x -= 1;
   }
   ScreenSetCursor(LocalScrn_y, LocalScrn_x);
   return(0);
}

// ... Error Message Handler Function ...
void Err_Handler(int ERR_FLAG)
{
    int xe = 0;
    int ye = 0;
    int y_es = 0;
    int x_es = 0;
    extern int _ON;
    extern int _OFF;
    unsigned *saved_scrn = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);

    if(ERR_FLAG == 1)
    {
        mouse_xy_get();
        mouse_off();
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(2, 0);
        cprintf("File ... !!!  Error  !!! ... in Micro-x Accessor System.\n\r");
        cprintf("Check the Micro-x Files and Directory, and ensure they are correct.\n\r");
        cprintf("Read the Micro-x.doc File for more detailed information ....\n\r");
        cprintf("Press Esc to continue.......\n\r");
//........
        while (ye != K_Escape)
        {
           if (kbhit())
           {
             ye = getkey();
           }
        }
        free(saved_scrn);
        mouse_xy_set();
        mouse_on();
        return;
    }
    if(ERR_FLAG == 2)
    {
        mouse_xy_get();
        mouse_off();
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(2, 0);
        cprintf("\n\rFile ... !!!  Error  !!! ... in Micro-x Accessor System.\n\r");
        cprintf("Use Mxloder.exe to run this program. Read the Micro-x.doc file.\n\r");
        cprintf("Press Esc to continue.......\n\r");
//........
        while (ye != K_Escape)
        {
           if (kbhit())
           {
             ye = getkey();
           }
        }
        free(saved_scrn);
        mouse_xy_set();
        mouse_on();
        return;
    }
// ........
    if(ERR_FLAG == 3)
    {
        mouse_xy_get();
        mouse_off();
        ScreenRetrieve(saved_scrn);
        textbackground(7);
        textcolor(0);
        ScreenSetCursor(4, 10);
        cprintf("%c", '\xDA');
        ScreenSetCursor(4, 11);
        r.h.ah = 0x09;
        r.h.al = 0xC4;
        r.h.bh = 0x00;
        r.h.bl = 0x70;
        r.x.cx = 0x3B;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        ScreenSetCursor(4, 69);
        cprintf("%c", '\xBF');
        ScreenSetCursor(5, 10);
        cprintf("%c", '\xB3');
        x_es = 11;
        y_es = 5;
        xe = 1;
// ........
        while (xe != 12)
        {
            ScreenSetCursor(y_es, x_es);
            r.h.ah = 0x09;
            r.h.al = 0x20;
            r.h.bh = 0x00;
            r.h.bl = 0x70;
            r.x.cx = 0x3B;
            r.x.ss = r.x.sp =0x00;
            _go32_dpmi_simulate_int(0x10, &r);
            x_es = 69;
            ScreenSetCursor(y_es, x_es);
            cprintf("%c", '\xB3');
            ++y_es;
            x_es =10;
            ScreenSetCursor(y_es, x_es);
            cprintf("%c", '\xB3');
            x_es = 11;
            ++xe;
        }
        ScreenSetCursor(16, 10);
        cprintf("%c", '\xC0');
        ScreenSetCursor(16, 11);
        r.h.ah = 0x09;
        r.h.al = 0xC4;
        r.h.bh = 0x00;
        r.h.bl = 0x70;
        r.x.cx = 0x3B;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        ScreenSetCursor(16, 69);
        cprintf("%c", '\xD9');
// ........
        textbackground(7);
        textcolor(4);
        ScreenSetCursor(6, 24);
        cprintf("Accessor System File !! ERROR !!");
        textbackground(7);
        textcolor(0);
        ScreenSetCursor(8, 13);
        cprintf("The Selected Item May Not Be Install in the Accessor. ");
        ScreenSetCursor(9, 13);
        cprintf("Check Files And Directories To Ensure They Are Correct.");
        ScreenSetCursor(10, 13);
        cprintf("Make Sure That All Application Program Start Up Files");
        ScreenSetCursor(11, 13);
        cprintf("Are Located In Their Directories,  And Are Not Corrupt.");
        ScreenSetCursor(13, 13);
        cprintf("Press Esc");
        ye = 0;
        sound(440);
        delay(50);
        nosound();
        while (ye != K_Escape)
        {
           if (kbhit())
           {
             ye = getkey();
           }
        }
    }
// ........
    ScreenUpdate(saved_scrn);
    free(saved_scrn);
    mouse_xy_set();
    mouse_on();
    return;
}

// ...Micro-x 's Help Information Function .....
void Accs_Help(void)
{
    int xh = 0;
    int yh = 0;
    int y_hs = 0;
    int x_hs = 0;
    extern int _OFF;
    extern _ON;
    unsigned *saved_hscrn = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);
// ........
    mouse_xy_get();
    mouse_off();
    ScreenRetrieve(saved_hscrn);
    textbackground(7);
    textcolor(1);
    ScreenSetCursor(4, 10);
    cprintf("%c", '\xDA');
    ScreenSetCursor(4, 11);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x71;
    r.x.cx = 0x3B;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(4, 69);
    cprintf("%c", '\xBF');
    ScreenSetCursor(5, 10);
    cprintf("%c", '\xB3');
    x_hs = 11;
    y_hs = 5;
    xh = 1;
// ........
    while (xh != 16)
    {
       ScreenSetCursor(y_hs, x_hs);
       r.h.ah = 0x09;
       r.h.al = 0x20;
       r.h.bh = 0x00;
       r.h.bl = 0x71;
       r.x.cx = 0x3B;
       r.x.ss = r.x.sp =0x00;
       _go32_dpmi_simulate_int(0x10, &r);
       x_hs = 69;
       ScreenSetCursor(y_hs, x_hs);
       cprintf("%c", '\xB3');
       ++y_hs;
       x_hs =10;
       ScreenSetCursor(y_hs, x_hs);
       cprintf("%c", '\xB3');
       x_hs = 11;
       ++xh;
   }
   ScreenSetCursor(20, 10);
   cprintf("%c", '\xC0');
   ScreenSetCursor(20, 11);
   r.h.ah = 0x09;
   r.h.al = 0xC4;
   r.h.bh = 0x00;
   r.h.bl = 0x71;
   r.x.cx = 0x3B;
   r.x.ss = r.x.sp =0x00;
   _go32_dpmi_simulate_int(0x10, &r);
   ScreenSetCursor(20, 69);
   cprintf("%c", '\xD9');
// ........
   textbackground(7);
   textcolor(1);
   ScreenSetCursor(5, 20);
   cprintf("MICRO-X ACCESSOR SYSTEM HELP INFORMATION");
   ScreenSetCursor(6, 15);
   cprintf("");
   textbackground(7);
   textcolor(0);
   ScreenSetCursor(8, 13);
   cprintf("To Select an item, use the up and down arrow keys to");
   ScreenSetCursor(9, 13);
   cprintf("move the cursor bar to the desired item, then press");
   ScreenSetCursor(10, 13);
   cprintf("the Enter key to activate. Mouse users, move the mouse");
   ScreenSetCursor(11, 13);
   cprintf("pointer on the desired item, then press the left mouse");
   ScreenSetCursor(12, 13);
   cprintf("button to activate. Many of the Acessor's items can be");
   ScreenSetCursor(13, 13);
   cprintf("changed by use of the Micro-x Accessor System Editor.");
   ScreenSetCursor(14, 13);
   cprintf("For a better description on how to set up, and operate");
   ScreenSetCursor(15, 13);
   cprintf("the Micro-x Accessor System, see the Micro-x.doc file.");
   ScreenSetCursor(16, 13);
   cprintf("The file is normally located in the Micro-x directory.");
   ScreenSetCursor(18, 13);
   cprintf("Press Esc");
   yh = 0;
// ........   
   while (yh != K_Escape)
   {
      yh = getkey();
   }
   ScreenUpdate(saved_hscrn);
   mouse_xy_set();
   free(saved_hscrn);
   mouse_on();
   return;
}
// ....Mouse INIT. Function ....
void Mouse_init(unsigned long int mass1, unsigned long int mass2)
{
        unsigned long int j = 0;
        extern unsigned long int mouse_install;
        j = 0;
        j = mouseinit();
        if (j == 0)
        {
          return;
        }
        j = 0xFFFF;
        mouse_install = j;
        return;
}
// ........
void mouse_on(void)
{
        extern int mouse_ON_OFF;
        extern unsigned long int mouse_install;
        if ((mouse_install != 0) && (mouse_ON_OFF !=1))
        {
           mousecursor(ON);
           mouse_ON_OFF = 1;
        }
        return;
}

// ........
void mouse_off(void)
{
        extern int mouse_ON_OFF;
        extern unsigned long int mouse_install;
        if ((mouse_install != 0) && (mouse_ON_OFF != 0))
        {
           mousecursor(OFF);
           mouse_ON_OFF = 0;
        }
        return;
}

// ....Mouse button status .....
int mouse_btn_stas(void)
{
        int j = 0;
        extern unsigned long int mouse_install;
        if (mouse_install != 0)
        {
         j = mousebuttons();
        }
        return(j);
}

// ....Mouse y status Fuctionn....
int mouse_y_stas(void)
{
        int x = 0;
        int mouse_y = 0;
        extern unsigned long int mouse_install;
        if (mouse_install != 0)
        {
           getmousepos(x, mouse_y);
           mouse_y = (mouse_y >> 3) + 1;
           return(mouse_y);
        }
        return(mouse_y);
}

// ....Mouse x status Function....
int mouse_x_stas(void)
{
        extern unsigned long int mouse_install;
        int y = 0;
        int mouse_x = 0 ;
        if (mouse_install != 0)
        {
           getmousepos(mouse_x, y);
           mouse_x = (mouse_x >> 3) + 1;
           if (mouse_x  >= 80)
           {
             mouse_x = 79;
           }
           return(mouse_x);
        }
        return(mouse_x);
}

// ....Mouse button Release Function .....
int mouse_btn_rels(void)
{
        int k = 0;
        extern unsigned long int mouse_install;

        if (mouse_install != 0)
        {
           r.x.ax = 0x06;
           r.x.ss = r.x.sp =0x00;
           _go32_dpmi_simulate_int(0x33, &r);
           k = r.x.bx;
        }
        return(k);
}

// ... Mouse x,y, Reset Function ........
void mouse_xy_set(void)
{
    extern int mouse_px_y;
    extern int mouse_px_x;
    extern unsigned long int mouse_install;
    if (mouse_install != 0)
    {
      setmousepos(mouse_px_x, mouse_px_y);
    }
    return;
}
// ... Mouse Get x,y, Function ........
void mouse_xy_get(void)
{
    extern int mouse_px_y;
    extern int mouse_px_x;
    extern unsigned long int mouse_install;
    if (mouse_install != 0)
    {
        getmousepos(mouse_px_x, mouse_px_y);
    }
    return;
}

// ....Screen setup Function ....
void Set_screen(char *ar_ptr[56])
{
    int ys = 0;
    int xs = 0;
    int y_scrn = 0;
    int x_scrn = 0;
    int t = 0;
    char c = '\x0F';
    extern char Itm_8[38];
    extern char Itm_9[38];
    extern int cur_ybase;
    extern int cur_xbase;
    extern int itm_sbcrp;
// ........
    textbackground(3);
    textcolor(1);
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xC9');
    x_scrn = 1;
    ScreenSetCursor(y_scrn, x_scrn);
    r.h.ah = 0x09;
    r.h.al = 0xCD;
    r.h.bh = 0x00;
    r.h.bl = 0x31;
    r.x.cx = 0x4F;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    x_scrn = 79;
    y_scrn = 0;
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xBB');
    y_scrn = 1;
    x_scrn = 0;
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xBA');
    x_scrn = 1;
    xs = 1;
// ........
    while (xs != 24)
    {
        ScreenSetCursor(y_scrn, x_scrn);
        r.h.ah = 0x09;
        r.h.al = 0xB0;
        r.h.bh = 0x00;
        r.h.bl = 0x30;
        r.x.cx = 0x4F;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        x_scrn = 79;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xBA');
        ++y_scrn;
        x_scrn = 0;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xBA');
        x_scrn = 1;
        ++xs;
    }
    y_scrn = 24;
    x_scrn = 0;
    ScreenSetCursor(y_scrn, x_scrn);
    cprintf("%c", '\xC8');
// ........
    ++x_scrn;
    ScreenSetCursor(y_scrn, x_scrn);
    r.h.ah = 0x09;
    r.h.al = 0xCD;
    r.h.bh = 0x00;
    r.h.bl = 0x31;
    r.x.cx = 0x4F;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    x_scrn = 79;
    y_scrn = 24;
    ScreenSetCursor(y_scrn, x_scrn);
    ScreenPutChar('\xBC', (CYAN << 4) | BLUE, x_scrn, y_scrn);
// ........
    ScreenPutString(" Micro-x Ver. 1.5.1 ", (BLUE << 4) | WHITE, 29, 0);
// ........
    textbackground(3);
    textcolor(1);
    ScreenSetCursor(2, 7);
    cprintf("%c", '\xDA');
    ScreenSetCursor(2, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x31;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(2, 72);
    cprintf("%c", '\xBF');
    ScreenSetCursor(3, 7);
    cprintf("%c ", '\xB3');
    ScreenSetCursor(3, 71);
    cprintf(" %c", '\xB3');
    ScreenSetCursor(4, 7);
    cprintf("%c", '\xC0');
    ScreenSetCursor(4, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x31;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(4, 72);
    cprintf("%c", '\xD9');
    ScreenPutString("   M I C R O - X   S U B #1   A C C E S S O R   S Y S T E M   ", (CYAN << 4) | BLACK, 9, 3);
// ........
    textbackground(0);
    textcolor(14);
    ScreenSetCursor(7, 7);
    cprintf("%c", '\xDA');
    ScreenSetCursor(7, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x0E;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(7, 72);
    cprintf("%c", '\xBF');
    ScreenSetCursor(8, 7);
    cprintf("%c", '\xB3');
    x_scrn = 8;
    y_scrn = 8;
    xs = 1;
// ........
    while (xs != 12)
    {
        ScreenSetCursor(y_scrn, x_scrn);
        r.h.ah = 0x09;
        r.h.al = 0x20;
        r.h.bh = 0x00;
        r.h.bl = 0x0E;
        r.x.cx = 0x40;
        r.x.ss = r.x.sp =0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        x_scrn = 72;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xB3');
        ++y_scrn;
        x_scrn = 7;
        ScreenSetCursor(y_scrn, x_scrn);
        cprintf("%c", '\xB3');
        x_scrn = 8;
        ++xs;
    }
    ScreenSetCursor(19, 7);
    cprintf("%c", '\xC0');
    ScreenSetCursor(19, 8);
    r.h.ah = 0x09;
    r.h.al = 0xC4;
    r.h.bh = 0x00;
    r.h.bl = 0x0E;
    r.x.cx = 0x40;
    r.x.ss = r.x.sp =0x00;
    _go32_dpmi_simulate_int(0x10, &r);
    ScreenSetCursor(19, 72);
    cprintf("%c", '\xD9');
// ........
    ScreenPutString(" Sub1 Accessor Selections ", (BLUE << 4) | WHITE, 26, 6);
    ScreenPutString(" F1 Help ", (RED << 4) | WHITE, 64, 20);
    ScreenPutString( " Use Up (), And Down () Arrow Keys To Select, And Press Enter ", (CYAN << 4) | BLACK, 8, 22);
    ScreenPutString( " Micro-x Nov. 2001 (Copy Right Pending)  Designed By John F. Clark Jr.", (BLUE << 4) | WHITE, 5, 24);
// ........
    textbackground(3);
    textcolor(0);
    ScreenSetCursor(8, 8);
    for (xs = 8; xs <= 19; xs++)
    {
      cprintf(" %63c", '\x20');
      ScreenSetCursor(xs, 8);
    }
// ........
    textbackground(3);
    textcolor(1);
    ys = 0;
    ScreenSetCursor(9, 17);
    for (xs = 9; xs <= 18; xs++)
    {
      cprintf("[ %d ]..", ys);
      ScreenSetCursor(xs, 17);
      ++ys;

    }
// ........
   ys = 7;
   for (xs = 9; xs <= 15; xs++)
   {
     ScreenPutString(ar_ptr[ys], 48, 25, xs);
     ys += 1;
   }
    textbackground(3);
    textcolor(14);
    ScreenSetCursor(16, 25);
    cprintf("%s", Itm_8);
    ScreenSetCursor(17, 25);
    cprintf("%s", Itm_9);
// ........
    ScreenSetCursor(cur_ybase, cur_xbase);
    ScreenPutString(ar_ptr[itm_sbcrp], (BLACK << 4) | LIGHTCYAN, cur_xbase, cur_ybase);
    return;
}

//... Down Arrow Key Function ....
void Dwn_Arrow(char *ar_ptr[56])
{
    extern int itm_sbcrp;
    extern int pat_sbcrp;
    extern int cur_ybase;
    extern int cur_xbase;
    extern char Itm_8[38];
    extern char Itm_9[38];

    if ((cur_ybase >= 9) && (cur_ybase <= 15))
    {
       textbackground(3);
       textcolor(0);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
    }
// ........
    if (cur_ybase == 16)
    {
       textbackground(3);
       textcolor(14);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_8);
    }
// ........
    if (cur_ybase == 17)
    {
       textbackground(3);
       textcolor(14);
       ScreenSetCursor(cur_ybase, cur_xbase);
       mouse_off();
       cprintf("%s", Itm_9);
    }
// ........
    if (cur_ybase == 9)
    {
       cur_ybase = 10;
       itm_sbcrp = 8;
       pat_sbcrp = 36;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 10)
    {
       cur_ybase = 11;
       itm_sbcrp = 9;
       pat_sbcrp = 37;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 11)
    {
       cur_ybase = 12;
       itm_sbcrp = 10;
       pat_sbcrp = 38;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 12)
    {
       cur_ybase = 13;
       itm_sbcrp = 11;
       pat_sbcrp = 39;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 13)
    {
       cur_ybase = 14;
       itm_sbcrp = 12;
       pat_sbcrp = 40;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 14)
    {
       cur_ybase = 15;
       itm_sbcrp = 13;
       pat_sbcrp = 41;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 15)
    {
       cur_ybase = 16;
       itm_sbcrp = 7;
       pat_sbcrp = 35;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_8);
       return;
    }
// ........
    if (cur_ybase == 16)
    {
       cur_ybase = 17;
       itm_sbcrp = 7;
       pat_sbcrp = 35;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_9);
       return;
    }
// ........
    if (cur_ybase == 17)
    {
       cur_ybase = 9;
       itm_sbcrp = 7;
       pat_sbcrp = 35;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
    return;
}

// ... Up Arrow Key Function ....
void Up_Arrow(char *ar_ptr[56])
{
    int x = 0;
    extern int itm_sbcrp;
    extern int pat_sbcrp;
    extern int cur_ybase;
    extern int cur_xbase;
    extern char Itm_8[38];
    extern char Itm_9[38];

    if ((cur_ybase >= 9) && (cur_ybase <= 15))
    {
       textbackground(3);
       textcolor(0);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
    }
// ........
    if (cur_ybase == 16)
    {
       textbackground(3);
       textcolor(14);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_8);
    }
// ........
    if (cur_ybase == 17)
    {
       textbackground(3);
       textcolor(14);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_9);
    }
// ........
    if (cur_ybase == 9)
    {
       cur_ybase = 17;
       itm_sbcrp = 7;
       pat_sbcrp = 35;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_9);
       return;
     }
// ........
    if (cur_ybase == 10)
    {
       cur_ybase = 9;
       itm_sbcrp = 7;
       pat_sbcrp = 35;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 11)
    {
       cur_ybase = 10;
       itm_sbcrp = 8;
       pat_sbcrp = 36;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 12)
    {
       cur_ybase = 11;
       itm_sbcrp = 9;
       pat_sbcrp = 37;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 13)
    {
       cur_ybase = 12;
       itm_sbcrp = 10;
       pat_sbcrp = 38;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 14)
    {
       cur_ybase = 13;
       itm_sbcrp = 11;
       pat_sbcrp = 39;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 15)
    {
       cur_ybase = 14;
       itm_sbcrp = 12;
       pat_sbcrp = 40;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 16)
    {
       cur_ybase = 15;
       itm_sbcrp = 13;
       pat_sbcrp = 41;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", ar_ptr[itm_sbcrp]);
       return;
    }
// ........
    if (cur_ybase == 17)
    {
       cur_ybase = 16;
       itm_sbcrp = 7;
       pat_sbcrp = 35;
       textbackground(0);
       textcolor(11);
       ScreenSetCursor(cur_ybase, cur_xbase);
       cprintf("%s", Itm_8);
       return;
    }
   return;
}

// ... Enter Key Function ...
void Enter_Key(char *ar_ptr[56])
{
    int x = 0;
    int handle = 0;
    int pos_chr = 0;
    unsigned int result = 0;
    char Prg_Exit_Code[ ] = "SUBEXIT60786MX1ACC";
    char prg_idsub1[ ] = "60786MX1";
    char prg_idsub2[ ] = "60787MX1";
    extern int itm_sbcrp;
    extern int pat_sbcrp;
    extern int cur_ybase;
    extern int cur_xbase;
    extern char Itm_8[38];
    extern char Itm_9[38];
    extern int LoadExeReady;
    extern int _ON;
    extern int _OFF;
    int ER_FLG;
    char path_chk[130];
    char data_buf[200];
    char *file_buf = (char*) alloca(200);
    if((cur_ybase >= 9) && (cur_ybase <= 15))
    {
     strcpy(path_chk, *(ar_ptr + pat_sbcrp));
     pos_chr = strcspn(path_chk, " ");
     if(pos_chr != 0)
     {
      path_chk[pos_chr] = '\0';
     }
     if(!__file_exists(path_chk))
     {
      ER_FLG = 3;
      Err_Handler(ER_FLG);
      mouse_xy_set();
      mouse_on();
      return;
     }
    }
    if ((cur_ybase >= 9) && (cur_ybase <= 15))
    {
      strcpy(data_buf, *(ar_ptr + pat_sbcrp));
      strcat(data_buf, prg_idsub1);
      strcpy(file_buf + 0, data_buf);
    }
// ........       
    if (cur_ybase == 16)
    {
      strcpy(data_buf, prg_idsub2);
      strcat(data_buf, prg_idsub1);
      strcpy(file_buf + 0, data_buf);
    }
// ........       
    if (cur_ybase == 17)
    {
      strcpy(data_buf, Prg_Exit_Code);
      strcat(data_buf, prg_idsub1);
      strcpy(file_buf + 0, data_buf);
    }
    fflush(stdout);
    if(_dos_creat("ACCSLNCH.DAT", _A_ARCH, &handle) != 0)
    {
      ER_FLG =  1;
      Err_Handler(ER_FLG);
      LoadExeReady = _OFF;
      _dos_close(handle);
      return;
    }
    if(_dos_write(handle, file_buf, 200, &result) != 0)
    {
      ER_FLG =  1;
      Err_Handler(ER_FLG);
      LoadExeReady = _OFF;
      _dos_close(handle);
      return;
    }
  _dos_close(handle);
  LoadExeReady = _OFF;
  return;
}
//... Mouse Event Handler Function ......
void Mouse_Ev_Hndle(char *ar_ptr[56])
{
   extern int cur_ybase;
   extern int cur_xbase;
   extern int _OFF;
   extern int _ON;
   int ymh = 0;
   int xmh = 0;

   ymh = mouse_y_stas();
   xmh = mouse_x_stas();
   ymh -= 1;
   xmh -= 1;

   if ((cur_ybase == ymh) && (xmh >= 8) && (xmh <= 30))
   {
       Enter_Key(ar_ptr);
       return;
   }
// ........
   if ((ymh >= 9) && (ymh <= 17))
   {
      if ((xmh >= 8) && (xmh <= 30))
      {
          mouse_xy_get();
          mouse_off();
          if (cur_ybase > ymh)
          {
             while (cur_ybase != ymh)
             {
                Up_Arrow(ar_ptr);
             }
             mouse_xy_set();
             mouse_on();
             return;
          }
          if (cur_ybase < ymh)
          {
             while (cur_ybase != ymh)
             {
                Dwn_Arrow(ar_ptr);
             }
             mouse_xy_set();
             mouse_on();
             return;
           }
      }
   }
   return;
}

//*************************************************************
//*************************************************************
// ... End of Program for Mcsub1.cpp Subaccessor1 ...
//*************************************************************
