// PROGRAM NAME:: MXLODER.C, FOR MXLODER.EXE.  REVISED DATE:: 4/11/2003.
// Mxloder.c Version 3.2, a full 32 bit protected mode loader program.
// PROGRAM DESIGNED FOR MICRO-X Ver. 1.5.1 AS A PROGRAM LOADER FOR DOS.
//
// Author       : JOHN F. CLARK JR.
// I can be contacted by mail at......
// Address      : 11-15 Port Richmond Av. Staten Island, NY 10302
//
// *****************************************************
// [ Appendix: Terms Conditions and Aggreements ]
// *****************************************************
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//                       NO WARRANTY
// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
// OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
// PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
// OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
// TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
// PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
// REPAIR OR CORRECTION.
//
// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
// INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
// OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
// TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
// YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
// PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGES.
//                    END OF TERMS AND CONDITIONS
//***************************************************************************
//
// -------------------------------------------
// [ Mxloder.c's header file include section ]
// -------------------------------------------
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <dpmi.h>
#include <go32.h>
#include <libc.h>
#include <keys.h>
#include <pc.h>
#include <fcntl.h>
#include <errno.h>
#include <bios.h>
#include <unistd.h>
#include <sys/stat.h>
#include <process.h>

#define BITMASK1 (0x5C)
#define BITMASK2 (0x2F)

// ...Mxloder.c's Function Definition Section ...
void Err_Handler(int ER_FLG, char mxfile[16]);
void mem_check();

// ... Global Variables declaration Section ...
unsigned long int mouse_install = 0;
int video_mode = 0;
int Idel_lop = 1;


// ... Start of Mxloder Main Program ...
int main(int argc, char **argv)
{
   _go32_dpmi_registers r;
   int a, y, x;
   FILE *fp;
   int ERR_FLAG = 0;
   unsigned *scrn_buf = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);
   char prg_name[130];
   char prg_id[130];
   char home_dir[130];
   extern int viedo_mode;
   signed int prg_rt_code;
   char mx_main[ ] = "MICROX1.EXE 60785MX1 ";
   char mx_mainid[ ] = "60785MX1";
   char mx_lod_86[ ] = "MCSUB1.EXE 60786MX1";
   char mx_lod_86id[ ] = "60786MX1";
   char mx_lod_87[ ] = "MCSUB2.EXE 60787MX1";
   char mx_lod_87id[ ] = "60787MX1";
   char mx_lod_88[ ] = "MCSUB3.EXE 60788MX1";
   char mx_lod_88id[ ] = "60788MX1";
   char mx_lod_exit[ ] = "EXIT60785XMX1ACC";
   char subexit1[ ] = "SUBEXIT60786MX1ACC";
   char subexit2[ ] = "SUBEXIT60787MX1ACC";
   char subexit3[ ] = "SUBEXIT60788MX1ACC";
   char user_req[200];
   char corect_path[200];
   char *path_buf = (char*) alloca(200);
   char mxfile[16];
   char tmpset[164];
   int handle = 0;
   unsigned int result = 0;
   int ER_FLG = 0;
   int LocalScrn_y = 0;
   int LocalScrn_x = 0;
   int prg_rtrn_code = 0;
   int prg_zpass = 999;

   extern char **environ;
// .......
  _fmode = O_BINARY;
   fflush(stdout);
   fflush(stdin);
   a = 0;
   x = 0;
//........
    if (strlen(argv[1]) > 127)
    {
      ER_FLG = 2;
      Err_Handler(ER_FLG, mxfile);
      free(scrn_buf);
      exit(0);
   }
//........
   if (strlen(argv[1]) == NULL)
   {
     ER_FLG = 2;
     Err_Handler(ER_FLG, mxfile);
     free(scrn_buf);
     exit(0);
   }
//........
   if ((argc >= 4) || (argc == 0))
   {
     ER_FLG = 2;
     Err_Handler(ER_FLG, mxfile);
     free(scrn_buf);
     exit(0);
   }
// .......
   fp = fopen("accs.tmp", "w");
   fprintf(fp, "%s", argv[1]);
   fclose(fp);
   fp = fopen("accs.tmp", "r");
   fscanf(fp, "%s", home_dir);
   fclose(fp);
   remove("accs.tmp");
//........
   if (chdir(home_dir))
   {
     ER_FLG = 2;
     Err_Handler(ER_FLG, mxfile);
     perror(home_dir);
     free(scrn_buf);
     exit(0);
   }
// .......
   if(argv[2] != NULL)
   {
    fp = fopen("accs.tmp", "w");
    fprintf(fp, "%s", argv[2]);
    fclose(fp);
    fp = fopen("accs.tmp", "r");
    fscanf(fp, "%s", home_dir);
    fclose(fp);
    remove("accs.tmp");
    strcat(mx_main, home_dir);
   }
//........
   if (!__file_exists("MICROX1.EXE"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Microx1.exe");
     Err_Handler(ER_FLG, mxfile);
     free(scrn_buf);
     exit(0);
   }
//........
   if (!__file_exists("MCSUB1.EXE"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Mcsub1.exe");
     Err_Handler(ER_FLG, mxfile);
     free(scrn_buf);
     exit(0);
   }
//........
   if (!__file_exists("MCSUB2.EXE"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Mcsub2.exe");
     Err_Handler(ER_FLG, mxfile);
     free(scrn_buf);
     exit(0);
   }
//........
   if (!__file_exists("MCSUB3.EXE"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Mcsub3.exe");
     Err_Handler(ER_FLG, mxfile);
     free(scrn_buf);
     exit(0);
   }
//........
   if (!__file_exists("ACCSLNCH.DAT"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Accslnch.dat");
     Err_Handler(ER_FLG, mxfile);
     free(scrn_buf);
     exit(0);
   }
//........
   if (!__file_exists("ACCSD15.DAT"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Accsd15.dat");
     Err_Handler(ER_FLG, mxfile);
     free(scrn_buf);
     exit(0);
   }
//........
   if (!__file_exists("MXLHWS.COM"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Mxlhws.com");
     Err_Handler(ER_FLG, mxfile);
     free(scrn_buf);
     exit(0);
   }
// .... Main program INI startup ...
   video_mode = ScreenMode();
   LocalScrn_y = wherey();
   LocalScrn_x = wherex();
   ScreenRetrieve(scrn_buf);
   textmode(C80);
   gppconio_init();
   ScreenClear();
   ScreenSetCursor(0, 0);
   cprintf("Mxloder Version 3.2, Release (1a).   Designed By John F. Clark Jr.\n\r");
   cprintf("Control Program Loading For Micro-x Accessor System  Version 1.5.1 \n\r");
   cprintf("All Rights Reserved.                        ( Copy Right Pending )\n\r");
   cprintf("Date Revised :  November 2001.\n\r\n\r");
// ........
   strcpy(prg_name, mx_mainid);
// ........
// ........
   while (Idel_lop == 1)
   {
     chdir(home_dir);
     prg_rtrn_code = system("MXLHWS.COM");
     prg_rtrn_code = 0;
     if (strcmp(prg_name, mx_mainid) == 0)
     {
       cprintf("[Mxloder] - Program Loading In Process For\n\r");
       cprintf("Micro-x Main Accessor System Access ....\n\r\n\r");
       prg_rtrn_code = system(mx_main);
       if (prg_rtrn_code != 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("[Mxloder] - Report For Program Return.\n\r\n\r");
         cprintf("End of Program Run For .... Micro-x Main Accessor System Access ....\n\r\n\r");
         cprintf("!! ERROR !!  on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
         free(scrn_buf);
         return(0);
       }
       if (prg_rtrn_code == 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("[Mxloder] - Report For Program Return.\n\r\n\r");
         cprintf("End of Program Run For .... Micro-x Main Accessor System Access ....\n\r\n\r");
         cprintf("No Error on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
// ........
     }
     if (strcmp(prg_name, mx_lod_86id) == 0)
     {
       cprintf("[Mxloder] - Program Loading In Process For\n\r");
       cprintf("Micro-x Sub1 Accessor System Access ....\n\r\n\r");
       mem_check();
       prg_rtrn_code = system(mx_lod_86);
       if (prg_rtrn_code != 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("[Mxloder] - Report For Program Return.\n\r\n\r");
         cprintf("End of Program Run For ...\n\r");
         cprintf("Micro-x Sub1 Accessor System Access ....\n\r\n\r");
         cprintf("!! ERROR !!  on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
         free(scrn_buf);
         return(0);
       }
       if (prg_rtrn_code == 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("[Mxloder] - Report For Program Return.\n\r\n\r");
         cprintf("End of Program Run For ...\n\r");
         cprintf("Micro-x Sub1 Accessor System Access .......\n\r\n\r");
         cprintf("No Error on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
// ........
     }
// ........
     if (strcmp(prg_name, mx_lod_87id) == 0)
     {
       cprintf("[Mxloder] - Program Loading In Process For\n\r");
       cprintf("Micro-x Sub2 Accessor System Access .......\n\r\n\r");
       mem_check();
       prg_rtrn_code = system(mx_lod_87);
       if (prg_rtrn_code != 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("[Mxloder] - Report For Program Return.\n\r\n\r");
         cprintf("End of Program Run For ...\n\r");
         cprintf("Micro-x Sub2 Accessor System Access .......\n\r\n\r");
         cprintf("!! ERROR !!  on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
         free(scrn_buf);
         return(0);
       }
       if (prg_rtrn_code == 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("[Mxloder] - Report For Program Return.\n\r\n\r");
         cprintf("End of Program Run For ...\n\r");
         cprintf("Micro-x Sub2 Accessor System Access .......\n\r\n\r");
         cprintf("No Error on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
// ........
     }
// ........
     if (strcmp(prg_name, mx_lod_88id) == 0)
     {
       cprintf("[Mxloder] - Program Loading In Process For\n\r");
       cprintf("Micro-x Sub3 Accessor System Access .......\n\r\n\r");
       mem_check();
       prg_rtrn_code = system(mx_lod_88);
       if (prg_rtrn_code != 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("[Mxloder] - Report For Program Return.\n\r\n\r");
         cprintf("End of Program Run For ...\n\r");
         cprintf("Micro-x Sub3 Accessor System Access .......\n\r\n\r");
         cprintf("!! ERROR !!  on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
         free(scrn_buf);
         return(0);
       }
       if (prg_rtrn_code == 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("[Mxloder] - Report For Program Return.\n\r\n\r");
         cprintf("End of Program Run For ...\n\r");
         cprintf("Micro-x Sub3 Accessor System Access .......\n\r\n\r");
         cprintf("No Error on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
// ........
     }
// ..........
    if(!_dos_open("ACCSLNCH.DAT", O_RDONLY, &handle) )
    {
      if(_dos_read(handle, path_buf, 200, &result) != 0)
      {
        ER_FLG =  1;
        strcpy(mxfile, "Accslnch.dat");
        Err_Handler(ER_FLG, mxfile);
        free(scrn_buf);
        _dos_close(handle);
        exit(0);
      }
    }
    _dos_close(handle);
    x = 0;
    strcpy(user_req, path_buf + x);
    y = strlen(user_req);
    y -= 8;
    strncpy(prg_name, user_req + y, 8);
    user_req[y] = '\0';
    prg_name[8] = '\0';
// ........
     if (strncmp(user_req, mx_lod_exit, 16) == 0)
     {
        r.h.ah = 0x00;
        r.h.al = video_mode;
        r.x.ss = r.x.sp = 0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        ScreenUpdate(scrn_buf);
        free(scrn_buf);
        _setcursortype(_NORMALCURSOR);
        if (LocalScrn_y >= 25)
        {
           LocalScrn_y -= 1;
        }
        if (LocalScrn_x >= 80)
        {
          LocalScrn_x -= 1;
        }
        ScreenSetCursor(LocalScrn_y, LocalScrn_x);
        exit(0);
     }
// ........
     if (strncmp(user_req, subexit1, 18) == 0)
     {
        strcpy(prg_name, mx_mainid);
        prg_zpass = 0;
     }
// ........
     if (strncmp(user_req, subexit2, 18) == 0)
     {
        strcpy(prg_name, mx_mainid);
        prg_zpass = 0;
     }
// ........
     if (strncmp(user_req, subexit3, 18) == 0)
     {
        strcpy(prg_name, mx_mainid);
        prg_zpass = 0;
     }
// ........
// ........
     if (strncmp(user_req, mx_lod_86id, 18) == 0)
     {
        strcpy(prg_name, mx_lod_86id);
        prg_zpass = 0;
     }
// ........
     if (strncmp(user_req, mx_lod_87id, 18) == 0)
     {
        strcpy(prg_name, mx_lod_87id);
        prg_zpass = 0;
     }
// ........
     if (strncmp(user_req, mx_lod_88id, 18) == 0)
     {
        strcpy(prg_name, mx_lod_88id);
        prg_zpass = 0;
     }
// ........
// ........
     if (prg_zpass != 0)
     {
       strcpy(corect_path, user_req);
       x = 0;
       y = 0;
       x = strcspn(corect_path, ".");
       if(x != 0)
       {
        corect_path[x] = '\0';
       }
// ........
// ........
       y = strlen(corect_path);
       x = y;
       while(x != 0)
       {
        if(corect_path[y] == BITMASK1)
        {
         corect_path[y] = '\0';
         break;
        }
        if(corect_path[y] == BITMASK2)
        {
         corect_path[y] = '\0';
         break;
        }
        x -= 1;
        y -= 1;
       }
// ........
// .......
       cprintf("[Mxloder] - Program Loading In Process For\n\r");
       cprintf("%s\n\r\n\r", user_req);
       chdir(home_dir);
       prg_rtrn_code = system("MXLHWS.COM");
       prg_rtrn_code = 0;
       mem_check();
       chdir(corect_path);
       prg_rtrn_code = system(user_req);
       cprintf("------------------------------------------------------------------------\n\r\n\r");
// ........
       if (prg_rtrn_code != 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("[Mxloder] - Report For Program Return.\n\r\n\r");
         cprintf("End of Program Run For ...\n\r");
         cprintf("%s\n\r\n\r", user_req);
         cprintf("!! ERROR !!  on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
// ........
       if (prg_rtrn_code == 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("[Mxloder] - Report For Program Return.\n\r\n\r");
         cprintf("End of Program Run For ...\n\r");
         cprintf("%s\n\r\n\r", user_req);
         cprintf("No Error on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
     }
     prg_zpass = 999;
   }
   ScreenSetCursor(LocalScrn_y, LocalScrn_x);
   return(0);
}

// ... Memory Status Function .....
void mem_check()
{
   extern __Go32_Info_Block _go32_info_block;

  _go32_dpmi_meminfo info;
  _go32_dpmi_get_free_memory_information(&info);
  cprintf("___System's Memory Status____ \n\r");
  cprintf("Total Physical Memory = %x\n\r",info.total_physical_pages);
  cprintf("Available Memory = %x\n\r",info.available_memory * 4096);
  cprintf("Linear Space = %x\n\r",info.linear_space);
  cprintf("Available Pages = %x\n\r",info.available_pages);
  cprintf("Available Physical Pages = %x\n\r",info.available_physical_pages);
  cprintf("Available Lockable Pages = %x\n\r",info.available_lockable_pages);
  cprintf("Max Pages In Paging File = %x\n\r\n\r",info.max_pages_in_paging_file);
  return;
}

// ... Error Message Handler Function ...
void Err_Handler(int ER_FLG, char mxfile[16])
{
    unsigned *saved_scrn = (unsigned *)malloc(ScreenRows()*ScreenCols()*2);

    if(ER_FLG == 1)
    {
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Mxloder Version 3.2, Release (1a). Designed By John F. Clark Jr.\n\r\n\r");
        cprintf("File ... !!!  Error  !!! ... in Mxloder Accessor System Start Up Program.\n\r");
        cprintf("Check the Micro-x Files and Directory, and ensure they are correct.\n\r");
        cprintf("Read the Micro-x.doc File for more detailed information ....\n\r");
        cprintf("Cannot find the File ... %s\n\r\n\r", mxfile);
        cprintf("Strike any key to continue ....\n\r");
        while(!kbhit())
        {
        }
        free(saved_scrn);
        return;
    }
//........
    if(ER_FLG == 2)
    {
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Mxloder Version 3.2, Release (1a). Designed By John F. Clark Jr.\n\r\n\r");
        cprintf("!! Error !! ... in Mxloder Accessor System Start Up Program.\n\r");
        cprintf("Invalid Command Line Paramerters ......\n\r");
        free(saved_scrn);
        return;
    }
}

//*************************************************************
//*************************************************************
// ... End of Program for Mxloder.c Accessor System Loader ...
//*************************************************************
