/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Uses_TResourceFile
#define Uses_TStreamable
#define Uses_fpstream

#define Uses_TRect
#define Uses_TKeys
#define Uses_RawKeys
#define Uses_IDEConst

#define Uses_TFlagCollection
#define Uses_TFlagEntry

#define Uses_TEditor
#define Uses_TProject
#define Uses_TOptions
#define Uses_TStringCollection
#define Uses_IDEConst
#define Uses_TStreamableClass

#define Uses_TResourceCollection
#define Uses_TLabel
#define Uses_TButton

#define Uses_TProgram

#define Uses_TDirListBox
#define Uses_TIDEEditWindow
#define Uses_TFileList
#define Uses_MsgBox
#define Uses_TChDirDialog
#define Uses_TFileDialog
#define Uses_TFileInfoPane
#define Uses_LangTexte

#include <libide.h>

#define Uses_TSCollection
#include <libtvuti.h>

#include <rhide.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

__link ( RResourceCollection )
__link ( RSCollection )

#ifndef ORIG_NAMES

  #define N(w,n)\
    const char * const w::name = #n;
  N(TSCollection,\xFD)
  N(TResourceCollection,\xFC)
  N(TButton,\xF5)
  N(TLabel,\xF4)

#endif

static TResourceFile *resource = NULL;
static TResourceFile *common_dlg = NULL;
char *lang_ext = NULL;

static void * GetResource(const char *key,int common = 0)
{
  if (common) return common_dlg->get(key);
  else return resource->get(key);
}

void SaveScreen();

static ushort default_lang,default_lang_new;
static char *dlg_name = NULL;

static Boolean OpenResource()
{
  fpstream *ifp;
  char lang[4];
  uint32 common_pos,pos;
  ushort lang_count;
  int handle,handle1;
  handle = -1;
  if (getenv("RHIDEDLG") != NULL)
  {
    string_dup(dlg_name,getenv("RHIDEDLG"));
    handle = open(dlg_name,O_RDONLY | O_BINARY);
    if (handle <= 0) string_free(dlg_name);
  }
  if (handle <= 0)
  {
    string_dup(dlg_name,RHIDE_DIR);
    string_cat(dlg_name,RHIDE_NAME);
    string_cat(dlg_name,".dlg");
    handle = open(dlg_name,O_RDONLY | O_BINARY);
  }
  if (handle <= 0)
  {
    string_free(dlg_name);
    string_dup(dlg_name,RHIDE_DIR);
    string_cat(dlg_name,"rhide.dlg");
    handle = open(dlg_name,O_RDONLY | O_BINARY);
    if (handle <= 0)
    {
      string_free(dlg_name);
      if (getenv("DJDIR") == NULL)
      {
        return False;
      }
      string_dup(dlg_name,getenv("DJDIR"));
      string_cat(dlg_name,"/bin/rhide.dlg");
      handle = open(dlg_name,O_RDONLY | O_BINARY);
      if (handle <= 0)
      {
        string_free(dlg_name);
        return False;
      }
    }
  }
  handle1 = open(dlg_name,O_RDONLY | O_BINARY);
  ifp = new fpstream(handle1);
  *ifp >> lang_count >> default_lang;
  default_lang_new = default_lang;
  ifp->readBytes(lang,4);
  *ifp >> common_pos;
  ifp->seekg(common_pos,ios::beg); 
  common_dlg = new TResourceFile(ifp);
  ifp->seekg(12,ios::beg);
  if (!lang_ext && getenv("RHIDELANG") != NULL)
    string_dup(lang_ext,getenv("RHIDELANG"));
  if (lang_ext)
  {
    int found = 0;
    default_lang_new = 0;
    while (lang_count--)
    {
      ifp->readBytes(lang,4);
      *ifp >> pos;
      if (stricmp(lang,lang_ext) == 0)
      {
        found = 1;
        break;
      }
      default_lang_new++;
    }
    if (!found)
    {
      fprintf(stderr,"%s: language (%s) is not supported\n",RHIDE_NAME,lang_ext);
      default_lang_new = default_lang;
      ifp->seekg(12+default_lang*8);
      ifp->readBytes(lang,4);
      fprintf(stderr," using [%s] as default\n",lang);
      SaveScreen();
      string_free(lang_ext);
    }
  }
  ifp->seekg(16+default_lang_new*8,ios::beg);
  *ifp >> pos;
  ifp = new fpstream(handle);
  ifp->seekg(pos,ios::beg);
  resource = new TResourceFile(ifp);
  return True;
}

void CloseResource()
{
  destroy(resource);
  destroy(common_dlg);
  if (default_lang != default_lang_new)
  {
    int handle = open(dlg_name,O_RDWR | O_BINARY);
    if (handle > 0)
    {
      lseek(handle,2,SEEK_SET);
      write(handle,&default_lang_new,sizeof(default_lang_new));
      close(handle);
    }
    else
    {
      fprintf(stderr,"Could not update the default language in %s\n",dlg_name);
    }
  }
  string_free(dlg_name);
}

Boolean InitResource()
{
  if (OpenResource() == False) return False;
  return True;
}

#define df(name) return (TFlagCollection *)GetResource(name,1)

TFlagCollection * GetOptFlags()
{
  df("OptFlags");
}

TFlagCollection * GetDebugFlags()
{
  df("DebugFlags");
}

TFlagCollection * GetWarnFlags()
{
  df("WarnFlags");
}

TFlagCollection * GetCXXFlags()
{
  df("CXXFlags");
}

TFlagCollection * GetCFlags()
{
  df("CFlags");
}

TStringCollection *GetReservedWords()
{
  return (TStringCollection *)GetResource("ReservedWords",1);
}


