#include <stdio.h>
#include <limits.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <dos.h>

char actual[PATH_MAX];
char diffs[PATH_MAX];

void ConvertTimeToFTime(time_t t,struct ftime *ft)
{
 char buf[80];
 struct tm *p;

 p=gmtime(&t);
 ft->ft_tsec  = p->tm_sec;
 ft->ft_min  = p->tm_min;
 ft->ft_hour = p->tm_hour;
 ft->ft_day  = p->tm_mday;
 ft->ft_month= p->tm_mon+1;
 ft->ft_year = p->tm_year-80;
}

void CopyFile(char *dest, char *ori, time_t time)
{
 char b[PATH_MAX],*s=dest,*d=b,c;
 struct stat st;
 FILE *o,*de;
 struct ftime ft;

 do
   {
    for (;*s && *s!='/'; s++,d++) *d=*s;
    if (*s=='/')
      {
       *d=0;
       if (stat(b,&st))
         { // No existe
          if (mkdir(b,S_IWUSR))
            {
             printf("No puedo crear el directorio %s\n",b);
             exit(1);
            }
         }
       else
         if (!S_ISDIR(st.st_mode))
           {
            printf("No es directorio! %s\n",dest);
            exit(1);
           }
       *d='/';
       d++;
       s++;
      }
   }
 while (*s);
 o=fopen(ori,"rb");
 if (!o)
   {
    printf("No puedo abrir: %s\n",ori);
    exit(1);
   }
 de=fopen(dest,"wb");
 if (!de)
   {
    printf("No crear abrir: %s\n",dest);
    exit(1);
   }
 while (!feof(o))
   {
    c=fgetc(o);
    if (!feof(o))
       fputc(c,de);
   }
 fclose(o);
 fclose(de);
 de=fopen(dest,"rb");
 ConvertTimeToFTime(time,&ft);
 setftime(fileno(de),&ft);
 fclose(de);
}

int main(int argc, char *argv[])
{
 int i,isbin;
 struct stat st,st2;
 char *difbase,*oldbase,*original,*nuevavers;

 printf("Diff maker Copyright (c) 1997 by SET\n\n");
 printf("Nombre: %s\n",argv[0]);
 printf("Base viejo: %s\n",argv[1]);
 oldbase=argv[1];
 printf("Base diffs: %s\n",argv[2]);
 difbase=argv[2];
 printf("Nueva version: %s\n",argv[3]);
 nuevavers=argv[3];

 sprintf(actual,"%srest.dif",difbase);
 unlink(actual);
 for (i=4; i<argc; i++)
    {
     original=argv[i];
     if (*original=='-')
       {
        isbin=1;
        original++;
       }
     else
        isbin=0;
     printf("Chequeando: %s ",original);
     if (isbin)
        printf("(binary) ");
     if (stat(original,&st))
       { // No existe
        printf("\nNo exite el fuente: %s\n",original);
        return 1;
       }
     else
       {
        strcpy(diffs,oldbase);
        strcat(diffs,original);
        if (stat(diffs,&st2))
          { // No exite el viejo
           printf("---> copying ");
           strcpy(diffs,difbase);
           strcat(diffs,original);
           CopyFile(diffs,original,st.st_ctime);
          }
        else
          {
           if (st.st_ctime!=st2.st_ctime)
             {
              if (isbin)
                {
                 printf("---> copying ");
                 strcpy(diffs,difbase);
                 strcat(diffs,original);
                 CopyFile(diffs,original,st.st_ctime);
                }
              else
                {
                 printf("---> diff ");
                 sprintf(actual,"diff -u %s%s %s >> %srest.dif",oldbase,original,original,difbase);
                 system(actual);
                 /*if (system(actual))
                   {
                    printf("No pude ejecutar: %s\n",actual);
                    return 1;
                   }*/
                }
             }
           else
              printf("Ok ");
          }
       }
     strcpy(diffs,nuevavers);
     strcat(diffs,original);
     CopyFile(diffs,original,st.st_ctime);
     printf("[copied]");
     printf("\n");
    }
 return 0;
}
