@17140@
@13830@
@13245@
@13635@
@13440@
@13245@

Modified by Robert Hhne to be used for RHIDE.

@13245@
@13245@
@14024@

@14828@
@14852@
@14567@
@14141@
@16849@
@16751@
@16727@
@16745@

TRangeValidator::TRangeValidator() : TFilterValidator("0123456789-+")
@23372@
  Min = LONG_MIN;
  Max = LONG_MAX;
@24151@

TRangeValidator::TRangeValidator(long aMin,long aMax) :
  TFilterValidator("xX0123456789+-")
@23372@
  Min = aMin;
  Max = aMax;
  if (Min >= 0) strcpy(ValidChars,"xX0123456789+");
  if (Min < 0 && Max < 0) strcpy(ValidChars,"xX0123456789-");
@24151@

void TRangeValidator::Error()
@23372@
  if (Min >= 0)
    messageBox(mfError|mfOKButton,_("Value not in the range %uld to %uld"),
               (unsigned long)Min,(unsigned long)Max);
@12774@
    messageBox(mfError|mfOKButton,_("Value not in the range %ld to %ld"),
               Min,Max);
@24151@

static long get_val(const char *buf)
@23372@
  long val;
  if (buf[0] == '0')
@12966@
    if (buf[1] == 'x' || buf[1] == 'X')
      sscanf(buf+2, "%lx", &val);
@07986@
      sscanf(buf, "%lo", &val);
@12978@
@12774@
    sscanf(buf, "%ld", &val);
  return val;
@24151@

static unsigned long get_uval(const char *buf)
@23372@
  unsigned long val;
  if (buf[0] == '0')
@12966@
    if (buf[1] == 'x' || buf[1] == 'X')
      sscanf(buf+2, "%lux", &val);
@07986@
      sscanf(buf, "%luo", &val);
@12978@
@12774@
    sscanf(buf, "%lud", &val);
  return val;
@24151@


Boolean TRangeValidator::IsValid(const char *S)
@23372@
@12840@
  if (TFilterValidator::IsValid(S) == False) return False;
  if (Min >= 0)
    value = get_uval(S);
@12774@
    value = get_val(S);
  if (Min >= 0)
@12966@
    if ((unsigned long)value < (unsigned long)Min ||
        (unsigned long)value > (unsigned long)Max)
      return False;
@12978@
@12774@
@12966@
    if (value < Min || value > Max) return False;
@12978@
@12886@
@24151@

ushort TRangeValidator::Transfer(char *S,void * Buffer,
  TVTransfer Flag)
@23372@
  if (!(Options & voTransfer)) return 0;
  switch (Flag)
@12966@
@07490@
      if (Min >= 0)
        *((unsigned long *)Buffer) = get_uval(S);
@06123@
        *((long *)Buffer) = get_val(S);
      break;
@07491@
      if (Min >= 0)
        sprintf(S,"%lu",*((unsigned long *)Buffer));
@06123@
        sprintf(S,"%ld",*((long *)Buffer));
      break;
    default:
      break;
@12978@
  return sizeof(long);
@24151@

#if !defined( NO_STREAM )
TRangeValidator::TRangeValidator(StreamableInit) :
  TFilterValidator(streamableInit)
@23372@
@24151@

TStreamable * TRangeValidator::build()
@23372@
  return (TStreamable *) new TRangeValidator(streamableInit);
@24151@

void TRangeValidator::write(opstream & os)
@23372@
  TFilterValidator::write(os);
  os << Min << Max;
@24151@

void * TRangeValidator::read(ipstream & is)
@23372@
  TFilterValidator::read(is);
  is >> Min >> Max;
@12904@
@24151@
#endif // NO_STREAM

