This is doc/cpp.info, produced by makeinfo version 4.2 from
doc/cpp.texi.

INFO-DIR-SECTION Programming
START-INFO-DIR-ENTRY
* Cpp: (cpp).		       The GNU C preprocessor.
END-INFO-DIR-ENTRY


File: cpp.info,  Node: If,  Next: Defined,  Prev: Ifdef,  Up: Conditional Syntax

If
--

   The `#if' directive allows you to test the value of an arithmetic
expression, rather than the mere existence of one macro.  Its syntax is

     #if EXPRESSION
     
     CONTROLLED TEXT
     
     #endif /* EXPRESSION */

   EXPRESSION is a C expression of integer type, subject to stringent
restrictions.  It may contain

   * Integer constants.

   * Character constants, which are interpreted as they would be in
     normal code.

   * Arithmetic operators for addition, subtraction, multiplication,
     division, bitwise operations, shifts, comparisons, and logical
     operations (`&&' and `||').  The latter two obey the usual
     short-circuiting rules of standard C.

   * Macros.  All macros in the expression are expanded before actual
     computation of the expression's value begins.

   * Uses of the `defined' operator, which lets you check whether macros
     are defined in the middle of an `#if'.

   * Identifiers that are not macros, which are all considered to be the
     number zero.  This allows you to write `#if MACRO' instead of
     `#ifdef MACRO', if you know that MACRO, when defined, will always
     have a nonzero value.  Function-like macros used without their
     function call parentheses are also treated as zero.

     In some contexts this shortcut is undesirable.  The `-Wundef'
     option causes GCC to warn whenever it encounters an identifier
     which is not a macro in an `#if'.

   The preprocessor does not know anything about types in the language.
Therefore, `sizeof' operators are not recognized in `#if', and neither
are `enum' constants.  They will be taken as identifiers which are not
macros, and replaced by zero.  In the case of `sizeof', this is likely
to cause the expression to be invalid.

   The preprocessor calculates the value of EXPRESSION.  It carries out
all calculations in the widest integer type known to the compiler; on
most machines supported by GCC this is 64 bits.  This is not the same
rule as the compiler uses to calculate the value of a constant
expression, and may give different results in some cases.  If the value
comes out to be nonzero, the `#if' succeeds and the CONTROLLED TEXT is
included; otherwise it is skipped.

   If EXPRESSION is not correctly formed, GCC issues an error and
treats the conditional as having failed.


File: cpp.info,  Node: Defined,  Next: Else,  Prev: If,  Up: Conditional Syntax

Defined
-------

   The special operator `defined' is used in `#if' and `#elif'
expressions to test whether a certain name is defined as a macro.
`defined NAME' and `defined (NAME)' are both expressions whose value is
1 if NAME is defined as a macro at the current point in the program,
and 0 otherwise.  Thus,  `#if defined MACRO' is precisely equivalent to
`#ifdef MACRO'.

   `defined' is useful when you wish to test more than one macro for
existence at once.  For example,

     #if defined (__vax__) || defined (__ns16000__)

would succeed if either of the names `__vax__' or `__ns16000__' is
defined as a macro.

   Conditionals written like this:

     #if defined BUFSIZE && BUFSIZE >= 1024

can generally be simplified to just `#if BUFSIZE >= 1024', since if
`BUFSIZE' is not defined, it will be interpreted as having the value
zero.

   If the `defined' operator appears as a result of a macro expansion,
the C standard says the behavior is undefined.  GNU cpp treats it as a
genuine `defined' operator and evaluates it normally.  It will warn
wherever your code uses this feature if you use the command-line option
`-pedantic', since other compilers may handle it differently.


File: cpp.info,  Node: Else,  Next: Elif,  Prev: Defined,  Up: Conditional Syntax

Else
----

   The `#else' directive can be added to a conditional to provide
alternative text to be used if the condition fails.  This is what it
looks like:

     #if EXPRESSION
     TEXT-IF-TRUE
     #else /* Not EXPRESSION */
     TEXT-IF-FALSE
     #endif /* Not EXPRESSION */

If EXPRESSION is nonzero, the TEXT-IF-TRUE is included and the
TEXT-IF-FALSE is skipped.  If EXPRESSION is zero, the opposite happens.

   You can use `#else' with `#ifdef' and `#ifndef', too.


File: cpp.info,  Node: Elif,  Prev: Else,  Up: Conditional Syntax

Elif
----

   One common case of nested conditionals is used to check for more
than two possible alternatives.  For example, you might have

     #if X == 1
     ...
     #else /* X != 1 */
     #if X == 2
     ...
     #else /* X != 2 */
     ...
     #endif /* X != 2 */
     #endif /* X != 1 */

   Another conditional directive, `#elif', allows this to be
abbreviated as follows:

     #if X == 1
     ...
     #elif X == 2
     ...
     #else /* X != 2 and X != 1*/
     ...
     #endif /* X != 2 and X != 1*/

   `#elif' stands for "else if".  Like `#else', it goes in the middle
of a conditional group and subdivides it; it does not require a
matching `#endif' of its own.  Like `#if', the `#elif' directive
includes an expression to be tested.  The text following the `#elif' is
processed only if the original `#if'-condition failed and the `#elif'
condition succeeds.

   More than one `#elif' can go in the same conditional group.  Then
the text after each `#elif' is processed only if the `#elif' condition
succeeds after the original `#if' and all previous `#elif' directives
within it have failed.

   `#else' is allowed after any number of `#elif' directives, but
`#elif' may not follow `#else'.


File: cpp.info,  Node: Deleted Code,  Prev: Conditional Syntax,  Up: Conditionals

Deleted Code
============

   If you replace or delete a part of the program but want to keep the
old code around for future reference, you often cannot simply comment it
out.  Block comments do not nest, so the first comment inside the old
code will end the commenting-out.  The probable result is a flood of
syntax errors.

   One way to avoid this problem is to use an always-false conditional
instead.  For instance, put `#if 0' before the deleted code and
`#endif' after it.  This works even if the code being turned off
contains conditionals, but they must be entire conditionals (balanced
`#if' and `#endif').

   Some people use `#ifdef notdef' instead.  This is risky, because
`notdef' might be accidentally defined as a macro, and then the
conditional would succeed.  `#if 0' can be counted on to fail.

   Do not use `#if 0' for comments which are not C code.  Use a real
comment, instead.  The interior of `#if 0' must consist of complete
tokens; in particular, single-quote characters must balance.  Comments
often contain unbalanced single-quote characters (known in English as
apostrophes).  These confuse `#if 0'.  They don't confuse `/*'.


File: cpp.info,  Node: Diagnostics,  Next: Line Control,  Prev: Conditionals,  Up: Top

Diagnostics
***********

   The directive `#error' causes the preprocessor to report a fatal
error.  The tokens forming the rest of the line following `#error' are
used as the error message.

   You would use `#error' inside of a conditional that detects a
combination of parameters which you know the program does not properly
support.  For example, if you know that the program will not run
properly on a VAX, you might write

     #ifdef __vax__
     #error "Won't work on VAXen.  See comments at get_last_object."
     #endif

   If you have several configuration parameters that must be set up by
the installation in a consistent way, you can use conditionals to detect
an inconsistency and report it with `#error'.  For example,

     #if !defined(UNALIGNED_INT_ASM_OP) && defined(DWARF2_DEBUGGING_INFO)
     #error "DWARF2_DEBUGGING_INFO requires UNALIGNED_INT_ASM_OP."
     #endif

   The directive `#warning' is like `#error', but causes the
preprocessor to issue a warning and continue preprocessing.  The tokens
following `#warning' are used as the warning message.

   You might use `#warning' in obsolete header files, with a message
directing the user to the header file which should be used instead.

   Neither `#error' nor `#warning' macro-expands its argument.
Internal whitespace sequences are each replaced with a single space.
The line must consist of complete tokens.  It is wisest to make the
argument of these directives be a single string constant; this avoids
problems with apostrophes and the like.


File: cpp.info,  Node: Line Control,  Next: Pragmas,  Prev: Diagnostics,  Up: Top

Line Control
************

   The C preprocessor informs the C compiler of the location in your
source code where each token came from.  Presently, this is just the
file name and line number.  All the tokens resulting from macro
expansion are reported as having appeared on the line of the source
file where the outermost macro was used.  We intend to be more accurate
in the future.

   If you write a program which generates source code, such as the
`bison' parser generator, you may want to adjust the preprocessor's
notion of the current file name and line number by hand.  Parts of the
output from `bison' are generated from scratch, other parts come from a
standard parser file.  The rest are copied verbatim from `bison''s
input.  You would like compiler error messages and symbolic debuggers
to be able to refer to `bison''s input file.

   `bison' or any such program can arrange this by writing `#line'
directives into the output file.  `#line' is a directive that specifies
the original line number and source file name for subsequent input in
the current preprocessor input file.  `#line' has three variants:

`#line LINENUM'
     LINENUM is a non-negative decimal integer constant.  It specifies
     the line number which should be reported for the following line of
     input.  Subsequent lines are counted from LINENUM.

`#line LINENUM FILENAME'
     LINENUM is the same as for the first form, and has the same
     effect.  In addition, FILENAME is a string constant.  The
     following line and all subsequent lines are reported to come from
     the file it specifies, until something else happens to change that.
     FILENAME is interpreted according to the normal rules for a string
     constant: backslash escapes are interpreted.  This is different
     from `#include'.

     Previous versions of GNU CPP did not interpret escapes in `#line';
     we have changed it because the standard requires they be
     interpreted, and most other compilers do.

`#line ANYTHING ELSE'
     ANYTHING ELSE is checked for macro calls, which are expanded.  The
     result should match one of the above two forms.

   `#line' directives alter the results of the `__FILE__' and
`__LINE__' predefined macros from that point on.  *Note Standard
Predefined Macros::.  They do not have any effect on `#include''s idea
of the directory containing the current file.  This is a change from
GCC 2.95.  Previously, a file reading

     #line 1 "../src/gram.y"
     #include "gram.h"

   would search for `gram.h' in `../src', then the `-I' chain; the
directory containing the physical source file would not be searched.
In GCC 3.0 and later, the `#include' is not affected by the presence of
a `#line' referring to a different directory.

   We made this change because the old behavior caused problems when
generated source files were transported between machines.  For instance,
it is common practice to ship generated parsers with a source release,
so that people building the distribution do not need to have yacc or
Bison installed.  These files frequently have `#line' directives
referring to the directory tree of the system where the distribution was
created.  If GCC tries to search for headers in those directories, the
build is likely to fail.

   The new behavior can cause failures too, if the generated file is not
in the same directory as its source and it attempts to include a header
which would be visible searching from the directory containing the
source file.  However, this problem is easily solved with an additional
`-I' switch on the command line.  The failures caused by the old
semantics could sometimes be corrected only by editing the generated
files, which is difficult and error-prone.


File: cpp.info,  Node: Pragmas,  Next: Other Directives,  Prev: Line Control,  Up: Top

Pragmas
*******

   The `#pragma' directive is the method specified by the C standard
for providing additional information to the compiler, beyond what is
conveyed in the language itself.  Three forms of this directive
(commonly known as "pragmas") are specified by the 1999 C standard.  A
C compiler is free to attach any meaning it likes to other pragmas.

   GCC has historically preferred to use extensions to the syntax of the
language, such as `__attribute__', for this purpose.  However, GCC does
define a few pragmas of its own.  These mostly have effects on the
entire translation unit or source file.

   In GCC version 3, all GNU-defined, supported pragmas have been given
a `GCC' prefix.  This is in line with the `STDC' prefix on all pragmas
defined by C99.  For backward compatibility, pragmas which were
recognized by previous versions are still recognized without the `GCC'
prefix, but that usage is deprecated.  Some older pragmas are
deprecated in their entirety.  They are not recognized with the `GCC'
prefix.  *Note Obsolete Features::.

   C99 introduces the `_Pragma' operator.  This feature addresses a
major problem with `#pragma': being a directive, it cannot be produced
as the result of macro expansion.  `_Pragma' is an operator, much like
`sizeof' or `defined', and can be embedded in a macro.

   Its syntax is `_Pragma (STRING-LITERAL)', where STRING-LITERAL can
be either a normal or wide-character string literal.  It is
destringized, by replacing all `\\' with a single `\' and all `\"' with
a `"'.  The result is then processed as if it had appeared as the right
hand side of a `#pragma' directive.  For example,

     _Pragma ("GCC dependency \"parse.y\"")

has the same effect as `#pragma GCC dependency "parse.y"'.  The same
effect could be achieved using macros, for example

     #define DO_PRAGMA(x) _Pragma (#x)
     DO_PRAGMA (GCC dependency "parse.y")

   The standard is unclear on where a `_Pragma' operator can appear.
The preprocessor does not accept it within a preprocessing conditional
directive like `#if'.  To be safe, you are probably best keeping it out
of directives other than `#define', and putting it on a line of its own.

   This manual documents the pragmas which are meaningful to the
preprocessor itself.  Other pragmas are meaningful to the C or C++
compilers.  They are documented in the GCC manual.

`#pragma GCC dependency'
     `#pragma GCC dependency' allows you to check the relative dates of
     the current file and another file.  If the other file is more
     recent than the current file, a warning is issued.  This is useful
     if the current file is derived from the other file, and should be
     regenerated.  The other file is searched for using the normal
     include search path.  Optional trailing text can be used to give
     more information in the warning message.

          #pragma GCC dependency "parse.y"
          #pragma GCC dependency "/usr/include/time.h" rerun fixincludes

`#pragma GCC poison'
     Sometimes, there is an identifier that you want to remove
     completely from your program, and make sure that it never creeps
     back in.  To enforce this, you can "poison" the identifier with
     this pragma.  `#pragma GCC poison' is followed by a list of
     identifiers to poison.  If any of those identifiers appears
     anywhere in the source after the directive, it is a hard error.
     For example,

          #pragma GCC poison printf sprintf fprintf
          sprintf(some_string, "hello");

     will produce an error.

     If a poisoned identifier appears as part of the expansion of a
     macro which was defined before the identifier was poisoned, it
     will _not_ cause an error.  This lets you poison an identifier
     without worrying about system headers defining macros that use it.

     For example,

          #define strrchr rindex
          #pragma GCC poison rindex
          strrchr(some_string, 'h');

     will not produce an error.

`#pragma GCC system_header'
     This pragma takes no arguments.  It causes the rest of the code in
     the current file to be treated as if it came from a system header.
     *Note System Headers::.


File: cpp.info,  Node: Other Directives,  Next: Preprocessor Output,  Prev: Pragmas,  Up: Top

Other Directives
****************

   The `#ident' directive takes one argument, a string constant.  On
some systems, that string constant is copied into a special segment of
the object file.  On other systems, the directive is ignored.

   This directive is not part of the C standard, but it is not an
official GNU extension either.  We believe it came from System V.

   The `#sccs' directive is recognized on some systems, because it
appears in their header files.  It is a very old, obscure, extension
which we did not invent, and we have been unable to find any
documentation of what it should do, so GCC simply ignores it.

   The "null directive" consists of a `#' followed by a newline, with
only whitespace (including comments) in between.  A null directive is
understood as a preprocessing directive but has no effect on the
preprocessor output.  The primary significance of the existence of the
null directive is that an input line consisting of just a `#' will
produce no output, rather than a line of output containing just a `#'.
Supposedly some old C programs contain such lines.


File: cpp.info,  Node: Preprocessor Output,  Next: Traditional Mode,  Prev: Other Directives,  Up: Top

Preprocessor Output
*******************

   When the C preprocessor is used with the C, C++, or Objective-C
compilers, it is integrated into the compiler and communicates a stream
of binary tokens directly to the compiler's parser.  However, it can
also be used in the more conventional standalone mode, where it produces
textual output.

   The output from the C preprocessor looks much like the input, except
that all preprocessing directive lines have been replaced with blank
lines and all comments with spaces.  Long runs of blank lines are
discarded.

   The ISO standard specifies that it is implementation defined whether
a preprocessor preserves whitespace between tokens, or replaces it with
e.g. a single space.  In GNU CPP, whitespace between tokens is collapsed
to become a single space, with the exception that the first token on a
non-directive line is preceded with sufficient spaces that it appears in
the same column in the preprocessed output that it appeared in the
original source file.  This is so the output is easy to read.  *Note
Differences from previous versions::.  CPP does not insert any
whitespace where there was none in the original source, except where
necessary to prevent an accidental token paste.

   Source file name and line number information is conveyed by lines of
the form

     # LINENUM FILENAME FLAGS

These are called "linemarkers".  They are inserted as needed into the
output (but never within a string or character constant).  They mean
that the following line originated in file FILENAME at line LINENUM.
FILENAME will never contain any non-printing characters; they are
replaced with octal escape sequences.

   After the file name comes zero or more flags, which are `1', `2',
`3', or `4'.  If there are multiple flags, spaces separate them.  Here
is what the flags mean:

`1'
     This indicates the start of a new file.

`2'
     This indicates returning to a file (after having included another
     file).

`3'
     This indicates that the following text comes from a system header
     file, so certain warnings should be suppressed.

`4'
     This indicates that the following text should be treated as being
     wrapped in an implicit `extern "C"' block.

   As an extension, the preprocessor accepts linemarkers in
non-assembler input files.  They are treated like the corresponding
`#line' directive, (*note Line Control::), except that trailing flags
are permitted, and are interpreted with the meanings described above.
If multiple flags are given, they must be in ascending order.

   Some directives may be duplicated in the output of the preprocessor.
These are `#ident' (always), `#pragma' (only if the preprocessor does
not handle the pragma itself), and `#define' and `#undef' (with certain
debugging options).  If this happens, the `#' of the directive will
always be in the first column, and there will be no space between the
`#' and the directive name.  If macro expansion happens to generate
tokens which might be mistaken for a duplicated directive, a space will
be inserted between the `#' and the directive name.


File: cpp.info,  Node: Traditional Mode,  Next: Implementation Details,  Prev: Preprocessor Output,  Up: Top

Traditional Mode
****************

   Traditional (pre-standard) C preprocessing is rather different from
the preprocessing specified by the standard.  When GCC is given the
`-traditional' option, it attempts to emulate a traditional
preprocessor.  We do not guarantee that GCC's behavior under
`-traditional' matches any pre-standard preprocessor exactly.

   Traditional mode exists only for backward compatibility.  We have no
plans to augment it in any way nor will we change it except to fix
catastrophic bugs.  You should be aware that modern C libraries often
have header files which are incompatible with traditional mode.

   This is a list of the differences.  It may not be complete, and may
not correspond exactly to the behavior of either GCC or a true
traditional preprocessor.

   * Traditional macro expansion pays no attention to single-quote or
     double-quote characters; macro argument symbols are replaced by the
     argument values even when they appear within apparent string or
     character constants.

   * Traditionally, it is permissible for a macro expansion to end in
     the middle of a string or character constant.  The constant
     continues into the text surrounding the macro call.

   * However, the end of the line terminates a string or character
     constant, with no error.  (This is a kluge.  Traditional mode is
     commonly used to preprocess things which are not C, and have a
     different comment syntax.  Single apostrophes often appear in
     comments.  This kluge prevents the traditional preprocessor from
     issuing errors on such comments.)

   * Preprocessing directives are recognized in traditional C only when
     their leading `#' appears in the first column.  There can be no
     whitespace between the beginning of the line and the `#'.

   * In traditional C, a comment is equivalent to no text at all.  (In
     ISO C, a comment counts as whitespace.)  It can be used sort of
     the same way that `##' is used in ISO C, to paste macro arguments
     together.

   * Traditional C does not have the concept of a preprocessing number.

   * A macro is not suppressed within its own definition, in
     traditional C.  Thus, any macro that is used recursively
     inevitably causes an error.

   * The `#' and `##' operators are not available in traditional C.

   * In traditional C, the text at the end of a macro expansion can run
     together with the text after the macro call, to produce a single
     token.  This is impossible in ISO C.

   * None of the GNU extensions to the preprocessor are available in
     traditional mode, with the exception of a partial implementation of
     assertions, and those may be removed in the future.

   * A true traditional C preprocessor does not recognize `#elif',
     `#error', or `#pragma'.  GCC supports `#elif' and `#error' even in
     traditional mode, but not `#pragma'.

   * Traditional mode is text-based, not token-based, and comments are
     stripped after macro expansion.  Therefore, `/**/' can be used to
     paste tokens together provided that there is no whitespace between
     it and the tokens to be pasted.

   * Traditional mode preserves the amount and form of whitespace
     provided by the user.  Hard tabs remain hard tabs.  This can be
     useful, e.g. if you are preprocessing a Makefile (which we do not
     encourage).

   You can request warnings about features that did not exist, or worked
differently, in traditional C with the `-Wtraditional' option.  This
works only if you do _not_ specify `-traditional'.  GCC does not warn
about features of ISO C which you must use when you are using a
conforming compiler, such as the `#' and `##' operators.

   Presently `-Wtraditional' warns about:

   * Macro parameters that appear within string literals in the macro
     body.  In traditional C macro replacement takes place within
     string literals, but does not in ISO C.

   * In traditional C, some preprocessor directives did not exist.
     Traditional preprocessors would only consider a line to be a
     directive if the `#' appeared in column 1 on the line.  Therefore
     `-Wtraditional' warns about directives that traditional C
     understands but would ignore because the `#' does not appear as the
     first character on the line.  It also suggests you hide directives
     like `#pragma' not understood by traditional C by indenting them.
     Some traditional implementations would not recognize `#elif', so it
     suggests avoiding it altogether.

   * A function-like macro that appears without an argument list.  In
     traditional C this was an error.  In ISO C it merely means that the
     macro is not expanded.

   * The unary plus operator.  This did not exist in traditional C.

   * The `U' and `LL' integer constant suffixes, which were not
     available in traditional C.  (Traditional C does support the `L'
     suffix for simple long integer constants.)  You are not warned
     about uses of these suffixes in macros defined in system headers.
     For instance, `UINT_MAX' may well be defined as `4294967295U', but
     you will not be warned if you use `UINT_MAX'.

     You can usually avoid the warning, and the related warning about
     constants which are so large that they are unsigned, by writing the
     integer constant in question in hexadecimal, with no U suffix.
     Take care, though, because this gives the wrong result in exotic
     cases.


File: cpp.info,  Node: Implementation Details,  Next: Invocation,  Prev: Traditional Mode,  Up: Top

Implementation Details
**********************

   Here we document details of how the preprocessor's implementation
affects its user-visible behavior.  You should try to avoid undue
reliance on behavior described here, as it is possible that it will
change subtly in future implementations.

   Also documented here are obsolete features and changes from previous
versions of GNU CPP.

* Menu:

* Implementation-defined behavior::
* Implementation limits::
* Obsolete Features::
* Differences from previous versions::


File: cpp.info,  Node: Implementation-defined behavior,  Next: Implementation limits,  Up: Implementation Details

Implementation-defined behavior
===============================

   This is how GNU CPP behaves in all the cases which the C standard
describes as "implementation-defined".  This term means that the
implementation is free to do what it likes, but must document its choice
and stick to it.

   * The mapping of physical source file multi-byte characters to the
     execution character set.

     Currently, GNU cpp only supports character sets that are strict
     supersets of ASCII, and performs no translation of characters.

   * Non-empty sequences of whitespace characters.

     In textual output, each whitespace sequence is collapsed to a
     single space.  For aesthetic reasons, the first token on each
     non-directive line of output is preceded with sufficient spaces
     that it appears in the same column as it did in the original
     source file.

   * The numeric value of character constants in preprocessor
     expressions.

     The preprocessor and compiler interpret character constants in the
     same way; escape sequences such as `\a' are given the values they
     would have on the target machine.

     Multi-character character constants are interpreted a character at
     a time, shifting the previous result left by the number of bits per
     character on the host, and adding the new character.  For example,
     'ab' on an 8-bit host would be interpreted as 'a' * 256 + 'b'.  If
     there are more characters in the constant than can fit in the
     widest native integer type on the host, usually a `long', the
     excess characters are ignored and a diagnostic is given.

   * Source file inclusion.

     For a discussion on how the preprocessor locates header files,
     *Note Include Operation::.

   * Interpretation of the filename resulting from a macro-expanded
     `#include' directive.

     *Note Computed Includes::.

   * Treatment of a `#pragma' directive that after macro-expansion
     results in a standard pragma.

     No macro expansion occurs on any `#pragma' directive line, so the
     question does not arise.

     Note that GCC does not yet implement any of the standard pragmas.



File: cpp.info,  Node: Implementation limits,  Next: Obsolete Features,  Prev: Implementation-defined behavior,  Up: Implementation Details

Implementation limits
=====================

   GNU CPP has a small number of internal limits.  This section lists
the limits which the C standard requires to be no lower than some
minimum, and all the others we are aware of.  We intend there to be as
few limits as possible.  If you encounter an undocumented or
inconvenient limit, please report that to us as a bug.  (See the
section on reporting bugs in the GCC manual.)

   Where we say something is limited "only by available memory", that
means that internal data structures impose no intrinsic limit, and space
is allocated with `malloc' or equivalent.  The actual limit will
therefore depend on many things, such as the size of other things
allocated by the compiler at the same time, the amount of memory
consumed by other processes on the same computer, etc.

   * Nesting levels of `#include' files.

     We impose an arbitrary limit of 200 levels, to avoid runaway
     recursion.  The standard requires at least 15 levels.

   * Nesting levels of conditional inclusion.

     The C standard mandates this be at least 63.  GNU CPP is limited
     only by available memory.

   * Levels of parenthesised expressions within a full expression.

     The C standard requires this to be at least 63.  In preprocessor
     conditional expressions, it is limited only by available memory.

   * Significant initial characters in an identifier or macro name.

     The preprocessor treats all characters as significant.  The C
     standard requires only that the first 63 be significant.

   * Number of macros simultaneously defined in a single translation
     unit.

     The standard requires at least 4095 be possible.  GNU CPP is
     limited only by available memory.

   * Number of parameters in a macro definition and arguments in a
     macro call.

     We allow `USHRT_MAX', which is no smaller than 65,535.  The minimum
     required by the standard is 127.

   * Number of characters on a logical source line.

     The C standard requires a minimum of 4096 be permitted.  GNU CPP
     places no limits on this, but you may get incorrect column numbers
     reported in diagnostics for lines longer than 65,535 characters.

   * Maximum size of a source file.

     The standard does not specify any lower limit on the maximum size
     of a source file.  GNU cpp maps files into memory, so it is
     limited by the available address space.  This is generally at
     least two gigabytes.  Depending on the operating system, the size
     of physical memory may or may not be a limitation.



File: cpp.info,  Node: Obsolete Features,  Next: Differences from previous versions,  Prev: Implementation limits,  Up: Implementation Details

Obsolete Features
=================

   GNU CPP has a number of features which are present mainly for
compatibility with older programs.  We discourage their use in new code.
In some cases, we plan to remove the feature in a future version of GCC.

* Menu:

* Assertions::
* Obsolete once-only headers::
* Miscellaneous obsolete features::


File: cpp.info,  Node: Assertions,  Next: Obsolete once-only headers,  Up: Obsolete Features

Assertions
----------

   "Assertions" are a deprecated alternative to macros in writing
conditionals to test what sort of computer or system the compiled
program will run on.  Assertions are usually predefined, but you can
define them with preprocessing directives or command-line options.

   Assertions were intended to provide a more systematic way to describe
the compiler's target system.  However, in practice they are just as
unpredictable as the system-specific predefined macros.  In addition,
they are not part of any standard, and only a few compilers support
them.  Therefore, the use of assertions is *less* portable than the use
of system-specific predefined macros.  We recommend you do not use them
at all.

   An assertion looks like this:

     #PREDICATE (ANSWER)

PREDICATE must be a single identifier.  ANSWER can be any sequence of
tokens; all characters are significant except for leading and trailing
whitespace, and differences in internal whitespace sequences are
ignored.  (This is similar to the rules governing macro redefinition.)
Thus, `(x + y)' is different from `(x+y)' but equivalent to
`( x + y )'.  Parentheses do not nest inside an answer.

   To test an assertion, you write it in an `#if'.  For example, this
conditional succeeds if either `vax' or `ns16000' has been asserted as
an answer for `machine'.

     #if #machine (vax) || #machine (ns16000)

You can test whether _any_ answer is asserted for a predicate by
omitting the answer in the conditional:

     #if #machine

   Assertions are made with the `#assert' directive.  Its sole argument
is the assertion to make, without the leading `#' that identifies
assertions in conditionals.

     #assert PREDICATE (ANSWER)

You may make several assertions with the same predicate and different
answers.  Subsequent assertions do not override previous ones for the
same predicate.  All the answers for any given predicate are
simultaneously true.

   Assertions can be cancelled with the `#unassert' directive.  It has
the same syntax as `#assert'.  In that form it cancels only the answer
which was specified on the `#unassert' line; other answers for that
predicate remain true.  You can cancel an entire predicate by leaving
out the answer:

     #unassert PREDICATE

In either form, if no such assertion has been made, `#unassert' has no
effect.

   You can also make or cancel assertions using command line options.
*Note Invocation::.


File: cpp.info,  Node: Obsolete once-only headers,  Next: Miscellaneous obsolete features,  Prev: Assertions,  Up: Obsolete Features

Obsolete once-only headers
--------------------------

   GNU CPP supports two more ways of indicating that a header file
should be read only once.  Neither one is as portable as a wrapper
`#ifndef', and we recommend you do not use them in new programs.

   In the Objective-C language, there is a variant of `#include' called
`#import' which includes a file, but does so at most once.  If you use
`#import' instead of `#include', then you don't need the conditionals
inside the header file to prevent multiple inclusion of the contents.
GCC permits the use of `#import' in C and C++ as well as Objective-C.
However, it is not in standard C or C++ and should therefore not be
used by portable programs.

   `#import' is not a well designed feature.  It requires the users of
a header file to know that it should only be included once.  It is much
better for the header file's implementor to write the file so that users
don't need to know this.  Using a wrapper `#ifndef' accomplishes this
goal.

   In the present implementation, a single use of `#import' will
prevent the file from ever being read again, by either `#import' or
`#include'.  You should not rely on this; do not use both `#import' and
`#include' to refer to the same header file.

   Another way to prevent a header file from being included more than
once is with the `#pragma once' directive.  If `#pragma once' is seen
when scanning a header file, that file will never be read again, no
matter what.

   `#pragma once' does not have the problems that `#import' does, but
it is not recognized by all preprocessors, so you cannot rely on it in
a portable program.


File: cpp.info,  Node: Miscellaneous obsolete features,  Prev: Obsolete once-only headers,  Up: Obsolete Features

Miscellaneous obsolete features
-------------------------------

   Here are a few more obsolete features.

   * Attempting to paste two tokens which together do not form a valid
     preprocessing token.

     The preprocessor currently warns about this and outputs the two
     tokens adjacently, which is probably the behavior the programmer
     intends.  It may not work in future, though.

     Most of the time, when you get this warning, you will find that
     `##' is being used superstitiously, to guard against whitespace
     appearing between two tokens.  It is almost always safe to delete
     the `##'.

   * `#pragma poison'

     This is the same as `#pragma GCC poison'.  The version without the
     `GCC' prefix is deprecated.  *Note Pragmas::.

   * Multi-line string constants

     GCC currently allows a string constant to extend across multiple
     logical lines of the source file.  This extension is deprecated
     and will be removed in a future version of GCC.  Such string
     constants are already rejected in all directives apart from
     `#define'.

     Instead, make use of ISO C concatenation of adjacent string
     literals, or use `\n' followed by a backslash-newline.



File: cpp.info,  Node: Differences from previous versions,  Prev: Obsolete Features,  Up: Implementation Details

Differences from previous versions
==================================

   This section details behavior which has changed from previous
versions of GNU CPP.  We do not plan to change it again in the near
future, but we do not promise not to, either.

   The "previous versions" discussed here are 2.95 and before.  The
behavior of GCC 3.0 is mostly the same as the behavior of the widely
used 2.96 and 2.97 development snapshots.  Where there are differences,
they generally represent bugs in the snapshots.

   * Order of evaluation of `#' and `##' operators

     The standard does not specify the order of evaluation of a chain of
     `##' operators, nor whether `#' is evaluated before, after, or at
     the same time as `##'.  You should therefore not write any code
     which depends on any specific ordering.  It is possible to
     guarantee an ordering, if you need one, by suitable use of nested
     macros.

     An example of where this might matter is pasting the arguments `1',
     `e' and `-2'.  This would be fine for left-to-right pasting, but
     right-to-left pasting would produce an invalid token `e-2'.

     GCC 3.0 evaluates `#' and `##' at the same time and strictly left
     to right.  Older versions evaluated all `#' operators first, then
     all `##' operators, in an unreliable order.

   * The form of whitespace betwen tokens in preprocessor output

     *Note Preprocessor Output::, for the current textual format.  This
     is also the format used by stringification.  Normally, the
     preprocessor communicates tokens directly to the compiler's
     parser, and whitespace does not come up at all.

     Older versions of GCC preserved all whitespace provided by the
     user and inserted lots more whitespace of their own, because they
     could not accurately predict when extra spaces were needed to
     prevent accidental token pasting.

   * Optional argument when invoking rest argument macros

     As an extension, GCC permits you to omit the variable arguments
     entirely when you use a variable argument macro.  This is
     forbidden by the 1999 C standard, and will provoke a pedantic
     warning with GCC 3.0.  Previous versions accepted it silently.

   * `##' swallowing preceding text in rest argument macros

     Formerly, in a macro expansion, if `##' appeared before a variable
     arguments parameter, and the set of tokens specified for that
     argument in the macro invocation was empty, previous versions of
     GNU CPP would back up and remove the preceding sequence of
     non-whitespace characters (*not* the preceding token).  This
     extension is in direct conflict with the 1999 C standard and has
     been drastically pared back.

     In the current version of the preprocessor, if `##' appears between
     a comma and a variable arguments parameter, and the variable
     argument is omitted entirely, the comma will be removed from the
     expansion.  If the variable argument is empty, or the token before
     `##' is not a comma, then `##' behaves as a normal token paste.

   * Traditional mode and GNU extensions

     Traditional mode used to be implemented in the same program as
     normal preprocessing.  Therefore, all the GNU extensions to the
     preprocessor were still available in traditional mode.  It is now
     a separate program and does not implement any of the GNU
     extensions, except for a partial implementation of assertions.
     Even those may be removed in a future release.

   * `#line' and `#include'

     The `#line' directive used to change GCC's notion of the
     "directory containing the current file," used by `#include' with a
     double-quoted header file name.  In 3.0 and later, it does not.
     *Note Line Control::, for further explanation.

   * Syntax of `#line'

     In GCC 2.95 and previous, the string constant argument to `#line'
     was treated the same way as the argument to `#include': backslash
     escapes were not honored, and the string ended at the second `"'.
     This is not compliant with the C standard.  In GCC 3.0, an attempt
     was made to correct the behavior, so that the string was treated
     as a real string constant, but it turned out to be buggy.  In 3.1,
     the bugs have been fixed.  (We are not fixing the bugs in 3.0
     because they affect relatively few people and the fix is quite
     invasive.)



File: cpp.info,  Node: Invocation,  Next: Environment Variables,  Prev: Implementation Details,  Up: Top

Invocation
**********

   Most often when you use the C preprocessor you will not have to
invoke it explicitly: the C compiler will do so automatically.
However, the preprocessor is sometimes useful on its own.  All the
options listed here are also acceptable to the C compiler and have the
same meaning, except that the C compiler has different rules for
specifying the output file.

   *Note:* Whether you use the preprocessor by way of `gcc' or `cpp',
the "compiler driver" is run first.  This program's purpose is to
translate your command into invocations of the programs that do the
actual work.  Their command line interfaces are similar but not
identical to the documented interface, and may change without notice.

   The C preprocessor expects two file names as arguments, INFILE and
OUTFILE.  The preprocessor reads INFILE together with any other files
it specifies with `#include'.  All the output generated by the combined
input files is written in OUTFILE.

   Either INFILE or OUTFILE may be `-', which as INFILE means to read
from standard input and as OUTFILE means to write to standard output.
Also, if either file is omitted, it means the same as if `-' had been
specified for that file.

   Unless otherwise noted, or the option ends in `=', all options which
take an argument may have that argument appear either immediately after
the option, or with a space between option and argument: `-Ifoo' and
`-I foo' have the same effect.

   Many options have multi-letter names; therefore multiple
single-letter options may _not_ be grouped: `-dM' is very different from
`-d -M'.

`-D NAME'
     Predefine NAME as a macro, with definition `1'.

`-D NAME=DEFINITION'
     Predefine NAME as a macro, with definition DEFINITION.  There are
     no restrictions on the contents of DEFINITION, but if you are
     invoking the preprocessor from a shell or shell-like program you
     may need to use the shell's quoting syntax to protect characters
     such as spaces that have a meaning in the shell syntax.

     If you wish to define a function-like macro on the command line,
     write its argument list with surrounding parentheses before the
     equals sign (if any).  Parentheses are meaningful to most shells,
     so you will need to quote the option.  With `sh' and `csh',
     `-D'NAME(ARGS...)=DEFINITION'' works.

     `-D' and `-U' options are processed in the order they are given on
     the command line.  All `-imacros FILE' and `-include FILE' options
     are processed after all `-D' and `-U' options.

`-U NAME'
     Cancel any previous definition of NAME, either built in or
     provided with a `-D' option.

`-undef'
     Do not predefine any system-specific macros.  The common predefined
     macros remain defined.

`-I DIR'
     Add the directory DIR to the list of directories to be searched
     for header files.  *Note Search Path::.  Directories named by `-I'
     are searched before the standard system include directories.

     It is dangerous to specify a standard system include directory in
     an `-I' option.  This defeats the special treatment of system
     headers (*note System Headers::) .  It can also defeat the repairs
     to buggy system headers which GCC makes when it is installed.

`-o FILE'
     Write output to FILE.  This is the same as specifying FILE as the
     second non-option argument to `cpp'.  `gcc' has a different
     interpretation of a second non-option argument, so you must use
     `-o' to specify the output file.

`-Wall'
     Turns on all optional warnings which are desirable for normal
     code.  At present this is `-Wcomment' and `-Wtrigraphs'.  Note that
     many of the preprocessor's warnings are on by default and have no
     options to control them.

`-Wcomment'
`-Wcomments'
     Warn whenever a comment-start sequence `/*' appears in a `/*'
     comment, or whenever a backslash-newline appears in a `//' comment.
     (Both forms have the same effect.)

`-Wtrigraphs'
     Warn if any trigraphs are encountered.  This option used to take
     effect only if `-trigraphs' was also specified, but now works
     independently.  Warnings are not given for trigraphs within
     comments, as they do not affect the meaning of the program.

`-Wtraditional'
     Warn about certain constructs that behave differently in
     traditional and ISO C.  Also warn about ISO C constructs that have
     no traditional C equivalent, and problematic constructs which
     should be avoided.  *Note Traditional Mode::.

`-Wimport'
     Warn the first time `#import' is used.

`-Wundef'
     Warn whenever an identifier which is not a macro is encountered in
     an `#if' directive, outside of `defined'.  Such identifiers are
     replaced with zero.

`-Werror'
     Make all warnings into hard errors.  Source code which triggers
     warnings will be rejected.

`-Wsystem-headers'
     Issue warnings for code in system headers.  These are normally
     unhelpful in finding bugs in your own code, therefore suppressed.
     If you are responsible for the system library, you may want to see
     them.

`-w'
     Suppress all warnings, including those which GNU CPP issues by
     default.

`-pedantic'
     Issue all the mandatory diagnostics listed in the C standard.
     Some of them are left out by default, since they trigger
     frequently on harmless code.

`-pedantic-errors'
     Issue all the mandatory diagnostics, and make all mandatory
     diagnostics into errors.  This includes mandatory diagnostics that
     GCC issues without `-pedantic' but treats as warnings.

`-M'
     Instead of outputting the result of preprocessing, output a rule
     suitable for `make' describing the dependencies of the main source
     file.  The preprocessor outputs one `make' rule containing the
     object file name for that source file, a colon, and the names of
     all the included files, including those coming from `-include' or
     `-imacros' command line options.

     Unless specified explicitly (with `-MT' or `-MQ'), the object file
     name consists of the basename of the source file with any suffix
     replaced with object file suffix.  If there are many included
     files then the rule is split into several lines using `\'-newline.
     The rule has no commands.

     This option does not suppress the preprocessor's debug output,
     such as `-dM'.  To avoid mixing such debug output with the
     dependency rules you should explicitly specify the dependency
     output file with `-MF', or use an environment variable like
     `DEPENDENCIES_OUTPUT' (*note DEPENDENCIES_OUTPUT::).  Debug output
     will still be sent to the regular output stream as normal.

     Passing `-M' to the driver implies `-E'.

`-MM'
     Like `-M' but do not mention header files that are found in system
     header directories, nor header files that are included, directly
     or indirectly, from such a header.

     This implies that the choice of angle brackets or double quotes in
     an `#include' directive does not in itself determine whether that
     header will appear in `-MM' dependency output.  This is a slight
     change in semantics from GCC versions 3.0 and earlier.

`-MF FILE'
     When used with `-M' or `-MM', specifies a file to write the
     dependencies to.  If no `-MF' switch is given the preprocessor
     sends the rules to the same place it would have sent preprocessed
     output.

     When used with the driver options `-MD' or `-MMD', `-MF' overrides
     the default dependency output file.

`-MG'
     When used with `-M' or `-MM', `-MG' says to treat missing header
     files as generated files and assume they live in the same
     directory as the source file.  It suppresses preprocessed output,
     as a missing header file is ordinarily an error.

     This feature is used in automatic updating of makefiles.

`-MP'
     This option instructs CPP to add a phony target for each dependency
     other than the main file, causing each to depend on nothing.  These
     dummy rules work around errors `make' gives if you remove header
     files without updating the `Makefile' to match.

     This is typical output:

          test.o: test.c test.h
          
          test.h:

`-MT TARGET'
     Change the target of the rule emitted by dependency generation.  By
     default CPP takes the name of the main input file, including any
     path, deletes any file suffix such as `.c', and appends the
     platform's usual object suffix.  The result is the target.

     An `-MT' option will set the target to be exactly the string you
     specify.  If you want multiple targets, you can specify them as a
     single argument to `-MT', or use multiple `-MT' options.

     For example, `-MT '$(objpfx)foo.o'' might give

          $(objpfx)foo.o: foo.c

`-MQ TARGET'
     Same as `-MT', but it quotes any characters which are special to
     Make.  `-MQ '$(objpfx)foo.o'' gives

          $$(objpfx)foo.o: foo.c

     The default target is automatically quoted, as if it were given
     with `-MQ'.

`-MD'
     `-MD' is equivalent to `-M -MF FILE', except that `-E' is not
     implied.  The driver determines FILE based on whether an `-o'
     option is given.  If it is, the driver uses its argument but with
     a suffix of `.d', otherwise it take the basename of the input file
     and applies a `.d' suffix.

     If `-MD' is used in conjunction with `-E', any `-o' switch is
     understood to specify the dependency output file (but *note
     -MF::), but if used without `-E', each `-o' is understood to
     specify a target object file.

     Since `-E' is not implied, `-MD' can be used to generate a
     dependency output file as a side-effect of the compilation process.

`-MMD'
     Like `-MD' except mention only user header files, not system
     -header files.

`-x c'
`-x c++'
`-x objective-c'
`-x assembler-with-cpp'
     Specify the source language: C, C++, Objective-C, or assembly.
     This has nothing to do with standards conformance or extensions;
     it merely selects which base syntax to expect.  If you give none
     of these options, cpp will deduce the language from the extension
     of the source file: `.c', `.cc', `.m', or `.S'.  Some other common
     extensions for C++ and assembly are also recognized.  If cpp does
     not recognize the extension, it will treat the file as C; this is
     the most generic mode.

     *Note:* Previous versions of cpp accepted a `-lang' option which
     selected both the language and the standards conformance level.
     This option has been removed, because it conflicts with the `-l'
     option.

`-std=STANDARD'
`-ansi'
     Specify the standard to which the code should conform.  Currently
     cpp only knows about the standards for C; other language standards
     will be added in the future.

     STANDARD may be one of:
    `iso9899:1990'
    `c89'
          The ISO C standard from 1990.  `c89' is the customary
          shorthand for this version of the standard.

          The `-ansi' option is equivalent to `-std=c89'.

    `iso9899:199409'
          The 1990 C standard, as amended in 1994.

    `iso9899:1999'
    `c99'
    `iso9899:199x'
    `c9x'
          The revised ISO C standard, published in December 1999.
          Before publication, this was known as C9X.

    `gnu89'
          The 1990 C standard plus GNU extensions.  This is the default.

    `gnu99'
    `gnu9x'
          The 1999 C standard plus GNU extensions.

`-I-'
     Split the include path.  Any directories specified with `-I'
     options before `-I-' are searched only for headers requested with
     `#include "FILE"'; they are not searched for `#include <FILE>'.
     If additional directories are specified with `-I' options after
     the `-I-', those directories are searched for all `#include'
     directives.

     In addition, `-I-' inhibits the use of the directory of the current
     file directory as the first search directory for `#include "FILE"'.
     *Note Search Path::.

`-nostdinc'
     Do not search the standard system directories for header files.
     Only the directories you have specified with `-I' options (and the
     directory of the current file, if appropriate) are searched.

`-nostdinc++'
     Do not search for header files in the C++-specific standard
     directories, but do still search the other standard directories.
     (This option is used when building the C++ library.)

`-include FILE'
     Process FILE as if `#include "file"' appeared as the first line of
     the primary source file.  However, the first directory searched
     for FILE is the preprocessor's working directory _instead of_ the
     directory containing the main source file.  If not found there, it
     is searched for in the remainder of the `#include "..."' search
     chain as normal.

     If multiple `-include' options are given, the files are included
     in the order they appear on the command line.

`-imacros FILE'
     Exactly like `-include', except that any output produced by
     scanning FILE is thrown away.  Macros it defines remain defined.
     This allows you to acquire all the macros from a header without
     also processing its declarations.

     All files specified by `-imacros' are processed before all files
     specified by `-include'.

`-idirafter DIR'
     Search DIR for header files, but do it _after_ all directories
     specified with `-I' and the standard system directories have been
     exhausted.  DIR is treated as a system include directory.

`-iprefix PREFIX'
     Specify PREFIX as the prefix for subsequent `-iwithprefix'
     options.  If the prefix represents a directory, you should include
     the final `/'.

`-iwithprefix DIR'
`-iwithprefixbefore DIR'
     Append DIR to the prefix specified previously with `-iprefix', and
     add the resulting directory to the include search path.
     `-iwithprefixbefore' puts it in the same place `-I' would;
     `-iwithprefix' puts it where `-idirafter' would.

     Use of these options is discouraged.

`-isystem DIR'
     Search DIR for header files, after all directories specified by
     `-I' but before the standard system directories.  Mark it as a
     system directory, so that it gets the same special treatment as is
     applied to the standard system directories.  *Note System
     Headers::.

`-fpreprocessed'
     Indicate to the preprocessor that the input file has already been
     preprocessed.  This suppresses things like macro expansion,
     trigraph conversion, escaped newline splicing, and processing of
     most directives.  The preprocessor still recognizes and removes
     comments, so that you can pass a file preprocessed with `-C' to
     the compiler without problems.  In this mode the integrated
     preprocessor is little more than a tokenizer for the front ends.

     `-fpreprocessed' is implicit if the input file has one of the
     extensions `.i', `.ii' or `.mi'.  These are the extensions that
     GCC uses for preprocessed files created by `-save-temps'.

`-ftabstop=WIDTH'
     Set the distance between tab stops.  This helps the preprocessor
     report correct column numbers in warnings or errors, even if tabs
     appear on the line.  If the value is less than 1 or greater than
     100, the option is ignored.  The default is 8.

`-fno-show-column'
     Do not print column numbers in diagnostics.  This may be necessary
     if diagnostics are being scanned by a program that does not
     understand the column numbers, such as `dejagnu'.

`-A PREDICATE=ANSWER'
     Make an assertion with the predicate PREDICATE and answer ANSWER.
     This form is preferred to the older form `-A PREDICATE(ANSWER)',
     which is still supported, because it does not use shell special
     characters.  *Note Assertions::.

`-A -PREDICATE=ANSWER'
     Cancel an assertion with the predicate PREDICATE and answer ANSWER.

`-A-'
     Cancel all predefined assertions and all assertions preceding it on
     the command line.  Also, undefine all predefined macros and all
     macros preceding it on the command line.  (This is a historical
     wart and may change in the future.)

`-dCHARS'
     CHARS is a sequence of one or more of the following characters,
     and must not be preceded by a space.  Other characters are
     interpreted by the compiler proper, or reserved for future
     versions of GCC, and so are silently ignored.  If you specify
     characters whose behavior conflicts, the result is undefined.

    `M'
          Instead of the normal output, generate a list of `#define'
          directives for all the macros defined during the execution of
          the preprocessor, including predefined macros.  This gives
          you a way of finding out what is predefined in your version
          of the preprocessor.  Assuming you have no file `foo.h', the
          command

               touch foo.h; cpp -dM foo.h

          will show all the predefined macros.

    `D'
          Like `M' except in two respects: it does _not_ include the
          predefined macros, and it outputs _both_ the `#define'
          directives and the result of preprocessing.  Both kinds of
          output go to the standard output file.

    `N'
          Like `D', but emit only the macro names, not their expansions.

    `I'
          Output `#include' directives in addition to the result of
          preprocessing.

`-P'
     Inhibit generation of linemarkers in the output from the
     preprocessor.  This might be useful when running the preprocessor
     on something that is not C code, and will be sent to a program
     which might be confused by the linemarkers.  *Note Preprocessor
     Output::.

`-C'
     Do not discard comments.  All comments are passed through to the
     output file, except for comments in processed directives, which
     are deleted along with the directive.

     You should be prepared for side effects when using `-C'; it causes
     the preprocessor to treat comments as tokens in their own right.
     For example, comments appearing at the start of what would be a
     directive line have the effect of turning that line into an
     ordinary source line, since the first token on the line is no
     longer a `#'.

`-gcc'
     Define the macros __GNUC__, __GNUC_MINOR__ and
     __GNUC_PATCHLEVEL__.  These are defined automatically when you use
     `gcc -E'; you can turn them off in that case with `-no-gcc'.

`-traditional'
     Try to imitate the behavior of old-fashioned C, as opposed to ISO
     C.  *Note Traditional Mode::.

`-trigraphs'
     Process trigraph sequences.  *Note Initial processing::.

`-remap'
     Enable special code to work around file systems which only permit
     very short file names, such as MS-DOS.

`-$'
     Forbid the use of `$' in identifiers.  The C standard allows
     implementations to define extra characters that can appear in
     identifiers.  By default GNU CPP permits `$', a common extension.

`-h'
`--help'
`--target-help'
     Print text describing all the command line options instead of
     preprocessing anything.

`-v'
     Verbose mode.  Print out GNU CPP's version number at the beginning
     of execution, and report the final form of the include path.

`-H'
     Print the name of each header file used, in addition to other
     normal activities.  Each name is indented to show how deep in the
     `#include' stack it is.

`-version'
`--version'
     Print out GNU CPP's version number.  With one dash, proceed to
     preprocess as normal.  With two dashes, exit immediately.

