This is ../p/doc/info/gpc.info, produced by makeinfo version 4.0 from
gpc.texi.

INFO-DIR-SECTION GNU programming tools
START-INFO-DIR-ENTRY
* GPC: (gpc).                   The GNU Pascal Compiler.
END-INFO-DIR-ENTRY
INFO-DIR-SECTION Individual utilities
START-INFO-DIR-ENTRY
* GPC: (gpc)Invoking GPC.       The GNU Pascal Compiler.
END-INFO-DIR-ENTRY

   This file documents the GNU Pascal Compiler.

   Copyright (C) 1988-2002 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the sections entitled "GNU General Public License", "The GNU
Project", "The GNU Manifesto" and "Funding for Free Software" are
included exactly as in the original, and provided that the entire
resulting derived work is distributed under the terms of a permission
notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the sections entitled "GNU General Public
License", "The GNU Project", "The GNU Manifesto" and "Funding for Free
Software" and this permission notice, may be included in translations
approved by the Free Software Foundation instead of in the original
English.


File: gpc.info,  Node: Compiling GPC,  Next: Compilation Notes,  Prev: Binary Distributions,  Up: Installation

Compiling GPC
=============

   The preferred way to distribute GNU software is distribution of the
source code. However, it can be a non-trivial exercise to build GNU
Pascal on some non-Unix systems, so we also provide ready-to-run
binaries for a number of platforms. (See *Note Binary Distributions::
for how to install a binary distribution.)

   GPC is based on the GNU Compiler Collection, GNU CC or GCC. You will
need the GCC sources to build it. It must be the same version as the
one GPC is implemented with - `2.95.x' as of this writing. Although you
need GCC to build the GNU Pascal compiler, you don't need GCC to
compile Pascal programs once GNU Pascal is installed. (However, using
certain libraries will require compiling C wrappers, so it is a good
idea to install the C compiler as well.)

   Because GNU Pascal shares its back-end with GCC, it should run on any
system supported by GCC. A full list of platforms supported by GCC can
be found in *Note the GCC installation instructions: (gcc)Installation.

   The GCC source can be obtained from any mirror of the GNU FTP site,
`ftp://ftp.gnu.org/gnu/gcc/'. The "core" distribution is sufficient for
GPC.

   Here is the generic procedure for installing GNU Pascal on a Unix
system. See *Note Compilation Notes:: for extra information needed to
install GPC on DOS-like platforms.

  1. Checking the prerequisites

     Make sure that GNU make is installed. (In the following, we will
     simply speak of `make' when invoking GNU make; you might need to
     call `gmake' instead.)

     For extracting the example programs from the documentation to the
     `doc/docdemos' directory a non-crippled `sed' is needed.  GNU sed
     is known to work.

     If you want to build the GPC WWW pages you will also need:
     `texi2html' version 1.61 (older versions are missing some needed
     features; newer versions suffer from a bug), `texi2dvi', TeX,
     `gzip', `dvips', `dviselect', and `dviconcat'.

     If you run into trouble during the installation process, please
     check whether you are using outdated versions of the required
     utilities and upgrade if necessary.

     The GNU versions of the packages above are available from the GNU
     FTP server (ftp://ftp.gnu.org) or any of its mirrors.  Package
     PACKAGE is usually located in the directory `gnu/PACKAGE'.

  2. Unpacking the source

     From a directory of your choice (e.g. `/home/fred'), unpack the
     GCC and GNU Pascal source distributions. This will create separate
     subdirectories for GCC and GPC. Let us assume `gcc-2.95.1' and
     `gpc-20000535' in this example.
          % cd /home/fred
          % gzip -c -d gcc-core-2.95.1.tar.gz | tar xf -
          % gzip -c -d gpc-20000535.tar.gz | tar xf -

     `cd' to the GPC directory and move the contents (a subdirectory
     `p') to the subdirectory `gcc' of the GCC directory:

          % cd /home/fred/gpc-20000535
          % mv p /home/fred/gcc-2.95.1/gcc/

     It is recommended, though not required, to use a separate
     directory for building the compiler, rather than compiling in the
     source directory. In this example, let us create
     `/home/fred/gpc-build' for this purpose:

          % mkdir /home/fred/gpc-build

     If you use a separate directory, you do not need to write into the
     GCC source directory once you have patched the GCC source (see
     below), and can build GPC for more than one platform from the same
     source tree.

     In case you are re-using a directory where you have already built
     GCC and/or GPC for a different target machine, do `make distclean'
     to delete all files that might be invalid. One of the files this
     deletes is `Makefile'; if `make distclean' complains that
     `Makefile' does not exist, it probably means that the directory is
     already suitably clean.

  3. Configuring and building GCC

     GNU Pascal is automatically configured with GCC. Configuration of
     GCC is treated in depth in *Note the GCC installation
     instructions: (gcc)Installation. The normal procedure is as
     follows:

     `cd' to the GPC build directory. From there, run the `configure'
     script in the GCC source directory:

          % cd /home/fred/gpc-build
          % /home/fred/gcc-2.95.1/configure --enable-languages=pascal

     This creates all the necessary config files, links and Makefile in
     the GCC object directory.

     Note 1: The configuration will prompt you for patching the GCC
     source for GPC support, so you need write access to that
     directory. All changes to GCC are surrounded by `#ifdef GPC ...
     #endif', so they should not interfere when you build a C compiler
     from this source tree.

     Note 2: The `--enable-languages=pascal' option means that we only
     want to build the Pascal compiler and not, for instance, the C++
     compiler.

     Note 3: The standard base directory for installing GCC and GPC is
     `/usr/local'. If you want to install files to an alternate
     directory DIR, specify `--prefix=DIR' when you run `configure'.

  4. Putting other GNU tools in place

     Some environments require other GNU tools (such as the GNU
     assembler or linker) instead of the standard system tools for GCC
     to work. (See the GCC installation instructions for details.) If
     this is the case for your system, install the required tools in
     the GPC build directory under the names `as', `ld', or whatever is
     appropriate. This will enable the compiler to find the proper
     tools for compilation of the program `enquire' (a part of GCC) and
     to install the GNU tools to a place where they are found by GCC
     but do not interfere with the standard system tools.

     Alternatively, you can do subsequent compilation using a value of
     the `PATH' environment variable such that the necessary GNU tools
     come before the standard system tools.

  5. Compiling GPC

     Once you are satisfied with the configuration as determined by
     `configure', you can build the compiler:

          % make

     Notice that this procedure will build the C compiler (and maybe
     some other compilers) too, because that is used to compile the GPC
     runtime library.

     Optionally, you may supply CFLAGS, LDFLAGS or RTSFLAGS. CFLAGS is
     used for compiler and RTS, RTSFLAGS are for RTS only, i.e.: `make
     CFLAGS="-O2" RTSFLAGS=-Wall'

  6. Completing the installation

     When everything has been compiled, you can check the installation
     process with:

          % make -n install

     To complete the installation, run the command `make install'. You
     need write access to the target directories (`/usr/local/bin',
     `/usr/local/lib', `/usr/local/info', `/usr/local/doc', and
     `/usr/local/man' in this example), so this is usually done as
     `root':

          % su -c "make install"

     If you want to install _only_ the Pascal compiler (for example if
     you already have the correct version of GCC installed), `cd' to the
     `gcc' subdirectory of the build directory (e.g.
     `/home/fred/gpc-build/gcc') and run `make pascal.install'. This
     installation process does *not* overwrite existing copies of
     `libgcc.a' or `specs', should they exist.

     There is a (partial) translation of the GPC manual into Croatian
     available now. It is not installed by default. If you want to
     install it, do a `pascal.install-hr' in the `gcc' directory. This
     will install the manpage `gpc-hr.1' and the info documentation
     `gpc-hr.info*'. Other formats like PS, PDF and HTML can be built
     manually (it's also easy to add appropriate make targets for them
     when needed).

     Also from the `gcc' subdirectory you can do some more "exotic"
     builds. For instance, you can build the GPC WWW pages by typing
     `make pascal.html' or a binary distribution by typing `make
     pascal.bindist'. See the `Makefile' in that directory for more
     examples.


File: gpc.info,  Node: Compilation Notes,  Next: Cross-Compilers,  Prev: Compiling GPC,  Up: Installation

Compilation notes for specific platforms
========================================

* Menu:

* MS-DOS with DJGPP::        The DJGPP port of GNU compilers to MS-DOS.
* MS-DOS or OS/2 with EMX::  The EMX port of GNU compilers to MS-DOS and OS/2.
* MS Windows 95/98/NT::      Installation on a Windows 95/98/NT system.


File: gpc.info,  Node: MS-DOS with DJGPP,  Next: MS-DOS or OS/2 with EMX,  Up: Compilation Notes

MS-DOS with DJGPP
-----------------

   The only compiler that is capable of compiling the GNU Compiler
Collection (GNU CC or GCC) under MS-DOS is GCC itself. In order to
compile GPC or GCC for MS-DOS with DJGPP you will therefore need either
a working copy of DJGPP installed, or you will have to cross-build from
a non-MS-DOS system.

   Building GPC under MS-DOS with DJGPP follows the same scheme as
building GPC under a Unix-like system: Place the `p' subdirectory in the
`gcc' directory and follow the instructions for compiling GCC. This
requires `bash' and many other tools installed, and you must be very
careful at many places to circumvent the limitations of the DOS
platform.

   Our preferred way to build GPC for DJGPP is to cross-build it from a
Unix-like platform - which is much easier. For instructions, see *Note
Cross-Compilers:: and *Note Crossbuilding::.


File: gpc.info,  Node: MS-DOS or OS/2 with EMX,  Next: MS Windows 95/98/NT,  Prev: MS-DOS with DJGPP,  Up: Compilation Notes

MS-DOS or OS/2 with EMX
-----------------------

   EMX is a free 32-bit DOS extender which adds some properties of Unix
to MS-compatible DOS and IBM's OS/2 operating systems.

   As of this writing, we are not aware of current versions of GCC for
EMX, and EMX support in GPC has not been maintained. Please contact us
if you know about recent development in EMX and are interested in
continuing EMX support in GPC.


File: gpc.info,  Node: MS Windows 95/98/NT,  Prev: MS-DOS or OS/2 with EMX,  Up: Compilation Notes

MS Windows 95/98/NT
-------------------

   There are two ports of the GNU development tools to MS Windows
95/98/NT: CygWin and mingw32.

   The CygWin environment implements a POSIX layer under MS Windows,
giving it large parts of the functionality of Unix. Thus, compiling GCC
and GPC under the CygWin environment can be done following the
instructions for compiling it under a Unix-like system (see *Note
Compiling GPC::).

   The Minimalists' GNU Win32 environment, mingw32, uses the native
`crtdll.dll' library of MS Windows. It is much smaller than CygWin, but
it is not self-hosting and must be crossbuilt from another system (see
*Note Crossbuilding::).


File: gpc.info,  Node: Cross-Compilers,  Next: Crossbuilding,  Prev: Compilation Notes,  Up: Installation

Building and Installing a cross-compiler
========================================

   GNU Pascal can function as a cross-compiler for many machines.
Information about GNU tools in a cross-configuration can be found at
`ftp://ftp.cygnus.com/pub/embedded/crossgcc/'.

   Since GNU Pascal generates assembler code, you need a cross-assembler
that GNU Pascal can run, in order to produce object files. If you want
to link on other than the target machine, you need a cross-linker as
well. It is straightforward to install the GNU binutils to act as
cross-tools - see the installation instructions of the GNU binutils for
details.

   You also need header files and libraries suitable for the target
machine that you can install on the host machine. Please install them
under `PREFIX/PLATFORM/include/', for instance
`/usr/local/i386-pc-msdosdjgpp/include/' for a cross-compiler from a
typical Unix-like environment to MS-DOS with DJGPP.

   Configuration and compilation of the compiler can then be done using
the scripts `cfgpc' and `mkgpc' which are included in the source
distribution in the subdirectory `p/script'. Please call them with the
`-h' option for instructions.


File: gpc.info,  Node: Crossbuilding,  Prev: Cross-Compilers,  Up: Installation

Crossbuilding a compiler.
=========================

   Using a cross-compiler to build GNU Pascal results in a compiler
binary that runs on the cross-target platform. This is called
"crossbuilding". A possible reason why anybody would want to do this,
is when the platform on which you want to run the GNU Pascal compiler
is not self-hosting. An example is mingw32.

   To crossbuild GNU Pascal, you have to install a cross-compiler for
your target first, see *Note Cross-Compilers::.

   As when building a cross-compiler, configuration and compilation of
the compiler can be done using the scripts `cfgpc' and `mkgpc' which
are included in the source distribution in the subdirectory `p/script'.
Please call them with the `-h' option for instructions.


File: gpc.info,  Node: Borland Pascal,  Next: Invoking GPC,  Prev: Installation,  Up: Top

A QuickStart Guide from Borland Pascal to GNU Pascal.
*****************************************************

   This chapter is intended to be a QuickStart guide for programmers
who are familiar with Borland Pascal.

   Throughout the manual, we talk of "Borland Pascal" or "BP" for
short, to refer to Borland Pascal version 7 for Dos protected mode.
Other versions of Borland Pascal and Turbo Pascall don't differ too
much, but this one was the very last Dos version Borland has published,
so in most if not all cases, you can safely substitute the version
you're familiar with.

   "Borland Pascal" and "Turbo Pascal" are registered trademarks of
Borland Inc.

* Menu:

* BP Compatibility::
* BP Incompatibilities::
* IDE versus command line::
* Comments::
* BP Compatible Compiler Directives::
* Units; GPI files and AutoMake::
* Optimization::
* Debugging::
* Objects::
* Strings in BP and GPC::
* Typed Constants::
* Bit; Byte and Memory Manipulation::
* User-defined Operators in GPC::
* Data Types in BP and GPC::
* BP Procedural Types::
* Files::
* Built-in Constants::
* Built-in Operators in BP and GPC::
* Built-in Procedures and Functions::
* Special Parameters::
* Miscellaneous::
* BP and Extended Pascal::
* Portability hints::


File: gpc.info,  Node: BP Compatibility,  Next: BP Incompatibilities,  Up: Borland Pascal

BP Compatibility
================

   GNU Pascal (GPC) is compatible to version 7 of Borland Pascal (BP)
to a large extent and comes with portable replacements of the BP
standard units.

   However, BP is a 16-bit compiler while GPC is a 32/64-bit compiler,
so the size of the `Integer' type, for instance, is 16 bits in BP, but
at least 32 bits in GPC. If a BP program has been designed with
portability in mind from the ground up, it may work with GPC without
any change. Programs which rely on byte order, on the internals or
sizes of data types or which use unportable things like interrupts and
assembler code, will need to be changed. The following section lists
the possible problems with solutions.

   The GPC Run Time System (RTS) is fairly complete, and you can use
all libraries written for GNU C from GNU Pascal, so there is much less
need to use unportable constructs than there was in BP. (For example,
BP's Turbo Vision library uses assembler to call a local procedure
through a pointer. With GPC you can do this in Pascal just as with
global procedures.) Please do not throw away the advantage of full
portability by sticking to those workarounds.

   We have successfully ported real-world projects (with several 10000s
of lines) from BP to GPC, so this is possible for you, too.


File: gpc.info,  Node: BP Incompatibilities,  Next: IDE versus command line,  Prev: BP Compatibility,  Up: Borland Pascal

BP Incompatibilities
====================

   This sections lists the remaining incompatibilities of GPC to BP,
and the problems you might encounter when porting BP programs from
16-bit Dos to other platforms, and gives solutions for them.

   By "incompatibilites" we mean problems that can arise when trying to
compile a valid BP program with GPC. Of course, there are many features
in GPC that BP doesn't know, but we call them extensions unless they
can break valid BP programs, so they are not mentioned here. The
subsequent sections of the `Borland Pascal' chapter mention a number of
useful extensions that you might want to know about but which will not
break your BP code.

* Menu:

* String type::
* Qualified identifiers::
* Assembler::
* Move; FillChar::
* Real type::
* Graph unit::
* OOP units::
* Keep; GetIntVec; SetIntVec::
* TFDDs::
* Mem; Port; Ptr; Seg; Ofs; PrefixSeg; etc.::
* Endianness assumptions::

   Some of the differences can be "overcome" by command-line switches.
As a summary:

     --borland-pascal -w --uses=System -D__BP_TYPE_SIZES__ --pack-struct
     -D__BP_RANDOM__ -D__BP_UNPORTABLE_ROUTINES__ -D__BP_PARAMSTR_0__

   But please read the following notes, and don't use these switches
indiscriminately when not necessary. There are reasons why they are not
GPC's defaults.

* Menu:

* - -borland-pascal - disable GPC extensions::
* -w - disable all warnings::
* - -uses=System - Swap; HeapError; etc.::
* -D__BP_TYPE_SIZES__ - small integer types etc.::
* - -pack-struct - disable structure alignment::
* -D__BP_RANDOM__ - BP compatible pseudo random number generator::
* -D__BP_UNPORTABLE_ROUTINES__ - Intr; DosVersion; etc.::
* -D__BP_PARAMSTR_0__ - BP compatible ParamStr (0) behaviour::


File: gpc.info,  Node: String type,  Next: Qualified identifiers,  Up: BP Incompatibilities

String type
-----------

   GPC's internal string format (Extended Pascal string schema) is
different from BP's. BP compatible "short strings" will be implemented
in GPC soon, but in the meantime, you'll have to live with the
difference. In general, GPC's format has many advantages (no length
limit of 255 characters, constant and reference parameters always know
about their capacity, etc.), but you will see differences if you:

   - declare a variable as `String' without a capacity. However, GPC
     will assume 255 then (like BP) and only warn about it (and not even
     this when using `--borland-pascal', see below), so that's not a
     real problem. The "clean" way, however, is to declare `String
     [255]' when you mean so (but perhaps you'll prefer `String
     (2000)'? :-).

   - access "character 0" which happens to hold the length in BP. This
     does not work with string schemata. Use `Length' to get the
     length, and `SetLength' to modify it.

   - try to `FillChar' a string, e.g.  `FillChar (StringVar, 256, 0);',
     which would overwrite the `Capacity' field. Using `FillChar
     (StringVar[1], ...);' is alright since it accesses the characters
     of the string, not the `Capacity' and `Length' fields. If you want
     to set the length to zero, use `SetLength' (see above) or simply
     assign an empty string (`StringVar := '''). This is more efficient
     than clearing all the characters, anyway, and has the same effect
     for all normal purposes.

   - try to read or write strings from/to _binary_ files (`Text' files
     are no problem). You will have to rewrite the code. If you also
     want to get rid of the 255 character limit and handle endianness
     issues (see below) in one go, you can use the
     `ReadStringLittleEndian' etc. routines (*note Run Time System::),
     but if you need BP compatible strings (i.e., with a one-byte
     length field) in data files, you cannot use them (but you can
     easily modify them for this purpose).


File: gpc.info,  Node: Qualified identifiers,  Next: Assembler,  Prev: String type,  Up: BP Incompatibilities

Qualified identifiers
---------------------

   GPC does not yet support "qualified identifiers". They will be
implemented soon. In the meantime, just don't use them, sorry. (In
general, using the same global identifier in different units can easily
be confusing, so it's not bad practice to avoid this, anyway.)


File: gpc.info,  Node: Assembler,  Next: Move; FillChar,  Prev: Qualified identifiers,  Up: BP Incompatibilities

Assembler
---------

   GPC's inline assembler is not compatible to BP's. It uses "AT&T
syntax", supports a large variety of processors and works together with
GPC's optimizer. So, either convert your inline assembly to AT&T
syntax, or (usually better) to Pascal, or put it into an external file
which you can assemble with your favourite (32 bit) assembler. A
tutorial for using the GPC inline assembler is available at
`http://www.gnu-pascal.de/contrib/misc/gpcasm.zip'

   Since many things you usually do with assembler in BP are provided
by GPC's Run Time System (RTS), you will not need the inline assembler
as often as in BP. (See *Note Portability hints::.)

   The same applies to BP's `inline' directive for hand-written machine
code. GPC's `inline' directive works for Pascal routines (*note
Miscellaneous::), so you'll have to convert any hand-written machine
code to Pascal (and thereby make it more readable, portable and easier
to maintain while still getting the performance of inline code).


File: gpc.info,  Node: Move; FillChar,  Next: Real type,  Prev: Assembler,  Up: BP Incompatibilities

Move; FillChar
--------------

   GPC supports `Move' and `FillChar', and they're fully BP compatible.
However, some data structures have different internal formats which may
become relevant when using these procedures. E.g., using `Move' on file
variables does not work in GPC (there are reasons why assigning file
variables with `:=' is not allowed in Pascal, and circumventing this
restriction with `Move' is not a good idea). For other examples, see
*Note String type::, *Note Real type::, and *Note Endianness
assumptions::.


File: gpc.info,  Node: Real type,  Next: Graph unit,  Prev: Move; FillChar,  Up: BP Incompatibilities

Real type
---------

   GPC does not support BP's 6-byte `Real' type. It supports `Single',
`Double' and `Extended' which, at least on the IA32 and some other
processors, are compatible to BP.

   For BP's 6-byte `Real' type, GPC's `System' unit provides an
emulation, called `BPReal', as well as conversion routines to GPC's
`Real' type (which is the same as `Double'), called `RealToBPReal' and
`BPRealToReal'. You'll probably only need them when reading or writing
binary files containing values of the BP 6-byte real type. There are no
operators (e.g., `+') available for `BPReal', but since GPC supports
operator overloading, you could define them yourself (e.g., convert to
`Real', do the operation, and convert back). Needless to say that this
is very inefficient and should not be done for any serious
computations. Better convert your data after reading them from the file
and before writing them back, or simply convert your data files once
(the other types are more efficient even with BP on any non-prehistoric
processor, anyway).


File: gpc.info,  Node: Graph unit,  Next: OOP units,  Prev: Real type,  Up: BP Incompatibilities

Graph unit
----------

   A mostly BP compatible `Graph' unit exists as part of the `GRX'
package. It is known to work under DJGPP, Cygwin, mingw, Linux/IA32
with svgalib, and should work under any Unix system with X11 (tested
under Linux, Solaris, AIX, etc.).

   There is a small difference in the color numbering, but it should be
easy to work-around: You can't assume, e.g., that color 1 is always
blue, and 2 is green, etc. On a system with 15 or more bits of color
depth (i.e., 32768 or more colors, which most PCs today have), they
will all be very dark shades of blue. This is not really a bug, but
simply a property of modern high colors modes (whereas BP's `Graph'
unit was only designed for 16 and 256 color modes).

   However, the names `Blue', `Green' etc. stand for the correct colors
in the `Graph' unit of GRX. They are no constants, but functions
(because the color depth is in general not known until runtime), so you
can't use them in contexts where constants are expected. Also, they
might conflict with the identifiers of the `CRT' unit if you use both
units at the same time. If you want to use computed color values in the
range 0 ... 15, you can translate them to the correct colors using the
`EGAColor' function.


File: gpc.info,  Node: OOP units,  Next: Keep; GetIntVec; SetIntVec,  Prev: Graph unit,  Up: BP Incompatibilities

OOP units
---------

   The OOP stuff (Turbo Vision etc.) is not yet completed, but work on
several projects is underway. If you want information about the current
status or access to development source, please contact the GPC mailing
list.


File: gpc.info,  Node: Keep; GetIntVec; SetIntVec,  Next: TFDDs,  Prev: OOP units,  Up: BP Incompatibilities

Keep; GetIntVec; SetIntVec
--------------------------

   The routines `Keep', `GetIntVec' and `SetIntVec' in the `Dos' unit
do not even make sense on DJGPP (32 bit Dos extender). If your program
uses these, it is either a low-level Dos utility for which porting to a
32 bit environment might cause bigger problems (because the internal
issues of DPMI become relevant which are usually hidden by DJGPP), or
it installs interrupt handlers which will have to be thought about more
carefully because of things like locking memory, knowing about and
handling the differences between real and protected mode interrupts,
etc. For these kinds of things, we refer you to the DJGPP FAQ (*note
DJGPP FAQ: (djgppfaq)Top.).


File: gpc.info,  Node: TFDDs,  Next: Mem; Port; Ptr; Seg; Ofs; PrefixSeg; etc.,  Prev: Keep; GetIntVec; SetIntVec,  Up: BP Incompatibilities

TFDDs
-----

   The internal structure of file variables (`FileRec' and `TextRec' in
BP's `Dos' unit and `TFileRec' and `TTextRec' in BP's `WinDos' unit) is
different in GPC.  However, as far as "Text File Device Drivers"
(TFDDs) are concerned, GPC offers a more powerful mechanism. Please see
the RTS reference (*note Run Time System::), under `AssignTFDD'.


File: gpc.info,  Node: Mem; Port; Ptr; Seg; Ofs; PrefixSeg; etc.,  Next: Endianness assumptions,  Prev: TFDDs,  Up: BP Incompatibilities

Mem; Port; Ptr; Seg; Ofs; PrefixSeg; etc.
-----------------------------------------

   Those few routines in the `System' unit that deal with segmented
pointers (e.g., `Ptr') are emulated in such a way that such ugly BP
constructs like
     PInteger (Ptr (Seg (a), Ofs (a) + 6 * SizeOf (Integer)))^ = 42
   work in GPC, but they do not provide access to absolute memory
addresses. Neither do `absolute' variables (which take a simple address
in the program's address space in GPC, rather than a segmented
address), and the `Mem' and `Port' arrays don't exist in GPC.

   As a replacement for `Port' on IA32 processors, you can use the
routines provided in the `Ports' unit, *Note Ports::. If you want to
access absolute memory addresses in the first megabyte under DJGPP, you
can't do this with normal pointers because DJGPP programs run in a
protected memory environment, unless you use a dirty trick called "near
pointer hack". Please see the DJGPP FAQ (*note DJGPP FAQ:
(djgppfaq)Top.) for this and for other ways.

   For similar reasons, the variable `PrefixSeg' in the `System' unit
is not supported. Apart from "TSR"s, its only meaningful use in BP
might be the setting of environment variables.  GPC provides the
`SetEnv' and `UnSetEnv' procedures for this purpose which you can use
instead of any BP equivalents based on `PrefixSeg'. (However note that
they will modify the program's own and its childs' environment, not its
parent's environment. This is a property - most people call it a
feature - of the environments, including DJGPP, that GPC compiled
programs run in.)


File: gpc.info,  Node: Endianness assumptions,  Next: - -borland-pascal - disable GPC extensions,  Prev: Mem; Port; Ptr; Seg; Ofs; PrefixSeg; etc.,  Up: BP Incompatibilities

Endianness assumptions
----------------------

   GPC also runs on big-endian systems (*note Endianness::). This is,
of course, a feature of GPC, but might affect your programs when
running on a big-endian system if they make assumptions about
endianness, e.g., by using type casts (or `absolute' declarations or
variant records misused as type casts) in certain ways. Please see the
demo program `absdemo.pas' for an example and how to solve it.

   Endianness is also relevant (the more common case) when exchanging
data between different machines, e.g. via binary files or over a
network. Since the latter is not easily possible in BP, and the
techniques to solve the problems are mostly the same as for files, we
concentrate on files here.

   First, you have to choose the endianness to use for the file. Most
known data formats have a specified endianness (usually that of the
processor on which the format was originally created). If you define
your own binary data format, you're free to choose the endianness to
use.

   Then, when reading or writing values larger than one byte from/to
the file, you have to convert them. GPC's Run Time System supports this
by some routines. E.g., you can read an array from a little-endian file
with the procedure `BlockReadLittleEndian', or write one to a
big-endian file with `BlockWriteBigEndian'.  _Note:_ The endianness in
the procedure names refers to the file, not the system - the routines
know about the endianness of the system they run on, but you have to
tell them the endianness of the file to use. This means you do not have
to (and must not) use an `ifdef' to use the version matching the
system's endianness.

   When reading or writing records or other more complicated
structures, either read/write them field by field using
`BlockReadBigEndian' etc., or read/write them with the regular
`BlockRead' and `BlockWrite' procedures and convert each field after
reading or before writing using procedures like `ConvertFromBigEndian'
or `ConvertToLittleEndian' (but remember, when writing, to undo the
conversion afterwards, if you want to keep using the data - this is not
necessary with `BlockWriteLittleEndian' etc.).

   Especially for strings, there are ready-made procedures like
`ReadStringBigEndian' or `WriteStringLittleEndian' which will
read/write the length as a 64 bit value (much space for really long
strings :-) in the given endianness, followed by the characters (which
have no endianness problem).

   All these routines are described in detail in the RTS reference
(*note Run Time System::), under `endianness'. The demo program
`endiandemo.pas' contains an example on how to use these routines.


File: gpc.info,  Node: - -borland-pascal - disable GPC extensions,  Next: -w - disable all warnings,  Prev: Endianness assumptions,  Up: BP Incompatibilities

- -borland-pascal - disable GPC extensions
------------------------------------------

   GPC warns about some BP constructs which are especially "dirty",
like misusing typed constants as initialized variables. GPC also
supports some features that may conflict with BP code, like macros.
The command line option `--borland-pascal' disables both, so you might
want to use it for a first attempt to compile your BP code under GPC.
However, we suggest you try compiling without this switch and fixing
any resulting problems as soon as you've become acquainted with GPC.


File: gpc.info,  Node: -w - disable all warnings,  Next: - -uses=System - Swap; HeapError; etc.,  Prev: - -borland-pascal - disable GPC extensions,  Up: BP Incompatibilities

-w - disable all warnings
-------------------------

   Even in `--borland-pascal' mode, GPC may warn about some dangerous
things. To disable *all* warnings, you can use the `-w' option (note:
lower-case `w'!). This is not recommended at all, but you may consider
it more BP compatible ...


File: gpc.info,  Node: - -uses=System - Swap; HeapError; etc.,  Next: -D__BP_TYPE_SIZES__ - small integer types etc.,  Prev: -w - disable all warnings,  Up: BP Incompatibilities

- -uses=System - Swap; HeapError; etc.
--------------------------------------

   A few exotic BP routines and declarations (e.g., `Swap' and
`HeapError') are contained in a `System' unit, *Note System::, which
GPC (unlike BP) does not automatically use in each program. To use it,
you can add a `uses System;' clause to your program. If you don't want
to change your code, the command line option `--uses=System' will do
the same.


File: gpc.info,  Node: -D__BP_TYPE_SIZES__ - small integer types etc.,  Next: - -pack-struct - disable structure alignment,  Prev: - -uses=System - Swap; HeapError; etc.,  Up: BP Incompatibilities

-D__BP_TYPE_SIZES__ - small integer types etc.
----------------------------------------------

   Since GPC runs on 32 and 64 bit platforms, integer types have larger
sizes than in BP. However, if you use the `System' unit (*note -
-uses=System - Swap; HeapError; etc.::) and define the symbol
`__BP_TYPE_SIZES__' (by giving `-D__BP_TYPE_SIZES__' on the command
line), it will redeclare the types to the sizes used by BP. This is
less efficient and more limiting, but might be necessary if your
program relies on the exact type sizes.


File: gpc.info,  Node: - -pack-struct - disable structure alignment,  Next: -D__BP_RANDOM__ - BP compatible pseudo random number generator,  Prev: -D__BP_TYPE_SIZES__ - small integer types etc.,  Up: BP Incompatibilities

- -pack-struct - disable structure alignment
--------------------------------------------

   GPC by default aligns fields of records and arrays suitably for
higher performance, while BP doesn't. If you don't want the alignment
(e.g., because the program relies on the internal format of your
structures), either declare the relevant structures as `packed' (which
BP also accepts, but ignores), or give the `--pack-struct' option.


File: gpc.info,  Node: -D__BP_RANDOM__ - BP compatible pseudo random number generator,  Next: -D__BP_UNPORTABLE_ROUTINES__ - Intr; DosVersion; etc.,  Prev: - -pack-struct - disable structure alignment,  Up: BP Incompatibilities

-D__BP_RANDOM__ - BP compatible pseudo random number generator
--------------------------------------------------------------

   GPC uses a more elaborate pseudo random number generator than BP
does. Using the `Random' and `Randomize' functions works the same way,
but there is no `RandSeed' variable (but a `SeedRandom' procedure).
However, if you use the `System' unit (*note - -uses=System - Swap;
HeapError; etc.::) and define the symbol `__BP_RANDOM__' (by giving
`-D__BP_RANDOM__' on the command line), it will provide a 100% BP
compatible pseudo random number generator, including the `RandSeed'
variable, which will produce exactly the same sequence of pseudo random
numbers that BP's pseudo random number generator does. Even the
`Randomize' function will then behave exactly like in BP.


File: gpc.info,  Node: -D__BP_UNPORTABLE_ROUTINES__ - Intr; DosVersion; etc.,  Next: -D__BP_PARAMSTR_0__ - BP compatible ParamStr (0) behaviour,  Prev: -D__BP_RANDOM__ - BP compatible pseudo random number generator,  Up: BP Incompatibilities

-D__BP_UNPORTABLE_ROUTINES__ - Intr; DosVersion; etc.
-----------------------------------------------------

   A few more routines in the `Dos' and `WinDos' units besides the ones
mentioned under *Note Keep; GetIntVec; SetIntVec::, like `Intr' or
`DosVersion', are meaningless on non-Dos systems. By default, the `Dos'
unit does not provide these routines (it only provides those that are
meaningful on all systems, which are most of its routines, including
the most commonly used ones). If you need the unportable ones, you get
them by using the `System' unit (*note - -uses=System - Swap;
HeapError; etc.::) and defining the symbol `__BP_UNPORTABLE_ROUTINES__'
(by giving `-D__BP_UNPORTABLE_ROUTINES__' on the command line). If you
use `Intr' or `MsDos', your program will only compile under DJGPP then.
Other routines, e.g. `DosVersion' are emulated quite roughly on other
systems. Please see the notes in the `Dos' unit (*note Dos::) for
details.


File: gpc.info,  Node: -D__BP_PARAMSTR_0__ - BP compatible ParamStr (0) behaviour,  Prev: -D__BP_UNPORTABLE_ROUTINES__ - Intr; DosVersion; etc.,  Up: BP Incompatibilities

-D__BP_PARAMSTR_0__ - BP compatible ParamStr (0) behaviour
----------------------------------------------------------

   In BP (or under Dos), `ParamStr (0)' always contains the full path
of the current executable. Under GPC, by default it contains what was
passed by the caller as the 0th argument - which is often the name of
the executable, but that's merely a convention, and it usually does not
include the path.

   If you use the `System' unit (*note - -uses=System - Swap;
HeapError; etc.::) and define the symbol `__BP_PARAMSTR_0__' (by giving
`-D__BP_PARAMSTR_0__' on the command line), it will change the value of
`ParamStr (0)' to that of `ExecutablePath', overwriting the value
actually passed by the caller, to imitate BP's/Dos's behaviour.
*However note:* On most systems, `ExecutablePath' is *not* guaranteed to
return the full path, so defining this symbol doesn't change anything.
In general, you *cannot* expect to find the full executable path, so
better don't even try it, or your program will (at best) run on some
systems. For most cases where BP programs access their own executable,
there are cleaner alternatives available.


File: gpc.info,  Node: IDE versus command line,  Next: Comments,  Prev: BP Incompatibilities,  Up: Borland Pascal

IDE versus command line
=======================

   On the Dos (DJGPP) and Linux platforms, you can use RHIDE for GNU
Pascal; check the subdirectories of your DJGPP distribution.

   Unfortunately, there is no IDE which would run on all platforms. We
are working on it, but this will take some time. Please be patient - or
offer your help!

   Without an IDE, the GNU Pascal Compiler, GPC, is called about like
the command-line version of the Borland Pascal Compiler, BPC. Edit your
source file(s) with your favorite ASCII editor, then call GNU Pascal
with a command line like

     C:\GNU-PAS> gpc hello.pas -o hello.exe

on your Dos or OS/2 box or

     myhost:/home/joe/gnu-pascal> gpc hello.pas -o hello

on your Unix (or Unix-compatible) system.

   Don't omit the `.pas' suffix: GPC is a common interface for a Pascal
compiler, a C, ObjC and C++ compiler, an assembler, a linker, and
perhaps an Ada and a FORTRAN compiler. From the extension of your
source file GPC figures out which compiler to run. GPC recognizes
Pascal sources by the extension `.pas', `.p', `.pp' or `.dpr'.

   The `-o' is a command line option which tells GPC how the executable
has to be named. If not given, the executable will be called `a.out'
(Unix) or `a.exe' (Dos). However, you can use the
`--executable-file-name' to tell GPC to always call the executable like
the source (with the extension removed under Unix and changed to `.exe'
under Dos).

   Note that GPC is case-sensitive concerning file names and options,
so it will _not_ work if you type

     C:\GNU-PAS> GPC HELLO.PAS -O HELLO.EXE

   GPC is a very quiet compiler and doesn't print anything on the
screen unless you request it or there is an error. If you want to see
what is going on, invoke GPC with additional options:

     -Q            "don't be quiet"  (or: Quassel-Modus in German)

(with _capital_ `Q'!) means that GPC prints out the names of procedures
and functions it processes, and

     --verbose

or abbreviated

     -v

means that GPC informs you about the stages of compilation, i.e.
preprocessing, compiling, assembling, and linking.

   One example (this time for OS/2):

     [C:\GNU-Pascal] gpc --verbose -Q hello.pas

   Throughout this chapter, we will tell you about a lot of
command-line switches. They are all invoked this way.

   After compilation, there will be an executable `hello' file in the
current directory. (`hello.exe' on Dos or OS/2.) Just run it and enjoy.
If you're new to Unix, please note that the current directory is not on
the PATH in most installations, so you might have to run your program
as `./hello'. This also helps to avoid name conflicts with other
programs. Such conflicts are especially common with the program name
`test' which happens to be a standard utility under Unix that does not
print any output. If you call your program `test.pas', compile it, and
then invoke `test', you will usually not run your program, but the
utility which leads to mysterious problems. So, invoke your program as
`./test' or, better yet, avoid the name `test' for your programs.

   If there are compilation errors, GNU Pascal will not stop
compilation after the first one - as Borland Pascal does - but try to
catch all errors in one compilation. If you get more error messages
than your screen can hold, you can catch them in a file (e.g.
`gpc.out') or pipe them to a program like `more' in the following way:

     gpc hello.pas 2> gpc.out

   This works with OS/2 and any bash-like shell under Unix; for Dos you
must get a replacement for `command.com' which supports this kind of
redirection, or use the `redir' utility (see also the DJGPP FAQ, *Note
DJGPP FAQ: (djgppfaq)Top.):

     C:\GNU-PAS> redir -eo gpc hello.pas -o hello.exe | more

   You can also use Borland's IDE for GNU Pascal on the Dos platform:
Install the GNU Pascal Compiler in the Tools menu (via Options/Tools).

     Name:       GNU Pascal
     Path:       gpc
     Arguments:  $SAVE ALL --executable-file-name $NAME($EDNAME).pas
     HotKey:     Shift+F9

   Note once more that GPC is case-sensitive, so it is important to
specify `.pas' instead of the `.PAS' Borland Pascal would append
otherwise!

   You can include more command-line arguments to GNU Pascal (e.g.
`--automake'; see below) as you will learn more about them.

   Since Borland Pascal will try to recompile your program if you use
its `Run' menu function, you will need another tool to run your program:

     Name:       Run Program
     Path:       command.com
     Arguments:  /c $NAME($EDNAME)
     HotKey:     Shift+F10


File: gpc.info,  Node: Comments,  Next: BP Compatible Compiler Directives,  Prev: IDE versus command line,  Up: Borland Pascal

Comments
========

   GPC supports comments surrounded by `{ }' and `(* *)', just like BP
does. According to the ISO 7185 and ISO 10206 standards, Pascal allows
comments opened with `(*' and closed with `}'. Borland Pascal does not
support such "mixed" comments, so you might have sources where passages
containing comments are "commented out" using the other kind of comment
delimiters. GPC's default behaviour is (like BP) not to allow mixed
comments, so you don't need to worry about this. However, if you happen
to like mixed comments, you can turn them on either by a command-line
option, or by a compiler directive:

     --mixed-comments     {$mixed-comments}    (*$mixed-comments*)

   GPC supports nested comments (e.g., `{ foo { bar } baz }'), but they
are disabled by default (compatible to BP which doesn't know nested
comments at all). You can enable them with the option
`--nested-comments' (or the equivalent compiler directive)

   GPC also supports Delphi style comments starting with `//' and
extending until the end of the line. This comment style is activated by
default unless one of the `--classic-pascal', `--extended-pascal',
`--object-pascal' or `--borland-pascal' dialect options is given. You
can turn them on or off with the `--[no-]delphi-comments' option.


File: gpc.info,  Node: BP Compatible Compiler Directives,  Next: Units; GPI files and AutoMake,  Prev: Comments,  Up: Borland Pascal

BP Compatible Compiler Directives
=================================

   All of BP's one-letter compiler directives are supported by GPC,
though some of them are ignored because they are not necessary under
GPC. Besides, GPC supports a lot more directives. For an overview, see
*Note Compiler Directives::.


File: gpc.info,  Node: Units; GPI files and AutoMake,  Next: Optimization,  Prev: BP Compatible Compiler Directives,  Up: Borland Pascal

Units, GPI files and AutoMake
=============================

   You can use units in the same way as in Borland Pascal. However,
there are some additional features.

   Concerning the syntax of a unit, you can, if you want, use Extended
Pascal syntax to specify a unit initializer, i.e., instead of writing

     begin
       ...
     end.

at the end of the unit, you can get the same result with

     to begin do
       begin
         ...
       end;

and there also exists

     to end do
       begin
         ...
       end;

which specifies a finalization routine. You can use this instead of
Borland Pascal's exit procedures, but for compatibility, the included
`System' unit also provides the `ExitProc' variable. The `to begin do'
and/or `to end do' parts must be followed by the final `end.'. See
*Note Modules::, for information about Extended Pascal modules, an
alternative to units.

   When GPC compiles a unit, it produces two files: an `.o' object file
(compatible with other GNU compilers such as GNU C) plus a `.gpi' file
which describes the interface.

   If you are interested in the internal format of GPI file, see *Note
GPI files::.

   If you want to compile a program that uses units, you must "make"
the project. (This is the command-line switch `-M' or the IDE keystroke
`F9' in BP.) For this purpose, GPC provides the command-line switch
`--automake':

     gpc --automake hello.pas

   If you want to force everything to be rebuilt rather than only
recompile changed files (`-B' or "build" in BP), use `--autobuild'
instead of `--automake':

     gpc --autobuild hello.pas

   For more information about the AutoMake mechanism, see *Note
AutoMake::.

   If you do not want to use the AutoMake mechanism for whatever
reason, you can also compile every unit manually and then link
everything together.

   GPC does not automatically recognize that something is a unit and
cannot be linked; you have to tell this by a command line switch:

     -c            only compile, don't link.

   (If you omit this switch when compiling a unit, you only get a
linker error message `undefined reference to `main''.  Nothing serious.)

   For example, to compile two units, use:

     gpc -c myunit1.pas myunit2.pas

   When you have compiled all units, you can compile a program that
uses them without using `--automake':

     gpc hello.pas

   However, using `--automake' is recommended, since it will recompile
units that were modified.

   You could also specify the program and the units in one command line:

     gpc hello.pas myunit1.pas myunit2.pas

   One of the purposes of writing units is to compile them separately.
However, GNU Pascal allows you to have one or more units in the same
source file (producing only one `.o' file but separate `.gpi' files).
You even can have a program and one or more units in one source file;
in this case, no `.o' file is produced at all.


File: gpc.info,  Node: Optimization,  Next: Debugging,  Prev: Units; GPI files and AutoMake,  Up: Borland Pascal

Optimization
============

   GNU Pascal is a 32/64 bit compiler with excellent optimization
algorithms (which are identically the same as those of GNU C). There
are six optimization levels, specified by the command line options
`-O', `-O2', ..., `-O6'.

   One example:

     program OptimizationDemo;
     
     procedure Foo;
     var
       A, B: Integer;
     begin
       A := 3;
       B := 4;
       WriteLn (A + B)
     end;
     
     begin
       Foo
     end.

   When GNU Pascal compiles this program with optimization (`-O3'), it
recognizes that the argument to `WriteLn' is the constant 7 - and
optimizes away the variables `A' and `B'. If the variables were global,
they would not be optimized away because they might be accessed from
other places, but the constant 7 would still be optimized.

   For more about optimization, see the GNU C documentation.


File: gpc.info,  Node: Debugging,  Next: Objects,  Prev: Optimization,  Up: Borland Pascal

Debugging
=========

   The command line option `-g' specifies generation of debugging
information for GDB, the GNU debugger. GDB comes with its own
documentation. Currently, GDB does not understand Pascal syntax, so you
should be familiar with C expressions if you want to use it.

   See also "Notes for debugging" in the "Programming" chapter; see
*Note Notes for Debugging::.

   Sometimes it is nice to have a look at the assembler output of the
compiler. You can do this in a debugger or disassembler (which is the
only way to do it in BP), but you can also tell GPC to produce
assembler code directly: When you specify the `-S' command line option,
GPC produces an `.s' file instead of an `.o' file.  The `.s' file
contains assembler source for your program. More about this in the next
section.


File: gpc.info,  Node: Objects,  Next: Strings in BP and GPC,  Prev: Debugging,  Up: Borland Pascal

Objects
=======

   Objects in the Borland Pascal 7.0 notation are implemented into GNU
Pascal with the following differences:

   * the `private', `protected', `public' and `published' directives
     are recognized but ignored,

   * data fields and methods may be mixed:
          type
            MyObj = object
              x: Integer;
              procedure Foo; virtual;
              y: Real;
              function Bar: Char;
            end;

