#if 0
GPI file definitions
Copyright (C) 1997-2002, Free Software Foundation, Inc.

This file defines only macros, uses `#' directives and `#if 0' for
comments, so it can be included in both C and Pascal files.

Authors: Jukka Virtanen <jtv@hut.fi>
         Peter Gerwinski <peter@gerwinski.de>
         Alexei Volokhov <voh@ispras.ru>
         Jan-Jaap van der Heijden <j.j.vanderheijden@student.utwente.nl>
         Frank Heckenbach <frank@pascal.gnu.de>

This file is part of GNU Pascal.

GNU Pascal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU Pascal is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Pascal; see the file COPYING. If not, write to the
Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.
#endif

#define INTERFACE_NAME_NODE LAST_AND_UNUSED_TREE_CODE

#ifdef __GNU_PASCAL__

  { @@ Since GPC does not support auto-detected constant array size
       and we cannot process the special nodes below twice without
       extra effort, we just put them in a single string constant,
       spearated by spaces, and split them in the main program. }
  #define SN_START const SpecialNodesString =
  #define SN(NODE) #NODE ' '
  #define SN_END ;
  #define HEX(n) $##n

#else

  /* Special nodes. The array index is the uid number in the GPI file. */
  #define SN_START static tree *special_nodes[] = {
  #define SN(NODE) &NODE,
  #define SN_END NULL_PTR };

  #ifdef __STDC__
  #define HEX(n) 0x##n
  #else
  #define HEX(n) 0x/**/n
  #endif

#endif

#define GPI_HEADER "GNU Pascal unit/module interface\n"
#define GPI_DEBUG_KEY HEX(54637281)
#define GPI_ENDIANNESS_MARKER HEX(12345678)
#define GPI_INVERSE_ENDIANNESS_MARKER HEX(78563412)

#define GPI_CHUNKS \
  GPI_CHUNK (GPI_CHUNK_INVALID,        0, 0, "invalid chunk"), \
  GPI_CHUNK (GPI_CHUNK_VERSION,        1, 1, "version"), \
  GPI_CHUNK (GPI_CHUNK_MODULE_NAME,    1, 1, "module name"), \
  GPI_CHUNK (GPI_CHUNK_SRCFILE,        1, 1, "source file name"), \
  GPI_CHUNK (GPI_CHUNK_IMPORT,         0, 0, "name of imported interface"), \
  GPI_CHUNK (GPI_CHUNK_LINK,           0, 0, "name of file to be linked"), \
  GPI_CHUNK (GPI_CHUNK_LIB,            0, 0, "name of library to be linked"), \
  GPI_CHUNK (GPI_CHUNK_INITIALIZER,    0, 0, "module initializer"), \
  GPI_CHUNK (GPI_CHUNK_GPC_MAIN_NAME,  0, 1, "main function name"), \
  GPI_CHUNK (GPI_CHUNK_NODES,          1, 1, "tree nodes"), \
  GPI_CHUNK (GPI_CHUNK_OFFSETS,        1, 1, "offset table"), \
  GPI_CHUNK (GPI_CHUNK_IMPLEMENTATION, 0, 1, "implementation flag")

SN_START
  SN (null_tree_node)

  SN (error_mark_node)
  SN (gpc_integer_type_node)
  SN (gpc_boolean_type_node)
  SN (short_integer_type_node)
  SN (integer_type_node)
  SN (long_integer_type_node)
  SN (long_long_integer_type_node)
  SN (short_unsigned_type_node)
  SN (unsigned_type_node)
  SN (long_unsigned_type_node)
  SN (long_long_unsigned_type_node)
  SN (ptrdiff_type_node)
  SN (char_type_node)
  SN (unsigned_char_type_node)
  SN (signed_char_type_node)
  SN (float_type_node)
  SN (double_type_node)
  SN (long_double_type_node)
  SN (complex_integer_type_node)
  SN (complex_float_type_node)
  SN (complex_double_type_node)
  SN (complex_long_double_type_node)
  SN (intQI_type_node)
  SN (intHI_type_node)
  SN (intSI_type_node)
  SN (intDI_type_node)
  SN (unsigned_intQI_type_node)
  SN (unsigned_intHI_type_node)
  SN (unsigned_intSI_type_node)
  SN (unsigned_intDI_type_node)
  SN (void_type_node)
  SN (ptr_type_node)
  SN (const_ptr_type_node)
  SN (integer_zero_node)
  SN (null_pointer_node)
  SN (integer_one_node)
  SN (boolean_type_node)
  SN (boolean_false_node)
  SN (boolean_true_node)
  SN (string_type_node)
  SN (const_string_type_node)
  SN (char_array_type_node)
  SN (int_array_type_node)
  SN (wchar_array_type_node)
  SN (default_function_type)
  SN (int_ftype_int)
  SN (void_ftype_ptr)
  SN (byte_boolean_type_node)
  SN (short_boolean_type_node)
  SN (word_boolean_type_node)
  SN (long_boolean_type_node)
  SN (long_long_boolean_type_node)
  SN (wchar_type_node)
  SN (signed_wchar_type_node)
  SN (unsigned_wchar_type_node)
#ifndef EGCS97
  SN (double_ftype_double)
  SN (double_ftype_double_double)
  SN (float_ftype_float)
  SN (ldouble_ftype_ldouble)
  SN (long_ftype_long)
  SN (void_ftype_ptr_ptr_int)
  SN (void_ftype_ptr_int_int)
  SN (string_ftype_ptr_ptr)
  SN (int_ftype_string_string)
  SN (int_ftype_cptr_cptr_sizet)
#else
  SN (sizetype)
  SN (bitsizetype)
#endif

  SN (integer_ptr_type_node)
  SN (size_of_file_type)
#ifdef EGCS
  SN (size_unit_of_file_type)
#endif
  SN (text_type_node)
  SN (complex_type_node)
  SN (integer_maxint_node)
  SN (identifier_output)
  SN (identifier_input)
  SN (identifier_stderr)
  SN (global_input_file_node)
  SN (global_output_file_node)
  SN (global_error_file_node)
  SN (real_zero_node)
  SN (real_half_node)
  SN (string_schema_proto_type)
  SN (const_string_schema_proto_type)
  SN (cstring_type_node)
  SN (empty_arglist)
  SN (complex_zero_node)
  SN (real_max_node)
  SN (real_min_node)
  SN (real_eps_node)
  SN (char_max_node)
  SN (gpc_type_TIME)
  SN (gpc_type_DATE)
  SN (gpc_type_TIMESTAMP)
  SN (gpc_type_BINDINGTYPE)
  SN (gpc_type_PObjectType)
SN_END
