program Foo;

uses System;

type
  RBR = record
    R : Real;
    BR : BPReal
  end;

var
  i : Integer;
  x : RBR;
  R2 : Real;
  f : file of RBR;

begin
  Rewrite (f, 'bpreal.dat');
  Randomize;
  for i := 1 to 20000 do
    begin
      x.R := (Random + 1e-6) * Exp (Random (86) - 43);
      if Random (2) = 0 then x.R := - x.R;
      x.BR := RealToBPReal (x.R);
      Write (f, x);
      R2 := BPRealToReal (x.BR);
      if Abs (x.R / R2 - 1) > 1e-6 then
        begin
          WriteLn ('failed: ', i, ' ', x.R, ', ', R2);
          Halt (1)
        end
    end;
  WriteLn ('OK')
end.
