"======================================================================
|
|   SystemDictionary Method Definitions
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

RootNamespace variableSubclass: #SystemDictionary
	   instanceVariableNames: ''
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Language-Implementation'
!

SystemDictionary comment: 
'I am a special namespace. I only have one instance, called "Smalltalk",
which is known to the Smalltalk interpreter.  I define
several methods that are "system" related, such as #quitPrimitive.
My instance also helps keep track of dependencies between objects.' !


">>> See also builtins.st for some non-primitive but highly useful
SystemDictionary method definitions."


!SystemDictionary methodsFor: 'basic'!

halt
    "Interrupt interpreter"
    ContextPart unwind
!

initializeGlobals
    "Initialize the globals"
    self at: #Super put: nil.
    self at: #Dependencies put: (IdentityDictionary new).
    self addFeature: #Kernel.
    KernelInitialized := true.
! !


!SystemDictionary methodsFor: 'printing'!

defaultName
    ^'Smalltalk'
!

name
    "Answer the receiver's name"
    ^'Smalltalk'
!

storeOn: aStream
    "Store Smalltalk code compiling to the receiver"
    | result name |
    aStream nextPutAll: 'Smalltalk'.
! !


!SystemDictionary methodsFor: 'initialization'!

addInit: aBlock
    "Adds 'aBlock' to the array of blocks to be invoked after every start
     of the system.
     If the kernel has been already initialized, evaluate the block"
    InitBlocks isNil ifTrue: [
	InitBlocks := OrderedCollection new.
    ].
    InitBlocks add: aBlock.
    KernelInitialized ifTrue: [ aBlock value ]
!

doInits
    "Called after the system has loaded the image, this will invoke any
     init blocks that have been installed."
    InitBlocks isNil ifFalse: [
	InitBlocks do: [ :aBlock | aBlock value ]
    ].
! !


!SystemDictionary methodsFor: 'miscellaneous'!

arguments
    "Return the command line arguments after the -a switch"
    self getArgc > 0 ifFalse: [ ^#() ].

    ^(1 to: self getArgc)
	collect: [ :i | self getArgv: i ]
!

backtrace
    "Print a backtrace on the Transcript."
    "This replaces the primitive in builtins.st"
    thisContext parentContext backtrace
!

snapshot
    "Save a snapshot on the image file that was loaded on startup"
    self snapshot: File image
! !


!SystemDictionary methodsFor: 'special accessing'!

dependenciesAt: anObject
    "Answer the dependants of anObject (or nil if there's no key for anObject
     in the Dependencies IdentityDictionary)"
    ^Dependencies at: anObject ifAbsent: [ ^nil ]
!

hasFeatures: features
    " Returns true if the feature or features in 'features' is one of the 
      implementation dependent features present"

    features class == Symbol
	ifTrue: [ ^Features includes: features ]
	ifFalse: [
	    features do: [ :feature |
		(Features includes: feature asSymbol) ifTrue: [ ^true ]
	    ].
	    ^false
	]
!

addFeature: aFeature
    "Add the aFeature feature to the Features set"
    Features class == Set ifFalse: [ Features := Features asSet ].
    Features add: aFeature asSymbol.
!

removeFeature: aFeature
    "Remove the aFeature feature to the Features set"
    Features class == Set ifFalse: [ Features := Features asSet ].
    Features remove: aFeature ifAbsent: [ ]
!

version
    "Answer the current version of the GNU Smalltalk environment"
    ^Version
! !


!Namespace methodsFor: 'testing'!

isSmalltalk
    ^true
! !
