/*
 * make_pe.cpp  Makes PE executable  from COFF a.out  ver 1.1
 *
 * Author:      Max Feoktistov <max@feokt.spb.ru>
 *
 *
 *              This program is free software; you can redistribute it and/or
 *              modify it under the terms of the GNU General Public License
 *              as published by the Free Software Foundation; either version
 *              2 of the License, or (at your option) any later version.
 *
 *
 * Compile
 * command:     gcc -fpack-struct -fsjlj-exceptions -s -O2 make_pe.cpp -o make_pe.exe
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>


#if  (__GNUC__ >=2 ) && ( __GNUC_MINOR__ > 81 )
#include <string.h>
#else
#include "mstring.h"
#endif

#include "mdef.h"
#include "pe_m.h"

#define OPEN_READ       (O_BINARY|O_RDONLY)
#define OPEN_WRITE      (O_BINARY|O_WRONLY)
#define OPEN_READ_WRITE (O_BINARY|O_RDWR)

#define exit_error(a,b...){ printf("Error: " a "\n", ## b); return -1;}

ulong pe_header[]={
0x00905A4D,0x00000001,0x00000004,0x0000FFFF,0x000001FF,0x00000000,
0x00000040,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000070,0x09B41F0E,0xCD010DBA,
0xCD4CB421,0x726F5321,0x202C7972,0x20726F66,0x336E6957,0x2E2E2E32,
0x0A283A20,0x8900240D,0x27BC8DF6,0x00000000,0x00004550,0x0001014C,
0x00000000,0x00000000,0x00000000,0x020300E0,0x0102010B,0x00000400,
0x00000400,0x00000400,0x00000000,0x00000000,0x00000000,0x00400000,
0x00001000,0x00000200,0x000B0001,0x00000000,0x00000004,0x00000000,
0x00000400,0x00000200,0x00000000,0x00000002,0x00010000,0x00001000,
0x00080000,0x00001000,0x00000000,0x00000010,0x00000000,0x00000000,
0x00000000,0x00000028,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x6B6F6546,0x00002E74,0x00000800,0x00000000,0x00000400,0x00000400,
0x00000000,0x00000000,0x00000000,0xE2501040
,0,0
};


int hfin,hfout;
char   def_outname[]="aout.exe";
char   *foutname=def_outname;
ulong flag;
ulong first=1;
char  *dt;

char msg1[]=
"Make PE by Max Feoktistov E-mail: max@feokt.spb.ru\n\
Command line: \nmake_pe [-c|console][-s Stack_Reserve_Size][-p Heap_Reserve_Size][-o out_file] in_file\n";

long  stk_size=0x10000;
long  heap_size=0x100000;
short SubSystem=2;

PEAOUTHDR *peh;
SCNHDR    *lsh;
SCNHDR    *lsh_text;
SCNHDR    *lsh_data;
SCNHDR    *lsh_bss;


int  main(int argc,char *argv[])
{
 if(argc<2)
 {
 ex1:
  printf(msg1,argv[0]);
  return -1;
 };
//-----------
 while(*argv[first] == '-' ||*argv[first] == '/')
 {
   switch(argv[first][1])
   {
    case 'h':
    case 'H':
    case '?':
             goto ex1;
    case 'o':
    case 'O':
             first++;
             foutname=argv[first];
             break;
    case  's':
    case  'S':
             first++;
             stk_size=atoi(argv[first]);
             stk_size&=0xFFFF000;
             if(stk_size<0x4000)
                printf("**Warning: Bad value (0x%X) for virtual stack size\n",stk_size);
             break;
    case  'p':
    case  'P':
             first++;
             heap_size=atoi(argv[first]);
             heap_size&=0xFFFF000;
             if(heap_size<0x8000)
                printf("**Warning: Bad value (0x%X) for virtual heap size\n",heap_size);
             break;
    case   'c':
    case   'C':
             SubSystem=0x0003;
             break;
    default:
             printf("**Warning: Unknow option \"%s\" \n",argv[first+1]);
   };
   first++;
   if((argc-first)<=0)goto ex1;
 };
//------------
 if((hfin=open(argv[first],OPEN_READ))<0)
 {
   printf("Unable to open \"%s\" \n",argv[first]);
   return -2;
 };
//------------

 int i,j;
  i=lseek(hfin,0,2);
  lseek(hfin,0,0);
  if(!
       ( dt=new char[i+0x200+64])
    )
  {
   printf("No enought memory :( ...\n");
   close(hfin);
   return -4;
  };
  memset(dt,0,(i+0x200));
  memcpy((void *)dt,(void *)pe_header,sizeof(pe_header));

  if(read(hfin,dt+0x200,i)!=i)
  {
   printf("Read error  :( ...\n");
   close(hfin);
   return -3;
  }
  close(hfin);
  peh=(PEAOUTHDR *) (dt+DWORD_PTR(dt[0x3C])+0x18);
  lsh=(SCNHDR    *) (dt + 0x200 + FILHSZ + AOUTSZ);

  peh->DataDirectory[1][1]=
   ( peh->standard.entry
     =((AOUTHDR *)(dt + 0x200 + FILHSZ))->entry - 0x400000)
   - (peh->DataDirectory[1][0]=0x1000);

  peh->SizeOfStackReserve=stk_size;
  peh->SizeOfHeapReserve=heap_size;
  peh->Subsystem=SubSystem;


  for(peh->SizeOfImage=j=0;j<WORD_PTR(dt[0x202]);j++,lsh++ )
  {
     if(!strcmp(lsh->s_name,".bss") )
     {
       lsh_bss=lsh;
       peh->SizeOfImage+=lsh->s_size;
     }else if(!strcmp(lsh->s_name,".text") )
     {
       peh->SizeOfImage+=lsh->s_size;
       lsh_text=lsh;
     }else if(!strcmp(lsh->s_name,".data") )
     {
       peh->SizeOfImage+=lsh->s_size;
       lsh_data=lsh;
     }
  };

  if(!lsh_text)
   exit_error("Text section not found...");

  lsh=(SCNHDR    *)(&peh[1]);
  lsh->s_vaddr=0x1000;
  lsh->s_scnptr=0x200;
  peh->SizeOfImage+=0x1FFF;
  peh->SizeOfImage&=0xFFFFF000;
  lsh->s_paddr=peh->SizeOfImage-0x1000;
  lsh=(SCNHDR    *) (dt + 0x200 + FILHSZ + AOUTSZ);

  if(!lsh_bss)
   j=i-lsh->s_scnptr;
  else
   j=lsh_bss->s_vaddr - lsh->s_vaddr;

  memcpy(dt+0x200,dt+0x200+lsh->s_scnptr,j);


  if(j%0x200)
  {
   int k;
   k=j;
   j= (j+0x200) & 0xFFFFE00;
   memset(dt+0x200+k,0,j-k);
  }

  ((SCNHDR    *)(&peh[1]))->s_size=peh->standard.tsize=peh->standard.dsize=j;

  if((hfin=_creat(foutname,0) )<0)
  {
   no_tag:;
     close(hfin);
     printf("Unable create %s\n",foutname);
     return -2;
  };
//------------
  write(hfin,dt,j+0x200);
  close(hfin);
  return 0;
};
//------------------
