#! /usr/bin/perl
##
## vi:ts=4
##
##---------------------------------------------------------------------------##
##
##  Author:
##      Markus F.X.J. Oberhumer         markus.oberhumer@jk.uni-linz.ac.at
##
##  Description:
##      Convert the output of the LZSDEMO test program suitable as
##      input for table.pl
##
##  Copyright (C) 1996 Markus Franz Xaver Johannes Oberhumer
##
##---------------------------------------------------------------------------##

$alg = 'LZS221';
$blocksize = 256*1024;

while (<>) {

	# get performance level of compression (0-255)
	if (/^\s*lzsdemo.+\/p(\d+)/i) {
		$alg = 'LZS221/' . $1;
	}
	# get block size
	if (/^\s*lzsdemo.+\/b(\d+)/i) {
		$blocksize = $1;
	}

	if (/^\s*(\d+)[\-\>\s]+(\d+)\s+\d+\%[\s\d\.\:]+([\w\:\\\/]+)\s*$/) {
		$name = $3;
		$name =~ s/^.*[\\\/]//;
		$name =~ tr/A-Z/a-z/;
		$blocks = ($1 + $blocksize - 1) / $blocksize;
		print "$alg ";
		printf("| %-14s %7d %4d %7d %6.1f %5.2f %8.2f %8.2f |\n",
			$name, $1, $blocks, $2,
			100.0 * $2 / $1, 8.0 * $2 / $1,
			0.0, 0.0 );
	}
}

exit(0);

