/* renamefile.c -- rename file 
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

WORD	process_rename_file(
		IN LPCSTR lpOldPathName,
		IN LPCSTR lpNewPathName)
{
	WORD result ;
	PROLOG(process_rename_file);
	IS_NULL(lpOldPathName, ERROR_FILE_NOT_FOUND);
	IS_NULL(lpNewPathName, ERROR_FILE_NOT_FOUND);
	IS_MAX_PATH_SIZE(lpOldPathName);
	IS_MAX_PATH_SIZE(lpNewPathName);
	DBGVALUE(lpOldPathName,"%s");
	DBGVALUE(lpNewPathName,"%s");
	
	if(!MoveFile(lpOldPathName, lpNewPathName)) {
		result = (WORD)GetLastError();
		if (result == ERROR_ALREADY_EXISTS)
			result = ERROR_ACCESS_DENIED;	// need for DJGPP's _rename()
	} else
		result = ERROR_SUCCESS;

	EPILOG(process_rename_file,TRUE);
	return result;
}

