/*
        SMARTEDIT - A general purpose editor for text files.

        Copyright (C) 1999 Prashant TR
                          B-42, Kudremukh Colony,
                          II Block, Koramangala,
                          Bangalore - 560034.

This program is freeware. You are free to modify and/or redistribute them
under the terms of the GNU General Public License version 2.0 or later.
Read the file COPYING for the license.

The file COPYING.TR contains details about the distribution of this software.

*/

/* ID for this file. */
#define _KSTROKE_C_

#include "editor.h"

extern int quit;
extern WINDOW *win;
extern PREFERENCES pref;

char searchtxt[256] = "";
char replacetxt[256] = "";
char filename[256] = "";
extern int mousedisable;

void processkey(int key)
{
	int result, inloop = 0, x;
	if (key < 0) {
		/* Mouse button pressed. */
		mousestat();

		/* Check if close/fullscreen button on window. */
		if (mregs.x.dx == 8 * (win -> y1 - 1)) {
			if ((win -> x1 + 3) * 8 == mregs.x.cx)
				Window_CloseWindow();
			else if ((win -> x2 - 5) * 8 == mregs.x.cx)
				Window_FullScreen();
			return;
		}


		if ((mregs.x.dx != 8) && (mregs.x.dx != 192)) return;

		/* See if it is the status bar. */
		if (mregs.x.dx == 192) {
			if (mregs.x.cx < 80) key = 315; /* F1. */
			else if (mregs.x.cx < 152) key = 316;	/* F2. */
			else if (mregs.x.cx < 224) key = 317;	/* F3. */
			else if (mregs.x.cx < 344) key = 319;	/* F5. */
			else if (mregs.x.cx < 432) key = 320;	/* F6. */
			else if (mregs.x.cx < 518) key = 324;	/* F10. */
		}

		/* See if it is the menu bar. */
		if (mregs.x.dx == 8) {
			if (mregs.x.cx < 80) key = 289; /* Alt-F. */
			else if (mregs.x.cx < 136) key = 274;	/* Alt-E. */
			else if (mregs.x.cx < 208) key = 287;	/* Alt-S. */
			else if (mregs.x.cx < 288) key = 280;	/* Alt-O. */
			else if (mregs.x.cx < 368) key = 273;	/* Alt-W. */
			else if (mregs.x.cx > 536) key = 291;	/* Alt-H. */
		}
	}

	if (!key) key = 256 + getch();
	if (key >= 256) _setcursortype(0);
	do {
		result = 0;
		switch (key) {
			/* ESC pressed. */
			case 27:
				quit = 1;
				break;

			/* Alt-F pressed or F10. */
			case 289:
			case 324:
				result = filemenu();
				switch (result) {
					/* Left pressed. */
					case -2:
						inloop = 1;
						key = 291;
						continue;

					/* Right pressed. */
					case -3:
						inloop = 1;
						key = 274;
						continue;

					case 1:
						File_New();
						break;

					case 2:
						open_save_dialog(filename);
						if (strcmp(filename, "+None+"))
							File_Load(filename);
						break;

					case 3:
						if (!strcmp(win -> filename,
								"")
								&& (!strcmp(
								pref.deffilename,
								"")))
						open_save_dialog(filename);
						else strcpy(filename,
							win -> filename);
						if (!strcmp(win -> filename,
								""))
							strcpy(filename,
								pref.deffilename);
						if (strcmp(filename, "+None+"))
							File_Save(filename);
						break;

					case 4:
						open_save_dialog(filename);
						if (strcmp(filename, "+None+"))
							File_Save(filename);
						break;

					case 5:
						File_SaveConfig();
						break;

					case 7:
						File_Print();
						break;

					case 8:
						File_DOSShell();
						break;

					case 9:
						File_ExecDOSCmd();
						break;

					case 11:
						File_Exit();
						break;
				}
				break;

			/* Alt-E pressed. */
			case 274:
				result = editmenu();
				switch (result) {
					/* Left pressed. */
					case -2:
						inloop = 1;
						key = 289;
						continue;

					/* Right pressed. */
					case -3:
						inloop = 1;
						key = 287;
						continue;

					/* Menu functions. */
					case 1:
						Edit_Cut();
						break;

					case 2:
						Edit_Copy();
						break;

					case 3:
						Edit_Paste();
						break;

					case 4:
						Edit_Clear();
						break;
				}
				break;

			/* Alt-S pressed. */
			case 287:
				result = searchmenu();
				switch (result) {
					/* Left pressed. */
					case -2:
						inloop = 1;
						key = 274;
						continue;

					/* Right pressed. */
					case -3:
						inloop = 1;
						key = 280;
						continue;

					case 1:
						find_dialog(searchtxt);
						if (strcmp(searchtxt, ""))
							Search_Find(searchtxt);
						break;

					case 2:
						replace_dialog(searchtxt,
								replacetxt);
						if (strcmp(searchtxt, ""))
						Search_Replace(searchtxt,
							replacetxt);
						break;

					case 3:
						if (strcmp(searchtxt, ""))
							Search_Find(searchtxt);
						break;

					case 4:
						if (strcmp(searchtxt, ""))
						Search_Replace(searchtxt,
							replacetxt);
						break;

					case 6:
						find_dialog(filename);
						Search_gotoline(
						     atoi(filename));
						break;
				}
				break;

			/* Alt-O pressed. */
			case 280:
				result = optionsmenu();
				switch (result) {
					/* Left pressed. */
					case -2:
						inloop = 1;
						key = 287;
						continue;

					/* Right pressed. */
					case -3:
						inloop = 1;
						key = 273;
						continue;

					/* Editor preferences. */
					case 1:
						Options_Editor();
						break;

					/* Desktop properties. */
					case 2:
						Options_Desktop();
						break;
				}
				break;

			/* Alt-W pressed. */
			case 273:
				result = windowmenu();
				switch (result) {
					/* Left pressed. */
					case -2:
						inloop = 1;
						key = 280;
						continue;

					/* Right pressed. */
					case -3:
						inloop = 1;
						key = 291;
						continue;

					/* Size/Move. */
					case 1:
						Window_Size();
						break;

					case 2:
						Window_FullScreen();
						break;

					case 4:
						Window_NewWindow();
						break;

					case 5:
						Window_NextWindow();
						break;

					case 6:
						Window_CloseWindow();
						break;

					case 7:
						Window_CloseAll();
						break;

				}
				break;

			/* Alt-H pressed. */
			case 291:
				result = helpmenu();
				switch (result) {
					/* Left pressed. */
					case -2:
						inloop = 1;
						key = 273;
						continue;

					/* Right pressed. */
					case -3:
						inloop = 1;
						key = 289;
						continue;

					/* Help contents. */
					case 1:
						Help_Contents();
						break;

					/* About. */
					case 2:
						Help_About();
						break;

				}
				break;

			/* Alt-X pressed. */
			case 301:
				File_Exit();
				break;

			/* F1 pressed. */
			case 315:
				Help_Contents();
				break;

			/* Ctrl-I */
			/* Insert tab. */
			case 9:
				if (!pref.tabs) break;
				for(x = 1; x <= pref.tabsize; x++)
				send_message(' ');
				break;

			/* INSERT pressed. */
			/* Ctrl-V pressed. */
			case 338:
			case 22:
				if (shiftstatus & 3) {
					Edit_Paste();
					break;
				}
				if (!pref.insertmode) break;
				win -> insert = !win -> insert;
				_setcursortype(win -> insert + 1);
				break;

			/* Ctrl-F */
			/* Find. */
			case 6:
				find_dialog(searchtxt);
				if (strcmp(searchtxt, ""))
					Search_Find(searchtxt);
				break;

			/* Ctrl-A*/
			/* Replace. */
			case 1:
				replace_dialog(searchtxt, replacetxt);
				if (strcmp(searchtxt, ""))
					Search_Replace(searchtxt,
							replacetxt);
				break;
		}
		/* Simply continue if Alt+xx is presed. */
		if (result > 256) {
			inloop = 1;
			key = result;
		}
		else inloop = 0;
	} while (inloop);

	/* See if the key is to be passed on to the editor */
	/* and pass on if necessary. */
	send_message(key);

	if (key >= 256) {
		gotoxy(win -> physicalcol, win -> physicalrow);
		_setcursortype((!win -> insert) + 1);
	}
}