/*
 * EXTERNAL.H - Contains external functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _EXTERNAL_H_

// External variables.
#ifndef _DMI_CC_

extern int errflag;

#endif

#ifdef stderr

#undef stderr

#ifdef _DMI_CC_

FILE *stderr;

#else

extern FILE *stderr;

#endif

#endif

// PNP structure.
typedef struct _PNP_tag {
	char 		signature[4];
	unsigned char 	version;
	char		misc[8];
	unsigned short	(*pnp_entry_point)(...);
	unsigned short	protected_mode_entry_offset;
	char		misc_1[8];
	unsigned short	bios_selector;
	char 		misc_3[4];
	unsigned short	isa_read_port;
	char 		misc_4[8];
} PNP;

typedef struct DMI_INFO_tag {
	unsigned char   info_type_specifier;
	unsigned char	strings_offset;
	unsigned short	handle;
} DMI_INFO;

typedef struct DMI_BIOS_tag {
	unsigned char   index_to_vendor;
	unsigned char	index_to_version;
	unsigned short	rom_segment;
	unsigned char	index_to_date;
	unsigned char 	rom_size_multiplier;
	unsigned long	bios_features;
} DMI_BIOS;

typedef struct DMI_SYSINFO_tag {
	unsigned char   index_to_manufacturer;
	unsigned char	index_to_product_name;
	unsigned char 	index_to_version;
	unsigned char	index_to_serial_no;
} DMI_SYSINFO;

typedef struct DMI_BOARD_tag {
	unsigned char   index_to_manufacturer;
	unsigned char	index_to_product_name;
	unsigned char 	index_to_version;
	unsigned char	index_to_serial_no;
} DMI_BOARD;

typedef struct DMI_CHASSIS_tag {
	unsigned char   index_to_manufacturer;
	unsigned char	flags;
	unsigned char 	index_to_version;
	unsigned char	index_to_serial_no;
	unsigned char	index_to_asset_tag_no;
} DMI_CHASSIS;

typedef struct DMI_MEMC_tag {
	unsigned char   error_detecting_method;
	unsigned char	error_correcting_method;
	unsigned char 	supported_interleave;
	unsigned char	current_interleave;
	unsigned char	max_module_size;
	unsigned short	supported_speeds;
	unsigned short	memory_types;
	unsigned char	voltage;
	unsigned char	index;
} DMI_MEMC;

typedef struct DMI_MEMM_tag {
	unsigned char   index_to_socket_designation;
	unsigned char	bank_connections;
	unsigned char 	current_speed;
	unsigned short	memory_types;
	unsigned char	installed_size;
	unsigned char	enabled_size;
	unsigned char	error_status;
} DMI_MEMM;

typedef struct DMI_SLOT_tag {
	unsigned char   index_to_socket_designation;
	unsigned char	type;
	unsigned char 	width;
	unsigned char	usage;
	unsigned char 	length;
	unsigned short 	id;
	unsigned char 	flags;
} DMI_SLOT;

typedef struct DMI_PROC_tag {
	unsigned char   index_to_socket_designation;
	unsigned char	type;
	unsigned char 	family;
	unsigned char	index_to_manufacturer;
	unsigned long 	id_low;
	unsigned long 	id_hi;
	unsigned char 	index_to_version;
	unsigned char	voltage_capability;
	unsigned short	external_clock;
	unsigned short	maximum_speed;
	unsigned short	current_speed;
	unsigned char	status;
	unsigned char	upgrade;
} DMI_PROC;

typedef struct DMI_CACHE_tag {
	unsigned char   index_to_socket_designation;
	unsigned short	flags;
	unsigned short 	maximum_size;
	unsigned short	installed_size;
	unsigned short 	type;
	unsigned short 	current_type;
} DMI_CACHE;

// Function definitions.
void newhandler();
void checkerrors();
int pinrun(const char *, const char *);
