/*
 * PINMAK.C - Contains routines to make Packed Information modules.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _PINMAK_C_

#include <stdio.h>
#include <stdlib.h>
#include <io.h>

void usage()
{
 printf("PIN (Prashant's Information Modules) Maker version 1.00,"
             "Copyright (C) 1999 Prashant TR\n"
             "Usage is : pinmak [modulename] file1 [ [file2] [file3] ... ]\n");
 exit(0x7f);
}

char buffer[4096];

// The main function.
int main(int argc, char **argv)
{
 FILE *fp, *nfp;
 char fname[100];
 int counter = argc - 3;
 unsigned long size, fsize;
 if (argc <= 2) usage();

 // Open main file for writing.
 if ((nfp = fopen(argv[1], "ab")) == NULL) {
      printf("\nError: Could not open file <%s>\n", argv[1]);
      return 0;
 }

 // Write out all files into a single one.

 /* Write out files on be one after storing special header
    (100 bytes filename + 4 bytes size). */
 counter = argc - 3;
 do {
    strcpy(fname, argv[counter + 2]);
    fwrite(fname, 100, 1, nfp);
    if ((fp = fopen(fname, "rb")) == NULL) {
       printf("\nError: Could not find file <%s>\n", fname);
       continue;
    }
    fsize = filelength(fileno(fp));

    // Write size.
    fwrite(&fsize, sizeof(fsize), 1, nfp);

    // Divide into 4K bits for speed.
    for(size = 0; size < fsize / 4096; size++)
    {
     fread(buffer, 4096, 1, fp);
     fwrite(buffer, 4096, 1, nfp);
    }
    // Write out remaining.
    for(size = 0; size < fsize % 4096; size++)
    {
     fread(buffer, 1, 1, fp);
     fwrite(buffer, 1, 1, nfp);
    }
    fclose(fp);
 } while (counter--);

 fclose(nfp);

 return 0;
}
