/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#ifndef __BCC2GRX_TEXT_H__
#define __BCC2GRX_TEXT_H__

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

typedef unsigned char  uchar;
typedef   signed char  schar;
#ifndef __linux__
typedef unsigned short ushort;
#endif

#include <unistd.h>
#include "bccgrx00.h"

#define FirstUserFont    11
#define LastUserFont     (FirstUserFont+9)
#define FirstGrxFont     (LastUserFont+1)
#define LastGrxFont      (FirstGrxFont+9)
#define NrFonts          (LastGrxFont+1)
#define PreSkip          0x080
#define ZERO2ONE(chrsze) ((chrsze) ? : 1)

#define BITMAP(f) ((f)==DEFAULT_FONT || ((f)>=FirstGrxFont && (f)<=LastGrxFont))

typedef struct {
  uchar width;
  ushort *cmd;
} CharInfo;

/* -------------------------------------------------------------- */
#define PACKED __attribute ((packed))

typedef char FontNameTyp[4];

typedef struct FontFileHeader {
  ushort      header_size PACKED;   /* Version 2.0 Header Format   */
  FontNameTyp font_name   PACKED;   /* Font Internal Name          */
  ushort      font_size   PACKED;   /* filesize in byte            */
  uchar       font_major  PACKED,   /* Driver Version Information  */
	      font_minor  PACKED;
  uchar       min_major   PACKED,   /* BGI Revision Information    */
	      min_minor   PACKED;
} FontFileHeader;

typedef struct FontHeaderTyp {
  char   sig PACKED;            /* SIGNATURE byte                        */
  ushort nchrs PACKED;          /* number of characters in file          */
  char   unused1 PACKED;        /* Currently Undefined                   */
  uchar  firstch PACKED;        /* first character in file               */
  ushort cdefs PACKED;          /* offset to char definitions            */
  uchar  scan_flag PACKED;      /* <> 0 if set is scanable               */
  uchar  org_to_cap PACKED;     /* Height from origin to top of capitol  */
  uchar  org_to_base PACKED;    /* Height from origin to baseline        */
  schar  org_to_dec PACKED;     /* Height from origin to bot of decender */
  uchar  unused2[0x5] PACKED;   /* Currently undefined                   */
} FontHeaderTyp;

extern int  __gr_text_height;
extern int  __gr_text_multx, __gr_text_divx,
	    __gr_text_multy, __gr_text_divy;
extern int  __gr_text_usr_multx, __gr_text_usr_divx,
	    __gr_text_usr_multy, __gr_text_usr_divy;

extern void *__gr_text_Fonts[];
#define Fonts __gr_text_Fonts
extern CharInfo *__gr_text_fntptr;
#define fntptr __gr_text_fntptr
extern char *__gr_text_StdFonts[];
#define StdFonts __gr_text_StdFonts

extern GrTextOption __gr_text_style;
#define Style __gr_text_style

extern struct textsettingstype __gr_text_setting;
#define TXT __gr_text_setting

#ifdef GRX_VERSION
extern GrFont *__gr_text_DefaultFonts[11];
#define DefaultFonts __gr_text_DefaultFonts
#endif

extern void __gr_text_init(void);
extern void __gr_text_vec(int *xx, int *yy, int XX, int YY, uchar *textstring);
extern void __gr_text_bit(GrFont *fnt, int *xx, int *yy, int XX, int YY, uchar *txt);
extern int  __gr_text_ChrFontInfo(void *Font, CharInfo *fntptr, int *height);
extern int  __gr_text_registerfont( int start, int stop, void *font);
extern int  __gr_text_installfont( int start, int stop, char *name);

#endif
