#ifndef screen_line_header
#define screen_line_header

#include "overlap.h"

#define MAXCOLS 80
#define GROWTH_MARGIN 16

#define DEFAULT_CHARACTER  ' '
#define DEFAULT_COLOUR     black_bg+white_fg

typedef enum
{
   black_fg, blue_fg, green_fg, cyan_fg,
   red_fg, magenta_fg, brown_fg, white_fg,
   gray_fg, bright_blue_fg, bright_green_fg, bright_cyan_fg,
   bright_red_fg, bright_magenta_fg, bright_brown_fg, bright_white_fg,

   blue_bg    =  16,   green_bg   =  32,   cyan_bg    =  48,
   red_bg     =  64,   magenta_bg =  80,   brown_bg   =  96,
   white_bg   = 112,

   flashing_fg = 128
}
attrib_t;

#define black_bg         black_fg
#define bright_black_fg  gray_fg
#define bright_fg        gray_fg
#define yellow_fg        bright_brown_fg

typedef struct
{
   char character;
   char colour;
}
screen_char;


class screen_line : public line
{
public:
screen_line( int x = 0, int length = 0 );
screen_line( screen_char fill_char, int x = 0, int length = 0 );
screen_line( const char * text, int x, char colour );
screen_line( screen_line & other );
screen_line( const char * text );
~screen_line();

screen_line & operator=( screen_line & other );
screen_line & operator=( const char * text );

void resize( int new_length );
void resize_and_keep( int new_length );
void draw_to( screen_line & other );
void copy_to( screen_line & other, int x, int length );
void set_fill_char( char character, char colour );
void fill();
void fill( screen_char fill_char, int x, int length );

void get_text( char * buffer,     int x, int length );
void put_text( const char * text, int x, int length );
void set_text( char character,    int x, int length );
void insert_at( char character, int x );
void delete_at( int x );

void set_colour( char colour, int x, int length );
void set_colour( char colour, int x );

operator screen_char * () { return _image; }

screen_char _fill_char;
screen_char * _image;
int _buffer_length;
};

#endif
