/* overlap.h
 * defines the geometrical entities point, line and rectangle
 * inherited by windows to enable overlap detection.
 */

#ifndef overlap_header
#define overlap_header

#define bigger_of( a, b )  ( (a > b)? a : b )
#define smaller_of( a, b ) ( (a < b)? a : b )

#ifndef point_struct_defined
#define point_struct_defined

typedef struct
{
   int x;
   int y;
}
point;

#endif

#ifndef point_pair_defined
#define point_pair_defined

typedef struct
{
   point p1;
   point p2;
}
point_pair;

#endif

#ifndef line_segment_defined
#define line_segment_defined

typedef struct
{
   int start;
   int length;
}
line_segment;

#endif

/* class line is inherited by screen_line only.
 */
class line
{
public:
 line();
 line( int start, int length );
 line( line & model );
 line & operator=( line other );
 virtual ~line() {};

void move_to( int new_x );
void resize( int new_length );
void resize( int start, int length );
int left();
int right();
int length();

bool overlaps( int x );
bool overlaps( line & other );
bool contains( int x );
bool contains( line & other );
line overlap_with( line & other );
bool operator==( line & other );

private:
int _start;
int _end;
int _length;
};

class rectangle
{
public:
 rectangle();
 rectangle( rectangle & );
 rectangle( point tl, point br );
 rectangle( int tlx, int tly, int length, int height );
 virtual ~rectangle() {};

rectangle & operator=( rectangle & );
rectangle overlap_with( rectangle & other );

virtual void move_to( int tlx, int tly );
virtual void resize( int new_width, int new_height );

point top_left();
point bottom_right();
int  top();
int  left();
int  bottom();
int  right();

int  width();
int  height();

bool overlaps( int x, int y );
bool overlaps( point );
bool overlaps( rectangle & );

bool contains( int x, int y );
bool contains( point );
bool contains( rectangle & );

bool operator==( rectangle & );

private:
point _tl;
point _br;
int _width;
int _height;
};

bool  operator ==( point one, point the_other );
bool  operator !=( point one, point the_other );
point operator -( point one, point the_other );
point operator +( point one, point the_other );
point operator+=( point one, point the_other );
point operator-=( point one, point the_other );

#endif
