#include "mouse.h"
#include "sheet.h"
#include <iostream.h>
#include <conio.h>
#include <pc.h>

screen_sheet screen( 0, 0, ScreenCols(), ScreenRows() );

////////////////////////////////////////////////////////////////////
// positioning and drawing
//

void screen_sheet::
draw_to( screen_sheet & other )
{
   if( this -> overlaps( other ) )
   {
      rectangle overlap = overlap_with( other );
      int this_offset  = overlap.top() - this -> top();
      int others_offset = overlap.top() - other.top();
      int height = overlap.height();
      int y = 0;
      while( y < height )
      {
         _image[y+this_offset].draw_to( other[y+others_offset] );
         y++;
      }
   }
}


void screen_sheet::
copy( screen_sheet & other )
{
   resize( other.width(), other.height() );
   move_to( other.left(), other.top() );
   int height = other.height();
   int y = 0;
   while( y < height ) {
      _image[y] = other[y];
      y++;
      }
}

void screen_sheet::
copy_screen()
{
   int screen_cols = ScreenCols();
   int screen_rows = ScreenRows();

   if( width() != screen_cols || height() != screen_rows )
      resize( screen_cols, screen_rows );

   screen_char buffer[screen_rows][screen_cols];
   ScreenRetrieve( buffer );

   int y = 0, x, line_offset;
   while( y < screen_rows ) {
      line_offset = y * screen_cols;

      x = 0;
      while( x < screen_cols ) {
         _image[y][x] = buffer[y][x];
         x++;
         }

      y++;
      }
   }

void screen_sheet::draw_to_screen() {
   if( screen.height() != ScreenRows() )
      screen.resize_and_keep( ScreenCols(), ScreenRows() );
   draw_to( screen );
   update_screen();
   }

void update_screen()
{
   mouse.hide_cursor();

   int y = 0;
   while( y < ScreenRows() ) {
      ScreenUpdateLine( screen[y], y );
      y++;
      }

   mouse.show_cursor();
   }

void screen_sheet::
fill( rectangle area, screen_char fill_char )
{
   int tlx = bigger_of( area.left(), 0 );
   int tly = bigger_of( area.top(), 0 );
   int max_height = smaller_of( area.height(), height() - tly );
   int max_width  = area.width();

   int y = 0;
   while( y < max_height ) {
      _image[y+tly].fill( fill_char, tlx, max_width );
      y++;
      }
}

void screen_sheet::
fill()
{
   int y = 0;
   while( y < height() ) {
      _image[y].fill();
      y++;
      }
}



/////////////////////////////////////////////////////////////////////////
void screen_sheet::
get_text( char * buffer, int x, int y, int length ) {
   if( y >= 0 && y < height() )
      _image[y].get_text( buffer, x, length );
   }

void screen_sheet::
put_text( const char * text, int y, char colour ) {
   if( y >= 0 && y < height() ) {
      _image[y].fill();
      put_text( text, 0, y, colour );
      }
   }

void screen_sheet::
put_text( const char * text, int x, int y, char colour ) {
   if( y >= 0 && y < height() )
      _image[y].put_text( text, x, (int)strlen(text) );
   set_colour( colour, x, y, strlen(text) );
   }

void screen_sheet::
set_text( char character, int x, int y, int length ) {
   if( y >= 0 && y < height() )
      _image[y].set_text( character, x, length );
   }


void screen_sheet::
set_colour( char colour, int x, int y, int length ) {
   if( y >= 0 && y < height() )
      _image[y].set_colour( colour, x, length );
   }

void screen_sheet::
set_colour( char colour, int x, int y ) {
   if( y >= 0 && y < height() )
      _image[y].set_colour( colour, x );
   }

void screen_sheet::
set_colour( char colour, rectangle area )
{
   int tlx = bigger_of( area.left(), 0 );
   int tly = bigger_of( area.top(), 0 );
   int copy_height = smaller_of( area.height(), height() - tly );
   int copy_width  = area.width();

   int y = 0;
   while( y < copy_height ) {
      _image[y+tly].set_colour( colour, tlx, copy_width );
      y++;
      }
}

void screen_sheet::
colour_from_to( char colour, point start, point end )
{
   if( start.y < 0 || start.y >= height()
    || end.y < 0   || end.y >= height() )
      return;

   int x = start.x;
   int y = start.y;
   int length;

   if( end.y == start.y ) {
      length = end.x - start.x + 1;
      _image[y].set_colour( colour, x, length );
      }
   else {
      length = width();
      _image[y].set_colour( colour, x, length - x );

      y++;
      while( y < height() && y < end.y ) {
         _image[y].set_colour( colour, 0, length );
         y++;
         }

      length = end.x + 1;
      _image[y].set_colour( colour, 0, length );
      }
}

void screen_sheet::
colour_fill()
{
   int y = 0;
   while( y < height() ) {
      _image[y].set_colour( _fill_char.colour, 0, _image[y].length() );
      y++;
      }
}

/////////////////////////////////////////////////////////////////
// constructors, destructor
//
screen_sheet::
screen_sheet( int tlx, int tly, int width, int height )
: rectangle( tlx + 1, tly, width, height )
{
   _fill_char.character = DEFAULT_CHARACTER;
   _fill_char.colour = DEFAULT_COLOUR;
   _image = 0;
   resize( width, height );
   move_to( tlx, tly );
   fill();
}

screen_sheet::
screen_sheet()
{
   _fill_char.character = DEFAULT_CHARACTER;
   _fill_char.colour = DEFAULT_COLOUR;
   _image = 0;
}


screen_sheet::
~screen_sheet()
{
   delete [] _image;
}

/////////////////////////////////////////////////////////////////
// resizing and deleting
//
void screen_sheet::
resize( int new_width, int new_height )
{
   if( _image ) delete [] _image;
   _image = 0;

   if( new_width > 0 && new_height > 0 ) {
      _image = new screen_line[new_height]( _fill_char, left(), new_width );
      rectangle::resize( new_width, new_height );
      }
   else
      rectangle::resize( 0, 0 );
   }

void screen_sheet::
resize_and_keep( int new_width, int new_height )
{
   if( new_height <= 0 ) {
      if( _image ) {
         delete [] _image;
         _image = 0;
         }
      rectangle::resize( 0, 0 );
      return;
      }
   screen_line * old_image = _image;
   int old_height = height();
   int old_width = width();

   _image = new screen_line[new_height]
                                ( _fill_char, left(), new_width );

   rectangle::resize( new_width, new_height );

   if( old_image ) {
      int copy_height = smaller_of( new_height, old_height );
      int copy_width = smaller_of( new_width, old_width );
      int y = 0;
      while( y < copy_height ) {
         old_image[y].copy_to( _image[y], 0, copy_width );
         y++;
         }
      delete [] old_image;
      }
   }

void screen_sheet::
move_to( int new_x, int new_y ) {
   if( new_x != left() ) {
      int y = 0;
      while( y < height() ) {
         _image[y].move_to( new_x );
         y++;
         }
      }
   rectangle::move_to( new_x, new_y );
}

void screen_sheet::
set_character( char character ) {
   set_fill_char( character, fill_char().colour );
   }

void screen_sheet::
set_colour( char colour ) {
   set_fill_char( fill_char().character, colour );
   }


void screen_sheet::
set_fill_char( char character, char colour )
{
   _fill_char.character = character;
   _fill_char.colour = colour;
   int y = 0;
   while( y < height() ) {
      _image[y].set_fill_char( character, colour );
      y++;
      }
}

void resize_screen() {
   screen.resize_and_keep( ScreenCols(), ScreenRows() );
   }

void fill_screen( int character, char attribute ) {
   screen.set_fill_char( character, attribute );
   screen.fill();
   }

void clear_screen() {
   fill_screen( ' ', black_bg+white_fg );
   update_screen();
   }

