#ifndef string_array_header
#define string_array_header

#include <stdio.h>
#include <_string.h>

#ifndef point_struct_defined
#define point_struct_defined

typedef struct
{
   int x;
   int y;
}
point;

#endif

#ifndef point_pair_defined
#define point_pair_defined

typedef struct
{
   point p1;
   point p2;
}
point_pair;

#endif

#define DEFAULT_INITIAL_HEIGHT 16

class string_array
{
public:
 string_array( const string_array& );
 string_array( int );
 string_array();
~string_array();

string_array & operator=( const string_array & other );
string_array & operator+=( const string_array & other );
string_array & operator+=( const char * new_line );

String as_a_big_string();

bool resize( int );
bool resize_and_keep( int );

string_array from( int start = 0, int length = 0 );

bool read_file( const char * file_name );
bool read_file_from( const char * file_name, int start, int height );
bool write_file( const char * file_name );
bool read_file( FILE* stream );
bool write_file( FILE* stream );

void strip_newlines();
int  remove_repeats();
void alpha_sort();
void to_upper();
void to_lower();
string_array height_wrap( int width, int height );

void add_line( const char * new_line );
void insert_line_at( const char * new_line, int y = -1 );
void insert_at( char character, int x, int y );
void delete_line_at( int y );
void delete_at( int x, int y );

point index( const char * substring, int x = 0, int y = 0 );
point index( const Regex & pattern,  int x = 0, int y = 0 );
point index( char character,         int x = 0, int y = 0 );
point ci_index( const char * substring_text, int x, int y );

bool  check_xy( int & x, int & y );

operator String * () { return array; }
int height() const  { return _height; }
int width();
int size();  // lengths of all strings, plus one each for the '\n'

void detab();
void set_tab_width( int new_width );
int  tab_width();

private:
int _tab_width;
String * array;
int _height;
int actual_height;
};

int big_string_index( const String & big_string, point pos );
int big_string_index( String & big_string, int x, int y );
point big_string_pos( String & big_string, int index );
point array_pos( string_array _array, int index );

string_array string_to_array( String & big_string );

extern const int not_found;
extern const point point_not_found;



#endif
