#include "txtfield.h"
#include "keyboard.h"
#include "mouse.h"
#include <pc.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

text_field::text_field()
{
   resize( 20, 1 );
   set_border( true );
}


void text_field::
resize( int new_width, int new_height )
{
   new_height = 1;
   page.text.resize( new_height );
   page.refresh_text();
   editing_pane::resize( new_width, new_height );
}

String text_field::
value()
{
   return page.text[0];
}

void text_field::
set_value( const char * text )
{
   page.text[0] = text;
   page.refresh_text();
   process_key( end_key );
}


int text_field::
take_control()
{
   int  row, column;
   ScreenGetCursor( &row, &column );
   to_top();
   bool shown = false;
   if( this -> is_invisible() )
   {
      show();
      show_cursor();
      shown = true;
   }
   draw_all_windows();

   int event = 0;
   while( event != escape_key
       && event != return_key )
   {
      if( key.pressed() )
      {
         key.get();
         event = process_key( key );
      }
      else
      {
         mouse.poll();
         event = process_mouse();
      }
   }

   if( shown )
   {
      hide();
      hide_cursor();
      draw_all_windows();
   }

   ScreenSetCursor( row, column );
   return event;
}

int text_field::
process_key( int keystroke )
{
   show_cursor();

   if( keystroke != return_key
    && keystroke != escape_key )
      return editing_pane::process_key( keystroke );

   return keystroke;
}


