#include <stdarg.h>
#include <stdio.h>
#include <stone.h>

void test_func_extern (int v)
{
  printf ("  %d\n", v);
}

void error (char *str, ...) __attribute__ ((format (printf, 1, 2)));

void error (char *str, ...)
{
  va_list arg;

  va_start (arg, str);
  vfprintf (stdout, arg, str);
  va_end (arg);
  fputc ('\n', stdout);
  exit (1);
}

int main (int argc, char **argv)
{
  int objidx;
  
  if (argc != 2)
  {
    printf ("%s FILE\n", argv [0]);
    printf ("  For studying the output of a compiler.\n\n");
    return 1;
  }

  stone_export ("test_func_extern", &test_func_extern);
  if ((objidx = stone_load (argv [1])) == -1)
    error ("Couldn't open file '%s'\n", argv [1]);
  if (!stone_link_all ())
    error ("Problem linking files");
  if (!stone_list_unlink ())
    error ("Unlinked symbols listed");

  /* void test_func () - Just call */
  {
    void (*func) ();

    if ((func = stone_ptr ("test_func")) == NULL)
      error ("Couldn't find 'test_func'");
    printf ("test_func:\n");
    func ();
  }

  /* test_func_static - Make sure it's not visible */
  {
  }

  /* void test_func_args (int a, int b, int c, int d) - Just call */
  {
    void (*func) (int a, int b, int c, int d);

    if ((func = stone_ptr ("test_func_args")) == NULL)
      error ("Couldn't find 'test_func_args'");
    printf ("test_func_args:\n");
    func (0, 1, 2, 3);
    func (3, 2, 1, 0);
    func (1, 2, 3, 4);
  }

  printf ("\n");
  return 0;
}
