#
# BETATRON high level library for platform and action arcade games.
# Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
#
# V2V.S: This file is part of the BETATRON library and can be used
#        and/or distributed only under the terms of the GNU Library
#        General Public License. See doc/readme.1st for details.
#



.extern _pl_a000h
.globl	_v2v

#
# extern "C" void v2v(unsigned short pagefrom,unsigned short xfrom,unsigned short yfrom,
#		      unsigned short pageto  ,unsigned short xto,  unsigned short yto,
#		      unsigned short lenin4s, unsigned short hei);

.equ savedebp2 ,   0
.equ retadr2   ,   4
.equ pagefrom2 ,   8
.equ xfrom2    ,   12
.equ yfrom2    ,   16
.equ pageto2   ,   20
.equ xto2      ,   24
.equ yto2      ,   28
.equ lenin4s2  ,   32
.equ hei2      ,   36


_v2v:
	pushl	%ebp
	movl	%esp,%ebp

	pusha
	pushw %es
	pushf

	mov _pl_a000h,%ax
	mov %ax,%es

	xorl	%edi,%edi
	movl	%edi,%esi

WindowsAgain:
	cld
	movw	$0x03ce,%dx	   # graph index
	movb	$0x05,%al
	outb	%al,%dx
	incw	%dx
	inb	%dx,%al
	pushw	%ax         	# 驜  write mode
	andb	$0B11111111^0x02,%al
	orb	$0x01,%al
	outb	%al,%dx        # 256 color, linear addressing, read mode 0, write mode 1
	pushw	%ax	        	# sose kai auto pou stelneis gia elegxo argotera

	movw	$0x03c4,%dx	# Seqindex
	movw	$0x0ff02,%ax	# ola ta bitplanes, mapmask
	outw	%ax,%dx

	movw	yfrom2(%ebp),%ax     # yfrom
	movw	$88,%bx              # megethos grammis sti video ram
	mulw	%bx                  # ax= yfrom * 88


	movw	xfrom2(%ebp),%cx      # xfrom
	addw	%cx,%ax 	             # ax=yfrom * 88 + xfrom /4

	addw	pagefrom2(%ebp),%ax   # pagefrom
	movw	%ax,%si 	             # si: fromvideo

	movw	yto2(%ebp),%ax	      # yto
	mulw	%bx

	movw	xto2(%ebp),%cx	       # xto
	addw	%cx,%ax
	addw	pageto2(%ebp),%ax     #pageto
	movw	%ax,%di               # di: tovideo


	subw	lenin4s2(%ebp),%bx	 # bx: di,si increment step

	movw   hei2(%ebp),%dx	    # hei
column:

	movw   lenin4s2(%ebp),%cx   # cx = lenin4s
transferloop:
	testw %cx,%cx
	jz exitloop
	movb %es:(%esi),%al
	movb %al,%es:(%edi)
	incw  %di
	incw  %si
	decw  %cx
	jmp transferloop
exitloop:

	addw	%bx,%di
	addw	%bx,%si
	decw	%dx
	testw	%dx,%dx
	jnz	column

	 popw %bx

	 movw $0x03c4,%dx	# Seqindex
	 movb $2,%al		# ola ta bitplanes, mapmask
	 outb %al,%dx
	 incw %dx
	 inb %dx,%al
	 andb $0xf,%al		# einai ola ta bitplanes markarismena ?
	 cmpb $0xf,%al
	 jne windowsmessup

	  movw $0x03ce,%dx
	  movb $5,%al
	  outb %al,%dx
	  incw %dx
	  inb  %dx,%al
	  cmpb %bl,%al
	  je windowsok

windowsmessup:
	movw	$0x03ce,%dx
	popw	%ax
	movb	%al,%ah
	movb	$0x05,%al
	outw	%ax,%dx

	jmp WindowsAgain

windowsok:
	movw	$0x03ce,%dx
	popw	%ax
	movb	%al,%ah
	movb	$0x05,%al
	outw	%ax,%dx

	popf
	popw	%es
	popa
	popl	%ebp
	ret

.END
